/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql.join;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.stream.sql.join.JoinTest$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableFunc1;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Mf\u0001B\u001d;\u00015CQ\u0001\u0016\u0001\u0005\u0002UCq\u0001\u0017\u0001C\u0002\u0013%\u0011\f\u0003\u0004^\u0001\u0001\u0006IA\u0017\u0005\u0006=\u0002!\ta\u0018\u0005\u0006c\u0002!\ta\u0018\u0005\u0006g\u0002!\ta\u0018\u0005\u0006k\u0002!\ta\u0018\u0005\u0006o\u0002!\ta\u0018\u0005\u0006s\u0002!\ta\u0018\u0005\u0006w\u0002!\ta\u0018\u0005\u0006{\u0002!\ta\u0018\u0005\u0006\u007f\u0002!\ta\u0018\u0005\u0007\u0003\u0007\u0001A\u0011A0\t\r\u0005\u001d\u0001\u0001\"\u0001`\u0011\u0019\tY\u0001\u0001C\u0001?\"1\u0011q\u0002\u0001\u0005\u0002}Ca!a\u0005\u0001\t\u0003y\u0006BBA\f\u0001\u0011\u0005q\f\u0003\u0004\u0002\u001c\u0001!\ta\u0018\u0005\u0007\u0003?\u0001A\u0011A0\t\r\u0005\r\u0002\u0001\"\u0001`\u0011\u0019\t9\u0003\u0001C\u0001?\"1\u00111\u0006\u0001\u0005\u0002}Ca!a\f\u0001\t\u0003y\u0006BBA\u001a\u0001\u0011\u0005q\f\u0003\u0004\u00028\u0001!\ta\u0018\u0005\u0007\u0003w\u0001A\u0011A0\t\r\u0005}\u0002\u0001\"\u0001`\u0011\u0019\t\u0019\u0005\u0001C\u0001?\"1\u0011q\t\u0001\u0005\u0002}Ca!a\u0013\u0001\t\u0003y\u0006BBA(\u0001\u0011\u0005q\f\u0003\u0004\u0002T\u0001!\ta\u0018\u0005\u0007\u0003/\u0002A\u0011A0\t\r\u0005m\u0003\u0001\"\u0001`\u0011\u0019\ty\u0006\u0001C\u0001?\"1\u00111\r\u0001\u0005\u0002}Ca!a\u001a\u0001\t\u0003y\u0006BBA6\u0001\u0011\u0005q\f\u0003\u0004\u0002p\u0001!\ta\u0018\u0005\u0007\u0003g\u0002A\u0011A0\t\r\u0005]\u0004\u0001\"\u0001`\u0011\u0019\tY\b\u0001C\u0001?\"1\u0011q\u0010\u0001\u0005\u0002}Ca!a!\u0001\t\u0003y\u0006BBAD\u0001\u0011\u0005q\f\u0003\u0004\u0002\f\u0002!\ta\u0018\u0005\u0007\u0003\u001f\u0003A\u0011A0\t\r\u0005M\u0005\u0001\"\u0001`\u0011\u0019\t9\n\u0001C\u0001?\"1\u00111\u0014\u0001\u0005\u0002}Ca!a(\u0001\t\u0003y\u0006BBAR\u0001\u0011\u0005q\f\u0003\u0004\u0002(\u0002!\ta\u0018\u0005\u0007\u0003W\u0003A\u0011A0\t\r\u0005=\u0006\u0001\"\u0001`\u0005!Qu.\u001b8UKN$(BA\u001e=\u0003\u0011Qw.\u001b8\u000b\u0005ur\u0014aA:rY*\u0011q\bQ\u0001\u0007gR\u0014X-Y7\u000b\u0005\u0005\u0013\u0015\u0001\u00029mC:T!a\u0011#\u0002\u000fAd\u0017M\u001c8fe*\u0011QIR\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u000f\"\u000bQA\u001a7j].T!!\u0013&\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0015aA8sO\u000e\u00011C\u0001\u0001O!\ty%+D\u0001Q\u0015\t\t&)A\u0003vi&d7/\u0003\u0002T!\niA+\u00192mKR+7\u000f\u001e\"bg\u0016\fa\u0001P5oSRtD#\u0001,\u0011\u0005]\u0003Q\"\u0001\u001e\u0002\tU$\u0018\u000e\\\u000b\u00025B\u0011qjW\u0005\u00039B\u00131c\u0015;sK\u0006lG+\u00192mKR+7\u000f^+uS2\fQ!\u001e;jY\u0002\n\u0011\u0006^3ti\u0012+\u0007/\u001a8eK:$8i\u001c8eSRLwN\u001c#fe&4\u0018\r^5p]&sg.\u001a:K_&tG#\u00011\u0011\u0005\u0005$W\"\u00012\u000b\u0003\r\fQa]2bY\u0006L!!\u001a2\u0003\tUs\u0017\u000e\u001e\u0015\u0003\t\u001d\u0004\"\u0001[8\u000e\u0003%T!A[6\u0002\u0007\u0005\u0004\u0018N\u0003\u0002m[\u00069!.\u001e9ji\u0016\u0014(B\u00018K\u0003\u0015QWO\\5u\u0013\t\u0001\u0018N\u0001\u0003UKN$\u0018!\r;fgR$U\r]3oI\u0016tGoQ8oI&$\u0018n\u001c8EKJLg/\u0019;j_:LeN\\3s\u0015>LgnV5uQR\u0013X/\u001a\u0015\u0003\u000b\u001d\f\u0011\u0007^3ti\u0012+\u0007/\u001a8eK:$8i\u001c8eSRLwN\u001c#fe&4\u0018\r^5p]&sg.\u001a:K_&tw+\u001b;i\u001dVdG\u000e\u000b\u0002\u0007O\u0006iA/Z:u\u0013:tWM\u001d&pS:D#aB4\u00021Q,7\u000f^%o]\u0016\u0014(j\\5o/&$\b.R9vC2\u00046\u000e\u000b\u0002\tO\u0006\u0019B/Z:u\u0013:tWM\u001d&pS:<\u0016\u000e\u001e5QW\"\u0012\u0011bZ\u0001\u0014i\u0016\u001cH\u000fT3gi*{\u0017N\u001c(p]\u0016\u000bX/\u001b\u0015\u0003\u0015\u001d\fa\u0004^3ti2+g\r\u001e&pS:<\u0016\u000e\u001e5FcV\fG\u000eU6O_:,\u0015/^5)\u0005-9\u0017!\t;fgRdUM\u001a;K_&tw+\u001b;i%&<\u0007\u000e\u001e(piB[gj\u001c8FcVL\u0007F\u0001\u0007h\u0003e!Xm\u001d;MK\u001a$(j\\5o/&$\b\u000eU6O_:,\u0015/^5)\u000559\u0017\u0001\u0004;fgRdUM\u001a;K_&t\u0007F\u0001\bh\u0003]!Xm\u001d;MK\u001a$(j\\5o/&$\b.R9vC2\u00046\u000e\u000b\u0002\u0010O\u0006QB/Z:u\u0019\u00164GOS8j]^KG\u000f\u001b*jO\"$hj\u001c;QW\"\u0012\u0001cZ\u0001\u0013i\u0016\u001cH\u000fT3gi*{\u0017N\\,ji\"\u00046\u000e\u000b\u0002\u0012O\u0006!B/Z:u%&<\u0007\u000e\u001e&pS:tuN\\#rk&D#AE4\u0002?Q,7\u000f\u001e*jO\"$(j\\5o/&$\b.R9vC2\u00046NT8o\u000bF,\u0018\u000e\u000b\u0002\u0014O\u0006\u0011C/Z:u%&<\u0007\u000e\u001e&pS:<\u0016\u000e\u001e5SS\u001eDGOT8u!.tuN\\#rk&D#\u0001F4\u00025Q,7\u000f\u001e*jO\"$(j\\5o/&$\b\u000eU6O_:,\u0015/^5)\u0005U9\u0017!\u0004;fgR\u0014\u0016n\u001a5u\u0015>Lg\u000e\u000b\u0002\u0017O\u0006AB/Z:u%&<\u0007\u000e\u001e&pS:<\u0016\u000e\u001e5FcV\fG\u000eU6)\u0005]9\u0017a\u0007;fgR\u0014\u0016n\u001a5u\u0015>LgnV5uQJKw\r\u001b;O_R\u00046\u000e\u000b\u0002\u0019O\u0006\u0019B/Z:u%&<\u0007\u000e\u001e&pS:<\u0016\u000e\u001e5QW\"\u0012\u0011dZ\u0001\u0014i\u0016\u001cHOR;mY*{\u0017N\u001c(p]\u0016\u000bX/\u001b\u0015\u00035\u001d\fa\u0004^3ti\u001a+H\u000e\u001c&pS:<\u0016\u000e\u001e5FcV\fG\u000eU6O_:,\u0015/^5)\u0005m9\u0017\u0001\t;fgR4U\u000f\u001c7K_&tw+\u001b;i\rVdGNT8u!.tuN\\#rk&D#\u0001H4\u00023Q,7\u000f\u001e$vY2Tu.\u001b8XSRD\u0007k\u001b(p]\u0016\u000bX/\u001b\u0015\u0003;\u001d\fA\u0002^3ti\u001a+H\u000e\u001c&pS:D#AH4\u0002/Q,7\u000f\u001e$vY2Tu.\u001b8XSRDW)];bYB[\u0007FA\u0010h\u0003e!Xm\u001d;Gk2d'j\\5o/&$\bNR;mY:{G\u000fU6)\u0005\u0001:\u0017A\u0005;fgR4U\u000f\u001c7K_&tw+\u001b;i!.D#!I4\u0002!Q,7\u000f^*fY\u001aTu.\u001b8QY\u0006t\u0007F\u0001\u0012h\u0003A!Xm\u001d;K_&tw+\u001b;i'>\u0014H\u000f\u000b\u0002$O\u0006IB/Z:u\u0019\u00164GoT;uKJTu.\u001b8FcVL\u0007K]3eQ\t!s-A\u0011uKN$H*\u001a4u\u001fV$XM\u001d&pS:,\u0015/^5B]\u0012dunY1m!J,G\r\u000b\u0002&O\u0006\u0019C/Z:u\u0019\u00164GoT;uKJTu.\u001b8FcVL\u0017I\u001c3O_:,\u0015/^5Qe\u0016$\u0007F\u0001\u0014h\u0003i!Xm\u001d;SS\u001eDGoT;uKJTu.\u001b8FcVL\u0007K]3eQ\t9s-\u0001\u0012uKN$(+[4ii>+H/\u001a:K_&tW)];j\u0003:$Gj\\2bYB\u0013X\r\u001a\u0015\u0003Q\u001d\fA\u0005^3tiJKw\r\u001b;PkR,'OS8j]\u0016\u000bX/[!oI:{g.R9vSB\u0013X\r\u001a\u0015\u0003S\u001d\fQ\u0006^3ti*{\u0017N\\!oIN+G.Z2u\u001f:\u0004\u0016M\u001d;jC2\u001cu.\u001c9pg&$X\r\u0015:j[\u0006\u0014\u0018pS3zQ\tQs-A\ruKN$(j\\5o\t&\u001cxN\u001d3fe\u000eC\u0017M\\4f\u0019><\u0007FA\u0016h\u0003\u0015\"Xm\u001d;K_&tw*\u001e;qkR,\u0006o]3si.+\u0017PT8u\u001b\u0006$8\r[*j].\u00046\u000e\u000b\u0002-O\u0006yB/Z:u\u0015>LgnT;uaV$X\u000b]:feR\\U-_%o'&t7\u000eU6)\u00055:\u0017!\n;fgRTu.\u001b8PkR\u0004X\u000f\u001e'pgR,\u0006o]3si.+\u0017pV5uQNKgn\u001b)lQ\tqs-A\u0010uKN$\u0018J\u001c8fe*{\u0017N\\,ji\"4\u0015\u000e\u001c;feB+8\u000f\u001b#po:D#aL4\u0002MQ,7\u000f^%o]\u0016\u0014(j\\5o/&$\bNS8j]\u000e{g\u000eZ5uS>t\u0007+^:i\t><h\u000e\u000b\u00021O\u0006qB/Z:u\u0019\u00164GOS8j]^KG\u000f\u001b$jYR,'\u000fU;tQ\u0012{wO\u001c\u0015\u0003c\u001d\fQ\u0005^3ti2+g\r\u001e&pS:<\u0016\u000e\u001e5K_&t7i\u001c8eSRLwN\u001c)vg\"$un\u001e8)\u0005I:\u0017a\b;fgR\u0014\u0016n\u001a5u\u0015>LgnV5uQ\u001aKG\u000e^3s!V\u001c\b\u000eR8x]\"\u00121gZ\u0001'i\u0016\u001cHOU5hQRTu.\u001b8XSRD'j\\5o\u0007>tG-\u001b;j_:\u0004Vo\u001d5E_^t\u0007F\u0001\u001bh\u0003}!Xm\u001d;K_&tW\u000b\u0012+G/&$\b.\u00138wC2LGMS8j]\"Kg\u000e\u001e\u0015\u0003k\u001d\fa\u0006^3ti*{\u0017N\u001c)beRLG/[8o)\u0006\u0014G.Z,ji\"tuN\\#ySN$XM\u001c;QCJ$\u0018\u000e^5p]\"\u0012agZ\u0001,i\u0016\u001cHOS8j]\u0006\u001b7-Z:t'>,(oY3QW^KG\u000f['j]&\u0014\u0015\r^2i\u0003N\u001c\u0018n\u001a8fe\"\u0012qgZ\u0001+i\u0016\u001cH/T5oS\n\u000bGo\u00195K_&tw+\u001b;i\u001d\u0016<\u0017\r^5wK6Kg.\u001b\"bi\u000eD7+\u001b>fQ\tAt\r")
public class JoinTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testDependentConditionDerivationInnerJoin() {
        this.util().verifyExecPlan("SELECT a1, b1 FROM A JOIN B ON (a1 = 1 AND b1 = 1) OR (a2 = 2 AND b2 = 2)");
    }

    @Test
    public void testDependentConditionDerivationInnerJoinWithTrue() {
        this.util().verifyExecPlan("SELECT a1, b1 FROM A JOIN B ON (a1 = 1 AND b1 = 1) OR (a2 = 2 AND true)");
    }

    @Test
    public void testDependentConditionDerivationInnerJoinWithNull() {
        this.util().verifyExecPlan("SELECT * FROM t JOIN s ON (a = 1 AND x = 1) OR (a = 2 AND y is null)");
    }

    @Test
    public void testInnerJoin() {
        this.util().verifyExecPlan("SELECT a1, b1 FROM A JOIN B ON a1 = b1");
    }

    @Test
    public void testInnerJoinWithEqualPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(40).append("SELECT a1, b1 FROM (").append(query1).append(") JOIN (").append(query2).append(") ON a1 = b1").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testInnerJoinWithPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(48).append("SELECT a1, a2, b1, b2 FROM (").append(query1).append(") JOIN (").append(query2).append(") ON a2 = b2").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testLeftJoinNonEqui() {
        this.util().verifyRelPlan("SELECT a1, b1 FROM A LEFT JOIN B ON a1 = b1 AND a2 > b2", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testLeftJoinWithEqualPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(57).append("SELECT a1, b1 FROM (").append(query1).append(") LEFT JOIN (").append(query2).append(") ON a1 = b1 AND a2 > b2").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testLeftJoinWithRightNotPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query = new StringBuilder(56).append("SELECT a1, b1 FROM (").append(query1).append(") LEFT JOIN B ON a1 = b1 AND a2 > b2").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testLeftJoinWithPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(65).append("SELECT a1, a2, b1, b2 FROM (").append(query1).append(") LEFT JOIN (").append(query2).append(") ON a2 = b2 AND a1 > b1").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testLeftJoin() {
        this.util().verifyRelPlan("SELECT a1, b1 FROM A LEFT JOIN B ON a1 = b1", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testLeftJoinWithEqualPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(45).append("SELECT a1, b1 FROM (").append(query1).append(") LEFT JOIN (").append(query2).append(") ON a1 = b1").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testLeftJoinWithRightNotPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query = new StringBuilder(44).append("SELECT a1, b1 FROM (").append(query1).append(") LEFT JOIN B ON a1 = b1").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testLeftJoinWithPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(53).append("SELECT a1, a2, b1, b2 FROM (").append(query1).append(") LEFT JOIN (").append(query2).append(") ON a2 = b2").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRightJoinNonEqui() {
        this.util().verifyRelPlan("SELECT a1, b1 FROM A RIGHT JOIN B ON a1 = b1 AND a2 > b2", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRightJoinWithEqualPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(58).append("SELECT a1, b1 FROM (").append(query1).append(") RIGHT JOIN (").append(query2).append(") ON a1 = b1 AND a2 > b2").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRightJoinWithRightNotPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query = new StringBuilder(57).append("SELECT a1, b1 FROM (").append(query1).append(") RIGHT JOIN B ON a1 = b1 AND a2 > b2").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRightJoinWithPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(66).append("SELECT a1, a2, b1, b2 FROM (").append(query1).append(") RIGHT JOIN (").append(query2).append(") ON a2 = b2 AND a1 > b1").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRightJoin() {
        this.util().verifyRelPlan("SELECT a1, b1 FROM A RIGHT JOIN B ON a1 = b1", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRightJoinWithEqualPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(46).append("SELECT a1, b1 FROM (").append(query1).append(") RIGHT JOIN (").append(query2).append(") ON a1 = b1").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRightJoinWithRightNotPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A group by a1";
        String query = new StringBuilder(45).append("SELECT a1, b1 FROM (").append(query1).append(") RIGHT JOIN B ON a1 = b1").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRightJoinWithPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A group by a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B group by b1";
        String query = new StringBuilder(54).append("SELECT a1, a2, b1, b2 FROM (").append(query1).append(") RIGHT JOIN (").append(query2).append(") ON a2 = b2").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testFullJoinNonEqui() {
        this.util().verifyRelPlan("SELECT a1, b1 FROM A FULL JOIN B ON a1 = b1 AND a2 > b2", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testFullJoinWithEqualPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(57).append("SELECT a1, b1 FROM (").append(query1).append(") FULL JOIN (").append(query2).append(") ON a1 = b1 AND a2 > b2").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testFullJoinWithFullNotPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query = new StringBuilder(56).append("SELECT a1, b1 FROM (").append(query1).append(") FULL JOIN B ON a1 = b1 AND a2 > b2").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testFullJoinWithPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(65).append("SELECT a1, a2, b1, b2 FROM (").append(query1).append(") FULL JOIN (").append(query2).append(") ON a2 = b2 AND a1 > b1").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testFullJoin() {
        String query = "SELECT a1, b1 FROM A FULL JOIN B ON a1 = b1";
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testFullJoinWithEqualPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(45).append("SELECT a1, b1 FROM (").append(query1).append(") FULL JOIN (").append(query2).append(") ON a1 = b1").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testFullJoinWithFullNotPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query = new StringBuilder(44).append("SELECT a1, b1 FROM (").append(query1).append(") FULL JOIN B ON a1 = b1").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testFullJoinWithPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(53).append("SELECT a1, a2, b1, b2 FROM (").append(query1).append(") FULL JOIN (").append(query2).append(") ON a2 = b2").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testSelfJoinPlan() {
        this.util().addTableSource("src", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "key")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "v"))}), new CaseClassTypeInfo<Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$9 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, String>> unused = new ScalaCaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                    public Tuple2<Object, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.planner.plan.stream.sql.join.JoinTest$$anon$9 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM (\n         |  SELECT * FROM src WHERE key = 0) src1\n         |LEFT OUTER JOIN (\n         |  SELECT * FROM src WHERE key = 0) src2\n         |ON (src1.key = src2.key AND src2.key > 10)\n       ")).stripMargin();
        this.util().verifyRelPlan(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testJoinWithSort() {
        this.util().addTableSource("MyTable3", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "i")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "j")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "t"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$11 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$6[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$6(org.apache.flink.table.planner.plan.stream.sql.join.JoinTest$$anon$11 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTableSource("MyTable4", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "i")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "k"))}), new CaseClassTypeInfo<Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$13 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$7[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$7(org.apache.flink.table.planner.plan.stream.sql.join.JoinTest$$anon$13 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM\n        |  MyTable3 FULL JOIN\n        |  (SELECT * FROM MyTable4 ORDER BY MyTable4.i DESC, MyTable4.k ASC) MyTable4\n        |  ON MyTable3.i = MyTable4.i and MyTable3.i = MyTable4.k\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testLeftOuterJoinEquiPred() {
        this.util().verifyExecPlan("SELECT b, y FROM t LEFT OUTER JOIN s ON a = z");
    }

    @Test
    public void testLeftOuterJoinEquiAndLocalPred() {
        this.util().verifyExecPlan("SELECT b, y FROM t LEFT OUTER JOIN s ON a = z AND b < 2");
    }

    @Test
    public void testLeftOuterJoinEquiAndNonEquiPred() {
        this.util().verifyExecPlan("SELECT b, y FROM t LEFT OUTER JOIN s ON a = z AND b < x");
    }

    @Test
    public void testRightOuterJoinEquiPred() {
        this.util().verifyExecPlan("SELECT b, y FROM t RIGHT OUTER JOIN s ON a = z");
    }

    @Test
    public void testRightOuterJoinEquiAndLocalPred() {
        this.util().verifyExecPlan("SELECT b, x FROM t RIGHT OUTER JOIN s ON a = z AND x < 2");
    }

    @Test
    public void testRightOuterJoinEquiAndNonEquiPred() {
        this.util().verifyExecPlan("SELECT b, y FROM t RIGHT OUTER JOIN s ON a = z AND b < x");
    }

    @Test
    public void testJoinAndSelectOnPartialCompositePrimaryKey() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE tableWithCompositePk (\n                               |  pk1 INT,\n                               |  pk2 BIGINT,\n                               |  PRIMARY KEY (pk1, pk2) NOT ENFORCED\n                               |) WITH (\n                               |  'connector'='values'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExecPlan("SELECT A.a1 FROM A LEFT JOIN tableWithCompositePk T ON A.a1 = T.pk1");
    }

    @Test
    public void testJoinDisorderChangeLog() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE src (person String, votes BIGINT) WITH(\n                               |  'connector' = 'values'\n                               |)\n                               |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE award (votes BIGINT, prize DOUBLE, PRIMARY KEY(votes) NOT ENFORCED) WITH(\n        |  'connector' = 'values'\n        |)\n        |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE people (person STRING, age INT, PRIMARY KEY(person) NOT ENFORCED) WITH(\n        |  'connector' = 'values'\n        |)\n        |")).stripMargin());
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n                          |SELECT T1.person, T1.sum_votes, T1.prize, T2.age FROM\n                          | (SELECT T.person, T.sum_votes, award.prize FROM\n                          |   (SELECT person, SUM(votes) AS sum_votes FROM src GROUP BY person) T,\n                          |   award\n                          |   WHERE T.sum_votes = award.votes) T1, people T2\n                          | WHERE T1.person = T2.person\n                          |")).stripMargin());
    }

    @Test
    public void testJoinOutputUpsertKeyNotMatchSinkPk() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table source_city (\n                               | id varchar,\n                               | city_name varchar,\n                               | primary key (id) not enforced\n                               |) with (\n                               | 'connector' = 'values',\n                               | 'changelog-mode' = 'I,UA,D'\n                               |)\n                               |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table source_customer (\n                               | customer_id varchar,\n                               | city_id varchar,\n                               | age int,\n                               | gender varchar,\n                               | update_time timestamp(3),\n                               | primary key (customer_id) not enforced\n                               |) with (\n                               | 'connector' = 'values',\n                               | 'changelog-mode' = 'I,UA,D'\n                               |)\n                               |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table sink (\n                               | city_id varchar,\n                               | city_name varchar,\n                               | customer_cnt bigint,\n                               | primary key (city_name) not enforced\n                               |) with (\n                               | 'connector' = 'values'\n                               | ,'sink-insert-only' = 'false'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExplainInsert(new StringOps(Predef$.MODULE$.augmentString("\n        |insert into sink\n        |select t1.city_id, t2.city_name, t1.customer_cnt\n        | from (select city_id, count(*) customer_cnt from source_customer group by city_id) t1\n        | join source_city t2 on t1.city_id = t2.id\n        |")).stripMargin(), (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testJoinOutputUpsertKeyInSinkPk() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table source_city (\n                               | id varchar,\n                               | city_name varchar,\n                               | primary key (id) not enforced\n                               |) with (\n                               | 'connector' = 'values',\n                               | 'changelog-mode' = 'I,UA,D'\n                               |)\n                               |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table source_customer (\n                               | customer_id varchar,\n                               | city_id varchar,\n                               | age int,\n                               | gender varchar,\n                               | update_time timestamp(3),\n                               | primary key (customer_id) not enforced\n                               |) with (\n                               | 'connector' = 'values',\n                               | 'changelog-mode' = 'I,UA,D'\n                               |)\n                               |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table sink (\n                               | city_id varchar,\n                               | city_name varchar,\n                               | customer_cnt bigint,\n                               | primary key (city_id, city_name) not enforced\n                               |) with (\n                               | 'connector' = 'values'\n                               | ,'sink-insert-only' = 'false'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExplainInsert(new StringOps(Predef$.MODULE$.augmentString("\n        |insert into sink\n        |select t1.city_id, t2.city_name, t1.customer_cnt\n        | from (select city_id, count(*) customer_cnt from source_customer group by city_id) t1\n        | join source_city t2 on t1.city_id = t2.id\n        |")).stripMargin(), (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testJoinOutputLostUpsertKeyWithSinkPk() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table source_city (\n                               | id varchar,\n                               | city_name varchar,\n                               | primary key (id) not enforced\n                               |) with (\n                               | 'connector' = 'values',\n                               | 'changelog-mode' = 'I,UA,D'\n                               |)\n                               |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table source_customer (\n                               | customer_id varchar,\n                               | city_id varchar,\n                               | age int,\n                               | gender varchar,\n                               | update_time timestamp(3),\n                               | primary key (customer_id) not enforced\n                               |) with (\n                               | 'connector' = 'values',\n                               | 'changelog-mode' = 'I,UA,D'\n                               |)\n                               |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table sink (\n                               | city_name varchar,\n                               | customer_cnt bigint,\n                               | primary key (city_name) not enforced\n                               |) with (\n                               | 'connector' = 'values'\n                               | ,'sink-insert-only' = 'false'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExplainInsert(new StringOps(Predef$.MODULE$.augmentString("\n        |insert into sink\n        |select t2.city_name, t1.customer_cnt\n        | from (select city_id, count(*) customer_cnt from source_customer group by city_id) t1\n        | join source_city t2 on t1.city_id = t2.id\n        |")).stripMargin(), (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testInnerJoinWithFilterPushDown() {
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n                          |SELECT * FROM\n                          |   (select a1, count(a2) as a2 from A group by a1)\n                          |   join\n                          |   (select b1, count(b2) as b2 from B group by b1)\n                          |   on true where a1 = b1 and a2 = b2 and b1 = 2\n                          |")).stripMargin());
    }

    @Test
    public void testInnerJoinWithJoinConditionPushDown() {
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n                          |SELECT * FROM\n                          |  (select a1, count(a2) as a2 from A group by a1)\n                          |   join\n                          |  (select b1, count(b2) as b2 from B group by b1)\n                          |   on true where a1 = b1 and a2 = b2 and b1 = 2 and a2 = 1\n                          |")).stripMargin());
    }

    @Test
    public void testLeftJoinWithFilterPushDown() {
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n                          |SELECT * FROM\n                          |  (select a1, count(a2) as a2 from A group by a1)\n                          |   left join\n                          |  (select b1, count(b2) as b2 from B group by b1)\n                          |   on true where a1 = b1 and b2 = a2 and a1 = 2\n                          |")).stripMargin());
    }

    @Test
    public void testLeftJoinWithJoinConditionPushDown() {
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n                          |SELECT * FROM\n                          |  (select a1, count(a2) as a2 from A group by a1)\n                          |   left join\n                          |  (select b1, count(b2) as b2 from B group by b1)\n                          |   on a1 = b1 and a2 = b2 and a1 = 2 and b2 = 1\n                          |")).stripMargin());
    }

    @Test
    public void testRightJoinWithFilterPushDown() {
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n                          |SELECT * FROM\n                          |  (select a1, count(a2) as a2 from A group by a1)\n                          |   right join\n                          |  (select b1, count(b2) as b2 from B group by b1)\n                          |   on true where a1 = b1 and a2 = b2 and b1 = 2\n                          |")).stripMargin());
    }

    @Test
    public void testRightJoinWithJoinConditionPushDown() {
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n                          |SELECT * FROM\n                          | (select a1, count(a2) as a2 from A group by a1)\n                          |   right join\n                          | (select b1, count(b2) as b2 from B group by b1)\n                          |   on a1 = b1 and a2 = b2 and b1 = 2 and a2 = 1\n                          |")).stripMargin());
    }

    @Test
    public void testJoinUDTFWithInvalidJoinHint() {
        this.util().addTemporarySystemFunction("TableFunc1", (UserDefinedFunction)new TableFunc1());
        this.util().verifyExpectdException("SELECT /*+ LOOKUP('table'='D') */ T.a FROM t AS T CROSS JOIN LATERAL TABLE(TableFunc1(c)) AS D(c1)", "The options of following hints cannot match the name of input tables or views: \n`D` in `LOOKUP`", this.util().verifyExpectdException$default$3());
    }

    @Test
    public void testJoinPartitionTableWithNonExistentPartition() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table leftPartitionTable (\n                               | a1 varchar,\n                               | b1 int)\n                               | partitioned by (b1) \n                               | with (\n                               | 'connector' = 'values',\n                               | 'bounded' = 'false',\n                               | 'partition-list' = 'b1:1'\n                               |)\n                               |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table rightPartitionTable (\n                               | a2 varchar,\n                               | b2 int)\n                               | partitioned by (b2) \n                               | with (\n                               | 'connector' = 'values',\n                               | 'bounded' = 'false',\n                               | 'partition-list' = 'b2:2'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM leftPartitionTable, rightPartitionTable WHERE b1 = 1 AND b2 = 3 AND a1 = a2\n        |")).stripMargin());
    }

    @Test
    public void testJoinAccessSourcePkWithMiniBatchAssigner() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table left_table (\n                               | a varchar primary key not enforced,\n                               | b int\n                               |) with (\n                               | 'connector' = 'values'\n                               |)\n                               |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table right_table (\n                               | c varchar primary key not enforced,\n                               | d int\n                               |) with (\n                               | 'connector' = 'values'\n                               |)\n                               |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table sink (\n                               | e varchar primary key not enforced,\n                               | f int,\n                               | g int\n                               |) with (\n                               | 'connector' = 'values'\n                               |)\n                               |")).stripMargin());
        this.util().tableEnv().getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(10L));
        this.util().tableEnv().getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_SIZE, (Object)BoxesRunTime.boxToLong((long)5000L));
        this.util().verifyExplainInsert(new StringOps(Predef$.MODULE$.augmentString("\n        |insert into sink\n        |select left_table.a, left_table.b, right_table.d\n        | from left_table\n        | join right_table on left_table.a = right_table.c\n        |")).stripMargin());
    }

    @Test
    public void testMiniBatchJoinWithNegativeMiniBatchSize() {
        this.util().tableEnv().getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(10L));
        String sql = "SELECT * FROM A JOIN B ON a1 = b1";
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(sql)).hasMessage("Key: 'table.exec.mini-batch.size' , default: -1 (fallback keys: []) must be > 0.") instanceof IllegalArgumentException;
        this.util().tableEnv().getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_SIZE, (Object)BoxesRunTime.boxToLong((long)-500L));
        boolean cfr_ignored_1 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(sql)).hasMessage("Key: 'table.exec.mini-batch.size' , default: -1 (fallback keys: []) must be > 0.") instanceof IllegalArgumentException;
    }

    public JoinTest() {
        this.util().addTableSource("A", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a1")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a2")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a3"))}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.join.JoinTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTableSource("B", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b1")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b2")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b3"))}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.stream.sql.join.JoinTest$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTableSource("t", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.stream.sql.join.JoinTest$$anon$5 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTableSource("s", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "x")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "y")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "z"))}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.plan.stream.sql.join.JoinTest$$anon$7 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
    }
}

