/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql.agg;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.calcite.rel.RelNode;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.stream.sql.agg.OverAggregateTest$;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005%b\u0001B\u000f\u001f\u0001EBQ\u0001\u000f\u0001\u0005\u0002eBq\u0001\u0010\u0001C\u0002\u0013%Q\b\u0003\u0004B\u0001\u0001\u0006IA\u0010\u0005\u0006\u0005\u0002!\ta\u0011\u0005\u00063\u0002!\tA\u0017\u0005\u0006M\u0002!\tA\u0017\u0005\u0006Q\u0002!\tA\u0017\u0005\u0006U\u0002!\tA\u0017\u0005\u0006Y\u0002!\tA\u0017\u0005\u0006]\u0002!\tA\u0017\u0005\u0006a\u0002!\tA\u0017\u0005\u0006e\u0002!\tA\u0017\u0005\u0006i\u0002!\tA\u0017\u0005\u0006m\u0002!\tA\u0017\u0005\u0006q\u0002!\tA\u0017\u0005\u0006u\u0002!\tA\u0017\u0005\u0006y\u0002!\tA\u0017\u0005\u0006}\u0002!\tA\u0017\u0005\u0007\u0003\u0003\u0001A\u0011\u0001.\t\r\u0005\u0015\u0001\u0001\"\u0001[\u0011\u0019\tI\u0001\u0001C\u00015\"1\u0011Q\u0002\u0001\u0005\u0002iCa!!\u0005\u0001\t\u0003Q\u0006BBA\u000b\u0001\u0011\u0005!\f\u0003\u0004\u0002\u001a\u0001!\tA\u0017\u0005\u0007\u0003;\u0001A\u0011\u0001.\t\r\u0005\u0005\u0002\u0001\"\u0001[\u0011\u0019\t)\u0003\u0001C\u00015\n\trJ^3s\u0003\u001e<'/Z4bi\u0016$Vm\u001d;\u000b\u0005}\u0001\u0013aA1hO*\u0011\u0011EI\u0001\u0004gFd'BA\u0012%\u0003\u0019\u0019HO]3b[*\u0011QEJ\u0001\u0005a2\fgN\u0003\u0002(Q\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0015+\u0003\u0015!\u0018M\u00197f\u0015\tYC&A\u0003gY&t7N\u0003\u0002.]\u00051\u0011\r]1dQ\u0016T\u0011aL\u0001\u0004_J<7\u0001A\n\u0003\u0001I\u0002\"a\r\u001c\u000e\u0003QR!!\u000e\u0014\u0002\u000bU$\u0018\u000e\\:\n\u0005]\"$!\u0004+bE2,G+Z:u\u0005\u0006\u001cX-\u0001\u0004=S:LGO\u0010\u000b\u0002uA\u00111\bA\u0007\u0002=\u0005!Q\u000f^5m+\u0005q\u0004CA\u001a@\u0013\t\u0001EGA\nTiJ,\u0017-\u001c+bE2,G+Z:u+RLG.A\u0003vi&d\u0007%A\nwKJLg-\u001f)mC:LE-\u001a8uS\u000e\fG\u000eF\u0002E\u0015^\u0003\"!\u0012%\u000e\u0003\u0019S\u0011aR\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0013\u001a\u0013A!\u00168ji\")1\n\u0002a\u0001\u0019\u0006!1/\u001d72!\tiEK\u0004\u0002O%B\u0011qJR\u0007\u0002!*\u0011\u0011\u000bM\u0001\u0007yI|w\u000e\u001e \n\u0005M3\u0015A\u0002)sK\u0012,g-\u0003\u0002V-\n11\u000b\u001e:j]\u001eT!a\u0015$\t\u000ba#\u0001\u0019\u0001'\u0002\tM\fHNM\u0001\u0010i\u0016\u001cH/T;mi&<\u0016N\u001c3poR\tA\t\u000b\u0002\u00069B\u0011Q\fZ\u0007\u0002=*\u0011q\fY\u0001\u0004CBL'BA1c\u0003\u001dQW\u000f]5uKJT!a\u0019\u0018\u0002\u000b),h.\u001b;\n\u0005\u0015t&\u0001\u0002+fgR\f!\u0004^3ti&sg/\u00197jI>3XM]!hOJ,w-\u0019;j_:D#A\u0002/\u00027Q,7\u000f^%om\u0006d\u0017\u000eZ(wKJ\fum\u001a:fO\u0006$\u0018n\u001c83Q\t9A,\u0001\u001fuKN$\bK]8di&lWMQ8v]\u0012,G\rR5ti&t7\r^,ji\"tuN\u001c#jgRLgn\u0019;QCJ$\u0018\u000e^5p]\u0016$'k\\<Pm\u0016\u0014\bF\u0001\u0005]\u00035\"Xm\u001d;Qe>\u001cG/[7f\u0005>,h\u000eZ3e\t&\u001cH/\u001b8diB\u000b'\u000f^5uS>tW\r\u001a*po>3XM\u001d\u0015\u0003\u0013q\u000ba\u0005^3tiB\u0013xn\u0019+j[\u0016\u0014u.\u001e8eK\u0012\u0004\u0016M\u001d;ji&|g.\u001a3S_^\u001cxJ^3sQ\tQA,A\u0014uKN$\bK]8d)&lWMQ8v]\u0012,G\rU1si&$\u0018n\u001c8fIJ\u000bgnZ3Pm\u0016\u0014\bFA\u0006]\u0003)\"Xm\u001d;Qe>\u001cG+[7f\u0005>,h\u000eZ3e\u001d>t\u0007+\u0019:uSRLwN\\3e%\u0006tw-Z(wKJD#\u0001\u0004/\u0002SQ,7\u000f\u001e)s_\u000e$\u0016.\\3C_VtG-\u001a3O_:\u0004\u0016M\u001d;ji&|g.\u001a3S_^\u001cxJ^3sQ\tiA,A\u0015uKN$\bK]8d)&lW-\u00168c_VtG-\u001a3QCJ$\u0018\u000e^5p]\u0016$'+\u00198hK>3XM\u001d\u0015\u0003\u001dq\u000b\u0001\u0006^3tiB\u0013xn\u0019+j[\u0016,fNY8v]\u0012,G\rU1si&$\u0018n\u001c8fIJ{wo](wKJD#a\u0004/\u0002YQ,7\u000f\u001e)s_\u000e$\u0016.\\3V]\n|WO\u001c3fI:{g\u000eU1si&$\u0018n\u001c8fIJ\u000bgnZ3Pm\u0016\u0014\bF\u0001\t]\u0003-\"Xm\u001d;Qe>\u001cG+[7f+:\u0014w.\u001e8eK\u0012tuN\u001c)beRLG/[8oK\u0012\u0014vn^:Pm\u0016\u0014\bFA\t]\u0003\u0015\"Xm\u001d;S_^$\u0016.\\3C_VtG-\u001a3QCJ$\u0018\u000e^5p]\u0016$'k\\<t\u001fZ,'\u000f\u000b\u0002\u00139\u00061C/Z:u%><H+[7f\u0005>,h\u000eZ3e!\u0006\u0014H/\u001b;j_:,GMU1oO\u0016|e/\u001a:)\u0005Ma\u0016\u0001\u000b;fgR\u0014vn\u001e+j[\u0016\u0014u.\u001e8eK\u0012tuN\u001c)beRLG/[8oK\u0012\u0014vn^:Pm\u0016\u0014\bF\u0001\u000b]\u0003%\"Xm\u001d;S_^$\u0016.\\3C_VtG-\u001a3O_:\u0004\u0016M\u001d;ji&|g.\u001a3SC:<Wm\u0014<fe\"\u0012Q\u0003X\u0001)i\u0016\u001cHOU8x)&lW-\u00168c_VtG-\u001a3QCJ$\u0018\u000e^5p]\u0016$'+\u00198hK>3XM\u001d\u0015\u0003-q\u000bq\u0005^3tiJ{w\u000fV5nKVs'm\\;oI\u0016$\u0007+\u0019:uSRLwN\\3e%><8o\u0014<fe\"\u0012q\u0003X\u0001,i\u0016\u001cHOU8x)&lW-\u00168c_VtG-\u001a3O_:\u0004\u0016M\u001d;ji&|g.\u001a3SC:<Wm\u0014<fe\"\u0012\u0001\u0004X\u0001+i\u0016\u001cHOU8x)&lW-\u00168c_VtG-\u001a3O_:\u0004\u0016M\u001d;ji&|g.\u001a3S_^\u001cxJ^3sQ\tIB,\u0001\u001cuKN$\bK]8d)&lWMQ8v]\u0012,G\rU1si&$\u0018n\u001c8fIJ{wo](wKJ$\u0015N\u001a4fe\u0016tGoV5oI><8\u000f\u000b\u0002\u001b9\u0006ID/Z:u!J|7\rV5nK\n{WO\u001c3fIB\u000b'\u000f^5uS>tW\r\u001a*poN|e/\u001a:XSRD')^5mi&t\u0007K]8di&lW\r\u000b\u0002\u001c9\u0006\tB/Z:u\u001d\u0016\u001cH/\u001a3Pm\u0016\u0014\u0018iZ4)\u0005qa\u0006")
public class OverAggregateTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    public void verifyPlanIdentical(String sql1, String sql2) {
        Table table1 = this.util().tableEnv().sqlQuery(sql1);
        Table table2 = this.util().tableEnv().sqlQuery(sql2);
        RelNode optimized1 = this.util().getPlanner().optimize(TableTestUtil$.MODULE$.toRelNode(table1));
        RelNode optimized2 = this.util().getPlanner().optimize(TableTestUtil$.MODULE$.toRelNode(table2));
        Assertions.assertThat((String)FlinkRelOptUtil$.MODULE$.toString(optimized2, FlinkRelOptUtil$.MODULE$.toString$default$2(), FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5(), FlinkRelOptUtil$.MODULE$.toString$default$6(), FlinkRelOptUtil$.MODULE$.toString$default$7())).isEqualTo(FlinkRelOptUtil$.MODULE$.toString(optimized1, FlinkRelOptUtil$.MODULE$.toString$default$2(), FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5(), FlinkRelOptUtil$.MODULE$.toString$default$6(), FlinkRelOptUtil$.MODULE$.toString$default$7()));
    }

    @Test
    public void testMultiWindow() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT c,\n        |    COUNT(a) OVER (PARTITION BY c ORDER BY proctime RANGE UNBOUNDED PRECEDING),\n        |    SUM(a) OVER (PARTITION BY b ORDER BY proctime RANGE UNBOUNDED PRECEDING)\n        |from MyTable\n      ")).stripMargin();
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.util().verifyExecPlan(sqlQuery));
    }

    @Test
    public void testInvalidOverAggregation() {
        this.util().addTemporarySystemFunction("overAgg", (UserDefinedFunction)new JavaUserDefinedAggFunctions.OverAgg0());
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.util().verifyExecPlan("SELECT overAgg(c, a) FROM MyTable"));
    }

    @Test
    public void testInvalidOverAggregation2() {
        this.util().addTemporarySystemFunction("overAgg", (UserDefinedFunction)new JavaUserDefinedAggFunctions.OverAgg0());
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.util().verifyExecPlan("SELECT overAgg(c, a) FROM MyTable"));
    }

    @Test
    public void testProctimeBoundedDistinctWithNonDistinctPartitionedRowOver() {
        String sqlQuery1 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b,\n        |    COUNT(a) OVER (PARTITION BY b ORDER BY proctime\n        |        ROWS BETWEEN 2 PRECEDING AND CURRENT ROW) AS cnt1,\n        |    SUM(a) OVER (PARTITION BY b ORDER BY proctime\n        |        ROWS BETWEEN 2 PRECEDING AND CURRENT ROW) AS sum1,\n        |    COUNT(DISTINCT a) OVER (PARTITION BY b ORDER BY proctime\n        |        ROWS BETWEEN 2 preceding AND CURRENT ROW) AS cnt2,\n        |    sum(DISTINCT c) OVER (PARTITION BY b ORDER BY proctime\n        |        ROWS BETWEEN 2 preceding AND CURRENT ROW) AS sum2\n        |FROM MyTable\n      ")).stripMargin();
        String sqlQuery2 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b,\n        |    COUNT(a) OVER w AS cnt1,\n        |    SUM(a) OVER w AS sum1,\n        |    COUNT(DISTINCT a) OVER w AS cnt2,\n        |    SUM(DISTINCT c) OVER w AS sum2\n        |FROM MyTable\n        |    WINDOW w AS (PARTITION BY b ORDER BY proctime ROWS BETWEEN 2 PRECEDING AND CURRENT ROW)\n      ")).stripMargin();
        this.verifyPlanIdentical(sqlQuery1, sqlQuery2);
        this.util().verifyExecPlan(sqlQuery1);
    }

    @Test
    public void testProctimeBoundedDistinctPartitionedRowOver() {
        String sqlQuery1 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT c,\n        |    COUNT(DISTINCT a) OVER (PARTITION BY c ORDER BY proctime\n        |        ROWS BETWEEN 2 PRECEDING AND CURRENT ROW) AS cnt1,\n        |    SUM(DISTINCT a) OVER (PARTITION BY c ORDER BY proctime\n        |        ROWS BETWEEN 2 PRECEDING AND CURRENT ROW) AS sum1\n        |FROM MyTable\n      ")).stripMargin();
        String sqlQuery2 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT c,\n        |    COUNT(DISTINCT a) OVER w AS cnt1,\n        |    SUM(DISTINCT a) OVER (PARTITION BY c ORDER BY proctime\n        |        ROWS BETWEEN 2 PRECEDING AND CURRENT ROW) AS sum1\n        |FROM MyTable\n        |    WINDOW w AS (PARTITION BY c ORDER BY proctime ROWS BETWEEN 2 PRECEDING AND CURRENT ROW)\n      ")).stripMargin();
        this.verifyPlanIdentical(sqlQuery1, sqlQuery2);
        this.util().verifyExecPlan(sqlQuery1);
    }

    @Test
    public void testProcTimeBoundedPartitionedRowsOver() {
        String sqlQuery1 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT c,\n        |    COUNT(a) OVER (PARTITION BY c ORDER BY proctime\n        |        ROWS BETWEEN 2 PRECEDING AND CURRENT ROW) AS cnt1,\n        |    SUM(a) OVER (PARTITION BY c ORDER BY proctime\n        |        ROWS BETWEEN 2 PRECEDING AND CURRENT ROW) AS sum1\n        |FROM MyTable\n      ")).stripMargin();
        String sqlQuery2 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT c,\n        |    COUNT(a) OVER (PARTITION BY c ORDER BY proctime\n        |        ROWS BETWEEN 2 PRECEDING AND CURRENT ROW) AS cnt1,\n        |    SUM(a) OVER w AS sum1\n        |FROM MyTable\n        |    WINDOW w AS (PARTITION BY c ORDER BY proctime ROWS BETWEEN 2 PRECEDING AND CURRENT ROW)\n      ")).stripMargin();
        this.verifyPlanIdentical(sqlQuery1, sqlQuery2);
        this.util().verifyExecPlan(sqlQuery1);
    }

    @Test
    public void testProcTimeBoundedPartitionedRangeOver() {
        String sqlQuery1 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a,\n        |    AVG(c) OVER (PARTITION BY a ORDER BY proctime\n        |        RANGE BETWEEN INTERVAL '2' HOUR PRECEDING AND CURRENT ROW) AS avgA\n        |FROM MyTable\n      ")).stripMargin();
        String sqlQuery2 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a,  AVG(c) OVER w AS avgA FROM MyTable WINDOW w AS (\n        |    PARTITION BY a ORDER BY proctime\n        |        RANGE BETWEEN INTERVAL '2' HOUR PRECEDING AND CURRENT ROW)\n      ")).stripMargin();
        this.verifyPlanIdentical(sqlQuery1, sqlQuery2);
        this.util().verifyExecPlan(sqlQuery1);
    }

    @Test
    public void testProcTimeBoundedNonPartitionedRangeOver() {
        String sqlQuery1 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a,\n        |    COUNT(c) OVER (ORDER BY proctime\n        |        RANGE BETWEEN INTERVAL '10' SECOND PRECEDING AND CURRENT ROW)\n        | FROM MyTable\n      ")).stripMargin();
        String sqlQuery2 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, COUNT(c) OVER w FROM MyTable WINDOW w AS (\n        |    ORDER BY proctime RANGE BETWEEN INTERVAL '10' SECOND PRECEDING AND CURRENT ROW)\n      ")).stripMargin();
        this.verifyPlanIdentical(sqlQuery1, sqlQuery2);
        this.util().verifyExecPlan(sqlQuery1);
    }

    @Test
    public void testProcTimeBoundedNonPartitionedRowsOver() {
        String sqlQuery1 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT c,\n        |    COUNT(a) OVER (ORDER BY proctime ROWS BETWEEN 2 PRECEDING AND CURRENT ROW)\n        |FROM MyTable\n      ")).stripMargin();
        String sqlQuery2 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT c, COUNT(a) OVER w FROM MyTable WINDOW w AS (\n        |    ORDER BY proctime ROWS BETWEEN 2 PRECEDING AND CURRENT ROW)\n      ")).stripMargin();
        this.verifyPlanIdentical(sqlQuery1, sqlQuery2);
        this.util().verifyExecPlan(sqlQuery1);
    }

    @Test
    public void testProcTimeUnboundedPartitionedRangeOver() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT c,\n        |    COUNT(a) OVER (PARTITION BY c ORDER BY proctime RANGE UNBOUNDED PRECEDING) AS cnt1,\n        |    SUM(a) OVER (PARTITION BY c ORDER BY proctime RANGE UNBOUNDED PRECEDING) AS cnt2\n        |FROM MyTable\n      ")).stripMargin();
        String sql2 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT c,\n        |    COUNT(a) OVER w AS cnt1,\n        |    SUM(a) OVER (PARTITION BY c ORDER BY proctime RANGE UNBOUNDED PRECEDING) AS cnt2\n        |FROM MyTable WINDOW w AS (\n        |    PARTITION BY c ORDER BY proctime RANGE UNBOUNDED PRECEDING)\n      ")).stripMargin();
        this.verifyPlanIdentical(sql, sql2);
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testProcTimeUnboundedPartitionedRowsOver() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT c,\n        |    COUNT(a) OVER (PARTITION BY c ORDER BY proctime\n        |        ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW)\n        |FROM MyTable\n      ")).stripMargin();
        String sql2 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT c, COUNT(a) OVER w FROM MyTable WINDOW w AS (\n        |    PARTITION BY c ORDER BY proctime ROWS UNBOUNDED PRECEDING)\n      ")).stripMargin();
        this.verifyPlanIdentical(sql, sql2);
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testProcTimeUnboundedNonPartitionedRangeOver() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT c,\n        |    COUNT(a) OVER (ORDER BY proctime RANGE UNBOUNDED PRECEDING) AS cnt1,\n        |    SUM(a) OVER (ORDER BY proctime RANGE UNBOUNDED PRECEDING) AS cnt2\n        |FROM MyTable\n      ")).stripMargin();
        String sql2 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT c,\n        |    COUNT(a) OVER (ORDER BY proctime RANGE UNBOUNDED PRECEDING) AS cnt1,\n        |    sum(a) OVER w AS cnt2\n        |FROM MyTable WINDOW w AS(\n        |    ORDER BY proctime RANGE UNBOUNDED PRECEDING)\n      ")).stripMargin();
        this.verifyPlanIdentical(sql, sql2);
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testProcTimeUnboundedNonPartitionedRowsOver() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT c,\n        |    COUNT(a) OVER (ORDER BY proctime ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW)\n        |FROM MyTable\n      ")).stripMargin();
        String sql2 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT c, COUNT(a) OVER w FROM MyTable WINDOW w AS (\n        |    ORDER BY proctime ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW)\n      ")).stripMargin();
        this.verifyPlanIdentical(sql, sql2);
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testRowTimeBoundedPartitionedRowsOver() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT c,\n        |    COUNT(a) OVER (PARTITION BY c ORDER BY rowtime\n        |        ROWS BETWEEN 5 preceding AND CURRENT ROW)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testRowTimeBoundedPartitionedRangeOver() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT c,\n        |    COUNT(a) OVER (PARTITION BY c ORDER BY rowtime\n        |        RANGE BETWEEN INTERVAL '1' SECOND  PRECEDING AND CURRENT ROW)\n        |    FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testRowTimeBoundedNonPartitionedRowsOver() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT c,\n        |    COUNT(a) OVER (ORDER BY rowtime ROWS BETWEEN 5 PRECEDING AND CURRENT ROW)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testRowTimeBoundedNonPartitionedRangeOver() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT c,\n        |    COUNT(a) OVER (ORDER BY rowtime\n        |        RANGE BETWEEN INTERVAL '1' SECOND  PRECEDING AND CURRENT ROW) AS cnt1\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testRowTimeUnboundedPartitionedRangeOver() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT c,\n        |    COUNT(a) OVER (PARTITION BY c ORDER BY rowtime RANGE UNBOUNDED PRECEDING) AS cnt1,\n        |    SUM(a) OVER (PARTITION BY c ORDER BY rowtime RANGE UNBOUNDED PRECEDING) AS cnt2\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testRowTimeUnboundedPartitionedRowsOver() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT c,\n        |    COUNT(a) OVER (PARTITION BY c ORDER BY rowtime ROWS UNBOUNDED PRECEDING) AS cnt1,\n        |    SUM(a) OVER (PARTITION BY c ORDER BY rowtime ROWS UNBOUNDED PRECEDING) AS cnt2\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testRowTimeUnboundedNonPartitionedRangeOver() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT c,\n        |    COUNT(a) OVER (ORDER BY rowtime RANGE UNBOUNDED PRECEDING) AS cnt1,\n        |    SUM(a) OVER (ORDER BY rowtime RANGE UNBOUNDED PRECEDING) AS cnt2\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testRowTimeUnboundedNonPartitionedRowsOver() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT c,\n        |    COUNT(a) OVER (ORDER BY rowtime ROWS UNBOUNDED PRECEDING) AS cnt1,\n        |    SUM(a) OVER (ORDER BY rowtime ROWS UNBOUNDED preceding) AS cnt2\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testProcTimeBoundedPartitionedRowsOverDifferentWindows() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a,\n        |    SUM(c) OVER (PARTITION BY a ORDER BY proctime\n        |       ROWS BETWEEN 3 PRECEDING AND CURRENT ROW),\n        |    MIN(c) OVER (PARTITION BY a ORDER BY proctime\n        |       ROWS BETWEEN 2 PRECEDING AND CURRENT ROW)\n        |FROM MyTable\n      ")).stripMargin();
        String sql2 = "SELECT a, SUM(c) OVER w1, MIN(c) OVER w2 FROM MyTable WINDOW w1 AS (PARTITION BY a ORDER BY proctime ROWS BETWEEN 3 PRECEDING AND CURRENT ROW),w2 AS (PARTITION BY a ORDER BY proctime ROWS BETWEEN 2 PRECEDING AND CURRENT ROW)";
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> {
            this.verifyPlanIdentical(sql, sql2);
            this.util().verifyExecPlan(sql);
        });
    }

    @Test
    public void testProcTimeBoundedPartitionedRowsOverWithBuiltinProctime() {
        String sqlQuery = "SELECT a,   SUM(c) OVER (    PARTITION BY a ORDER BY proctime() ROWS BETWEEN 4 PRECEDING AND CURRENT ROW),   MIN(c) OVER (    PARTITION BY a ORDER BY proctime() ROWS BETWEEN 4 PRECEDING AND CURRENT ROW) FROM MyTable";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testNestedOverAgg() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TEMPORARY TABLE src (\n                     |  a STRING,\n                     |  b STRING,\n                     |  ts TIMESTAMP_LTZ(3),\n                     |  watermark FOR ts as ts\n                     |) WITH (\n                     |  'connector' = 'values'\n                     |)\n                     |")).stripMargin());
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n                           |SELECT *\n                           |FROM (\n                           | SELECT\n                           |    *, count(*) OVER (PARTITION BY a ORDER BY ts) AS c2\n                           |  FROM (\n                           |    SELECT\n                           |      *, count(*) OVER (PARTITION BY a,b ORDER BY ts) AS c1\n                           |    FROM src\n                           |  )\n                           |)\n                           |")).stripMargin());
    }

    public OverAggregateTest() {
        this.util().addDataStream("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.agg.OverAggregateTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
    }
}

