/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import java.time.Duration;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001}4A\u0001H\u000f\u0001]!)Q\u0007\u0001C\u0001m!9\u0011\b\u0001b\u0001\n\u0013Q\u0004B\u0002 \u0001A\u0003%1\bC\u0003@\u0001\u0011\u0005\u0001\tC\u0003S\u0001\u0011\u0005\u0001\tC\u0003U\u0001\u0011\u0005\u0001\tC\u0003W\u0001\u0011\u0005\u0001\tC\u0003Y\u0001\u0011\u0005\u0001\tC\u0003[\u0001\u0011\u0005\u0001\tC\u0003]\u0001\u0011\u0005\u0001\tC\u0003_\u0001\u0011\u0005\u0001\tC\u0003a\u0001\u0011\u0005\u0001\tC\u0003c\u0001\u0011\u0005\u0001\tC\u0003e\u0001\u0011\u0005\u0001\tC\u0003g\u0001\u0011\u0005\u0001\tC\u0003i\u0001\u0011\u0005\u0001\tC\u0003k\u0001\u0011\u0005\u0001\tC\u0003m\u0001\u0011\u0005\u0001\tC\u0003o\u0001\u0011\u0005\u0001\tC\u0003q\u0001\u0011\u0005\u0001\tC\u0003s\u0001\u0011\u0005\u0001\tC\u0003u\u0001\u0011\u0005\u0001\tC\u0003w\u0001\u0011\u0005\u0001\tC\u0003y\u0001\u0011\u0005\u0001\tC\u0003{\u0001\u0011\u0005\u0001\tC\u0003}\u0001\u0011\u0005\u0001\tC\u0003\u007f\u0001\u0011%\u0001IA\fXS:$wn\u001e+bE2,g)\u001e8di&|g\u000eV3ti*\u0011adH\u0001\u0004gFd'B\u0001\u0011\"\u0003\u0019\u0019HO]3b[*\u0011!eI\u0001\u0005a2\fgN\u0003\u0002%K\u00059\u0001\u000f\\1o]\u0016\u0014(B\u0001\u0014(\u0003\u0015!\u0018M\u00197f\u0015\tA\u0013&A\u0003gY&t7N\u0003\u0002+W\u00051\u0011\r]1dQ\u0016T\u0011\u0001L\u0001\u0004_J<7\u0001A\n\u0003\u0001=\u0002\"\u0001M\u001a\u000e\u0003ER!AM\u0012\u0002\u000bU$\u0018\u000e\\:\n\u0005Q\n$!\u0004+bE2,G+Z:u\u0005\u0006\u001cX-\u0001\u0004=S:LGO\u0010\u000b\u0002oA\u0011\u0001\bA\u0007\u0002;\u0005!Q\u000f^5m+\u0005Y\u0004C\u0001\u0019=\u0013\ti\u0014GA\nTiJ,\u0017-\u001c+bE2,G+Z:u+RLG.A\u0003vi&d\u0007%A\u0007uKN$H+^7cY\u0016$fK\u0012\u000b\u0002\u0003B\u0011!)R\u0007\u0002\u0007*\tA)A\u0003tG\u0006d\u0017-\u0003\u0002G\u0007\n!QK\\5uQ\t!\u0001\n\u0005\u0002J!6\t!J\u0003\u0002L\u0019\u0006\u0019\u0011\r]5\u000b\u00055s\u0015a\u00026va&$XM\u001d\u0006\u0003\u001f.\nQA[;oSRL!!\u0015&\u0003\tQ+7\u000f^\u0001\u0016i\u0016\u001cH\u000fV;nE2,GK\u0016$Qe>\u001cG/[7fQ\t)\u0001*\u0001\u0006uKN$\bj\u001c9U-\u001aC#A\u0002%\u0002%Q,7\u000f\u001e%paR3f\t\u0015:pGRLW.\u001a\u0015\u0003\u000f!\u000bq\u0002^3ti\u000e+X.\u001e7bi\u0016$fK\u0012\u0015\u0003\u0011!\u000bq\u0003^3ti\u000e+X.\u001e7bi\u0016$fK\u0012)s_\u000e$\u0018.\\3)\u0005%A\u0015\u0001\b;fgR<\u0016N\u001c3po>sgj\u001c8US6,\u0017\t\u001e;sS\n,H/\u001a\u0015\u0003\u0015!\u000b\u0011\u0004^3ti\u000e{gN\u001a7jGRLgn\u001a$jK2$g*Y7fg\"\u00121\u0002S\u0001\u0018i\u0016\u001cH\u000fV;nE2,GK\u0016$XSRDwJ\u001a4tKRD#\u0001\u0004%\u0002?Q,7\u000f\u001e+v[\ndW\r\u0016,G/&$\bNT3hCRLg/Z(gMN,G\u000f\u000b\u0002\u000e\u0011\u0006aB/Z:u)Vl'\r\\3U-\u001a;\u0016\u000e\u001e5OC6,G\rU1sC6\u001c\bF\u0001\bI\u0003Q!Xm\u001d;I_B$fKR,ji\"|eMZ:fi\"\u0012q\u0002S\u0001\u001di\u0016\u001cH\u000fS8q)Z3u+\u001b;i\u001d\u0016<\u0017\r^5wK>3gm]3uQ\t\u0001\u0002*A\ruKN$\bj\u001c9U-\u001a;\u0016\u000e\u001e5OC6,G\rU1sC6\u001c\bFA\tI\u0003e!Xm\u001d;Dk6,H.\u0019;f)Z3u+\u001b;i\u001f\u001a47/\u001a;)\u0005IA\u0015!\t;fgR\u001cU/\\;mCR,GK\u0016$XSRDg*Z4bi&4Xm\u00144gg\u0016$\bFA\nI\u00039!Xm\u001d;TKN\u001c\u0018n\u001c8U-\u001aC#\u0001\u0006%\u0002-Q,7\u000f^*fgNLwN\u001c+W\rB\u0013xn\u0019;j[\u0016D#!\u0006%\u0002?Q,7\u000f^*fgNLwN\u001c+W\r^KG\u000f\u001b)beRLG/[8o\u0017\u0016L8\u000f\u000b\u0002\u0017\u0011\u0006iB/Z:u'\u0016\u001c8/[8o)Z3u+\u001b;i\u001d\u0006lW\r\u001a)be\u0006l7\u000f\u000b\u0002\u0018\u0011\u00069C/Z:u/&tGm\\<U-\u001a;\u0016\u000e\u001e5OC6,G\rU1sC6\u001cxJ\u001d3fe\u000eC\u0017M\\4fQ\tA\u0002*\u0001\u0012uKN$\bK]8di&lWmV5oI><HK\u0016$XSRDW*\u001b8j\u0005\u0006$8\r\u001b\u0015\u00033!\u000b\u0011\u0005^3tiJ{w\u000f^5nK^Kg\u000eZ8x)Z3u+\u001b;i\u001b&t\u0017NQ1uG\"D#A\u0007%\u0002\u001f\u0015t\u0017M\u00197f\u001b&t\u0017NQ1uG\"\u0004")
public class WindowTableFunctionTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testTumbleTVF() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testTumbleTVFProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '15' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testHopTVF() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        | HOP(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testHopTVFProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        | HOP(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testCumulateTVF() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        | CUMULATE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testCumulateTVFProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        | CUMULATE(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testWindowOnNonTimeAttribute() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE VIEW v1 AS\n                               |SELECT *, LOCALTIMESTAMP AS cur_time\n                               |FROM MyTable\n                               |")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        | TUMBLE(TABLE v1, DESCRIPTOR(cur_time), INTERVAL '15' MINUTE))\n        |")).stripMargin();
        Assertions.assertThatThrownBy(() -> this.util().verifyRelPlan(sql)).hasCause((Throwable)new ValidationException("The window function requires the timecol is a time attribute type, but is TIMESTAMP(3)."));
    }

    @Test
    public void testConflictingFieldNames() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE VIEW v1 AS\n                               |SELECT *, rowtime AS window_start\n                               |FROM MyTable\n                               |")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        | TUMBLE(TABLE v1, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlan(sql)).hasMessageContaining("Column 'window_start' is ambiguous") instanceof ValidationException;
    }

    @Test
    public void testTumbleTVFWithOffset() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(TUMBLE(\n        |   TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE, INTERVAL '5' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testTumbleTVFWithNegativeOffset() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(TUMBLE(\n        |   TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE, INTERVAL '-5' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testTumbleTVFWithNamedParams() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(TUMBLE(\n        |   DATA => TABLE MyTable,\n        |   TIMECOL => DESCRIPTOR(rowtime),\n        |   SIZE => INTERVAL '15' MINUTE,\n        |   `OFFSET` => INTERVAL '5' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testHopTVFWithOffset() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        |  HOP(\n        |    TABLE MyTable,\n        |    DESCRIPTOR(rowtime),\n        |    INTERVAL '1' MINUTE,\n        |    INTERVAL '15' MINUTE,\n        |    INTERVAL '5' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testHopTVFWithNegativeOffset() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        |  HOP(\n        |    TABLE MyTable,\n        |    DESCRIPTOR(rowtime),\n        |    INTERVAL '1' MINUTE,\n        |    INTERVAL '15' MINUTE,\n        |    INTERVAL '-5' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testHopTVFWithNamedParams() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(TUMBLE(\n        |   DATA => TABLE MyTable,\n        |   TIMECOL => DESCRIPTOR(rowtime),\n        |   SIZE => INTERVAL '15' MINUTE,\n        |   `OFFSET` => INTERVAL '5' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testCumulateTVFWithOffset() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        |  CUMULATE(\n        |    TABLE MyTable,\n        |    DESCRIPTOR(rowtime),\n        |    INTERVAL '1' MINUTE,\n        |    INTERVAL '15' MINUTE,\n        |    INTERVAL '5' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testCumulateTVFWithNegativeOffset() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        |  CUMULATE(\n        |    TABLE MyTable,\n        |    DESCRIPTOR(rowtime),\n        |    INTERVAL '1' MINUTE,\n        |    INTERVAL '15' MINUTE,\n        |    INTERVAL '-5' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testSessionTVF() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(SESSION(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testSessionTVFProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(SESSION(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '15' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testSessionTVFWithPartitionKeys() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(SESSION(TABLE MyTable PARTITION BY (b, a), DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testSessionTVFWithNamedParams() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        |     SESSION(\n        |         DATA => TABLE MyTable PARTITION BY (b, a),\n        |         TIMECOL => DESCRIPTOR(rowtime),\n        |         GAP => INTERVAL '15' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testWindowTVFWithNamedParamsOrderChange() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        |     SESSION(\n        |         DATA => TABLE MyTable PARTITION BY (b, a),\n        |         GAP => INTERVAL '15' MINUTE,\n        |         TIMECOL => DESCRIPTOR(rowtime)))\n        |")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlan(sql)).hasMessage("fieldList must not be null, type = INTERVAL MINUTE") instanceof AssertionError;
    }

    @Test
    public void testProctimeWindowTVFWithMiniBatch() {
        this.enableMiniBatch();
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '15' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testRowtimeWindowTVFWithMiniBatch() {
        this.enableMiniBatch();
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    private void enableMiniBatch() {
        this.util().tableConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)Boolean.TRUE);
        this.util().tableConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_SIZE, (Object)5L);
        this.util().tableConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(5L));
    }

    public WindowTableFunctionTest() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                              |CREATE TABLE MyTable (\n                              |  a INT,\n                              |  b BIGINT,\n                              |  c STRING,\n                              |  d DECIMAL(10, 3),\n                              |  rowtime TIMESTAMP(3),\n                              |  proctime as PROCTIME(),\n                              |  WATERMARK FOR rowtime AS rowtime - INTERVAL '1' SECOND\n                              |) with (\n                              |  'connector' = 'values'\n                              |)\n                              |")).stripMargin());
    }
}

