/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.plan.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Q4A\u0001G\r\u0001U!)\u0011\u0007\u0001C\u0001e!9Q\u0007\u0001b\u0001\n\u00131\u0004B\u0002\u001e\u0001A\u0003%q\u0007C\u0003<\u0001\u0011\u0005A\bC\u0003O\u0001\u0011\u0005A\bC\u0003Q\u0001\u0011\u0005A\bC\u0003S\u0001\u0011\u0005A\bC\u0003U\u0001\u0011\u0005A\bC\u0003W\u0001\u0011\u0005A\bC\u0003Y\u0001\u0011\u0005A\bC\u0003[\u0001\u0011\u0005A\bC\u0003]\u0001\u0011\u0005A\bC\u0003_\u0001\u0011\u0005A\bC\u0003a\u0001\u0011\u0005A\bC\u0003c\u0001\u0011\u0005A\bC\u0003e\u0001\u0011\u0005A\bC\u0003g\u0001\u0011\u0005A\bC\u0003i\u0001\u0011\u0005A\bC\u0003k\u0001\u0011\u0005A\bC\u0003m\u0001\u0011\u0005A\bC\u0003o\u0001\u0011\u0005A\bC\u0003q\u0001\u0011\u0005A\bC\u0003s\u0001\u0011\u0005AH\u0001\bXS:$wn\u001e*b].$Vm\u001d;\u000b\u0005iY\u0012aA:rY*\u0011A$H\u0001\u0007gR\u0014X-Y7\u000b\u0005yy\u0012\u0001\u00029mC:T!\u0001I\u0011\u0002\u000fAd\u0017M\u001c8fe*\u0011!eI\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003I\u0015\nQA\u001a7j].T!AJ\u0014\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0013aA8sO\u000e\u00011C\u0001\u0001,!\tas&D\u0001.\u0015\tqs$A\u0003vi&d7/\u0003\u00021[\tiA+\u00192mKR+7\u000f\u001e\"bg\u0016\fa\u0001P5oSRtD#A\u001a\u0011\u0005Q\u0002Q\"A\r\u0002\tU$\u0018\u000e\\\u000b\u0002oA\u0011A\u0006O\u0005\u0003s5\u00121c\u0015;sK\u0006lG+\u00192mKR+7\u000f^+uS2\fQ!\u001e;jY\u0002\n1\u0007^3tiNKW\u000e\u001d7jMf$V/\u001c2mK^Kg\u000eZ8x)Z3%)\u001a4pe\u0016<\u0016N\u001c3poJ\u000bgn[,ji\"\u001c\u0015\r\\2\u0015\u0003u\u0002\"AP!\u000e\u0003}R\u0011\u0001Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0005~\u0012A!\u00168ji\"\u0012A\u0001\u0012\t\u0003\u000b2k\u0011A\u0012\u0006\u0003\u000f\"\u000b1!\u00199j\u0015\tI%*A\u0004kkBLG/\u001a:\u000b\u0005-;\u0013!\u00026v]&$\u0018BA'G\u0005\u0011!Vm\u001d;\u0002WQ,7\u000f^*j[Bd\u0017NZ=Uk6\u0014G.Z,j]\u0012|w\u000f\u0016,G\u0005\u00164wN]3XS:$wn\u001e*b].D#!\u0002#\u0002SQ,7\u000f^+ogV\u0004\bo\u001c:uK\u0012<\u0016N\u001c3poR3fi\u0018+v[\ndWm\u00148Qe>\u001cG/[7fQ\t1A)\u0001\u0019uKN$8+[7qY&4\u0017\u0010S8q/&tGm\\<U-\u001a\u0013UMZ8sK^Kg\u000eZ8x%\u0006t7nV5uQ\u000e\u000bGn\u0019\u0015\u0003\u000f\u0011\u000b\u0001\u0006^3tiNKW\u000e\u001d7jMfDu\u000e],j]\u0012|w\u000f\u0016,G\u0005\u00164wN]3XS:$wn\u001e*b].D#\u0001\u0003#\u0002MQ,7\u000f^+ogV\u0004\bo\u001c:uK\u0012<\u0016N\u001c3poR3fi\u0018%pa>s\u0007K]8di&lW\r\u000b\u0002\n\t\u0006)D/Z:u'&l\u0007\u000f\\5gs\u000e+X.\u001e7bi\u0016<\u0016N\u001c3poR3fIQ3g_J,w+\u001b8e_^\u0014\u0016M\\6XSRD7)\u00197dQ\tQA)A\u0017uKN$8+[7qY&4\u0017pQ;nk2\fG/Z,j]\u0012|w\u000f\u0016,G\u0005\u00164wN]3XS:$wn\u001e*b].D#a\u0003#\u0002WQ,7\u000f^+ogV\u0004\bo\u001c:uK\u0012<\u0016N\u001c3poR3fiX\"v[Vd\u0017\r^3P]B\u0013xn\u0019;j[\u0016D#\u0001\u0004#\u00027Q,7\u000f^(o)Vl'\r\\3XS:$wn^!hOJ,w-\u0019;fQ\tiA)A\u0013uKN$xJ\u001c+v[\ndWmV5oI><\u0018iZ4sK\u001e\fG/Z(o!J|7\r^5nK\"\u0012a\u0002R\u0001\u0019i\u0016\u001cHo\u00148I_B<\u0016N\u001c3po\u0006;wM]3hCR,\u0007FA\bE\u0003\t\"Xm\u001d;P]\"{\u0007oV5oI><\u0018iZ4sK\u001e\fG/Z(o!J|7\r^5nK\"\u0012\u0001\u0003R\u0001\u001ei\u0016\u001cHo\u00148Dk6,H.\u0019;f/&tGm\\<BO\u001e\u0014XmZ1uK\"\u0012\u0011\u0003R\u0001(i\u0016\u001cHo\u00148Dk6,H.\u0019;f/&tGm\\<BO\u001e\u0014XmZ1uK>s\u0007K]8di&lW\r\u000b\u0002\u0013\t\u00069C/Z:u)&lW-\u0011;ue&\u0014W\u000f^3Qe>\u0004\u0018mZ1uK\u001a{'oV5oI><(+\u00198lQ\t\u0019B)\u0001\u0015uKN$H+[7f\u0003R$(/\u001b2vi\u0016\u0004&o\u001c9bO\u0006$XMR8s/&tGm\\<SC:\\\u0017\u0007\u000b\u0002\u0015\t\u0006\u0001B/Z:u%\u0006t7NR;oGRLwN\u001c\u0015\u0003+\u0011\u000bQ\u0003^3ti\u0012+gn]3SC:\\g)\u001e8di&|g\u000e\u000b\u0002\u0017\t\u0006)B/Z:u-\u0006\u0014\u0018.\u00192mKJ\u000bgn\u001b*b]\u001e,\u0007FA\fE\u0001")
public class WindowRankTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testSimplifyTumbleWindowTVFBeforeWindowRankWithCalc() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT window_start, window_end, window_time, a, b, c, d, e\n        |FROM (\n        |SELECT *,\n        |   ROW_NUMBER() OVER(PARTITION BY a, window_start, window_end ORDER BY b DESC) as rownum\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |)\n        |WHERE rownum <= 3\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testSimplifyTumbleWindowTVFBeforeWindowRank() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |SELECT *,\n        |   ROW_NUMBER() OVER(PARTITION BY a, window_start, window_end ORDER BY b DESC) as rownum\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |)\n        |WHERE rownum <= 3\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testUnsupportedWindowTVF_TumbleOnProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT window_start, window_end, window_time, a, b, c, d, e\n        |FROM (\n        |SELECT *,\n        |   ROW_NUMBER() OVER(PARTITION BY a, window_start, window_end ORDER BY b DESC) as rownum\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '15' MINUTE))\n        |)\n        |WHERE rownum <= 3\n      ")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(sql)).hasMessageContaining("Processing time Window TopN is not supported yet.") instanceof TableException;
    }

    @Test
    public void testSimplifyHopWindowTVFBeforeWindowRankWithCalc() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT window_start, window_end, window_time, a, b, c, d, e\n        |FROM (\n        |SELECT *,\n        |   ROW_NUMBER() OVER(PARTITION BY a, window_start, window_end ORDER BY b DESC) as rownum\n        |FROM TABLE(\n        |  HOP(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |)\n        |WHERE rownum <= 3\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testSimplifyHopWindowTVFBeforeWindowRank() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |SELECT *,\n        |   ROW_NUMBER() OVER(PARTITION BY a, window_start, window_end ORDER BY b DESC) as rownum\n        |FROM TABLE(\n        |  HOP(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |)\n        |WHERE rownum <= 3\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testUnsupportedWindowTVF_HopOnProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT window_start, window_end, window_time, a, b, c, d, e\n        |FROM (\n        |SELECT *,\n        |   ROW_NUMBER() OVER(PARTITION BY a, window_start, window_end ORDER BY b DESC) as rownum\n        |FROM TABLE(\n        |  HOP(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |)\n        |WHERE rownum <= 3\n      ")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(sql)).hasMessageContaining("Processing time Window TopN is not supported yet.") instanceof TableException;
    }

    @Test
    public void testSimplifyCumulateWindowTVFBeforeWindowRankWithCalc() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT window_start, window_end, window_time, a, b, c, d, e\n        |FROM (\n        |SELECT *,\n        |   ROW_NUMBER() OVER(PARTITION BY a, window_start, window_end ORDER BY b DESC) as rownum\n        |FROM TABLE(\n        |  CUMULATE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |)\n        |WHERE rownum <= 3\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testSimplifyCumulateWindowTVFBeforeWindowRank() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |SELECT *,\n        |   ROW_NUMBER() OVER(PARTITION BY a, window_start, window_end ORDER BY b DESC) as rownum\n        |FROM TABLE(\n        |  CUMULATE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |)\n        |WHERE rownum <= 3\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testUnsupportedWindowTVF_CumulateOnProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT window_start, window_end, window_time, a, b, c, d, e\n        |FROM (\n        |SELECT *,\n        |   ROW_NUMBER() OVER(PARTITION BY a, window_start, window_end ORDER BY b DESC) as rownum\n        |FROM TABLE(\n        |  CUMULATE(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |)\n        |WHERE rownum <= 3\n      ")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(sql)).hasMessageContaining("Processing time Window TopN is not supported yet.") instanceof TableException;
    }

    @Test
    public void testOnTumbleWindowAggregate() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT window_start, window_end, window_time, a, cnt, sum_d, max_d, wAvg, uv\n        |FROM (\n        |SELECT *,\n        |   ROW_NUMBER() OVER(PARTITION BY window_start, window_end ORDER BY cnt DESC) as rownum\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    sum(d) as sum_d,\n        |    max(d) filter (where b > 1000) as max_d,\n        |    weightedAvg(b, e) AS wAvg,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |  )\n        |)\n        |WHERE rownum <= 3\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testOnTumbleWindowAggregateOnProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT window_start, window_end, window_time, a, cnt, sum_d, max_d, wAvg, uv\n        |FROM (\n        |SELECT *,\n        |   ROW_NUMBER() OVER(PARTITION BY a, window_start, window_end ORDER BY cnt DESC) as rownum\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    sum(d) as sum_d,\n        |    max(d) filter (where b > 1000) as max_d,\n        |    weightedAvg(b, e) AS wAvg,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |  )\n        |)\n        |WHERE rownum <= 3\n      ")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(sql)).hasMessageContaining("Processing time Window TopN is not supported yet.") instanceof TableException;
    }

    @Test
    public void testOnHopWindowAggregate() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT window_start, window_end, window_time, a, cnt, sum_d, max_d, wAvg, uv\n        |FROM (\n        |SELECT *,\n        |   ROW_NUMBER() OVER(PARTITION BY a, window_start, window_end ORDER BY cnt DESC) as rownum\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    sum(d) as sum_d,\n        |    max(d) filter (where b > 1000) as max_d,\n        |    weightedAvg(b, e) AS wAvg,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |    HOP(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |  )\n        |)\n        |WHERE rownum <= 3\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testOnHopWindowAggregateOnProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT window_start, window_end, window_time, a, cnt, sum_d, max_d, wAvg, uv\n        |FROM (\n        |SELECT *,\n        |   ROW_NUMBER() OVER(PARTITION BY a, window_start, window_end ORDER BY cnt DESC) as rownum\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    sum(d) as sum_d,\n        |    max(d) filter (where b > 1000) as max_d,\n        |    weightedAvg(b, e) AS wAvg,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |    HOP(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |  )\n        |)\n        |WHERE rownum <= 3\n      ")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(sql)).hasMessageContaining("Processing time Window TopN is not supported yet.") instanceof TableException;
    }

    @Test
    public void testOnCumulateWindowAggregate() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT window_start, window_end, window_time, a, cnt, sum_d, max_d, wAvg, uv\n        |FROM (\n        |SELECT *,\n        |   ROW_NUMBER() OVER(\n        |     PARTITION BY window_start, window_end ORDER BY cnt DESC) as rownum\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    sum(d) as sum_d,\n        |    max(d) filter (where b > 1000) as max_d,\n        |    weightedAvg(b, e) AS wAvg,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |    CUMULATE(\n        |      TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  GROUP BY a, window_start, window_end, window_time\n        |  )\n        |)\n        |WHERE rownum <= 3\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testOnCumulateWindowAggregateOnProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT window_start, window_end, window_time, a, cnt, sum_d, max_d, wAvg, uv\n        |FROM (\n        |SELECT *,\n        |   ROW_NUMBER() OVER(\n        |     PARTITION BY a, window_start, window_end ORDER BY cnt DESC) as rownum\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    sum(d) as sum_d,\n        |    max(d) filter (where b > 1000) as max_d,\n        |    weightedAvg(b, e) AS wAvg,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |    CUMULATE(\n        |      TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  GROUP BY a, window_start, window_end, window_time\n        |  )\n        |)\n        |WHERE rownum <= 3\n      ")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(sql)).hasMessageContaining("Processing time Window TopN is not supported yet.") instanceof TableException;
    }

    @Test
    public void testTimeAttributePropagateForWindowRank() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW tmp AS\n        |SELECT window_time as rowtime, a, b, c, d, e\n        |FROM (\n        |SELECT *,\n        |   ROW_NUMBER() OVER(PARTITION BY a, window_start, window_end ORDER BY b DESC) as rownum\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |)\n        |WHERE rownum <= 3\n      ")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE tmp, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testTimeAttributePropagateForWindowRank1() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW tmp1 AS\n        |SELECT window_time as rowtime, a, cnt, sum_d, max_d, wAvg, uv\n        |FROM (\n        |  SELECT *,\n        |    ROW_NUMBER() OVER(PARTITION BY a, window_start, window_end ORDER BY cnt DESC) as rownum\n        |  FROM (\n        |    SELECT\n        |      a,\n        |      window_start,\n        |      window_end,\n        |      window_time,\n        |      count(*) as cnt,\n        |      sum(d) as sum_d,\n        |      max(d) filter (where b > 1000) as max_d,\n        |      weightedAvg(b, e) AS wAvg,\n        |      count(distinct c) AS uv\n        |    FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |    GROUP BY a, window_start, window_end, window_time\n        |  )\n        |)\n        |WHERE rownum <= 3\n      ")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   sum(cnt),\n        |   sum(sum_d),\n        |   max(max_d)\n        |FROM TABLE(TUMBLE(TABLE tmp1, DESCRIPTOR(rowtime), INTERVAL '1' HOUR))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testRankFunction() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT window_start, window_end, window_time, a, cnt, sum_d, max_d, wAvg, uv\n        |FROM (\n        |SELECT *,\n        |   RANK() OVER(PARTITION BY window_start, window_end ORDER BY cnt DESC) as rownum\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    sum(d) as sum_d,\n        |    max(d) filter (where b > 1000) as max_d,\n        |    weightedAvg(b, e) AS wAvg,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |  )\n        |)\n        |WHERE rownum <= 3\n      ")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(sql)).hasMessageContaining("RANK() function is not supported on Window TopN currently, only ROW_NUMBER() is supported.") instanceof TableException;
    }

    @Test
    public void testDenseRankFunction() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT window_start, window_end, window_time, a, cnt, sum_d, max_d, wAvg, uv\n        |FROM (\n        |SELECT *,\n        |   DENSE_RANK() OVER(PARTITION BY window_start, window_end ORDER BY cnt DESC) as rownum\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    sum(d) as sum_d,\n        |    max(d) filter (where b > 1000) as max_d,\n        |    weightedAvg(b, e) AS wAvg,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |  )\n        |)\n        |WHERE rownum <= 3\n      ")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(sql)).hasMessageContaining("DENSE_RANK() function is not supported on Window TopN currently, only ROW_NUMBER() is supported.") instanceof TableException;
    }

    @Test
    public void testVariableRankRange() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT window_start, window_end, window_time, a, cnt, sum_d, max_d, wAvg, uv\n        |FROM (\n        |SELECT *,\n        |   ROW_NUMBER() OVER(PARTITION BY window_start, window_end ORDER BY cnt DESC) as rownum\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    sum(d) as sum_d,\n        |    max(d) filter (where b > 1000) as max_d,\n        |    max(b) as max_b,\n        |    weightedAvg(b, e) AS wAvg,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |  )\n        |)\n        |WHERE rownum <= max_b\n      ")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(sql)).hasMessageContaining("Rank strategy rankEnd=max_b is not supported on window rank currently.") instanceof TableException;
    }

    public WindowRankTest() {
        this.util().addTemporarySystemFunction("weightedAvg", JavaUserDefinedAggFunctions.WeightedAvgWithMerge.class);
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                              |CREATE TABLE MyTable (\n                              |  a INT,\n                              |  b BIGINT,\n                              |  c STRING NOT NULL,\n                              |  d DECIMAL(10, 3),\n                              |  e BIGINT,\n                              |  rowtime TIMESTAMP(3),\n                              |  proctime as PROCTIME(),\n                              |  WATERMARK FOR rowtime AS rowtime - INTERVAL '1' SECOND\n                              |) with (\n                              |  'connector' = 'values'\n                              |)\n                              |")).stripMargin());
    }
}

