/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Timestamp;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.FunctionHint;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.stream.sql.RelTimeIndicatorConverterTest$;
import org.apache.flink.table.planner.runtime.utils.TestSinkUtil$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.types.DataType;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005]d\u0001B\u000e\u001d\u00015BQ\u0001\u000e\u0001\u0005\u0002UBq\u0001\u000f\u0001C\u0002\u0013%\u0011\b\u0003\u0004>\u0001\u0001\u0006IA\u000f\u0005\u0006}\u0001!\ta\u0010\u0005\u0006#\u0002!\ta\u0010\u0005\u0006'\u0002!\ta\u0010\u0005\u0006+\u0002!\ta\u0010\u0005\u0006/\u0002!\ta\u0010\u0005\u00063\u0002!\ta\u0010\u0005\u00067\u0002!\ta\u0010\u0005\u0006;\u0002!\ta\u0010\u0005\u0006?\u0002!\ta\u0010\u0005\u0006C\u0002!\ta\u0010\u0005\u0006G\u0002!\ta\u0010\u0005\u0006K\u0002!\ta\u0010\u0005\u0006O\u0002!\ta\u0010\u0005\u0006S\u0002!\ta\u0010\u0005\u0006W\u0002!\taP\u0004\u0006[rA\tA\u001c\u0004\u00067qA\ta\u001c\u0005\u0006iQ!\ta\u001d\u0004\u0005iR\u0001Q\u000f\u0003\u00045-\u0011\u0005\u0011q\u0002\u0005\n\u0003+1\"\u0019!C\u0001\u0003/A\u0001\"a\n\u0017A\u0003%\u0011\u0011\u0004\u0005\b\u0003S1B\u0011AA\u0016\u0005u\u0011V\r\u001c+j[\u0016Le\u000eZ5dCR|'oQ8om\u0016\u0014H/\u001a:UKN$(BA\u000f\u001f\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003?\u0001\naa\u001d;sK\u0006l'BA\u0011#\u0003\u0011\u0001H.\u00198\u000b\u0005\r\"\u0013a\u00029mC:tWM\u001d\u0006\u0003K\u0019\nQ\u0001^1cY\u0016T!a\n\u0015\u0002\u000b\u0019d\u0017N\\6\u000b\u0005%R\u0013AB1qC\u000eDWMC\u0001,\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0006\u0005\u00020e5\t\u0001G\u0003\u00022E\u0005)Q\u000f^5mg&\u00111\u0007\r\u0002\u000e)\u0006\u0014G.\u001a+fgR\u0014\u0015m]3\u0002\rqJg.\u001b;?)\u00051\u0004CA\u001c\u0001\u001b\u0005a\u0012\u0001B;uS2,\u0012A\u000f\t\u0003_mJ!\u0001\u0010\u0019\u0003'M#(/Z1n)\u0006\u0014G.\u001a+fgR,F/\u001b7\u0002\u000bU$\u0018\u000e\u001c\u0011\u00023Q,7\u000f^*j[BdW-T1uKJL\u0017\r\\5{CRLwN\u001c\u000b\u0002\u0001B\u0011\u0011\tR\u0007\u0002\u0005*\t1)A\u0003tG\u0006d\u0017-\u0003\u0002F\u0005\n!QK\\5uQ\t!q\t\u0005\u0002I\u001f6\t\u0011J\u0003\u0002K\u0017\u0006\u0019\u0011\r]5\u000b\u00051k\u0015a\u00026va&$XM\u001d\u0006\u0003\u001d*\nQA[;oSRL!\u0001U%\u0003\tQ+7\u000f^\u0001\u000ei\u0016\u001cHoU3mK\u000e$\u0018\t\u001c7)\u0005\u00159\u0015A\u0006;fgR4\u0015\u000e\u001c;fe&twm\u00148S_^$\u0018.\\3)\u0005\u00199\u0015!\u0006;fgR<%o\\;qS:<wJ\u001c*poRLW.\u001a\u0015\u0003\u000f\u001d\u000b\u0001\u0004^3ti\u0006;wM]3hCRLwN\\(o%><H/[7fQ\tAq)\u0001\fuKN$xI]8va&twm\u00148Qe>\u001cG/[7fQ\tIq)A\ruKN$\u0018iZ4sK\u001e\fG/[8o\u001f:\u0004&o\\2uS6,\u0007F\u0001\u0006H\u0003E!Xm\u001d;UC\ndWMR;oGRLwN\u001c\u0015\u0003\u0017\u001d\u000b\u0011\u0002^3tiVs\u0017n\u001c8)\u000519\u0015A\u0003;fgR<\u0016N\u001c3po\"\u0012QbR\u0001\fi\u0016\u001cHoV5oI><(\u0007\u000b\u0002\u000f\u000f\u0006yA/Z:u\u001bVdG/[,j]\u0012|w\u000f\u000b\u0002\u0010\u000f\u0006\u0011C/Z:u/&tGm\\<XSRD\u0017iZ4sK\u001e\fG/[8o\u001f:\u0014vn\u001e;j[\u0016D#\u0001E$\u0002YQ,7\u000f^,j]\u0012|woV5uQ\u0006;wM]3hCRLwN\\(o%><H/[7f/&$\b\u000eS1wS:<\u0007FA\tH\u00031\"Xm\u001d;LK\u0016\u0004\bK]8dKN\u001cH+[7f\u0003R$(/\u00114uKJ\u001cVOY$sCBDw\n\u001d;j[&TX\r\u000b\u0002\u0013\u000f\u0006i\"+\u001a7US6,\u0017J\u001c3jG\u0006$xN]\"p]Z,'\u000f^3s)\u0016\u001cH\u000f\u0005\u00028)M\u0011A\u0003\u001d\t\u0003\u0003FL!A\u001d\"\u0003\r\u0005s\u0017PU3g)\u0005q'!\u0003+bE2,g)\u001e8d'\t1b\u000fE\u0002xurl\u0011\u0001\u001f\u0006\u0003s\u0012\n\u0011BZ;oGRLwN\\:\n\u0005mD(!\u0004+bE2,g)\u001e8di&|g\u000eE\u0002~\u0003\u0013q1A`A\u0003!\ty()\u0004\u0002\u0002\u0002)\u0019\u00111\u0001\u0017\u0002\rq\u0012xn\u001c;?\u0013\r\t9AQ\u0001\u0007!J,G-\u001a4\n\t\u0005-\u0011Q\u0002\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u001d!\t\u0006\u0002\u0002\u0012A\u0019\u00111\u0003\f\u000e\u0003Q\t\u0011\u0001^\u000b\u0003\u00033\u0001B!a\u0007\u0002$5\u0011\u0011Q\u0004\u0006\u0004;\u0005}!BAA\u0011\u0003\u0011Q\u0017M^1\n\t\u0005\u0015\u0012Q\u0004\u0002\n)&lWm\u001d;b[B\f!\u0001\u001e\u0011\u0002\t\u00154\u0018\r\u001c\u000b\b\u0001\u00065\u0012QHA!\u0011\u001d\tyC\u0007a\u0001\u0003c\tQ\u0001^5nKF\u0002B!a\r\u0002:5\u0011\u0011Q\u0007\u0006\u0004\u0003o!\u0013\u0001\u00023bi\u0006LA!a\u000f\u00026\tiA+[7fgR\fW\u000e\u001d#bi\u0006Dq!a\u0010\u001b\u0001\u0004\tI\"A\u0003uS6,'\u0007\u0003\u0004\u0002Di\u0001\r\u0001`\u0001\u0007gR\u0014\u0018N\\4)\u000fi\t9%a\u0015\u0002VA!\u0011\u0011JA(\u001b\t\tYEC\u0002\u0002N\u0011\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\t&a\u0013\u0003\u0019\u0019+hn\u0019;j_:D\u0015N\u001c;\u0002\u000b%t\u0007/\u001e;-\r\u0005]\u0013\u0011NA9W)\tI&a\u0018\u0002b\u0005\u0015\u0014q\r\t\u0005\u0003\u0013\nY&\u0003\u0003\u0002^\u0005-#\u0001\u0004#bi\u0006$\u0016\u0010]3IS:$\u0018!\u0002<bYV,\u0017EAA2\u00031!\u0016*T#T)\u0006k\u0005\u000bK\u001a*\u0003%\u0011'/\u001b3hK\u0012$vn\t\u0002\u00022-R\u0011\u0011LA0\u0003W\n)'a\u001c\"\u0005\u00055\u0014\u0001\u0005+J\u001b\u0016\u001bF+Q'Q?2#&\fK\u001a*G\t\tIb\u000b\u0004\u0002Z\u0005}\u00131O\u0011\u0003\u0003k\naa\u0015+S\u0013:;\u0005")
public class RelTimeIndicatorConverterTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testSimpleMaterialization() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT rowtime FROM\n        |    (SELECT FLOOR(rowtime TO DAY) AS rowtime, long FROM MyTable WHERE long > 0) t\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSelectAll() {
        this.util().verifyExecPlan("SELECT * FROM MyTable");
    }

    @Test
    public void testFilteringOnRowtime() {
        String sqlQuery = "SELECT rowtime FROM MyTable1 WHERE rowtime > CAST('1990-12-02 12:11:11' AS TIMESTAMP(3))";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingOnRowtime() {
        this.util().verifyExecPlan("SELECT COUNT(long) FROM MyTable GROUP BY rowtime");
    }

    @Test
    public void testAggregationOnRowtime() {
        this.util().verifyExecPlan("SELECT MIN(rowtime) FROM MyTable1 GROUP BY long");
    }

    @Test
    public void testGroupingOnProctime() {
        this.util().verifyExecPlan("SELECT COUNT(long) FROM MyTable2 GROUP BY proctime");
    }

    @Test
    public void testAggregationOnProctime() {
        this.util().verifyExecPlan("SELECT MIN(proctime) FROM MyTable2 GROUP BY long");
    }

    @Test
    public void testTableFunction() {
        this.util().addTemporarySystemFunction("tableFunc", (UserDefinedFunction)new TableFunc());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT rowtime, proctime, s\n        |FROM MyTable, LATERAL TABLE(tableFunc(rowtime, proctime, '')) AS T(s)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testUnion() {
        this.util().verifyExecPlan("SELECT rowtime FROM MyTable1 UNION ALL SELECT rowtime FROM MyTable1");
    }

    @Test
    public void testWindow() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_END(rowtime, INTERVAL '10' SECOND),\n        |    long,\n        |    SUM(`int`)\n        |FROM MyTable1\n        |    GROUP BY TUMBLE(rowtime, INTERVAL '10' SECOND), long\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testWindow2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_END(rowtime, INTERVAL '0.1' SECOND) AS `rowtime`,\n        |    `long`,\n        |   SUM(`int`)\n        |FROM MyTable1\n        |   GROUP BY `long`, TUMBLE(rowtime, INTERVAL '0.1' SECOND)\n        |\n        ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testMultiWindow() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_END(newrowtime, INTERVAL '30' SECOND), long, sum(`int`) FROM (\n        |    SELECT\n        |        TUMBLE_ROWTIME(rowtime, INTERVAL '10' SECOND) AS newrowtime,\n        |        long,\n        |        sum(`int`) as `int`\n        |    FROM MyTable1\n        |        GROUP BY TUMBLE(rowtime, INTERVAL '10' SECOND), long\n        |) t GROUP BY TUMBLE(newrowtime, INTERVAL '30' SECOND), long\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testWindowWithAggregationOnRowtime() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT MIN(rowtime), long FROM MyTable1\n        |GROUP BY long, TUMBLE(rowtime, INTERVAL '0.1' SECOND)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testWindowWithAggregationOnRowtimeWithHaving() {
        String result = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT MIN(rowtime), long FROM MyTable1\n        |GROUP BY long, TUMBLE(rowtime, INTERVAL '1' SECOND)\n        |HAVING QUARTER(TUMBLE_END(rowtime, INTERVAL '1' SECOND)) = 1\n      ")).stripMargin();
        this.util().verifyExecPlan(result);
    }

    @Test
    public void testKeepProcessTimeAttrAfterSubGraphOptimize() {
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    long,\n        |    SUM(`int`)\n        |FROM MyTable2\n        |    GROUP BY TUMBLE(proctime, INTERVAL '10' SECOND), long\n      ")).stripMargin();
        Table table = this.util().tableEnv().sqlQuery(sql);
        TestSinkUtil$.MODULE$.addValuesSink(this.util().tableEnv(), "appendSink1", (List<String>)new .colon.colon((Object)"long", (List)new .colon.colon((Object)"sum", (List)Nil$.MODULE$)), (List<DataType>)new .colon.colon((Object)DataTypes.BIGINT(), (List)new .colon.colon((Object)DataTypes.BIGINT(), (List)Nil$.MODULE$)), ChangelogMode.insertOnly(), TestSinkUtil$.MODULE$.addValuesSink$default$6());
        stmtSet.addInsert("appendSink1", table);
        TestSinkUtil$.MODULE$.addValuesSink(this.util().tableEnv(), "appendSink2", (List<String>)new .colon.colon((Object)"long", (List)new .colon.colon((Object)"sum", (List)Nil$.MODULE$)), (List<DataType>)new .colon.colon((Object)DataTypes.BIGINT(), (List)new .colon.colon((Object)DataTypes.BIGINT(), (List)Nil$.MODULE$)), ChangelogMode.insertOnly(), TestSinkUtil$.MODULE$.addValuesSink$default$6());
        stmtSet.addInsert("appendSink2", table);
        this.util().verifyExecPlan(stmtSet);
    }

    public RelTimeIndicatorConverterTest() {
        this.util().addDataStream("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime(), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "long")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "int")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.RelTimeIndicatorConverterTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addDataStream("MyTable1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime(), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "long")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "int"))}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.stream.sql.RelTimeIndicatorConverterTest$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addDataStream("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "long")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "int")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}), new CaseClassTypeInfo<Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcJI.sp(BoxesRunTime.unboxToLong((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.stream.sql.RelTimeIndicatorConverterTest$$anon$5 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
    }

    public static class TableFunc
    extends TableFunction<String> {
        private final Timestamp t = new Timestamp(0L);

        public Timestamp t() {
            return this.t;
        }

        @FunctionHint(input={@DataTypeHint(value="TIMESTAMP(3)", bridgedTo=TimestampData.class), @DataTypeHint(value="TIMESTAMP_LTZ(3)", bridgedTo=Timestamp.class), @DataTypeHint(value="STRING")})
        public void eval(TimestampData time1, Timestamp time2, String string) {
            this.collect(new StringBuilder(0).append(time1.toString()).append(time2.after(this.t())).append(string).toString());
        }
    }
}

