/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMetadataQuery;
import org.apache.flink.table.planner.plan.stream.sql.Func1;
import org.apache.flink.table.planner.plan.stream.sql.ModifiedMonotonicityTest$;
import org.apache.flink.table.planner.plan.trait.RelModifiedMonotonicity;
import org.apache.flink.table.planner.plan.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Ea\u0001\u0002\r\u001a\u0001)BQ!\r\u0001\u0005\u0002IBq!\u000e\u0001C\u0002\u0013\u0005a\u0007\u0003\u0004;\u0001\u0001\u0006Ia\u000e\u0005\u0006w\u0001!\t\u0001\u0010\u0005\u0006\u001d\u0002!\t\u0001\u0010\u0005\u0006!\u0002!\t\u0001\u0010\u0005\u0006%\u0002!\t\u0001\u0010\u0005\u0006)\u0002!\t\u0001\u0010\u0005\u0006-\u0002!\t\u0001\u0010\u0005\u00061\u0002!\t\u0001\u0010\u0005\u00065\u0002!\t\u0001\u0010\u0005\u00069\u0002!\t\u0001\u0010\u0005\u0006=\u0002!\t\u0001\u0010\u0005\u0006A\u0002!\t\u0001\u0010\u0005\u0006E\u0002!\t\u0001\u0010\u0005\u0006I\u0002!\t\u0001\u0010\u0005\u0006M\u0002!\t\u0001\u0010\u0005\u0006Q\u0002!\t\u0001\u0010\u0005\u0006U\u0002!\t\u0001\u0010\u0005\u0006Y\u0002!\t\u0001\u0010\u0005\u0006]\u0002!\t\u0001\u0010\u0005\u0006a\u0002!\t\u0001\u0010\u0005\u0006e\u0002!\ta\u001d\u0002\u0019\u001b>$\u0017NZ5fI6{gn\u001c;p]&\u001c\u0017\u000e^=UKN$(B\u0001\u000e\u001c\u0003\r\u0019\u0018\u000f\u001c\u0006\u00039u\taa\u001d;sK\u0006l'B\u0001\u0010 \u0003\u0011\u0001H.\u00198\u000b\u0005\u0001\n\u0013a\u00029mC:tWM\u001d\u0006\u0003E\r\nQ\u0001^1cY\u0016T!\u0001J\u0013\u0002\u000b\u0019d\u0017N\\6\u000b\u0005\u0019:\u0013AB1qC\u000eDWMC\u0001)\u0003\ry'oZ\u0002\u0001'\t\u00011\u0006\u0005\u0002-_5\tQF\u0003\u0002/?\u0005)Q\u000f^5mg&\u0011\u0001'\f\u0002\u000e)\u0006\u0014G.\u001a+fgR\u0014\u0015m]3\u0002\rqJg.\u001b;?)\u0005\u0019\u0004C\u0001\u001b\u0001\u001b\u0005I\u0012\u0001B;uS2,\u0012a\u000e\t\u0003YaJ!!O\u0017\u0003'M#(/Z1n)\u0006\u0014G.\u001a+fgR,F/\u001b7\u0002\u000bU$\u0018\u000e\u001c\u0011\u00025Q,7\u000f^'bq^KG\u000f\u001b*fiJ\f7\r^(qi&l\u0017N_3\u0015\u0003u\u0002\"AP!\u000e\u0003}R\u0011\u0001Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0005~\u0012A!\u00168ji\"\u0012A\u0001\u0012\t\u0003\u000b2k\u0011A\u0012\u0006\u0003\u000f\"\u000b1!\u00199j\u0015\tI%*A\u0004kkBLG/\u001a:\u000b\u0005-;\u0013!\u00026v]&$\u0018BA'G\u0005\u0011!Vm\u001d;\u00025Q,7\u000f^'j]^KG\u000f\u001b*fiJ\f7\r^(qi&l\u0017N_3)\u0005\u0015!\u0015!\u0006;fgRl\u0015N\\\"b]:{Go\u00149uS6L'0\u001a\u0015\u0003\r\u0011\u000b\u0011\u0006^3ti6\u000b\u0007pV5uQJ+GO]1di>\u0003H/[7ju\u0016<\u0016\u000e\u001e5M_\u000e\fGn\u00127pE\u0006d\u0007FA\u0004E\u0003%\"Xm\u001d;NS:<\u0016\u000e\u001e5SKR\u0014\u0018m\u0019;PaRLW.\u001b>f/&$\b\u000eT8dC2<En\u001c2bY\"\u0012\u0001\u0002R\u0001%i\u0016\u001cH/T5o\u0007\u0006tgj\u001c;PaRLW.\u001b>f/&$\b\u000eT8dC2<En\u001c2bY\"\u0012\u0011\u0002R\u0001'i\u0016\u001cH\u000fV;nE2,g)\u001e8B]\u0012\u0014VmZ;mCJ\fum\u001a$v]&swI]8va\nK\bF\u0001\u0006E\u00031!Xm\u001d;B]RL'j\\5oQ\tYA)\u0001\ruKN$8+Z7j\u0015>LgnV5uQ:{g.R9vC2D#\u0001\u0004#\u0002\u0019Q,7\u000f^*f[&Tu.\u001b8)\u00055!\u0015\u0001\u0007;fgRLeN\\3s\u0015>Lgn\u00148BO\u001e\u0014Vm];mi\"\u0012a\u0002R\u0001\u000ei\u0016\u001cH/\u00138oKJTu.\u001b8)\u0005=!\u0015\u0001\u0004;fgR,f.[8o\u00032d\u0007F\u0001\tE\u0003!!Xm\u001d;Pm\u0016\u0014\bFA\tE\u0003a!Xm\u001d;Nk2$\u0018n\u00149fe\u0006tGm\u001d$pe\u000e\u000bGn\u0019\u0015\u0003%\u0011\u000bA\u0002^3tiR{\u0007O\u0014#fg\u000eD#a\u0005#\u0002\u0017Q,7\u000f\u001e+pa:\u000b5o\u0019\u0015\u0003)\u0011\u000bA\u0003^3tiR{\u0007OT!gi\u0016\u0014xI]8va\nK\bFA\u000bE\u0003U!Xm\u001d;U_Bt\u0015I\u001a;fe\u001e\u0013x.\u001e9CsJB#A\u0006#\u0002%Y,'/\u001b4z\u001b>tw\u000e^8oS\u000eLG/\u001f\u000b\u0005{Q\f\t\u0001C\u0003\u001b/\u0001\u0007Q\u000f\u0005\u0002w{:\u0011qo\u001f\t\u0003q~j\u0011!\u001f\u0006\u0003u&\na\u0001\u0010:p_Rt\u0014B\u0001?@\u0003\u0019\u0001&/\u001a3fM&\u0011ap \u0002\u0007'R\u0014\u0018N\\4\u000b\u0005q|\u0004bBA\u0002/\u0001\u0007\u0011QA\u0001\u0007Kb\u0004Xm\u0019;\u0011\t\u0005\u001d\u0011QB\u0007\u0003\u0003\u0013Q1!a\u0003\u001e\u0003\u0015!(/Y5u\u0013\u0011\ty!!\u0003\u0003/I+G.T8eS\u001aLW\rZ'p]>$xN\\5dSRL\b")
public class ModifiedMonotonicityTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    public StreamTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testMaxWithRetractOptimize() {
        String query = "SELECT a1, MAX(a3) FROM (SELECT a1, a2, MAX(a3) AS a3 FROM A GROUP BY a1, a2) t GROUP BY a1";
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testMinWithRetractOptimize() {
        String query = "SELECT a1, MIN(a3) FROM (SELECT a1, a2, MIN(a3) AS a3 FROM A GROUP BY a1, a2) t GROUP BY a1";
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testMinCanNotOptimize() {
        String query = "SELECT a1, MIN(a3) FROM (SELECT a1, a2, MAX(a3) AS a3 FROM A GROUP BY a1, a2) t GROUP BY a1";
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testMaxWithRetractOptimizeWithLocalGlobal() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofMillis(100L));
        String query = "SELECT a1, max(a3) from (SELECT a1, a2, max(a3) as a3 FROM A GROUP BY a1, a2) group by a1";
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testMinWithRetractOptimizeWithLocalGlobal() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofMillis(100L));
        String query = "SELECT min(a3) from (SELECT a1, a2, min(a3) as a3 FROM A GROUP BY a1, a2)";
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testMinCanNotOptimizeWithLocalGlobal() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofMillis(100L));
        String query = "SELECT a1, MIN(a3) FROM (SELECT a1, a2, MAX(a3) AS a3 FROM A GROUP BY a1, a2) t GROUP BY a1";
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testTumbleFunAndRegularAggFunInGroupBy() {
        String sql = "SELECT b, d, weightedAvg(c, a) FROM  (SELECT a, b, c, count(*) d,  TUMBLE_START(rowtime, INTERVAL '15' MINUTE) as ping_start  FROM MyTable   GROUP BY a, b, c, TUMBLE(rowtime, INTERVAL '15' MINUTE)) AS t1 GROUP BY b, d, ping_start";
        this.verifyMonotonicity(sql, new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.CONSTANT, SqlMonotonicity.CONSTANT, SqlMonotonicity.NOT_MONOTONIC})));
    }

    @Test
    public void testAntiJoin() {
        String sql = "SELECT * FROM AA WHERE NOT EXISTS (SELECT b1 from BB WHERE a1 = b1)";
        this.verifyMonotonicity(sql, null);
    }

    @Test
    public void testSemiJoinWithNonEqual() {
        String query1 = "SELECT MAX(a2) AS a2, a1 FROM AA group by a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM BB group by b1";
        String sql = new StringBuilder(62).append("SELECT * FROM (").append(query1).append(") WHERE a1 in (SELECT b1 from (").append(query2).append(") WHERE a2 < b2)").toString();
        this.verifyMonotonicity(sql, null);
    }

    @Test
    public void testSemiJoin() {
        String query1 = "SELECT MAX(a2) AS a2, a1 FROM AA group by a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM BB group by b1";
        String sql = new StringBuilder(53).append("SELECT a1, a2 FROM (").append(query1).append(") WHERE a1 in (SELECT b1 from (").append(query2).append("))").toString();
        this.verifyMonotonicity(sql, new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.CONSTANT, SqlMonotonicity.INCREASING})));
    }

    @Test
    public void testInnerJoinOnAggResult() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM AA group by a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM BB group by b1";
        String sql = new StringBuilder(48).append("SELECT a1, a2, b1, b2 FROM (").append(query1).append(") JOIN (").append(query2).append(") ON a2 = b2").toString();
        this.verifyMonotonicity(sql, null);
    }

    @Test
    public void testInnerJoin() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM AA group by a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM BB group by b1";
        String sql = new StringBuilder(48).append("SELECT a1, a2, b1, b2 FROM (").append(query1).append(") JOIN (").append(query2).append(") ON a1 = b1").toString();
        this.verifyMonotonicity(sql, new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.CONSTANT, SqlMonotonicity.NOT_MONOTONIC, SqlMonotonicity.CONSTANT, SqlMonotonicity.NOT_MONOTONIC})));
    }

    @Test
    public void testUnionAll() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM AA group by a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM BB group by b1";
        String sql = new StringBuilder(34).append("SELECT a1, a2 FROM (").append(query1).append(") union all (").append(query2).append(")").toString();
        this.verifyMonotonicity(sql, new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.NOT_MONOTONIC, SqlMonotonicity.NOT_MONOTONIC})));
    }

    @Test
    public void testOver() {
        String sql = "SELECT a,   SUM(c) OVER (    PARTITION BY a ORDER BY proctime ROWS BETWEEN 4 PRECEDING AND CURRENT ROW),   MIN(c) OVER (    PARTITION BY a ORDER BY proctime ROWS BETWEEN 4 PRECEDING AND CURRENT ROW) FROM MyTable";
        this.verifyMonotonicity(sql, new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.CONSTANT, SqlMonotonicity.CONSTANT, SqlMonotonicity.CONSTANT})));
    }

    @Test
    public void testMultiOperandsForCalc() {
        this.util().addTemporarySystemFunction("func1", (UserDefinedFunction)new Func1());
        String sql = "SELECT func1(func1(a1, a3)) from (SELECT last_value(a1) as a1, last_value(a3) as a3 FROM AA group by a2) ";
        this.verifyMonotonicity(sql, new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.NOT_MONOTONIC})));
    }

    @Test
    public void testTopNDesc() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT b, c, a,\n        |      ROW_NUMBER() OVER (PARTITION BY a ORDER BY b DESC, c ASC) as rank_num\n        |  FROM MyTable)\n        |WHERE rank_num <= 10\n      ")).stripMargin();
        this.verifyMonotonicity(sql, new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.INCREASING, SqlMonotonicity.NOT_MONOTONIC, SqlMonotonicity.CONSTANT, SqlMonotonicity.CONSTANT})));
    }

    @Test
    public void testTopNAsc() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT a, b, c,\n        |      ROW_NUMBER() OVER (PARTITION BY a ORDER BY b ASC) as rank_num\n        |  FROM MyTable)\n        |WHERE rank_num <= 10\n      ")).stripMargin();
        this.verifyMonotonicity(sql, new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.CONSTANT, SqlMonotonicity.DECREASING, SqlMonotonicity.NOT_MONOTONIC, SqlMonotonicity.CONSTANT})));
    }

    @Test
    public void testTopNAfterGroupBy() {
        String subquery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, b, COUNT(*) as count_c\n        |FROM MyTable\n        |GROUP BY a, b\n      ")).stripMargin();
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(214).append("\n         |SELECT *\n         |FROM (\n         |  SELECT a, b, count_c,\n         |      ROW_NUMBER() OVER (PARTITION BY b ORDER BY count_c DESC) as rank_num\n         |  FROM (").append(subquery).append("))\n         |WHERE rank_num <= 10\n      ").toString())).stripMargin();
        this.verifyMonotonicity(sql, new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.NOT_MONOTONIC, SqlMonotonicity.CONSTANT, SqlMonotonicity.INCREASING, SqlMonotonicity.CONSTANT})));
    }

    @Test
    public void testTopNAfterGroupBy2() {
        String subquery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, b, COUNT(*) as count_c\n        |FROM MyTable\n        |GROUP BY a, b\n      ")).stripMargin();
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(214).append("\n         |SELECT *\n         |FROM (\n         |  SELECT a, b, count_c,\n         |      ROW_NUMBER() OVER (PARTITION BY count_c ORDER BY a DESC) as rank_num\n         |  FROM (").append(subquery).append("))\n         |WHERE rank_num <= 10\n      ").toString())).stripMargin();
        this.verifyMonotonicity(sql, null);
    }

    public void verifyMonotonicity(String sql, RelModifiedMonotonicity expect) {
        Table table = this.util().tableEnv().sqlQuery(sql);
        RelNode relNode = TableTestUtil$.MODULE$.toRelNode(table);
        RelNode optimized = this.util().getPlanner().optimize(relNode);
        RelModifiedMonotonicity actualMono = FlinkRelMetadataQuery.reuseOrCreate((RelMetadataQuery)optimized.getCluster().getMetadataQuery()).getRelModifiedMonotonicity(optimized);
        Assertions.assertThat((Object)actualMono).isEqualTo((Object)expect);
    }

    public ModifiedMonotonicityTest() {
        this.util().addDataStream("A", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a1")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a2")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a3"))}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.ModifiedMonotonicityTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addDataStream("B", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b1")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b2")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b3"))}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.stream.sql.ModifiedMonotonicityTest$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addDataStream("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.stream.sql.ModifiedMonotonicityTest$$anon$5 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTemporarySystemFunction("weightedAvg", JavaUserDefinedAggFunctions.WeightedAvgWithMerge.class);
        this.util().addTableSource("AA", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a1")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a2")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a3"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.plan.stream.sql.ModifiedMonotonicityTest$$anon$7 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTableSource("BB", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b1")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b2")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b3")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b4")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b5"))}), new CaseClassTypeInfo<Tuple5<Object, Object, Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$9 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple5<Object, Object, Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple5<Object, Object, Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple5<Object, Object, Object, String, Object>>(this, fieldSerializers){

                    public Tuple5<Object, Object, Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple5((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)((String)fields[3]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[4])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.planner.plan.stream.sql.ModifiedMonotonicityTest$$anon$9 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
    }
}

