/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001M3A\u0001D\u0007\u0001=!)Q\u0005\u0001C\u0001M!9\u0011\u0006\u0001b\u0001\n\u0013Q\u0003B\u0002\u0018\u0001A\u0003%1\u0006C\u00030\u0001\u0011\u0005\u0001\u0007C\u0003C\u0001\u0011\u0005\u0001\u0007C\u0003H\u0001\u0011\u0005\u0001\u0007C\u0003J\u0001\u0011\u0005\u0001\u0007C\u0003L\u0001\u0011\u0005\u0001\u0007C\u0003N\u0001\u0011\u0005\u0001\u0007C\u0003P\u0001\u0011\u0005\u0001\u0007C\u0003R\u0001\u0011\u0005\u0001G\u0001\u000bGS2$XM]1cY\u0016\u001cv.\u001e:dKR+7\u000f\u001e\u0006\u0003\u001d=\t1a]9m\u0015\t\u0001\u0012#\u0001\u0004tiJ,\u0017-\u001c\u0006\u0003%M\tA\u0001\u001d7b]*\u0011A#F\u0001\ba2\fgN\\3s\u0015\t1r#A\u0003uC\ndWM\u0003\u0002\u00193\u0005)a\r\\5oW*\u0011!dG\u0001\u0007CB\f7\r[3\u000b\u0003q\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\u0010\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0005\t\u001a\u0012!B;uS2\u001c\u0018B\u0001\u0013\"\u00055!\u0016M\u00197f)\u0016\u001cHOQ1tK\u00061A(\u001b8jiz\"\u0012a\n\t\u0003Q\u0001i\u0011!D\u0001\u0005kRLG.F\u0001,!\t\u0001C&\u0003\u0002.C\t\u00192\u000b\u001e:fC6$\u0016M\u00197f)\u0016\u001cH/\u0016;jY\u0006)Q\u000f^5mA\u0005)1/\u001a;vaR\t\u0011\u0007\u0005\u00023k5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14G\u0001\u0003V]&$\bF\u0001\u00039!\tI\u0004)D\u0001;\u0015\tYD(A\u0002ba&T!!\u0010 \u0002\u000f),\b/\u001b;fe*\u0011qhG\u0001\u0006UVt\u0017\u000e^\u0005\u0003\u0003j\u0012!BQ3g_J,W)Y2i\u0003\u0001\"Xm\u001d;Gk2dg)\u001b7uKJl\u0015\r^2i/&$\bnV1uKJl\u0017M]6)\u0005\u0015!\u0005CA\u001dF\u0013\t1%H\u0001\u0003UKN$\u0018a\t;fgR\u0004\u0016M\u001d;jC24\u0015\u000e\u001c;fe6\u000bGo\u00195XSRDw+\u0019;fe6\f'o\u001b\u0015\u0003\r\u0011\u000ba\u0004^3ti:{g)\u001b7uKJl\u0015\r^2i/&$\bnV1uKJl\u0017M]6)\u0005\u001d!\u0015\u0001\u000b;fgR4U\u000f\u001c7QkNDGm\\<o/&$\bn\\;u/\u0006$XM]7be.\f5o]5h]\u0016\u0014\bF\u0001\u0005E\u0003-\"Xm\u001d;QCJ$\u0018.\u00197QkNDGm\\<o/&$\bn\\;u/\u0006$XM]7be.\f5o]5h]\u0016\u0014\bFA\u0005E\u0003%\"Xm\u001d;D_6\u0004X\u000f^3e\u0007>dW/\u001c8QkNDGm\\<o\u0003\u000e\u0014xn]:XCR,'/\\1sW\"\u0012!\u0002R\u0001\u001ai\u0016\u001cHOR5mi\u0016\u0014\b+^:iI><hnV5uQV#g\r\u000b\u0002\f\t\u0002")
public class FilterableSourceTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n        | CREATE TABLE MyTable(\n        |   a INT,\n        |   b BIGINT,\n        |   c TIMESTAMP(3),\n        |   d STRING,\n        |   WATERMARK FOR c AS c\n        | ) WITH (\n        |   'connector' = 'values',\n        |   'enable-watermark-push-down' = 'true',\n        |   'filterable-fields' = 'a;d',\n        |   'bounded' = 'false',\n        |   'disable-lookup' = 'true'\n        | )\n        |")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
    }

    @Test
    public void testFullFilterMatchWithWatermark() {
        this.util().verifyExecPlan("SELECT * FROM MyTable WHERE LOWER(d) = 'hello'");
    }

    @Test
    public void testPartialFilterMatchWithWatermark() {
        this.util().verifyExecPlan("SELECT * FROM MyTable WHERE LOWER(d) = 'h' AND d IS NOT NULL");
    }

    @Test
    public void testNoFilterMatchWithWatermark() {
        this.util().verifyExecPlan("SELECT * FROM MyTable WHERE b > 5");
    }

    @Test
    public void testFullPushdownWithoutWatermarkAssigner() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE NoWatermark (\n        |  name STRING,\n        |  event_time TIMESTAMP(3)\n        |) WITH (\n        |  'connector' = 'values',\n        |  'filterable-fields' = 'name',\n        |  'bounded' = 'false',\n        |  'disable-lookup' = 'true'\n        |)\n        |")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        this.util().verifyExecPlan("SELECT * FROM NoWatermark WHERE LOWER(name) = 'foo' AND UPPER(name) = 'FOO'");
    }

    @Test
    public void testPartialPushdownWithoutWatermarkAssigner() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE NoWatermark (\n        |  name STRING,\n        |  event_time TIMESTAMP(3)\n        |) WITH (\n        |  'connector' = 'values',\n        |  'filterable-fields' = 'name',\n        |  'bounded' = 'false',\n        |  'disable-lookup' = 'true'\n        |)\n        |")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        this.util().verifyExecPlan("SELECT * FROM NoWatermark WHERE LOWER(name) = 'foo' AND name IS NOT NULL");
    }

    @Test
    public void testComputedColumnPushdownAcrossWatermark() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE WithWatermark (\n        |  event_time TIMESTAMP(3),\n        |  name STRING,\n        |  lowercase_name AS LOWER(name),\n        |  WATERMARK FOR event_time AS event_time\n        |) WITH (\n        |  'connector' = 'values',\n        |  'bounded' = 'false',\n        |  'enable-watermark-push-down' = 'true',\n        |  'filterable-fields' = 'name',\n        |  'disable-lookup' = 'true'\n        |)\n        |")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        this.util().verifyExecPlan("SELECT * FROM WithWatermark WHERE lowercase_name = 'foo'");
    }

    @Test
    public void testFilterPushdownWithUdf() {
        JavaUserDefinedScalarFunctions.JavaFunc5.closeCalled = false;
        JavaUserDefinedScalarFunctions.JavaFunc5.openCalled = false;
        this.util().addTemporarySystemFunction("func", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.JavaFunc5());
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n        | CREATE Table UdfTable (\n        |   a INT,\n        |   b BIGINT,\n        |   c timestamp(3),\n        |   d as func(c, a),\n        |   f STRING,\n        |   WATERMARK FOR c as func(func(d, a), a)\n        | ) with (\n        |   'connector' = 'values',\n        |   'bounded' = 'false',\n        |   'filterable-fields' = 'f',\n        |   'enable-watermark-push-down' = 'true',\n        |   'disable-lookup' = 'true'\n        | )\n        |")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        this.util().verifyExecPlan("SELECT * FROM UdfTable WHERE UPPER(f) = 'welcome'");
    }
}

