/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.stream;

import java.time.Duration;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.config.AggregatePhaseStrategy;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00054A\u0001E\t\u0001I!)1\u0006\u0001C\u0001Y!9q\u0006\u0001b\u0001\n\u0013\u0001\u0004B\u0002\u001b\u0001A\u0003%\u0011\u0007C\u00036\u0001\u0011\u0005a\u0007C\u0003I\u0001\u0011\u0005a\u0007C\u0003N\u0001\u0011\u0005a\u0007C\u0003P\u0001\u0011\u0005a\u0007C\u0003R\u0001\u0011\u0005a\u0007C\u0003T\u0001\u0011\u0005a\u0007C\u0003V\u0001\u0011\u0005a\u0007C\u0003X\u0001\u0011\u0005a\u0007C\u0003Z\u0001\u0011\u0005a\u0007C\u0003\\\u0001\u0011\u0005a\u0007C\u0003^\u0001\u0011\u0005a\u0007C\u0003`\u0001\u0011\u0005aG\u0001\u000eDQ\u0006tw-\u001a7pO6{G-Z%oM\u0016\u0014XM\\2f)\u0016\u001cHO\u0003\u0002\u0013'\u000511\u000f\u001e:fC6T!\u0001F\u000b\u0002\u0011AD\u0017p]5dC2T!AF\f\u0002\u000bI,H.Z:\u000b\u0005aI\u0012\u0001\u00029mC:T!AG\u000e\u0002\u000fAd\u0017M\u001c8fe*\u0011A$H\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003=}\tQA\u001a7j].T!\u0001I\u0011\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0013aA8sO\u000e\u00011C\u0001\u0001&!\t1\u0013&D\u0001(\u0015\tA\u0013$A\u0003vi&d7/\u0003\u0002+O\tiA+\u00192mKR+7\u000f\u001e\"bg\u0016\fa\u0001P5oSRtD#A\u0017\u0011\u00059\u0002Q\"A\t\u0002\tU$\u0018\u000e\\\u000b\u0002cA\u0011aEM\u0005\u0003g\u001d\u00121c\u0015;sK\u0006lG+\u00192mKR+7\u000f^+uS2\fQ!\u001e;jY\u0002\naAY3g_J,G#A\u001c\u0011\u0005aZT\"A\u001d\u000b\u0003i\nQa]2bY\u0006L!\u0001P\u001d\u0003\tUs\u0017\u000e\u001e\u0015\u0003\ty\u0002\"a\u0010$\u000e\u0003\u0001S!!\u0011\"\u0002\u0007\u0005\u0004\u0018N\u0003\u0002D\t\u00069!.\u001e9ji\u0016\u0014(BA#\"\u0003\u0015QWO\\5u\u0013\t9\u0005I\u0001\u0006CK\u001a|'/Z#bG\"\f!\u0002^3tiN+G.Z2uQ\t)!\n\u0005\u0002@\u0017&\u0011A\n\u0011\u0002\u0005)\u0016\u001cH/A\nuKN$xJ\\3MKZ,Gn\u0012:pkB\u0014\u0015\u0010\u000b\u0002\u0007\u0015\u0006\tC/Z:u)^|G*\u001a<fY\u001e\u0013x.\u001e9Cs2{7-\u00197HY>\u0014\u0017\r\\(gM\"\u0012qAS\u0001!i\u0016\u001cH\u000fV<p\u0019\u00164X\r\\$s_V\u0004()\u001f'pG\u0006dw\t\\8cC2|e\u000e\u000b\u0002\t\u0015\u0006\u0019C/Z:u)\u0016l\u0007o\u001c:bY*{\u0017N\\,ji\"$U\rZ;qY&\u001c\u0017\r^3WS\u0016<\bFA\u0005K\u0003u!Xm\u001d;UK6\u0004xN]1m\u0015>LgnV5uQ\u000eC\u0017M\\4fY><\u0007F\u0001\u0006K\u0003)\"Xm\u001d;UK6\u0004xN]1m\u0015>LgnV5uQ:{g.R9vC2\u001cuN\u001c3ji&|gn\u00148LKfD#a\u0003&\u0002OQ,7\u000f\u001e+f[B|'/\u00197K_&tw+\u001b;i\u000bF,\u0018\r\\\"p]\u0012LG/[8o\u001f:\\U-\u001f\u0015\u0003\u0019)\u000bQ\u0005^3tiR+W\u000e]8sC2Tu.\u001b8XSRDgj\u001c8FcV\fGnQ8oI&$\u0018n\u001c8)\u00055Q\u0015\u0001\u0006;fgR<%o\\;q\u0005f<\u0016\u000e\u001e5V]&|g\u000e\u000b\u0002\u000f\u0015\u0006IC/Z:u!J|\u0007/Y4bi\u0016,\u0006\u000fZ1uK.Kg\u000eZ!n_:<'+\u001a7O_\u0012,'\t\\8dWND#a\u0004&")
public class ChangelogModeInferenceTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void before() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE MyTable (\n                    | word STRING,\n                    | number INT\n                    |) WITH (\n                    | 'connector' = 'COLLECTION',\n                    | 'is-bounded' = 'false'\n                    |)\n      ")).stripMargin());
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE Orders (\n                    | amount INT,\n                    | currency STRING,\n                    | rowtime TIMESTAMP(3),\n                    | proctime AS PROCTIME(),\n                    | WATERMARK FOR rowtime AS rowtime\n                    |) WITH (\n                    | 'connector' = 'COLLECTION',\n                    | 'is-bounded' = 'false'\n                    |)\n      ")).stripMargin());
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE ratesHistory (\n                    | currency STRING,\n                    | rate INT,\n                    | rowtime TIMESTAMP(3),\n                    | WATERMARK FOR rowtime AS rowtime\n                    |) WITH (\n                    |  'connector' = 'COLLECTION',\n                    |  'is-bounded' = 'false',\n                    |  'changelog-mode' = 'I'\n                    |)\n      ")).stripMargin());
        this.util().addTable(" CREATE VIEW DeduplicatedView AS SELECT currency, rate, rowtime FROM   (SELECT *,           ROW_NUMBER() OVER (PARTITION BY currency ORDER BY rowtime DESC) AS rowNum    FROM ratesHistory  ) T   WHERE rowNum = 1");
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE ratesChangelogStream (\n                    | currency STRING,\n                    | rate INT,\n                    | rowtime TIMESTAMP(3),\n                    | WATERMARK FOR rowtime as rowtime,\n                    | PRIMARY KEY(currency) NOT ENFORCED\n                    |) WITH (\n                    |  'connector' = 'values',\n                    |  'changelog-mode' = 'I,UA,UB,D'\n                    |)\n      ")).stripMargin());
    }

    @Test
    public void testSelect() {
        this.util().verifyRelPlan("SELECT word, number FROM MyTable", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testOneLevelGroupBy() {
        this.util().verifyRelPlan("SELECT COUNT(number) FROM MyTable GROUP BY word", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testTwoLevelGroupByLocalGlobalOff() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT cnt, COUNT(cnt) AS frequency FROM (\n        |  SELECT word, COUNT(number) as cnt FROM MyTable GROUP BY word\n        |) GROUP BY cnt\n      ")).stripMargin();
        this.util().verifyRelPlan(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testTwoLevelGroupByLocalGlobalOn() {
        this.util().enableMiniBatch();
        this.util().tableEnv().getConfig().setIdleStateRetention(Duration.ofHours(1L));
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_AGG_PHASE_STRATEGY, (Object)AggregatePhaseStrategy.TWO_PHASE);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT cnt, COUNT(cnt) AS frequency FROM (\n        |  SELECT word, COUNT(number) as cnt FROM MyTable GROUP BY word\n        |) GROUP BY cnt\n      ")).stripMargin();
        this.util().verifyRelPlan(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testTemporalJoinWithDeduplicateView() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM Orders AS o\n        | JOIN DeduplicatedView FOR SYSTEM_TIME AS OF o.rowtime AS r\n        | ON o.currency = r.currency\n      ")).stripMargin();
        this.util().verifyRelPlan(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testTemporalJoinWithChangelog() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM Orders AS o\n        | JOIN ratesChangelogStream FOR SYSTEM_TIME AS OF o.rowtime AS r\n        | ON o.currency = r.currency\n      ")).stripMargin();
        this.util().verifyRelPlan(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testTemporalJoinWithNonEqualConditionOnKey() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM Orders AS o\n        | JOIN ratesChangelogStream FOR SYSTEM_TIME AS OF o.rowtime AS r\n        | ON o.currency = r.currency and o.currency < 5\n      ")).stripMargin();
        this.util().verifyRelPlan(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testTemporalJoinWithEqualConditionOnKey() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM Orders AS o\n        | JOIN ratesChangelogStream FOR SYSTEM_TIME AS OF o.rowtime AS r\n        | ON o.currency = r.currency and o.currency = 5\n      ")).stripMargin();
        this.util().verifyRelPlan(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testTemporalJoinWithNonEqualCondition() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM Orders AS o\n        | JOIN ratesChangelogStream FOR SYSTEM_TIME AS OF o.rowtime AS r\n        | ON o.currency = r.currency and o.amount > 5 and r.rate > 100\n      ")).stripMargin();
        this.util().verifyRelPlan(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testGroupByWithUnion() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE MyTable2 (\n                    | word STRING,\n                    | cnt INT\n                    |) WITH (\n                    | 'connector' = 'COLLECTION',\n                    | 'is-bounded' = 'false'\n                    |)\n      ")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT cnt, COUNT(cnt) AS frequency FROM (\n        |   SELECT word, COUNT(number) AS cnt FROM MyTable GROUP BY word\n        |   UNION ALL\n        |   SELECT word, cnt FROM MyTable2\n        |) GROUP BY cnt\n      ")).stripMargin();
        this.util().verifyRelPlan(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testPropagateUpdateKindAmongRelNodeBlocks() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_OPTIMIZE_BLOCK_WITH_DIGEST_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |create table sink1 (\n                    |  a INT,\n                    |  b VARCHAR\n                    |) with (\n                    |  'connector' = 'values',\n                    |  'sink-insert-only' = 'false'\n                    |)\n                    |")).stripMargin());
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |create table sink2 (\n                    |  a INT,\n                    |  b VARCHAR,\n                    |  primary key (b) not enforced\n                    |) with (\n                    |  'connector' = 'values',\n                    |  'sink-insert-only' = 'false'\n                    |)\n                    |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE VIEW v1 AS\n                               |SELECT\n                               |  SUM(number) AS number, word\n                               |FROM MyTable\n                               |GROUP BY word\n                               |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE VIEW v2 AS\n                               |SELECT number + 1 AS number, word FROM v1\n                               |UNION ALL\n                               |SELECT number - 1 AS number, word FROM v1\n                               |")).stripMargin());
        StatementSet statementSet = this.util().tableEnv().createStatementSet();
        statementSet.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n                                |INSERT INTO sink1 SELECT number, word FROM v2 WHERE word > 'a'\n                                |")).stripMargin());
        statementSet.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n                                |INSERT INTO sink1 SELECT number, word FROM v2 WHERE word < 'a'\n                                |")).stripMargin());
        statementSet.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n                                |INSERT INTO sink2 SELECT * FROM v1\n                                |")).stripMargin());
        this.util().verifyRelPlan(statementSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }
}

