/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.optimize.program.FlinkBatchProgram$;
import org.apache.flink.table.planner.plan.rules.logical.WindowGroupReorderRuleTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001q3Aa\u0004\t\u0001C!)\u0001\u0006\u0001C\u0001S!9A\u0006\u0001b\u0001\n\u0013i\u0003BB\u0019\u0001A\u0003%a\u0006C\u00033\u0001\u0011\u00051\u0007C\u0003F\u0001\u0011\u00051\u0007C\u0003K\u0001\u0011\u00051\u0007C\u0003M\u0001\u0011\u00051\u0007C\u0003O\u0001\u0011\u00051\u0007C\u0003Q\u0001\u0011\u00051\u0007C\u0003S\u0001\u0011\u00051\u0007C\u0003U\u0001\u0011\u00051\u0007C\u0003W\u0001\u0011\u00051\u0007C\u0003Y\u0001\u0011\u00051\u0007C\u0003[\u0001\u0011\u00051G\u0001\u000eXS:$wn^$s_V\u0004(+Z8sI\u0016\u0014(+\u001e7f)\u0016\u001cHO\u0003\u0002\u0012%\u00059An\\4jG\u0006d'BA\n\u0015\u0003\u0015\u0011X\u000f\\3t\u0015\t)b#\u0001\u0003qY\u0006t'BA\f\u0019\u0003\u001d\u0001H.\u00198oKJT!!\u0007\u000e\u0002\u000bQ\f'\r\\3\u000b\u0005ma\u0012!\u00024mS:\\'BA\u000f\u001f\u0003\u0019\t\u0007/Y2iK*\tq$A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001EA\u00111EJ\u0007\u0002I)\u0011QEF\u0001\u0006kRLGn]\u0005\u0003O\u0011\u0012Q\u0002V1cY\u0016$Vm\u001d;CCN,\u0017A\u0002\u001fj]&$h\bF\u0001+!\tY\u0003!D\u0001\u0011\u0003\u0011)H/\u001b7\u0016\u00039\u0002\"aI\u0018\n\u0005A\"#A\u0005\"bi\u000eDG+\u00192mKR+7\u000f^+uS2\fQ!\u001e;jY\u0002\nQa]3ukB$\u0012\u0001\u000e\t\u0003kaj\u0011A\u000e\u0006\u0002o\u0005)1oY1mC&\u0011\u0011H\u000e\u0002\u0005+:LG\u000f\u000b\u0002\u0005wA\u0011AhQ\u0007\u0002{)\u0011ahP\u0001\u0004CBL'B\u0001!B\u0003\u001dQW\u000f]5uKJT!A\u0011\u0010\u0002\u000b),h.\u001b;\n\u0005\u0011k$A\u0003\"fM>\u0014X-R1dQ\u0006aC/Z:u'\u0006lW\rU1si&$\u0018n\u001c8LKf\u001cx+\u001b;i'\u0006lWm\u0014:eKJ\\U-_:Qe\u00164\u0017\u000e\u001f\u0015\u0003\u000b\u001d\u0003\"\u0001\u0010%\n\u0005%k$\u0001\u0002+fgR\fq\u0005^3tiN\u000bW.\u001a)beRLG/[8o\u0017\u0016L8oV5uQ\u0012KgMZ(sI\u0016\u00148*Z=tc!\u0012aaR\u0001(i\u0016\u001cHoU1nKB\u000b'\u000f^5uS>t7*Z=t/&$\b\u000eR5gM>\u0013H-\u001a:LKf\u001c(\u0007\u000b\u0002\b\u000f\u0006!D/Z:u'\u0006lW\rU1si&$\u0018n\u001c8LKf\u001cx+\u001b;i'\u0006lWm\u0014:eKJ\\U-_:ES\u001a4G)\u001b:fGRLwN\\\u0019)\u0005!9\u0015\u0001\u000e;fgR\u001c\u0016-\\3QCJ$\u0018\u000e^5p].+\u0017p],ji\"\u001c\u0016-\\3Pe\u0012,'oS3zg\u0012KgM\u001a#je\u0016\u001cG/[8oe!\u0012\u0011bR\u00015i\u0016\u001cHoU1nKB\u000b'\u000f^5uS>t7*Z=t/&$\bnU1nK>\u0013H-\u001a:LKf\u001cx+\u001b;i\u000b6\u0004H/_(sI\u0016\u0014\bF\u0001\u0006H\u0003\u0019\"Xm\u001d;ES\u001a4\u0007+\u0019:uSRLwN\\&fsN<\u0016\u000e\u001e5TC6,wJ\u001d3fe.+\u0017p\u001d\u0015\u0003\u0017\u001d\u000bq\u0005^3ti\u0012KgM\u001a)beRLG/[8o\u0017\u0016L8oV5uQ\u0012KgMZ(sI\u0016\u00148*Z=tc!\u0012AbR\u0001(i\u0016\u001cH\u000fR5gMB\u000b'\u000f^5uS>t7*Z=t/&$\b\u000eR5gM>\u0013H-\u001a:LKf\u001c(\u0007\u000b\u0002\u000e\u000f\u0006aB/Z:u\u001bVdG/[(wKJ<\u0016N\u001c3poJ\u000bgnZ3UsB,\u0007F\u0001\bH\u0001")
public class WindowGroupReorderRuleTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        this.util().buildBatchProgram(FlinkBatchProgram$.MODULE$.LOGICAL());
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.rules.logical.WindowGroupReorderRuleTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testSamePartitionKeysWithSameOrderKeysPrefix() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a,\n        |    RANK() OVER (PARTITION BY b ORDER BY c, a DESC),\n        |    RANK() OVER (PARTITION BY b ORDER BY c, b)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testSamePartitionKeysWithDiffOrderKeys1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    SUM(a) OVER (PARTITION BY b ORDER BY c),\n        |    MAX(a) OVER (PARTITION BY b ORDER BY b),\n        |    AVG(a) OVER (PARTITION BY b ORDER BY a),\n        |    RANK() OVER (PARTITION BY b ORDER BY c),\n        |    MIN(a) OVER (PARTITION BY b ORDER BY b)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testSamePartitionKeysWithDiffOrderKeys2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    SUM(a) OVER (PARTITION BY b ORDER BY c),\n        |    MAX(a) OVER (PARTITION BY b ORDER BY a),\n        |    AVG(a) OVER (PARTITION BY b ORDER BY a, c),\n        |    RANK() OVER (PARTITION BY b ORDER BY a, b),\n        |    MIN(a) OVER (PARTITION BY b ORDER BY b)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testSamePartitionKeysWithSameOrderKeysDiffDirection1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    SUM(a) OVER (PARTITION BY b ORDER BY a ASC),\n        |    MAX(a) OVER (PARTITION BY b ORDER BY a ASC),\n        |    AVG(a) OVER (PARTITION BY b ORDER BY a DESC),\n        |    RANK() OVER (PARTITION BY b ORDER BY a ASC),\n        |    MIN(a) OVER (PARTITION BY b ORDER BY a DESC)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testSamePartitionKeysWithSameOrderKeysDiffDirection2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    RANK() OVER (PARTITION BY b ORDER BY a DESC),\n        |    RANK() OVER (PARTITION BY b ORDER BY a ASC)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testSamePartitionKeysWithSameOrderKeysWithEmptyOrder() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    SUM(a) OVER (PARTITION BY b ORDER BY a),\n        |    MIN(a) OVER (PARTITION BY b),\n        |    MAX(a) OVER (PARTITION BY b ORDER BY a)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testDiffPartitionKeysWithSameOrderKeys() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    SUM(a) OVER (PARTITION BY b ORDER BY a),\n        |    MAX(a) OVER (PARTITION BY b ORDER BY a),\n        |    AVG(a) OVER (PARTITION BY c ORDER BY a),\n        |    RANK() OVER (PARTITION BY b ORDER BY a),\n        |    MIN(a) OVER (PARTITION BY c ORDER BY a)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testDiffPartitionKeysWithDiffOrderKeys1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    SUM(a) OVER (PARTITION BY b ORDER BY a),\n        |    MAX(a) OVER (PARTITION BY b ORDER BY c),\n        |    AVG(a) OVER (PARTITION BY c ORDER BY a),\n        |    RANK() OVER (PARTITION BY b ORDER BY a),\n        |    MIN(a) OVER (PARTITION BY c ORDER BY a)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testDiffPartitionKeysWithDiffOrderKeys2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    SUM(a) OVER (PARTITION BY b ORDER BY c),\n        |    MAX(a) OVER (PARTITION BY c ORDER BY a),\n        |    MIN(a) OVER (ORDER BY c, a),\n        |    RANK() OVER (PARTITION BY b ORDER BY c),\n        |    AVG(a) OVER (ORDER BY b)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testMultiOverWindowRangeType() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    COUNT(*) OVER (PARTITION BY c ORDER BY a RANGE BETWEEN -1 PRECEDING AND 10 FOLLOWING),\n        |    SUM(a) OVER (PARTITION BY c ORDER BY a),\n        |    RANK() OVER (PARTITION BY c ORDER BY a, c),\n        |    SUM(a) OVER (PARTITION BY c ORDER BY a RANGE BETWEEN 1 PRECEDING AND 10 FOLLOWING),\n        |    COUNT(*) OVER (PARTITION BY c ORDER BY c ROWS BETWEEN 1 PRECEDING AND 10 FOLLOWING)\n        | FROM MyTable\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }
}

