/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.optimize.program.BatchOptimizeContext;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.apache.flink.table.planner.plan.rules.logical.SimplifyFilterConditionRule$;
import org.apache.flink.table.planner.plan.rules.logical.SimplifyFilterConditionRuleTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001e3AAD\b\u0001A!)q\u0005\u0001C\u0001Q!91\u0006\u0001b\u0001\n\u0013a\u0003B\u0002\u0019\u0001A\u0003%Q\u0006C\u00032\u0001\u0011\u0005!\u0007C\u0003E\u0001\u0011\u0005!\u0007C\u0003J\u0001\u0011\u0005!\u0007C\u0003L\u0001\u0011\u0005!\u0007C\u0003N\u0001\u0011\u0005!\u0007C\u0003P\u0001\u0011\u0005!\u0007C\u0003R\u0001\u0011\u0005!\u0007C\u0003T\u0001\u0011\u0005!\u0007C\u0003V\u0001\u0011\u0005!\u0007C\u0003X\u0001\u0011\u0005!GA\u0010TS6\u0004H.\u001b4z\r&dG/\u001a:D_:$\u0017\u000e^5p]J+H.\u001a+fgRT!\u0001E\t\u0002\u000f1|w-[2bY*\u0011!cE\u0001\u0006eVdWm\u001d\u0006\u0003)U\tA\u0001\u001d7b]*\u0011acF\u0001\ba2\fgN\\3s\u0015\tA\u0012$A\u0003uC\ndWM\u0003\u0002\u001b7\u0005)a\r\\5oW*\u0011A$H\u0001\u0007CB\f7\r[3\u000b\u0003y\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\u0011\u0011\u0005\t*S\"A\u0012\u000b\u0005\u0011*\u0012!B;uS2\u001c\u0018B\u0001\u0014$\u00055!\u0016M\u00197f)\u0016\u001cHOQ1tK\u00061A(\u001b8jiz\"\u0012!\u000b\t\u0003U\u0001i\u0011aD\u0001\u0005kRLG.F\u0001.!\t\u0011c&\u0003\u00020G\t\u0011\")\u0019;dQR\u000b'\r\\3UKN$X\u000b^5m\u0003\u0015)H/\u001b7!\u0003\u0015\u0019X\r^;q)\u0005\u0019\u0004C\u0001\u001b8\u001b\u0005)$\"\u0001\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005a*$\u0001B+oSRD#\u0001\u0002\u001e\u0011\u0005m\u0012U\"\u0001\u001f\u000b\u0005ur\u0014aA1qS*\u0011q\bQ\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\tU$A\u0003kk:LG/\u0003\u0002Dy\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002'Q,7\u000f^*j[BdWmQ8oI&$\u0018n\u001c8)\u0005\u00151\u0005CA\u001eH\u0013\tAEH\u0001\u0003UKN$\u0018!\t;fgR\u001c\u0016.\u001c9mK\u000e{g\u000eZ5uS>tw+\u001b;i\u0007\u0006\u001cH\u000fV8UeV,\u0007F\u0001\u0004G\u0003\t\"Xm\u001d;TS6\u0004H.Z\"p]\u0012LG/[8o/&$\bnQ1tiR{g)\u00197tK\"\u0012qAR\u0001!i\u0016\u001cHoU5na2Lg-_\"p]\u0012LG/[8o\u0013:\u001cVOY)vKJL\u0018\u0007\u000b\u0002\t\r\u0006\u0001C/Z:u'&l\u0007\u000f\\5gs\u000e{g\u000eZ5uS>t\u0017J\\*vEF+XM]=3Q\tIa)\u0001\u0011uKN$8+[7qY&4\u0017pQ8oI&$\u0018n\u001c8J]N+(-U;fef\u001c\u0004F\u0001\u0006G\u0003U!Xm\u001d;D_6\u0004H.\u001a=D_:$\u0017\u000e^5p]FB#a\u0003$\u0002+Q,7\u000f^\"p[BdW\r_\"p]\u0012LG/[8oe!\u0012ABR\u0001\u0016i\u0016\u001cHoQ8na2,\u0007pQ8oI&$\u0018n\u001c84Q\tia\t")
public class SimplifyFilterConditionRuleTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        FlinkChainedProgram programs = new FlinkChainedProgram();
        programs.addLast("FilterSimplifyExpressions", (FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_SEQUENCE()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{SimplifyFilterConditionRule$.MODULE$.EXTENDED()})).build());
        this.util().replaceBatchProgram((FlinkChainedProgram<BatchOptimizeContext>)programs);
        this.util().addTableSource("x", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.rules.logical.SimplifyFilterConditionRuleTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTableSource("y", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.rules.logical.SimplifyFilterConditionRuleTest$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTableSource("z", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "i")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "j")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "k"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.rules.logical.SimplifyFilterConditionRuleTest$$anon$5 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testSimpleCondition() {
        this.util().verifyRelPlan("SELECT * FROM x WHERE (a = 1 AND b = 2) OR (NOT(a <> 1) AND c = 3) AND true");
    }

    @Test
    public void testSimpleConditionWithCastToTrue() {
        this.util().verifyRelPlan("SELECT * FROM x WHERE CAST(200 AS BOOLEAN)");
    }

    @Test
    public void testSimpleConditionWithCastToFalse() {
        this.util().verifyRelPlan("SELECT * FROM x WHERE CAST(0 AS BOOLEAN)");
    }

    @Test
    public void testSimplifyConditionInSubQuery1() {
        String sqlQuery = "SELECT * FROM x WHERE EXISTS (SELECT * FROM y WHERE (d = 1 AND e = 2) OR (NOT (d <> 1) AND e = 3)) AND true";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testSimplifyConditionInSubQuery2() {
        String sqlQuery = "SELECT * FROM x WHERE (a = 1 AND b = 2) OR (NOT (a <> 1) AND b = 3) AND true AND EXISTS (SELECT * FROM y WHERE d > 10)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testSimplifyConditionInSubQuery3() {
        String sqlQuery = "SELECT * FROM x WHERE EXISTS (SELECT * FROM y WHERE d IN (SELECT i FROM z WHERE (i = 1 AND j = 2) OR (NOT (i <> 1) AND j = 3) AND true) AND e > 10)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testComplexCondition1() {
        String sqlQuery = "SELECT * FROM x WHERE (a = 1 AND b = 2) OR (NOT(a <> 1) AND c = 3) AND true AND EXISTS (SELECT * FROM y WHERE x.a = y.d AND 2=2 AND (SELECT count(*) FROM z WHERE i = 5 AND j = 6) > 0)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testComplexCondition2() {
        String sqlQuery = "SELECT * FROM x WHERE (a = 1 AND b = 2) OR (NOT(a <> 1) AND c = 3) AND true AND EXISTS (SELECT * FROM y WHERE x.a = y.d AND (SELECT count(*) FROM z WHERE (i = 5 AND j = 6) OR (NOT (i <> 5) AND j = 7) AND true) > 0)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testComplexCondition3() {
        String sqlQuery = "SELECT * FROM x WHERE (a = 1 AND b = 2) OR (NOT(a <> 1) AND c = 3) AND true AND EXISTS (SELECT * FROM y WHERE x.a = y.d AND 2=2 AND (SELECT count(*) FROM z WHERE (i = 5 AND j = 6) OR (NOT (i <> 5) AND j = 7) AND true) > 0)";
        this.util().verifyRelPlan(sqlQuery);
    }
}

