/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.nodes.FlinkConventions$;
import org.apache.flink.table.planner.plan.optimize.program.BatchOptimizeContext;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkVolcanoProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.apache.flink.table.planner.plan.rules.FlinkBatchRuleSets$;
import org.apache.flink.table.planner.plan.rules.FlinkStreamRuleSets$;
import org.apache.flink.table.planner.plan.rules.logical.PythonCalcSplitRuleTest$;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005}a\u0001\u0002\u0011\"\u0001IBQ!\u000f\u0001\u0005\u0002iBq!\u0010\u0001C\u0002\u0013%a\b\u0003\u0004C\u0001\u0001\u0006Ia\u0010\u0005\u0006\u0007\u0002!\t\u0001\u0012\u0005\u0006-\u0002!\t\u0001\u0012\u0005\u00067\u0002!\t\u0001\u0012\u0005\u0006;\u0002!\t\u0001\u0012\u0005\u0006?\u0002!\t\u0001\u0012\u0005\u0006C\u0002!\t\u0001\u0012\u0005\u0006G\u0002!\t\u0001\u0012\u0005\u0006K\u0002!\t\u0001\u0012\u0005\u0006O\u0002!\t\u0001\u0012\u0005\u0006S\u0002!\t\u0001\u0012\u0005\u0006W\u0002!\t\u0001\u0012\u0005\u0006[\u0002!\t\u0001\u0012\u0005\u0006_\u0002!\t\u0001\u0012\u0005\u0006c\u0002!\t\u0001\u0012\u0005\u0006g\u0002!\t\u0001\u0012\u0005\u0006k\u0002!\t\u0001\u0012\u0005\u0006o\u0002!\t\u0001\u0012\u0005\u0006s\u0002!\t\u0001\u0012\u0005\u0006w\u0002!\t\u0001\u0012\u0005\u0006{\u0002!\t\u0001\u0012\u0005\u0006\u007f\u0002!\t\u0001\u0012\u0005\u0007\u0003\u0007\u0001A\u0011\u0001#\t\r\u0005\u001d\u0001\u0001\"\u0001E\u0011\u0019\tY\u0001\u0001C\u0001\t\"1\u0011q\u0002\u0001\u0005\u0002\u0011Ca!a\u0005\u0001\t\u0003!\u0005BBA\f\u0001\u0011\u0005A\t\u0003\u0004\u0002\u001c\u0001!\t\u0001\u0012\u0002\u0018!f$\bn\u001c8DC2\u001c7\u000b\u001d7jiJ+H.\u001a+fgRT!AI\u0012\u0002\u000f1|w-[2bY*\u0011A%J\u0001\u0006eVdWm\u001d\u0006\u0003M\u001d\nA\u0001\u001d7b]*\u0011\u0001&K\u0001\ba2\fgN\\3s\u0015\tQ3&A\u0003uC\ndWM\u0003\u0002-[\u0005)a\r\\5oW*\u0011afL\u0001\u0007CB\f7\r[3\u000b\u0003A\n1a\u001c:h\u0007\u0001\u0019\"\u0001A\u001a\u0011\u0005Q:T\"A\u001b\u000b\u0005Y:\u0013!B;uS2\u001c\u0018B\u0001\u001d6\u00055!\u0016M\u00197f)\u0016\u001cHOQ1tK\u00061A(\u001b8jiz\"\u0012a\u000f\t\u0003y\u0001i\u0011!I\u0001\u0005kRLG.F\u0001@!\t!\u0004)\u0003\u0002Bk\t\u0011\")\u0019;dQR\u000b'\r\\3UKN$X\u000b^5m\u0003\u0015)H/\u001b7!\u0003\u0015\u0019X\r^;q)\u0005)\u0005C\u0001$J\u001b\u00059%\"\u0001%\u0002\u000bM\u001c\u0017\r\\1\n\u0005);%\u0001B+oSRD#\u0001\u0002'\u0011\u00055#V\"\u0001(\u000b\u0005=\u0003\u0016aA1qS*\u0011\u0011KU\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u0019v&A\u0003kk:LG/\u0003\u0002V\u001d\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002OQ,7\u000f\u001e)zi\"|gNR;oGRLwN\\!t\u0013:\u0004X\u000f^(g\u0015\u00064\u0018MR;oGRLwN\u001c\u0015\u0003\u000ba\u0003\"!T-\n\u0005is%\u0001\u0002+fgR\fq\u0005^3tiBKH\u000f[8o\rVt7\r^5p]6K\u00070\u001a3XSRD'*\u0019<b\rVt7\r^5p]\"\u0012a\u0001W\u00015i\u0016\u001cH\u000fU=uQ>tg)\u001e8di&|g.T5yK\u0012<\u0016\u000e\u001e5KCZ\fg)\u001e8di&|g.\u00138XQ\u0016\u0014Xm\u00117bkN,\u0007FA\u0004Y\u0003}!Xm\u001d;QsRDwN\u001c$v]\u000e$\u0018n\u001c8J]^CWM]3DY\u0006,8/\u001a\u0015\u0003\u0011a\u000b!\u0004^3ti\u000eC\u0017-\u001b8j]\u001e\u0004\u0016\u0010\u001e5p]\u001a+hn\u0019;j_:D#!\u0003-\u00023Q,7\u000f^(oYf|e.\u001a)zi\"|gNR;oGRLwN\u001c\u0015\u0003\u0015a\u000ba\u0005^3ti>sG._(oKBKH\u000f[8o\rVt7\r^5p]&sw\u000b[3sK\u000ec\u0017-^:fQ\tY\u0001,A\u000buKN$h)[3mI:\u000bW.Z+oSF,\u0018NZ=)\u00051A\u0016a\u0003;fgRd\u0015\u000e^3sC2D#!\u0004-\u0002+Q,7\u000f\u001e*f_J$WM\u001d)zi\"|gnQ1mG\"\u0012a\u0002W\u0001(i\u0016\u001cH\u000fU1oI\u0006\u001ch)\u001e8di&|g.Q:J]B,Ho\u00144KCZ\fg)\u001e8di&|g\u000e\u000b\u0002\u00101\u00069C/Z:u!\u0006tG-Y:Gk:\u001cG/[8o\u001b&DX\rZ,ji\"T\u0015M^1Gk:\u001cG/[8oQ\t\u0001\u0002,\u0001\u001buKN$\b+\u00198eCN4UO\\2uS>tW*\u001b=fI^KG\u000f\u001b&bm\u00064UO\\2uS>t\u0017J\\,iKJ,7\t\\1vg\u0016D#!\u0005-\u0002?Q,7\u000f\u001e)b]\u0012\f7OR;oGRLwN\\%o/\",'/Z\"mCV\u001cX\r\u000b\u0002\u00131\u0006QB/Z:u\u0007\"\f\u0017N\\5oOB\u000bg\u000eZ1t\rVt7\r^5p]\"\u00121\u0003W\u0001\u001ai\u0016\u001cHo\u00148ms>sW\rU1oI\u0006\u001ch)\u001e8di&|g\u000e\u000b\u0002\u00151\u00061C/Z:u\u001f:d\u0017p\u00148f!\u0006tG-Y:Gk:\u001cG/[8o\u0013:<\u0006.\u001a:f\u00072\fWo]3)\u0005UA\u0016\u0001\r;fgR\u0004\u0016M\u001c3bg\u001a+hn\u0019;j_:l\u0015\u000e_3e/&$\bnR3oKJ\fG\u000eU=uQ>tg)\u001e8di&|g\u000e\u000b\u0002\u00171\u00061D/Z:u!\u0006tG-Y:Gk:\u001cG/[8o\u001d>$8\t[1j]&twmV5uQ\u001e+g.\u001a:bYBKH\u000f[8o\rVt7\r^5p]\"\u0012q\u0003W\u0001&i\u0016\u001cH\u000fU=uQ>tg)\u001e8di&|gnV5uQ\u000e{W\u000e]8tSR,\u0017J\u001c9viND#\u0001\u0007-\u0002gQ,7\u000f\u001e)zi\"|gNR;oGRLwN\\,ji\"\u001cu.\u001c9pg&$X-\u00138qkR\u001c\u0018I\u001c3XQ\u0016\u0014Xm\u00117bkN,\u0007FA\rY\u00035\"Xm\u001d;DQ\u0006Lg.\u001b8h!f$\bn\u001c8Gk:\u001cG/[8o/&$\bnQ8na>\u001c\u0018\u000e^3J]B,Ho\u001d\u0015\u00035a\u000bQ\u0005^3tiB\u000bg\u000eZ1t\rVt7\r^5p]^KG\u000f[\"p[B|7/\u001b;f\u0013:\u0004X\u000f^:)\u0005mA\u0016A\n;fgR\u0004\u0016\u0010\u001e5p]\u001a+hn\u0019;j_:<\u0016\u000e\u001e5D_6\u0004xn]5uK>+H\u000f];ug\"\u0012A\u0004W\u0001/i\u0016\u001cH\u000fU=uQ>tg)\u001e8di&|gnV5uQ6+H\u000e^5qY\u0016\u001cu.\u001c9pg&$XmT;uaV$8\u000f\u000b\u0002\u001e1\u0006yC/Z:u!f$\bn\u001c8Gk:\u001cG/[8o/&$\bnQ8na>\u001c\u0018\u000e^3J]B,Ho]!oI>+H\u000f];ug\"\u0012a\u0004W\u0001+i\u0016\u001cH\u000fU=uQ>tg)\u001e8di&|gnV5uQ\u000e{W\u000e]8tSR,w\u000b[3sK\u000ec\u0017-^:fQ\ty\u0002\f")
public class PythonCalcSplitRuleTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        FlinkChainedProgram programs = new FlinkChainedProgram();
        programs.addLast("logical", (FlinkOptimizeProgram)FlinkVolcanoProgramBuilder$.MODULE$.newBuilder().add(FlinkBatchRuleSets$.MODULE$.LOGICAL_OPT_RULES()).setRequiredOutputTraits((RelTrait[])((Object[])new RelTrait[]{FlinkConventions$.MODULE$.LOGICAL()})).build());
        programs.addLast("logical_rewrite", (FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_SEQUENCE()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(FlinkStreamRuleSets$.MODULE$.LOGICAL_REWRITE()).build());
        this.util().replaceBatchProgram((FlinkChainedProgram<BatchOptimizeContext>)programs);
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d"))}), new CaseClassTypeInfo<Tuple4<Object, Object, Object, Tuple2<Object, Object>>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, Object, Tuple2<Object, Object>>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, Object, Object, Tuple2<Object, Object>>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Object, Object, Tuple2<Object, Object>>>(this, fieldSerializers){

                    public Tuple4<Object, Object, Object, Tuple2<Object, Object>> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)((Tuple2)fields[3]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.rules.logical.PythonCalcSplitRuleTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTemporarySystemFunction("pyFunc1", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.PythonScalarFunction("pyFunc1"));
        this.util().addTemporarySystemFunction("pyFunc2", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.PythonScalarFunction("pyFunc2"));
        this.util().addTemporarySystemFunction("pyFunc3", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.PythonScalarFunction("pyFunc3"));
        this.util().addTemporarySystemFunction("pyFunc4", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.BooleanPythonScalarFunction("pyFunc4"));
        this.util().addTemporarySystemFunction("pyFunc5", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.RowPythonScalarFunction("pyFunc5"));
        this.util().addTemporarySystemFunction("RowJavaFunc", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.RowJavaScalarFunction("RowJavaFunc"));
        this.util().addTemporarySystemFunction("pandasFunc1", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.PandasScalarFunction("pandasFunc1"));
        this.util().addTemporarySystemFunction("pandasFunc2", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.PandasScalarFunction("pandasFunc2"));
        this.util().addTemporarySystemFunction("pandasFunc3", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.PandasScalarFunction("pandasFunc3"));
        this.util().addTemporarySystemFunction("pandasFunc4", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.BooleanPandasScalarFunction("pandasFunc4"));
    }

    @Test
    public void testPythonFunctionAsInputOfJavaFunction() {
        String sqlQuery = "SELECT pyFunc1(a, b) + 1 FROM MyTable";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testPythonFunctionMixedWithJavaFunction() {
        String sqlQuery = "SELECT pyFunc1(a, b), c + 1 FROM MyTable";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testPythonFunctionMixedWithJavaFunctionInWhereClause() {
        String sqlQuery = "SELECT pyFunc1(a, b), c + 1 FROM MyTable WHERE pyFunc2(a, c) > 0";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testPythonFunctionInWhereClause() {
        String sqlQuery = "SELECT pyFunc1(a, b) FROM MyTable WHERE pyFunc4(a, c)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testChainingPythonFunction() {
        String sqlQuery = "SELECT pyFunc3(pyFunc2(a + pyFunc1(a, c), b), c) FROM MyTable";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testOnlyOnePythonFunction() {
        String sqlQuery = "SELECT pyFunc1(a, b) FROM MyTable";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testOnlyOnePythonFunctionInWhereClause() {
        String sqlQuery = "SELECT a, b FROM MyTable WHERE pyFunc4(a, c)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testFieldNameUniquify() {
        this.util().addTableSource("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2"))}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.plan.rules.logical.PythonCalcSplitRuleTest$$anon$7 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        String sqlQuery = "SELECT pyFunc1(f1, f2), f0 + 1 FROM MyTable2";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testLiteral() {
        String sqlQuery = "SELECT a, b, pyFunc1(a, c), 1 FROM MyTable";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testReorderPythonCalc() {
        String sqlQuery = "SELECT a, pyFunc1(a, c), b FROM MyTable";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testPandasFunctionAsInputOfJavaFunction() {
        String sqlQuery = "SELECT pandasFunc1(a, b) + 1 FROM MyTable";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testPandasFunctionMixedWithJavaFunction() {
        String sqlQuery = "SELECT pandasFunc1(a, b), c + 1 FROM MyTable";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testPandasFunctionMixedWithJavaFunctionInWhereClause() {
        String sqlQuery = "SELECT pandasFunc1(a, b), c + 1 FROM MyTable WHERE pandasFunc2(a, c) > 0";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testPandasFunctionInWhereClause() {
        String sqlQuery = "SELECT pandasFunc1(a, b) FROM MyTable WHERE pandasFunc4(a, c)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testChainingPandasFunction() {
        String sqlQuery = "SELECT pandasFunc3(pandasFunc2(a + pandasFunc1(a, c), b), c) FROM MyTable";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testOnlyOnePandasFunction() {
        String sqlQuery = "SELECT pandasFunc1(a, b) FROM MyTable";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testOnlyOnePandasFunctionInWhereClause() {
        String sqlQuery = "SELECT a, b FROM MyTable WHERE pandasFunc4(a, c)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testPandasFunctionMixedWithGeneralPythonFunction() {
        String sqlQuery = "SELECT pandasFunc1(a, b), pyFunc1(a, c) + 1, a + 1 FROM MyTable";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testPandasFunctionNotChainingWithGeneralPythonFunction() {
        String sqlQuery = "SELECT pyFunc1(a, pandasFunc1(a, b)) + 1 FROM MyTable";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testPythonFunctionWithCompositeInputs() {
        String sqlQuery = "SELECT a, pyFunc1(b, d._1) FROM MyTable";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testPythonFunctionWithCompositeInputsAndWhereClause() {
        String sqlQuery = "SELECT a, pyFunc1(b, d._1) FROM MyTable WHERE a + 1 > 0";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testChainingPythonFunctionWithCompositeInputs() {
        String sqlQuery = "SELECT a, pyFunc1(b, pyFunc1(c, d._1)) FROM MyTable";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testPandasFunctionWithCompositeInputs() {
        String sqlQuery = "SELECT a, pandasFunc1(b, d._1) FROM MyTable";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testPythonFunctionWithCompositeOutputs() {
        String sqlQuery = "SELECT e.* FROM (SELECT pyFunc5(a) as e FROM MyTable) AS T";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testPythonFunctionWithMultipleCompositeOutputs() {
        String sqlQuery = "SELECT e.*, f.* FROM (SELECT pyFunc5(a) as e, pyFunc5(b) as f FROM MyTable) AS T";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testPythonFunctionWithCompositeInputsAndOutputs() {
        String sqlQuery = "SELECT e.* FROM (SELECT pyFunc5(d._1) as e FROM MyTable) AS T";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testPythonFunctionWithCompositeWhereClause() {
        String sqlQuery = "SELECT a + 1 FROM MyTable where RowJavaFunc(pyFunc5(a).f0).f0 is NULL and b > 0";
        this.util().verifyRelPlan(sqlQuery);
    }
}

