/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.apache.flink.table.planner.plan.optimize.program.StreamOptimizeContext;
import org.apache.flink.table.planner.plan.rules.logical.ProjectWindowTableFunctionTransposeRule;
import org.apache.flink.table.planner.plan.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00113Aa\u0002\u0005\u00013!)\u0001\u0005\u0001C\u0001C!9A\u0005\u0001b\u0001\n\u0013)\u0003BB\u0015\u0001A\u0003%a\u0005C\u0003+\u0001\u0011\u00051\u0006C\u0003>\u0001\u0011\u00051\u0006C\u0003C\u0001\u0011\u00051FA\u0016Qe>TWm\u0019;XS:$wn\u001e+bE2,g)\u001e8di&|g\u000e\u0016:b]N\u0004xn]3Sk2,G+Z:u\u0015\tI!\"A\u0004m_\u001eL7-\u00197\u000b\u0005-a\u0011!\u0002:vY\u0016\u001c(BA\u0007\u000f\u0003\u0011\u0001H.\u00198\u000b\u0005=\u0001\u0012a\u00029mC:tWM\u001d\u0006\u0003#I\tQ\u0001^1cY\u0016T!a\u0005\u000b\u0002\u000b\u0019d\u0017N\\6\u000b\u0005U1\u0012AB1qC\u000eDWMC\u0001\u0018\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0004\u0005\u0002\u001c=5\tAD\u0003\u0002\u001e\u001d\u0005)Q\u000f^5mg&\u0011q\u0004\b\u0002\u000e)\u0006\u0014G.\u001a+fgR\u0014\u0015m]3\u0002\rqJg.\u001b;?)\u0005\u0011\u0003CA\u0012\u0001\u001b\u0005A\u0011\u0001B;uS2,\u0012A\n\t\u00037\u001dJ!\u0001\u000b\u000f\u0003'M#(/Z1n)\u0006\u0014G.\u001a+fgR,F/\u001b7\u0002\u000bU$\u0018\u000e\u001c\u0011\u0002\u000bM,G/\u001e9\u0015\u00031\u0002\"!\f\u0019\u000e\u00039R\u0011aL\u0001\u0006g\u000e\fG.Y\u0005\u0003c9\u0012A!\u00168ji\"\u0012Aa\r\t\u0003imj\u0011!\u000e\u0006\u0003m]\n1!\u00199j\u0015\tA\u0014(A\u0004kkBLG/\u001a:\u000b\u0005i2\u0012!\u00026v]&$\u0018B\u0001\u001f6\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u0016i\u0016\u001cH\u000f\u0015:v]\u0016,f.^:fI\u000e{G.^7oQ\t)q\b\u0005\u00025\u0001&\u0011\u0011)\u000e\u0002\u0005)\u0016\u001cH/A\nuKN$hj\\\"pYVlg\u000eV8QeVtW\r\u000b\u0002\u0007\u007f\u0001")
public class ProjectWindowTableFunctionTransposeRuleTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        FlinkChainedProgram programs = new FlinkChainedProgram();
        programs.addLast("rules", (FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_SEQUENCE()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{ProjectWindowTableFunctionTransposeRule.INSTANCE})).build());
        this.util().replaceStreamProgram((FlinkChainedProgram<StreamOptimizeContext>)programs);
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                                |CREATE TABLE MyTable (\n                                |  a INT,\n                                |  b BIGINT,\n                                |  c STRING NOT NULL,\n                                |  d DECIMAL(10, 3),\n                                |  e BIGINT,\n                                |  rowtime TIMESTAMP(3),\n                                |  WATERMARK FOR rowtime AS rowtime - INTERVAL '1' SECOND\n                                |) with (\n                                |  'connector' = 'values'\n                                |)\n                                |")).stripMargin());
    }

    @Test
    public void testPruneUnusedColumn() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |  CUMULATE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |GROUP BY window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testNoColumnToPrune() {
        this.util().addTemporarySystemFunction("weightedAvg", JavaUserDefinedAggFunctions.WeightedAvgWithMerge.class);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |  CUMULATE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }
}

