/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE;
import org.apache.flink.table.planner.plan.optimize.program.StreamOptimizeContext;
import org.apache.flink.table.planner.plan.rules.logical.ProjectWatermarkAssignerTransposeRule;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ProjectWatermarkAssignerTransposeRuleTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(TableConfig.getDefault());

    ProjectWatermarkAssignerTransposeRuleTest() {
    }

    @BeforeEach
    void setup() {
        FlinkChainedProgram program = new FlinkChainedProgram();
        program.addLast("ProjectWatermarkAssignerTransposeRule", (FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE.RULE_SEQUENCE()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{ProjectWatermarkAssignerTransposeRule.INSTANCE})).build());
        this.util.replaceStreamProgram((FlinkChainedProgram<StreamOptimizeContext>)program);
        String ddl1 = "CREATE TABLE SimpleTable(\n  a INT,\n  b BIGINT,\n  c TIMESTAMP(3),  d ROW<d1 INT, d2 INT, d3 INT>,\nWATERMARK FOR c AS c) WITH (  'connector' = 'values',\n  'bounded' = 'false'\n)";
        this.util.tableEnv().executeSql(ddl1);
        String ddl2 = "CREATE TABLE VirtualTable(  a int,\n  b BIGINT,\n  c ROW<c1 TIMESTAMP(3)>,\n  d AS c.c1 + INTERVAL '5' SECOND,\nWATERMARK FOR d as d - INTERVAL '5' second) WITH (  'connector' = 'values',\n  'bounded' = 'false'\n)";
        this.util.tableEnv().executeSql(ddl2);
        JavaUserDefinedScalarFunctions.JavaFunc5.openCalled = false;
        JavaUserDefinedScalarFunctions.JavaFunc5.closeCalled = false;
        this.util.addTemporarySystemFunction("myFunc", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.JavaFunc5());
        String ddl3 = "CREATE TABLE UdfTable(  a INT,\n  b TIMESTAMP(3),\n  c INT,\n  d STRING,\n  WATERMARK FOR b AS myFunc(b, c)) WITH (  'connector' = 'values',\n  'bounded' = 'false'\n)";
        this.util.tableEnv().executeSql(ddl3);
        String ddl4 = "CREATE TABLE NestedTable(\n  a int,\n  b BIGINT,\n  c ROW<c1 TIMESTAMP(3), c2 INT>,\n  d AS c.c1 + INTERVAL '5' SECOND,\nWATERMARK FOR d as myFunc(d, c.c2)\n) WITH (  'connector' = 'values',\n  'bounded' = 'false'\n)";
        this.util.tableEnv().executeSql(ddl4);
    }

    @Test
    void simpleTranspose() {
        this.util.verifyRelPlan("SELECT a, c FROM SimpleTable");
    }

    @Test
    void transposeWithReorder() {
        this.util.verifyRelPlan("SELECT b, a FROM SimpleTable");
    }

    @Test
    void transposeWithNestedField() {
        this.util.verifyRelPlan("SELECT b, d.d1, d.d2 FROM SimpleTable");
    }

    @Test
    void complicatedTranspose() {
        this.util.verifyRelPlan("SELECT d.d1, d.d2 + b FROM SimpleTable");
    }

    @Test
    void transposeExcludeRowTime() {
        this.util.verifyRelPlan("SELECT SECOND(c) FROM SimpleTable");
    }

    @Test
    void transposeWithIncludeComputedRowTime() {
        this.util.verifyRelPlan("SELECT a, b, d FROM VirtualTable");
    }

    @Test
    void transposeWithExcludeComputedRowTime() {
        this.util.verifyRelPlan("SELECT a, b FROM VirtualTable");
    }

    @Test
    void transposeWithExcludeComputedRowTime2() {
        this.util.verifyRelPlan("SELECT a, b, SECOND(d) FROM VirtualTable");
    }

    @Test
    void transposeWithExcludeComputedRowTime3() {
        this.util.verifyRelPlan("SELECT a, SECOND(d) FROM NestedTable");
    }

    @Test
    void transposeWithDuplicateColumns() {
        this.util.verifyRelPlan("SELECT a, b, b as e FROM VirtualTable");
    }

    @Test
    void transposeWithWatermarkWithMultipleInput() {
        this.util.verifyRelPlan("SELECT a FROM UdfTable");
    }
}

