/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.calcite.CalciteConfig;
import org.apache.flink.table.planner.plan.optimize.program.FlinkBatchProgram$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.apache.flink.table.planner.plan.rules.logical.JoinConditionEqualityTransferRule$;
import org.apache.flink.table.planner.plan.rules.logical.JoinConditionEqualityTransferRuleTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001!4Aa\u0005\u000b\u0001K!)A\u0006\u0001C\u0001[!9\u0001\u0007\u0001b\u0001\n\u0013\t\u0004BB\u001b\u0001A\u0003%!\u0007C\u00037\u0001\u0011\u0005q\u0007C\u0003J\u0001\u0011\u0005q\u0007C\u0003O\u0001\u0011\u0005q\u0007C\u0003Q\u0001\u0011\u0005q\u0007C\u0003S\u0001\u0011\u0005q\u0007C\u0003U\u0001\u0011\u0005q\u0007C\u0003W\u0001\u0011\u0005q\u0007C\u0003Y\u0001\u0011\u0005q\u0007C\u0003[\u0001\u0011\u0005q\u0007C\u0003]\u0001\u0011\u0005q\u0007C\u0003_\u0001\u0011\u0005q\u0007C\u0003a\u0001\u0011\u0005q\u0007C\u0003c\u0001\u0011\u0005q\u0007C\u0003e\u0001\u0011\u0005q\u0007C\u0003g\u0001\u0011\u0005qGA\u0013K_&t7i\u001c8eSRLwN\\#rk\u0006d\u0017\u000e^=Ue\u0006t7OZ3s%VdW\rV3ti*\u0011QCF\u0001\bY><\u0017nY1m\u0015\t9\u0002$A\u0003sk2,7O\u0003\u0002\u001a5\u0005!\u0001\u000f\\1o\u0015\tYB$A\u0004qY\u0006tg.\u001a:\u000b\u0005uq\u0012!\u0002;bE2,'BA\u0010!\u0003\u00151G.\u001b8l\u0015\t\t#%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002G\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\n\t\u0003O)j\u0011\u0001\u000b\u0006\u0003Si\tQ!\u001e;jYNL!a\u000b\u0015\u0003\u001bQ\u000b'\r\\3UKN$()Y:f\u0003\u0019a\u0014N\\5u}Q\ta\u0006\u0005\u00020\u00015\tA#\u0001\u0003vi&dW#\u0001\u001a\u0011\u0005\u001d\u001a\u0014B\u0001\u001b)\u0005I\u0011\u0015\r^2i)\u0006\u0014G.\u001a+fgR,F/\u001b7\u0002\u000bU$\u0018\u000e\u001c\u0011\u0002\u000bM,G/\u001e9\u0015\u0003a\u0002\"!\u000f\u001f\u000e\u0003iR\u0011aO\u0001\u0006g\u000e\fG.Y\u0005\u0003{i\u0012A!\u00168ji\"\u0012Aa\u0010\t\u0003\u0001\u001ek\u0011!\u0011\u0006\u0003\u0005\u000e\u000b1!\u00199j\u0015\t!U)A\u0004kkBLG/\u001a:\u000b\u0005\u0019\u0013\u0013!\u00026v]&$\u0018B\u0001%B\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u000fi\u0016\u001cH/\u00138oKJTu.\u001b82Q\t)1\n\u0005\u0002A\u0019&\u0011Q*\u0011\u0002\u0005)\u0016\u001cH/\u0001\buKN$\u0018J\u001c8fe*{\u0017N\u001c\u001a)\u0005\u0019Y\u0015A\u0004;fgRLeN\\3s\u0015>Lgn\r\u0015\u0003\u000f-\u000ba\u0002^3ti&sg.\u001a:K_&tG\u0007\u000b\u0002\t\u0017\u0006\u0011C/Z:u\u0013:tWM\u001d&pS:<\u0016\u000e\u001e5O_:,\u0015/^5D_:$\u0017\u000e^5p]FB#!C&\u0002EQ,7\u000f^%o]\u0016\u0014(j\\5o/&$\bNT8o\u000bF,\u0018nQ8oI&$\u0018n\u001c83Q\tQ1*\u0001\tuKN$8+Z7j\u0015>LgnX%oc!\u00121bS\u0001\u0011i\u0016\u001cHoU3nS*{\u0017N\\0J]JB#\u0001D&\u0002IQ,7\u000f^*f[&Tu.\u001b8XSRDgj\u001c8FcVL7i\u001c8eSRLwN\\0J]FB#!D&\u0002IQ,7\u000f^*f[&Tu.\u001b8XSRDgj\u001c8FcVL7i\u001c8eSRLwN\\0J]JB#AD&\u0002'Q,7\u000f^*f[&Tu.\u001b8`\u000bbL7\u000f^\u0019)\u0005=Y\u0015a\u0005;fgR\u001cV-\\5K_&tw,\u0012=jgR\u0014\u0004F\u0001\tL\u0003\u001d\"Xm\u001d;TK6L'j\\5o/&$\bNT8o\u000bF,\u0018nQ8oI&$\u0018n\u001c8`\u000bbL7\u000f^\u0019)\u0005EY\u0015a\n;fgR\u001cV-\\5K_&tw+\u001b;i\u001d>tW)];j\u0007>tG-\u001b;j_:|V\t_5tiJB#AE&")
public class JoinConditionEqualityTransferRuleTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        this.util().buildBatchProgram(FlinkBatchProgram$.MODULE$.DEFAULT_REWRITE());
        CalciteConfig calciteConfig = TableConfigUtils.getCalciteConfig((TableConfig)this.util().tableEnv().getConfig());
        ((FlinkChainedProgram)calciteConfig.getBatchProgram().get()).addLast("rules", (FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_SEQUENCE()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{JoinConditionEqualityTransferRule$.MODULE$.INSTANCE()})).build());
        this.util().addTableSource("MyTable1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.rules.logical.JoinConditionEqualityTransferRuleTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTableSource("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f"))}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.rules.logical.JoinConditionEqualityTransferRuleTest$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testInnerJoin1() {
        this.util().verifyRelPlan("SELECT * FROM MyTable1 JOIN MyTable2 ON a = d AND a = e");
    }

    @Test
    public void testInnerJoin2() {
        this.util().verifyRelPlan("SELECT * FROM MyTable1 JOIN MyTable2 ON a = d AND a = e AND b = d");
    }

    @Test
    public void testInnerJoin3() {
        this.util().verifyRelPlan("SELECT * FROM MyTable1 JOIN MyTable2 ON a = d AND a = e AND a = c");
    }

    @Test
    public void testInnerJoin4() {
        this.util().verifyRelPlan("SELECT * FROM MyTable1 JOIN MyTable2 ON a = d AND a = e AND b + 1 = d");
    }

    @Test
    public void testInnerJoinWithNonEquiCondition1() {
        this.util().verifyRelPlan("SELECT * FROM MyTable1 JOIN MyTable2 ON a = d AND a > e");
    }

    @Test
    public void testInnerJoinWithNonEquiCondition2() {
        this.util().verifyRelPlan("SELECT * FROM MyTable1 JOIN MyTable2 ON a = d AND a = e AND b > d");
    }

    @Test
    public void testSemiJoin_In1() {
        this.util().verifyRelPlan("SELECT * FROM MyTable1 WHERE a IN (SELECT d FROM MyTable2 WHERE a = e)");
    }

    @Test
    public void testSemiJoin_In2() {
        String sqlQuery = "SELECT * FROM MyTable1 WHERE a IN (SELECT d FROM MyTable2 WHERE a = e AND b = d)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testSemiJoinWithNonEquiCondition_In1() {
        this.util().verifyRelPlan("SELECT * FROM MyTable1 WHERE a IN (SELECT d FROM MyTable2 WHERE a > e)");
    }

    @Test
    public void testSemiJoinWithNonEquiCondition_In2() {
        String sqlQuery = "SELECT * FROM MyTable1 WHERE a IN (SELECT d FROM MyTable2 WHERE a > e AND b = d)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testSemiJoin_Exist1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable1 WHERE EXISTS (SELECT * FROM MyTable2 WHERE a = d AND a = e)\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testSemiJoin_Exist2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable1 WHERE EXISTS\n        |    (SELECT * FROM MyTable2 WHERE a = d AND a = e AND b = d)\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testSemiJoinWithNonEquiCondition_Exist1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable1 WHERE EXISTS (SELECT * FROM MyTable2 WHERE a = d AND a > e)\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testSemiJoinWithNonEquiCondition_Exist2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable1 WHERE EXISTS\n        |    (SELECT * FROM MyTable2 WHERE a = d AND a = e AND b > d)\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }
}

