/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.nodes.FlinkConventions$;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalCalc$;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalTableSourceScan$;
import org.apache.flink.table.planner.plan.optimize.program.BatchOptimizeContext;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkVolcanoProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.apache.flink.table.planner.plan.rules.FlinkBatchRuleSets$;
import org.apache.flink.table.planner.plan.rules.logical.FlinkCalcMergeRule;
import org.apache.flink.table.planner.plan.rules.logical.FlinkCalcMergeRuleTest$;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001e3AAD\b\u0001A!)q\u0005\u0001C\u0001Q!91\u0006\u0001b\u0001\n\u0013a\u0003B\u0002\u0019\u0001A\u0003%Q\u0006C\u00032\u0001\u0011\u0005!\u0007C\u0003E\u0001\u0011\u0005!\u0007C\u0003J\u0001\u0011\u0005!\u0007C\u0003L\u0001\u0011\u0005!\u0007C\u0003N\u0001\u0011\u0005!\u0007C\u0003P\u0001\u0011\u0005!\u0007C\u0003R\u0001\u0011\u0005!\u0007C\u0003T\u0001\u0011\u0005!\u0007C\u0003V\u0001\u0011\u0005!\u0007C\u0003X\u0001\u0011\u0005!G\u0001\fGY&t7nQ1mG6+'oZ3Sk2,G+Z:u\u0015\t\u0001\u0012#A\u0004m_\u001eL7-\u00197\u000b\u0005I\u0019\u0012!\u0002:vY\u0016\u001c(B\u0001\u000b\u0016\u0003\u0011\u0001H.\u00198\u000b\u0005Y9\u0012a\u00029mC:tWM\u001d\u0006\u00031e\tQ\u0001^1cY\u0016T!AG\u000e\u0002\u000b\u0019d\u0017N\\6\u000b\u0005qi\u0012AB1qC\u000eDWMC\u0001\u001f\u0003\ry'oZ\u0002\u0001'\t\u0001\u0011\u0005\u0005\u0002#K5\t1E\u0003\u0002%+\u0005)Q\u000f^5mg&\u0011ae\t\u0002\u000e)\u0006\u0014G.\u001a+fgR\u0014\u0015m]3\u0002\rqJg.\u001b;?)\u0005I\u0003C\u0001\u0016\u0001\u001b\u0005y\u0011\u0001B;uS2,\u0012!\f\t\u0003E9J!aL\u0012\u0003%\t\u000bGo\u00195UC\ndW\rV3tiV#\u0018\u000e\\\u0001\u0006kRLG\u000eI\u0001\u0006g\u0016$X\u000f\u001d\u000b\u0002gA\u0011AgN\u0007\u0002k)\ta'A\u0003tG\u0006d\u0017-\u0003\u00029k\t!QK\\5uQ\t!!\b\u0005\u0002<\u00056\tAH\u0003\u0002>}\u0005\u0019\u0011\r]5\u000b\u0005}\u0002\u0015a\u00026va&$XM\u001d\u0006\u0003\u0003v\tQA[;oSRL!a\u0011\u001f\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A\u000euKN$8)\u00197d\u001b\u0016\u0014x-Z,ji\"\u001c\u0016-\\3ES\u001e,7\u000f\u001e\u0015\u0003\u000b\u0019\u0003\"aO$\n\u0005!c$\u0001\u0002+fgR\fa\u0005^3ti\u000e\u000bGnY'fe\u001e,w+\u001b;i\u001d>tG)\u001a;fe6Lg.[:uS\u000e,\u0005\u0010\u001d:2Q\t1a)\u0001\u0014uKN$8)\u00197d\u001b\u0016\u0014x-Z,ji\"tuN\u001c#fi\u0016\u0014X.\u001b8jgRL7-\u0012=qeJB#a\u0002$\u0002WQ,7\u000f^\"bY\u000elUM]4f/&$\bNT3ti\u0016$gj\u001c8EKR,'/\\5oSN$\u0018nY#yaJD#\u0001\u0003$\u0002[Q,7\u000f^\"bY\u000elUM]4f/&$\b\u000eV8q\u001bVdG/\u001b(p]\u0012+G/\u001a:nS:L7\u000f^5d\u000bb\u0004(\u000f\u000b\u0002\n\r\u0006iC/Z:u\u0007\u0006d7-T3sO\u0016$v\u000e\u001d$jYR,'\u000fS1t\u001d>tG)\u001a;fe6Lg.[:uS\u000e,\u0005\u0010\u001d:)\u0005)1\u0015\u0001\r;fgR\u001c\u0015\r\\2NKJ<WmV5uQ\n{G\u000f^8n\u001bVdG/\u001b(p]\u0012+G/\u001a:nS:L7\u000f^5d\u000bb\u0004(\u000f\u000b\u0002\f\r\u0006YD/Z:u\u0007\u0006d7-T3sO\u0016<\u0016\u000e\u001e5C_R$x.\\'vYRLgj\u001c8EKR,'/\\5oSN$\u0018nY%o\u0007>tG-\u001b;j_:,\u0005\u0010\u001d:)\u000511\u0015!\f;fgR\u001c\u0015\r\\2NKJ<WmV5uQ>,H/\u00138oKJtuN\u001c#fi\u0016\u0014X.\u001b8jgRL7-\u0012=qe\"\u0012QB\u0012")
public class FlinkCalcMergeRuleTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        FlinkChainedProgram programs = new FlinkChainedProgram();
        programs.addLast("table_ref", (FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_SEQUENCE()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(FlinkBatchRuleSets$.MODULE$.TABLE_REF_RULES()).build());
        programs.addLast("logical", (FlinkOptimizeProgram)FlinkVolcanoProgramBuilder$.MODULE$.newBuilder().add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{CoreRules.FILTER_TO_CALC, CoreRules.PROJECT_TO_CALC, FlinkCalcMergeRule.INSTANCE, FlinkLogicalCalc$.MODULE$.CONVERTER(), FlinkLogicalTableSourceScan$.MODULE$.CONVERTER()})).setRequiredOutputTraits((RelTrait[])((Object[])new RelTrait[]{FlinkConventions$.MODULE$.LOGICAL()})).build());
        this.util().replaceBatchProgram((FlinkChainedProgram<BatchOptimizeContext>)programs);
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.rules.logical.FlinkCalcMergeRuleTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTemporarySystemFunction("random_udf", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.NonDeterministicUdf());
    }

    @Test
    public void testCalcMergeWithSameDigest() {
        this.util().verifyRelPlan("SELECT a, b FROM (SELECT * FROM MyTable WHERE a = b) t WHERE b = a");
    }

    @Test
    public void testCalcMergeWithNonDeterministicExpr1() {
        String sqlQuery = "SELECT a, a1 FROM (SELECT a, random_udf(a) AS a1 FROM MyTable) t WHERE a1 > 10";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testCalcMergeWithNonDeterministicExpr2() {
        String sqlQuery = "SELECT a FROM (SELECT a FROM MyTable) t WHERE random_udf(a) > 10";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testCalcMergeWithNestedNonDeterministicExpr() {
        String sqlQuery = "SELECT random_udf(a1) as a2 FROM (SELECT random_udf(a) as a1, b FROM MyTable) t WHERE b > 10";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testCalcMergeWithTopMultiNonDeterministicExpr() {
        String sqlQuery = "SELECT random_udf(a1) as a2, random_udf(a1) as a3 FROM (SELECT random_udf(a) as a1, b FROM MyTable) t WHERE b > 10";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testCalcMergeTopFilterHasNonDeterministicExpr() {
        String sqlQuery = "SELECT a, c FROM (SELECT a, random_udf(b) as b1, c FROM MyTable) t WHERE b1 > 10";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testCalcMergeWithBottomMultiNonDeterministicExpr() {
        String sqlQuery = "SELECT a1, b2 FROM (SELECT random_udf(a) as a1, random_udf(b) as b2, c FROM MyTable) t WHERE c > 10";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testCalcMergeWithBottomMultiNonDeterministicInConditionExpr() {
        String sqlQuery = "SELECT c FROM (SELECT random_udf(a) as a1, random_udf(b) as b2, c FROM MyTable) t WHERE a1 > b2";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testCalcMergeWithoutInnerNonDeterministicExpr() {
        String sqlQuery = "SELECT a, c FROM (SELECT a, random_udf(a) as a1, c FROM MyTable) t WHERE c > 10";
        this.util().verifyRelPlan(sqlQuery);
    }
}

