/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.expressions.utils.Func1$;
import org.apache.flink.table.planner.expressions.utils.FuncNotReducible$;
import org.apache.flink.table.planner.expressions.utils.RichFunc1;
import org.apache.flink.table.planner.plan.rules.logical.DeterministicPythonFunc$;
import org.apache.flink.table.planner.plan.rules.logical.ExpressionReductionRulesTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u000153Aa\u0003\u0007\u0001;!)A\u0005\u0001C\u0001K!9\u0001\u0006\u0001b\u0001\n\u0013I\u0003BB\u0017\u0001A\u0003%!\u0006C\u0003/\u0001\u0011\u0005q\u0006C\u0003B\u0001\u0011\u0005q\u0006C\u0003D\u0001\u0011\u0005q\u0006C\u0003F\u0001\u0011\u0005q\u0006C\u0003H\u0001\u0011\u0005q\u0006C\u0003J\u0001\u0011\u0005q\u0006C\u0003L\u0001\u0011\u0005qF\u0001\u000fFqB\u0014Xm]:j_:\u0014V\rZ;di&|gNU;mKN$Vm\u001d;\u000b\u00055q\u0011a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003\u001fA\tQA];mKNT!!\u0005\n\u0002\tAd\u0017M\u001c\u0006\u0003'Q\tq\u0001\u001d7b]:,'O\u0003\u0002\u0016-\u0005)A/\u00192mK*\u0011q\u0003G\u0001\u0006M2Lgn\u001b\u0006\u00033i\ta!\u00199bG\",'\"A\u000e\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001q\u0002CA\u0010#\u001b\u0005\u0001#BA\u0011\u0013\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0003EA\u0007UC\ndW\rV3ti\n\u000b7/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0019\u0002\"a\n\u0001\u000e\u00031\tA!\u001e;jYV\t!\u0006\u0005\u0002 W%\u0011A\u0006\t\u0002\u0013\u0005\u0006$8\r\u001b+bE2,G+Z:u+RLG.A\u0003vi&d\u0007%\u0001\u0010uKN$X\t\u001f9sKN\u001c\u0018n\u001c8SK\u0012,8\r^5p]^KG\u000f[+E\rR\t\u0001\u0007\u0005\u00022i5\t!GC\u00014\u0003\u0015\u00198-\u00197b\u0013\t)$G\u0001\u0003V]&$\bF\u0001\u00038!\tAt(D\u0001:\u0015\tQ4(A\u0002ba&T!\u0001P\u001f\u0002\u000f),\b/\u001b;fe*\u0011aHG\u0001\u0006UVt\u0017\u000e^\u0005\u0003\u0001f\u0012A\u0001V3ti\u0006\u0011C/Z:u\u000bb\u0004(/Z:tS>t'+\u001a3vGRLwN\\,ji\"\u0014\u0016n\u00195V\t\u001aC#!B\u001c\u0002aQ,7\u000f^#yaJ,7o]5p]J+G-^2uS>tw+\u001b;i%&\u001c\u0007.\u0016#G\u0003:$\u0017J\u001c<bY&$w\n]3oQ\t1q'\u0001\u0016uKN$X\t\u001f9sKN\u001c\u0018n\u001c8SK\u0012,8\r^5p]^KG\u000f\u001b(p]J+G-^2jE2,W\u000b\u0012$)\u0005\u001d9\u0014A\r;fgR,\u0005\u0010\u001d:fgNLwN\u001c*fIV\u001cG/[8o/&$\bNT8o%\u0016$WoY5cY\u0016lU\u000f\u001c;ja2,W\u000b\u0012$)\u0005!9\u0014\u0001\n;fgR,\u0005\u0010\u001d:fgNLwN\u001c*fIV\u001cG/[8o/&$\b\u000eU=uQ>tW\u000b\u0012$)\u0005%9\u0014a\b;fgR,\u0005\u0010\u001d:fgNLwN\u001c*fIV\u001cG/[8o/&$\bNU1oI\"\u0012!b\u000e")
public class ExpressionReductionRulesTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testExpressionReductionWithUDF() {
        this.util().addTemporarySystemFunction("MyUdf", (UserDefinedFunction)Func1$.MODULE$);
        this.util().verifyRelPlan("SELECT MyUdf(1) FROM MyTable");
    }

    @Test
    public void testExpressionReductionWithRichUDF() {
        this.util().addTemporarySystemFunction("MyUdf", (UserDefinedFunction)new RichFunc1());
        this.util().getTableEnv().getConfig().addJobParameter("int.value", "10");
        this.util().verifyRelPlan("SELECT myUdf(1) FROM MyTable");
    }

    @Test
    public void testExpressionReductionWithRichUDFAndInvalidOpen() {
        this.util().addTemporarySystemFunction("MyUdf", (UserDefinedFunction)new RichFunc1());
        this.util().getTableEnv().getConfig().addJobParameter("fail-for-cached-file", "true");
        this.util().verifyRelPlan("SELECT myUdf(1 + 1) FROM MyTable");
    }

    @Test
    public void testExpressionReductionWithNonReducibleUDF() {
        this.util().addTemporarySystemFunction("MyUdf", (UserDefinedFunction)FuncNotReducible$.MODULE$);
        this.util().verifyRelPlan("SELECT MyUdf(1) FROM MyTable");
    }

    @Test
    public void testExpressionReductionWithNonReducibleMultipleUDF() {
        this.util().addTemporarySystemFunction("MyUdf1", (UserDefinedFunction)Func1$.MODULE$);
        this.util().addTemporarySystemFunction("MyUdf2", (UserDefinedFunction)FuncNotReducible$.MODULE$);
        this.util().verifyRelPlan("SELECT MyUdf2(MyUdf1(1)), MyUdf1(MyUdf2(1)) FROM MyTable");
    }

    @Test
    public void testExpressionReductionWithPythonUDF() {
        this.util().addTemporarySystemFunction("PyUdf", (UserDefinedFunction)DeterministicPythonFunc$.MODULE$);
        this.util().addTemporarySystemFunction("MyUdf", (UserDefinedFunction)Func1$.MODULE$);
        this.util().verifyExecPlan("SELECT PyUdf(), MyUdf(1) FROM MyTable");
    }

    @Test
    public void testExpressionReductionWithRand() {
        this.util().verifyExecPlan("SELECT RAND(), RAND(), RAND(1), RAND(1), RAND_INTEGER(3), RAND_INTEGER(3) FROM MyTable");
    }

    public ExpressionReductionRulesTest() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.rules.logical.ExpressionReductionRulesTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
    }
}

