/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.apache.flink.table.planner.plan.optimize.program.StreamOptimizeContext;
import org.apache.flink.table.planner.plan.rules.logical.CorrelateSortToRankRule;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001q3Aa\u0004\t\u0001C!)\u0001\u0006\u0001C\u0001S!9A\u0006\u0001b\u0001\n\u0013i\u0003BB\u0019\u0001A\u0003%a\u0006C\u00033\u0001\u0011\u00051\u0007C\u0003F\u0001\u0011\u00051\u0007C\u0003K\u0001\u0011\u00051\u0007C\u0003M\u0001\u0011\u00051\u0007C\u0003O\u0001\u0011\u00051\u0007C\u0003Q\u0001\u0011\u00051\u0007C\u0003S\u0001\u0011\u00051\u0007C\u0003U\u0001\u0011\u00051\u0007C\u0003W\u0001\u0011\u00051\u0007C\u0003Y\u0001\u0011\u00051\u0007C\u0003[\u0001\u0011\u00051GA\u000eD_J\u0014X\r\\1uKN{'\u000f\u001e+p%\u0006t7NU;mKR+7\u000f\u001e\u0006\u0003#I\tq\u0001\\8hS\u000e\fGN\u0003\u0002\u0014)\u0005)!/\u001e7fg*\u0011QCF\u0001\u0005a2\fgN\u0003\u0002\u00181\u00059\u0001\u000f\\1o]\u0016\u0014(BA\r\u001b\u0003\u0015!\u0018M\u00197f\u0015\tYB$A\u0003gY&t7N\u0003\u0002\u001e=\u00051\u0011\r]1dQ\u0016T\u0011aH\u0001\u0004_J<7\u0001A\n\u0003\u0001\t\u0002\"a\t\u0014\u000e\u0003\u0011R!!\n\f\u0002\u000bU$\u0018\u000e\\:\n\u0005\u001d\"#!\u0004+bE2,G+Z:u\u0005\u0006\u001cX-\u0001\u0004=S:LGO\u0010\u000b\u0002UA\u00111\u0006A\u0007\u0002!\u0005!Q\u000f^5m+\u0005q\u0003CA\u00120\u0013\t\u0001DEA\nTiJ,\u0017-\u001c+bE2,G+Z:u+RLG.A\u0003vi&d\u0007%A\u0003tKR,\b\u000fF\u00015!\t)\u0004(D\u00017\u0015\u00059\u0014!B:dC2\f\u0017BA\u001d7\u0005\u0011)f.\u001b;)\u0005\u0011Y\u0004C\u0001\u001fD\u001b\u0005i$B\u0001 @\u0003\r\t\u0007/\u001b\u0006\u0003\u0001\u0006\u000bqA[;qSR,'O\u0003\u0002C=\u0005)!.\u001e8ji&\u0011A)\u0010\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017a\u0006;fgR\u001cuN\u001d:fY\u0006$XmU8siR{'+\u00198lQ\t)q\t\u0005\u0002=\u0011&\u0011\u0011*\u0010\u0002\u0005)\u0016\u001cH/\u0001\u000fuKN$hj\u001c8J]:,'OS8j]:{GoU;qa>\u0014H/\u001a3)\u0005\u00199\u0015a\u0006;fgR\fumZ\"bY2tu\u000e^*vaB|'\u000f^3eQ\t9q)\u0001\u0017uKN$8i\u001c:sK2\fG/Z*peR$vNU1oW^KG\u000f['vYRL\u0007\u000f\\3He>,\boS3zg\"\u0012\u0001bR\u0001#i\u0016\u001cH/Q4h\u0013:\u0004X\u000f\u001e(p]6\u000b\u0007\u000f]5oO:{GoU;qa>\u0014H/\u001a3)\u0005%9\u0015A\b;fgR\u001cvN\u001d;XSRDwJ\u001a4tKRtu\u000e^*vaB|'\u000f^3eQ\tQq)A\u0011uKN$hj\u001c8FcV\fGnQ8oI&$\u0018n\u001c8O_R\u001cV\u000f\u001d9peR,G\r\u000b\u0002\f\u000f\u0006\u0019C/Z:u\r&dG/\u001a:D_:$\u0017\u000e^5p]:{GoQ8se\u0016d\u0017\r^5p]&#\u0005F\u0001\u0007H\u00039\"Xm\u001d;Nk2$\u0018\u000e\u001d7f\u000fJ|W\u000f]5oON<\u0016\u000e\u001e5D_:\u001cH/\u00198u\u001d>$8+\u001e9q_J$X\rZ\u0019)\u000559\u0015A\f;fgRlU\u000f\u001c;ja2,wI]8va&twm],ji\"\u001cuN\\:uC:$hj\u001c;TkB\u0004xN\u001d;fIJB#AD$")
public class CorrelateSortToRankRuleTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        FlinkChainedProgram programs = new FlinkChainedProgram();
        programs.addLast("rules", (FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_SEQUENCE()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{CorrelateSortToRankRule.INSTANCE})).build());
        this.util().replaceStreamProgram((FlinkChainedProgram<StreamOptimizeContext>)programs);
        String createTable = new StringOps(Predef$.MODULE$.augmentString("\n         |create table t1(\n         |  f0 int,\n         |  f1 bigint,\n         |  f2 varchar(20)\n         |) with (\n         |  'connector' = 'values',\n         |  'bounded' = 'false'\n         |)\n         |")).stripMargin();
        this.util().tableEnv().executeSql(createTable);
    }

    @Test
    public void testCorrelateSortToRank() {
        String query = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT f0, f1\n         |FROM\n         |  (SELECT DISTINCT f0 FROM t1) t2,\n         |  LATERAL (\n         |    SELECT f1, f2\n         |    FROM t1\n         |    WHERE f0 = t2.f0\n         |    ORDER BY f2\n         |    DESC LIMIT 3\n         |  )\n      ")).stripMargin();
        this.util().verifyRelPlan(query);
    }

    @Test
    public void testNonInnerJoinNotSupported() {
        String query = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT f0, f1\n         |FROM\n         |  (SELECT DISTINCT f0 FROM t1) t2\n         |  NATURAL LEFT JOIN\n         |  LATERAL (\n         |    SELECT f1, f2\n         |    FROM t1\n         |    WHERE f0 = t2.f0\n         |    ORDER BY f2\n         |    DESC LIMIT 3\n         |  )\n      ")).stripMargin();
        this.util().verifyRelPlan(query);
    }

    @Test
    public void testAggCallNotSupported() {
        String query = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT mf0, f1\n         |FROM\n         |  (SELECT max(f0) as mf0 FROM t1) t2,\n         |  LATERAL (\n         |    SELECT f1, f2\n         |    FROM t1\n         |    WHERE f0 = t2.mf0\n         |    ORDER BY f2\n         |    DESC LIMIT 3\n         |  )\n      ")).stripMargin();
        this.util().verifyRelPlan(query);
    }

    @Test
    public void testCorrelateSortToRankWithMultipleGroupKeys() {
        String query = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT f0, f2\n         |FROM\n         |  (SELECT DISTINCT f0, f1 FROM t1) t2,\n         |  LATERAL (\n         |    SELECT f2\n         |    FROM t1\n         |    WHERE f0 = t2.f0 AND f1 = t2.f1\n         |    ORDER BY f2\n         |    DESC LIMIT 3\n         |  )\n      ")).stripMargin();
        this.util().verifyRelPlan(query);
    }

    @Test
    public void testAggInputNonMappingNotSupported() {
        String query = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT f0, f1\n         |FROM\n         |  (SELECT DISTINCT f0 FROM (SELECT f0 + f1 as f0 from t1)) t2,\n         |  LATERAL (\n         |    SELECT f1, f2\n         |    FROM t1\n         |    WHERE f0 = t2.f0\n         |    ORDER BY f2\n         |    DESC LIMIT 3\n         |  )\n      ")).stripMargin();
        this.util().verifyRelPlan(query);
    }

    @Test
    public void testSortWithOffsetNotSupported() {
        String query = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT f0, f1\n         |FROM\n         |  (SELECT DISTINCT f0 FROM t1) t2,\n         |  LATERAL (\n         |    SELECT f1, f2\n         |    FROM t1\n         |    WHERE f0 = t2.f0\n         |    ORDER BY f2 DESC\n         |    OFFSET 2 ROWS\n         |    FETCH NEXT 3 ROWS ONLY\n         |  )\n      ")).stripMargin();
        this.util().verifyRelPlan(query);
    }

    @Test
    public void testNonEqualConditionNotSupported() {
        String query = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT f0, f1\n         |FROM\n         |  (SELECT DISTINCT f0 FROM t1) t2,\n         |  LATERAL (\n         |    SELECT f1, f2\n         |    FROM t1\n         |    WHERE f0 > t2.f0\n         |    ORDER BY f2\n         |    DESC LIMIT 3\n         |  )\n      ")).stripMargin();
        this.util().verifyRelPlan(query);
    }

    @Test
    public void testFilterConditionNotCorrelationID() {
        String query = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT f0, f1\n         |FROM\n         |  (SELECT DISTINCT f0 FROM t1) t2,\n         |  LATERAL (\n         |    SELECT f1, f2\n         |    FROM t1\n         |    WHERE t2.f0 = f0 + 1\n         |    ORDER BY f2\n         |    DESC LIMIT 3\n         |  )\n      ")).stripMargin();
        this.util().verifyRelPlan(query);
    }

    @Test
    public void testMultipleGroupingsWithConstantNotSupported1() {
        String query = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT f0, f2\n         |FROM\n         |  (SELECT DISTINCT f0, f1 FROM t1) t2,\n         |  LATERAL (\n         |    SELECT f2\n         |    FROM t1\n         |    WHERE f0 = 1 AND f1 = t2.f1\n         |    ORDER BY f2\n         |    DESC LIMIT 3\n         |  )\n      ")).stripMargin();
        this.util().verifyRelPlan(query);
    }

    @Test
    public void testMultipleGroupingsWithConstantNotSupported2() {
        String query = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT f0, f2\n         |FROM\n         |  (SELECT DISTINCT f0, f1 FROM t1) t2,\n         |  LATERAL (\n         |    SELECT f2\n         |    FROM t1\n         |    WHERE 1 = t2.f0 AND f1 = t2.f1\n         |    ORDER BY f2\n         |    DESC LIMIT 3\n         |  )\n      ")).stripMargin();
        this.util().verifyRelPlan(query);
    }
}

