/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.optimize.program.BatchOptimizeContext;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.apache.flink.table.planner.plan.rules.logical.ConvertToNotInOrInRule$;
import org.apache.flink.table.planner.plan.rules.logical.ConvertToNotInOrInRuleTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma\u0001\u0002\u0010 \u0001ABQa\u000e\u0001\u0005\u0002aBqa\u000f\u0001C\u0002\u0013%A\b\u0003\u0004A\u0001\u0001\u0006I!\u0010\u0005\u0006\u0003\u0002!\tA\u0011\u0005\u0006)\u0002!\tA\u0011\u0005\u00063\u0002!\tA\u0011\u0005\u00067\u0002!\tA\u0011\u0005\u0006;\u0002!\tA\u0011\u0005\u0006?\u0002!\tA\u0011\u0005\u0006C\u0002!\tA\u0011\u0005\u0006G\u0002!\tA\u0011\u0005\u0006K\u0002!\tA\u0011\u0005\u0006O\u0002!\tA\u0011\u0005\u0006S\u0002!\tA\u0011\u0005\u0006W\u0002!\tA\u0011\u0005\u0006[\u0002!\tA\u0011\u0005\u0006_\u0002!\tA\u0011\u0005\u0006c\u0002!\tA\u0011\u0005\u0006g\u0002!\tA\u0011\u0005\u0006k\u0002!\tA\u0011\u0005\u0006o\u0002!\tA\u0011\u0005\u0006s\u0002!\tA\u0011\u0005\u0006w\u0002!\tA\u0011\u0005\u0006{\u0002!\tA\u0011\u0005\u0006\u007f\u0002!\tA\u0011\u0005\u0007\u0003\u0007\u0001A\u0011\u0001\"\t\r\u0005\u001d\u0001\u0001\"\u0001C\u0011\u0019\tY\u0001\u0001C\u0001\u0005\"1\u0011q\u0002\u0001\u0005\u0002\t\u0013!dQ8om\u0016\u0014H\u000fV8O_RLen\u0014:J]J+H.\u001a+fgRT!\u0001I\u0011\u0002\u000f1|w-[2bY*\u0011!eI\u0001\u0006eVdWm\u001d\u0006\u0003I\u0015\nA\u0001\u001d7b]*\u0011aeJ\u0001\ba2\fgN\\3s\u0015\tA\u0013&A\u0003uC\ndWM\u0003\u0002+W\u0005)a\r\\5oW*\u0011A&L\u0001\u0007CB\f7\r[3\u000b\u00039\n1a\u001c:h\u0007\u0001\u0019\"\u0001A\u0019\u0011\u0005I*T\"A\u001a\u000b\u0005Q*\u0013!B;uS2\u001c\u0018B\u0001\u001c4\u00055!\u0016M\u00197f)\u0016\u001cHOQ1tK\u00061A(\u001b8jiz\"\u0012!\u000f\t\u0003u\u0001i\u0011aH\u0001\u0005kRLG.F\u0001>!\t\u0011d(\u0003\u0002@g\t\u0011\")\u0019;dQR\u000b'\r\\3UKN$X\u000b^5m\u0003\u0015)H/\u001b7!\u0003\u0015\u0019X\r^;q)\u0005\u0019\u0005C\u0001#H\u001b\u0005)%\"\u0001$\u0002\u000bM\u001c\u0017\r\\1\n\u0005!+%\u0001B+oSRD#\u0001\u0002&\u0011\u0005-\u0013V\"\u0001'\u000b\u00055s\u0015aA1qS*\u0011q\nU\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\tV&A\u0003kk:LG/\u0003\u0002T\u0019\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002KQ,7\u000f^\"p]Z,'\u000f\u001e+p\u0013:|F*Z:t)\"\fg\u000e\u00165sKNDw\u000e\u001c3`\u0013:$\bFA\u0003W!\tYu+\u0003\u0002Y\u0019\n!A+Z:u\u0003\u0015\"Xm\u001d;D_:4XM\u001d;U_&sw,R9vC2\u001cHk\u001c+ie\u0016\u001c\bn\u001c7e?&sG\u000f\u000b\u0002\u0007-\u0006AC/Z:u\u0007>tg/\u001a:u)>LenX$sK\u0006$XM\u001d+iC:$\u0006N]3tQ>dGmX%oi\"\u0012qAV\u0001)i\u0016\u001cHoQ8om\u0016\u0014H\u000fV8J]~cUm]:UQ\u0006tG\u000b\u001b:fg\"|G\u000eZ0E_V\u0014G.\u001a\u0015\u0003\u0011Y\u000b1\u0006^3ti\u000e{gN^3siR{\u0017J\\0He\u0016\fG/\u001a:UQ\u0006tG\u000b\u001b:fg\"|G\u000eZ0E_V\u0014G.\u001a\u0015\u0003\u0013Y\u000bq\u0003^3ti\u000e{gN^3siR{\u0017J\\0XSRDwJ]\u0019)\u0005)1\u0016a\u0006;fgR\u001cuN\u001c<feR$v.\u00138`/&$\bn\u0014:3Q\tYa+\u0001\ruKN$8i\u001c8wKJ$Hk\\%o?^KG\u000f[!oIFB#\u0001\u0004,\u00021Q,7\u000f^\"p]Z,'\u000f\u001e+p\u0013:|v+\u001b;i\u0003:$'\u0007\u000b\u0002\u000e-\u0006AC/Z:u\u0007>tg/\u001a:u)>tu\u000e^%o?2+7o\u001d+iC:$\u0006N]3tQ>dGmX%oi\"\u0012aBV\u0001)i\u0016\u001cHoQ8om\u0016\u0014H\u000fV8O_RLenX#rk\u0006d7\u000fV8UQJ,7\u000f[8mI~Ke\u000e\u001e\u0015\u0003\u001fY\u000b1\u0006^3ti\u000e{gN^3siR{gj\u001c;J]~;%/Z1uKJ$\u0006.\u00198UQJ,7\u000f[8mI~Ke\u000e\u001e\u0015\u0003!Y\u000b1\u0006^3ti\u000e{gN^3siR{gj\u001c;J]~cUm]:UQ\u0006tG\u000b\u001b:fg\"|G\u000eZ0E_V\u0014G.\u001a\u0015\u0003#Y\u000ba\u0006^3ti\u000e{gN^3siR{gj\u001c;J]~;%/Z1uKJ$\u0006.\u00198UQJ,7\u000f[8mI~#u.\u001e2mK\"\u0012!CV\u0001\u001bi\u0016\u001cHoQ8om\u0016\u0014H\u000fV8O_RLenX,ji\"|%/\r\u0015\u0003'Y\u000b!\u0004^3ti\u000e{gN^3siR{gj\u001c;J]~;\u0016\u000e\u001e5PeJB#\u0001\u0006,\u00025Q,7\u000f^\"p]Z,'\u000f\u001e+p\u001d>$\u0018J\\0XSRDwJ]\u001a)\u0005U1\u0016a\u0007;fgR\u001cuN\u001c<feR$vNT8u\u0013:|v+\u001b;i\u0003:$\u0017\u0007\u000b\u0002\u0017-\u0006YB/Z:u\u0007>tg/\u001a:u)>tu\u000e^%o?^KG\u000f[!oIJB#a\u0006,\u00021Q,7\u000f^\"p]Z,'\u000f\u001e+p\u0013:\fe\u000e\u001a(pi&s\u0017\u0007\u000b\u0002\u0019-\u0006AB/Z:u\u0007>tg/\u001a:u)>Le.\u00118e\u001d>$\u0018J\u001c\u001a)\u0005e1\u0016\u0001\u0007;fgR\u001cuN\u001c<feR$v.\u00138B]\u0012tu\u000e^%og!\u0012!DV\u0001\u001ai\u0016\u001cHoQ8om\u0016\u0014H\u000fV8TK\u0006\u00148\r[*ue&tw\r\u000b\u0002\u001c-\u0006\tC/Z:u\u0007>tg/\u001a:u)>\u001cV-\u0019:dQN#(/\u001b8h/&$\bNT;mY\"\u0012ADV\u0001!i\u0016\u001cHoQ8om\u0016\u0014H\u000fV8TK\u0006\u00148\r[,ji\"l\u0015\u000e_3e)f\u0004X\r\u000b\u0002\u001e-\u0002")
public class ConvertToNotInOrInRuleTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        FlinkChainedProgram programs = new FlinkChainedProgram();
        programs.addLast("rules", (FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_SEQUENCE()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{ConvertToNotInOrInRule$.MODULE$.INSTANCE()})).build());
        this.util().replaceBatchProgram((FlinkChainedProgram<BatchOptimizeContext>)programs);
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))}), new CaseClassTypeInfo<Tuple5<Object, Object, Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple5<Object, Object, Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple5<Object, Object, Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple5<Object, Object, Object, Object, String>>(this, fieldSerializers){

                    public Tuple5<Object, Object, Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple5((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToFloat((Object)fields[2])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[3])), (Object)((String)fields[4]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.rules.logical.ConvertToNotInOrInRuleTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testConvertToIn_LessThanThreshold_Int() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a = 1 OR a = 2 OR a = 3");
    }

    @Test
    public void testConvertToIn_EqualsToThreshold_Int() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a = 1 OR a = 2 OR a = 3 OR a = 4");
    }

    @Test
    public void testConvertToIn_GreaterThanThreshold_Int() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a = 1 OR a = 2 OR a = 3 OR a = 4 OR a = 5");
    }

    @Test
    public void testConvertToIn_LessThanThreshold_Double() {
        String where = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 20).map((Function1 & Serializable & scala.Serializable)i -> ConvertToNotInOrInRuleTest.$anonfun$testConvertToIn_LessThanThreshold_Double$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(" OR ");
        this.util().verifyRelPlan(new StringBuilder(28).append("SELECT * FROM MyTable WHERE ").append(where).toString());
    }

    @Test
    public void testConvertToIn_GreaterThanThreshold_Double() {
        String where = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 21).map((Function1 & Serializable & scala.Serializable)i -> ConvertToNotInOrInRuleTest.$anonfun$testConvertToIn_GreaterThanThreshold_Double$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(" OR ");
        this.util().verifyRelPlan(new StringBuilder(28).append("SELECT * FROM MyTable WHERE ").append(where).toString());
    }

    @Test
    public void testConvertToIn_WithOr1() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a = 1 OR a = 2 OR a = 3 OR a = 4 OR b = 1");
    }

    @Test
    public void testConvertToIn_WithOr2() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a = 1 OR a = 2 OR b = 1 OR a = 3 OR a = 4");
    }

    @Test
    public void testConvertToIn_WithAnd1() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE (a = 1 OR a = 2 OR a = 3 OR a = 4) AND b = 1");
    }

    @Test
    public void testConvertToIn_WithAnd2() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a = 1 OR a = 2 OR a = 3 OR a = 4 AND b = 1");
    }

    @Test
    public void testConvertToNotIn_LessThanThreshold_Int() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a <> 1 AND a <> 2 AND a <> 3");
    }

    @Test
    public void testConvertToNotIn_EqualsToThreshold_Int() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a <> 1 AND a <> 2 AND a <> 3 AND a <> 4");
    }

    @Test
    public void testConvertToNotIn_GreaterThanThreshold_Int() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a <> 1 AND a <> 2 AND a <> 3 AND a <> 4 AND a = 5");
    }

    @Test
    public void testConvertToNotIn_LessThanThreshold_Double() {
        String where = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 20).map((Function1 & Serializable & scala.Serializable)i -> ConvertToNotInOrInRuleTest.$anonfun$testConvertToNotIn_LessThanThreshold_Double$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(" AND ");
        this.util().verifyRelPlan(new StringBuilder(28).append("SELECT * FROM MyTable WHERE ").append(where).toString());
    }

    @Test
    public void testConvertToNotIn_GreaterThanThreshold_Double() {
        String where = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 21).map((Function1 & Serializable & scala.Serializable)i -> ConvertToNotInOrInRuleTest.$anonfun$testConvertToNotIn_GreaterThanThreshold_Double$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(" AND ");
        this.util().verifyRelPlan(new StringBuilder(28).append("SELECT * FROM MyTable WHERE ").append(where).toString());
    }

    @Test
    public void testConvertToNotIn_WithOr1() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE (a <> 1 AND a <> 2 AND a <> 3 AND a <> 4) OR b = 1");
    }

    @Test
    public void testConvertToNotIn_WithOr2() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a <> 1 AND a <> 2 AND a <> 3 AND a <> 4 OR b = 1");
    }

    @Test
    public void testConvertToNotIn_WithOr3() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a <> 1 OR a <> 2 OR a <> 3 OR a <> 4 OR b = 1");
    }

    @Test
    public void testConvertToNotIn_WithAnd1() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a <> 1 AND a <> 2 AND a <> 3 AND a <> 4 AND b = 1");
    }

    @Test
    public void testConvertToNotIn_WithAnd2() {
        String sqlQuery = "SELECT * FROM MyTable WHERE a <> 1 AND a <> 2  AND b = 1 AND a <> 3 AND a <> 4";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testConvertToInAndNotIn1() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a = 1 OR a = 2 OR a = 3 OR a = 4 OR b = 1 OR (a <> 1 AND a <> 2 AND a <> 3 AND a <> 4)");
    }

    @Test
    public void testConvertToInAndNotIn2() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE b = 1 OR a = 1 OR a = 2 OR a = 3 OR a = 4  AND (a <> 1 AND a <> 2 AND a <> 3 AND a <> 4)");
    }

    @Test
    public void testConvertToInAndNotIn3() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE b = 1 OR b = 2 OR (a <> 1 AND a <> 2 AND a <> 3 AND a <> 4 AND c = 1) OR b = 3 OR b = 4 OR c = 1");
    }

    @Test
    public void testConvertToSearchString() {
        this.util().verifyRelPlan(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * from MyTable where e in (\n        |'CTNBSmokeSensor',\n        |'H388N',\n        |'H389N     ',\n        |'GHL-IRD',\n        |'JY-BF-20YN',\n        |'HC809',\n        |'DH-9908N-AEP',\n        |'DH-9908N'\n        |)\n        |")).stripMargin());
    }

    @Test
    public void testConvertToSearchStringWithNull() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE e = 'a' or e = 'b' or e = 'c' or e = 'd' or e = 'e' or e = 'f' or e = NULL or e = 'HELLO WORLD!'");
    }

    @Test
    public void testConvertToSearchWithMixedType() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a is null or a = 1 OR a = 2 OR a = 3.0 OR a = 4.0 OR a = 5 OR a = 7 OR a = CAST(8 AS BIGINT)");
    }

    public static final /* synthetic */ String $anonfun$testConvertToIn_LessThanThreshold_Double$1(int i) {
        return new StringBuilder(4).append("d = ").append(i).toString();
    }

    public static final /* synthetic */ String $anonfun$testConvertToIn_GreaterThanThreshold_Double$1(int i) {
        return new StringBuilder(4).append("d = ").append(i).toString();
    }

    public static final /* synthetic */ String $anonfun$testConvertToNotIn_LessThanThreshold_Double$1(int i) {
        return new StringBuilder(5).append("d <> ").append(i).toString();
    }

    public static final /* synthetic */ String $anonfun$testConvertToNotIn_GreaterThanThreshold_Double$1(int i) {
        return new StringBuilder(5).append("d <> ").append(i).toString();
    }
}

