/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.optimize.program;

import java.util.Collections;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepProgram$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkRuleSetProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkVolcanoProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkVolcanoProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Option;
import scala.collection.JavaConversions$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Y2A!\u0002\u0004\u0001/!)a\u0004\u0001C\u0001?!)!\u0005\u0001C\u0001G!)!\u0007\u0001C\u0001G!)A\u0007\u0001C\u0001G\t9b\t\\5oW\u000eC\u0017-\u001b8fIB\u0013xn\u001a:b[R+7\u000f\u001e\u0006\u0003\u000f!\tq\u0001\u001d:pOJ\fWN\u0003\u0002\n\u0015\u0005Aq\u000e\u001d;j[&TXM\u0003\u0002\f\u0019\u0005!\u0001\u000f\\1o\u0015\tia\"A\u0004qY\u0006tg.\u001a:\u000b\u0005=\u0001\u0012!\u0002;bE2,'BA\t\u0013\u0003\u00151G.\u001b8l\u0015\t\u0019B#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002+\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0007\t\u00033qi\u0011A\u0007\u0006\u00027\u0005)1oY1mC&\u0011QD\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\u0001\u0003CA\u0011\u0001\u001b\u00051\u0011\u0001\u0007;fgR\fE\rZ$fiJ+Wn\u001c<f!J|wM]1ngR\tA\u0005\u0005\u0002\u001aK%\u0011aE\u0007\u0002\u0005+:LG\u000f\u000b\u0002\u0003QA\u0011\u0011\u0006M\u0007\u0002U)\u00111\u0006L\u0001\u0004CBL'BA\u0017/\u0003\u001dQW\u000f]5uKJT!a\f\u000b\u0002\u000b),h.\u001b;\n\u0005ER#\u0001\u0002+fgR\f!\u0004^3ti\u001e+GO\u00127j].\u0014V\u000f\\3TKR\u0004&o\\4sC6D#a\u0001\u0015\u0002%Q,7\u000f^!eI:+H\u000e\u001c)s_\u001e\u0014\u0018-\u001c\u0015\u0003\t!\u0002")
public class FlinkChainedProgramTest {
    @Test
    public void testAddGetRemovePrograms() {
        FlinkChainedProgram programs = new FlinkChainedProgram();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)programs.getProgramNames().isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)programs.get("o1").isEmpty());
        HepProgramBuilder builder = new HepProgramBuilder();
        builder.addMatchLimit(10).addMatchOrder(HepMatchOrder.ARBITRARY).addRuleInstance((RelOptRule)CoreRules.FILTER_SUB_QUERY_TO_CORRELATE).addRuleInstance((RelOptRule)CoreRules.PROJECT_SUB_QUERY_TO_CORRELATE).addRuleInstance((RelOptRule)CoreRules.JOIN_SUB_QUERY_TO_CORRELATE).addMatchLimit(100).addMatchOrder(HepMatchOrder.BOTTOM_UP).addRuleCollection(Collections.singletonList(CoreRules.FILTER_VALUES_MERGE));
        FlinkHepProgram program1 = FlinkHepProgram$.MODULE$.apply(builder.build(), FlinkHepProgram$.MODULE$.apply$default$2());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)programs.addFirst("o2", (FlinkOptimizeProgram)program1));
        org.junit.jupiter.api.Assertions.assertEquals((Object)new .colon.colon((Object)"o2", (List)Nil$.MODULE$), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(programs.getProgramNames()).toList());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)programs.get("o2").isDefined());
        org.junit.jupiter.api.Assertions.assertTrue((program1 == programs.get("o2").get() ? 1 : 0) != 0);
        FlinkHepRuleSetProgram program2 = FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{CoreRules.FILTER_REDUCE_EXPRESSIONS, CoreRules.PROJECT_REDUCE_EXPRESSIONS, CoreRules.CALC_REDUCE_EXPRESSIONS, CoreRules.JOIN_REDUCE_EXPRESSIONS})).build();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)programs.addFirst("o1", (FlinkOptimizeProgram)program2));
        org.junit.jupiter.api.Assertions.assertEquals((Object)new .colon.colon((Object)"o1", (List)new .colon.colon((Object)"o2", (List)Nil$.MODULE$)), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(programs.getProgramNames()).toList());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)programs.get("o1").isDefined());
        org.junit.jupiter.api.Assertions.assertTrue((program2 == programs.get("o1").get() ? 1 : 0) != 0);
        FlinkHepRuleSetProgram program3 = FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{CoreRules.FILTER_CALC_MERGE, CoreRules.PROJECT_CALC_MERGE, CoreRules.FILTER_TO_CALC, CoreRules.PROJECT_TO_CALC, CoreRules.CALC_MERGE})).setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_COLLECTION()).setMatchLimit(10000).setHepMatchOrder(HepMatchOrder.ARBITRARY).build();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)programs.addLast("o4", (FlinkOptimizeProgram)program3));
        org.junit.jupiter.api.Assertions.assertEquals((Object)new .colon.colon((Object)"o1", (List)new .colon.colon((Object)"o2", (List)new .colon.colon((Object)"o4", (List)Nil$.MODULE$))), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(programs.getProgramNames()).toList());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)programs.get("o4").isDefined());
        org.junit.jupiter.api.Assertions.assertTrue((program3 == programs.get("o4").get() ? 1 : 0) != 0);
        Convention.Impl TEST = new Convention.Impl("TEST", RelNode.class);
        FlinkVolcanoProgram program4 = FlinkVolcanoProgramBuilder$.MODULE$.newBuilder().add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{CoreRules.FILTER_INTO_JOIN, CoreRules.JOIN_CONDITION_PUSH})).setRequiredOutputTraits((RelTrait[])((Object[])new RelTrait[]{TEST})).build();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)programs.addBefore("o4", "o3", (FlinkOptimizeProgram)program4));
        org.junit.jupiter.api.Assertions.assertEquals((Object)new .colon.colon((Object)"o1", (List)new .colon.colon((Object)"o2", (List)new .colon.colon((Object)"o3", (List)new .colon.colon((Object)"o4", (List)Nil$.MODULE$)))), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(programs.getProgramNames()).toList());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)programs.get("o3").isDefined());
        org.junit.jupiter.api.Assertions.assertTrue((program4 == programs.get("o3").get() ? 1 : 0) != 0);
        Option p2 = programs.remove("o2");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)p2.isDefined());
        org.junit.jupiter.api.Assertions.assertTrue((p2.get() == program1 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)new .colon.colon((Object)"o1", (List)new .colon.colon((Object)"o3", (List)new .colon.colon((Object)"o4", (List)Nil$.MODULE$))), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(programs.getProgramNames()).toList());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)programs.remove("o0").isEmpty());
        org.junit.jupiter.api.Assertions.assertEquals((Object)new .colon.colon((Object)"o1", (List)new .colon.colon((Object)"o3", (List)new .colon.colon((Object)"o4", (List)Nil$.MODULE$))), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(programs.getProgramNames()).toList());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)programs.addFirst("o3", (FlinkOptimizeProgram)program1));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)programs.addLast("o4", (FlinkOptimizeProgram)program1));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)programs.addBefore("o0", "o4", (FlinkOptimizeProgram)program1));
        org.junit.jupiter.api.Assertions.assertEquals((Object)new .colon.colon((Object)"o1", (List)new .colon.colon((Object)"o3", (List)new .colon.colon((Object)"o4", (List)Nil$.MODULE$))), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(programs.getProgramNames()).toList());
    }

    @Test
    public void testGetFlinkRuleSetProgram() {
        FlinkChainedProgram programs = new FlinkChainedProgram();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)programs.getProgramNames().isEmpty());
        FlinkHepRuleSetProgram program1 = FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{CoreRules.FILTER_REDUCE_EXPRESSIONS})).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).build();
        programs.addFirst("o1", (FlinkOptimizeProgram)program1);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)programs.get("o1").isDefined());
        org.junit.jupiter.api.Assertions.assertTrue((program1 == programs.get("o1").get() ? 1 : 0) != 0);
        HepProgramBuilder builder = new HepProgramBuilder();
        builder.addMatchLimit(10).addRuleInstance((RelOptRule)CoreRules.FILTER_SUB_QUERY_TO_CORRELATE).addRuleInstance((RelOptRule)CoreRules.JOIN_SUB_QUERY_TO_CORRELATE).addMatchOrder(HepMatchOrder.BOTTOM_UP);
        FlinkHepProgram program2 = FlinkHepProgram$.MODULE$.apply(builder.build(), FlinkHepProgram$.MODULE$.apply$default$2());
        programs.addLast("o2", (FlinkOptimizeProgram)program2);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)programs.get("o2").isDefined());
        org.junit.jupiter.api.Assertions.assertTrue((program2 == programs.get("o2").get() ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)programs.getFlinkRuleSetProgram("o2").isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)programs.getFlinkRuleSetProgram("o3").isEmpty());
        Option p1 = programs.getFlinkRuleSetProgram("o1");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)p1.isDefined());
        ((FlinkRuleSetProgram)p1.get()).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{CoreRules.PROJECT_SUB_QUERY_TO_CORRELATE}));
        org.junit.jupiter.api.Assertions.assertTrue((p1.get() == programs.getFlinkRuleSetProgram("o1").get() ? 1 : 0) != 0);
    }

    @Test
    public void testAddNullProgram() {
        FlinkChainedProgram programs = new FlinkChainedProgram();
        Assertions.assertThatThrownBy(() -> programs.addLast("o1", null)).isInstanceOf(NullPointerException.class);
    }
}

