/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.optimize;

import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.api.common.BatchShuffleMode;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.planner.factories.TestValuesCatalog;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameter;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
class ShuffleModePlanOptimizeTest
extends TableTestBase {
    @Parameter
    public BatchShuffleMode mode;
    private final BatchTableTestUtil util = this.batchTestUtil(TableConfig.getDefault());
    private final TestValuesCatalog catalog = new TestValuesCatalog("testCatalog", "test_database", true);

    ShuffleModePlanOptimizeTest() {
    }

    @Parameters(name="mode = {0}")
    public static Collection<BatchShuffleMode> parameters() {
        return Arrays.asList(BatchShuffleMode.ALL_EXCHANGES_BLOCKING, BatchShuffleMode.ALL_EXCHANGES_HYBRID_SELECTIVE, BatchShuffleMode.ALL_EXCHANGES_HYBRID_FULL);
    }

    @BeforeEach
    void setup() {
        this.catalog.open();
        this.util.tableEnv().registerCatalog("testCatalog", (Catalog)this.catalog);
        this.util.tableEnv().useCatalog("testCatalog");
        TableConfig tableConfig = this.util.tableEnv().getConfig();
        tableConfig.set(OptimizerConfigOptions.TABLE_OPTIMIZER_DYNAMIC_FILTERING_ENABLED, (Object)true);
        if (this.mode != null) {
            tableConfig.set(ExecutionOptions.BATCH_SHUFFLE_MODE, (Object)this.mode);
        }
        this.util.tableEnv().executeSql("CREATE TABLE fact_part (\n  id BIGINT,\n  name STRING,\n  amount BIGINT,\n  price BIGINT,\n  fact_date_sk BIGINT\n) PARTITIONED BY (fact_date_sk)\nWITH (\n 'connector' = 'values',\n 'runtime-source' = 'NewSource',\n 'partition-list' = 'fact_date_sk:1990;fact_date_sk:1991;fact_date_sk:1992',\n 'dynamic-filtering-fields' = 'fact_date_sk;amount',\n 'bounded' = 'true'\n)");
        this.util.tableEnv().executeSql("CREATE TABLE dim (\n  id BIGINT,\n  male BOOLEAN,\n  amount BIGINT,\n  price BIGINT,\n  dim_date_sk BIGINT\n) WITH (\n 'connector' = 'values',\n 'runtime-source' = 'NewSource',\n 'bounded' = 'true'\n)");
    }

    @TestTemplate
    void testMultipleInputWithDPP() {
        String query = "SELECT * FROM (Select count(*) c1 from fact_part, dim where fact_part.fact_date_sk = dim_date_sk and fact_part.price < 100) s1, (Select count(*) c2 from fact_part, dim where fact_part.fact_date_sk = dim_date_sk and dim.price < 200) s2, (Select count(*) c3 from fact_part, dim where fact_part.fact_date_sk = dim_date_sk and dim.price < 400) s3";
        this.util.verifyExecPlan(query);
    }

    @TestTemplate
    void testMultipleInputWithoutDPP() {
        String query = "SELECT * FROM (Select count(*) c1 from fact_part, dim where fact_part.fact_date_sk = dim_date_sk and fact_part.price < 100) s1, (Select count(*) c2 from fact_part, dim where fact_part.fact_date_sk = dim_date_sk and fact_part.price < 200) s2, (Select count(*) c3 from fact_part, dim where fact_part.fact_date_sk = dim_date_sk and fact_part.price < 400) s3";
        this.util.verifyExecPlan(query);
    }
}

