/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.testutils;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.shaded.guava32.com.google.common.reflect.ClassPath;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecPythonCalc;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecPythonCorrelate;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecPythonGroupAggregate;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecPythonGroupTableAggregate;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecPythonGroupWindowAggregate;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecPythonOverAggregate;
import org.apache.flink.table.planner.plan.nodes.exec.testutils.RestoreTestBase;
import org.apache.flink.table.planner.plan.utils.ExecNodeMetadataUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RestoreTestCompleteness {
    private static final Set<Class<? extends ExecNode<?>>> SKIP_EXEC_NODES = new HashSet<Class<? extends ExecNode<?>>>(){
        {
            this.add(StreamExecPythonCalc.class);
            this.add(StreamExecPythonCorrelate.class);
            this.add(StreamExecPythonOverAggregate.class);
            this.add(StreamExecPythonGroupAggregate.class);
            this.add(StreamExecPythonGroupTableAggregate.class);
            this.add(StreamExecPythonGroupWindowAggregate.class);
        }
    };

    private Class<? extends ExecNode<?>> getExecNode(Class<?> restoreTest) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Method getExecNodeMethod = restoreTest.getMethod("getExecNode", new Class[0]);
        Class execNode = (Class)getExecNodeMethod.invoke(restoreTest.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), new Object[0]);
        return execNode;
    }

    private List<Class<? extends ExecNode<?>>> getChildExecNodes(Class<?> restoreTest) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Method getChildExecNodesMethod = restoreTest.getMethod("getChildExecNodes", new Class[0]);
        List childExecNodes = (List)getChildExecNodesMethod.invoke(restoreTest.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), new Object[0]);
        return childExecNodes;
    }

    @Test
    public void testMissingRestoreTest() throws IOException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class execNode;
        Map versionedExecNodes = ExecNodeMetadataUtil.getVersionedExecNodes();
        Set classesInPackage = ClassPath.from((ClassLoader)this.getClass().getClassLoader()).getTopLevelClassesRecursive("org.apache.flink.table.planner.plan.nodes.exec.stream").stream().filter(x -> RestoreTestBase.class.isAssignableFrom(x.load())).collect(Collectors.toSet());
        HashSet execNodesWithRestoreTests = new HashSet();
        for (ClassPath.ClassInfo classInfo : classesInPackage) {
            Class restoreTest = classInfo.load();
            execNode = this.getExecNode(restoreTest);
            execNodesWithRestoreTests.add(execNode);
            List<Class<ExecNode<?>>> childExecNodes = this.getChildExecNodes(restoreTest);
            for (Class<? extends ExecNode<?>> clazz : childExecNodes) {
                execNodesWithRestoreTests.add(clazz);
            }
        }
        for (Map.Entry entry : versionedExecNodes.entrySet()) {
            ExecNodeMetadataUtil.ExecNodeNameVersion execNodeNameVersion = (ExecNodeMetadataUtil.ExecNodeNameVersion)entry.getKey();
            execNode = (Class)entry.getValue();
            if (SKIP_EXEC_NODES.contains(execNode)) continue;
            String msg = "Missing restore test for " + execNodeNameVersion + "\nPlease add a restore test for " + execNode.toString();
            Assertions.assertTrue((boolean)execNodesWithRestoreTests.contains(execNode), (String)msg);
        }
    }
}

