/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.test.program.SinkTestStep;
import org.apache.flink.table.test.program.SourceTestStep;
import org.apache.flink.table.test.program.TableTestProgram;
import org.apache.flink.types.Row;

public class TemporalJoinTestPrograms {
    static final SourceTestStep ORDERS = ((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"Orders").addSchema(new String[]{"amount bigint", "currency STRING", "order_time STRING", "rowtime as TO_TIMESTAMP(order_time) ", "WATERMARK FOR rowtime AS rowtime"})).producedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{2L, "Euro", "2020-10-10 00:00:42"}), Row.of((Object[])new Object[]{1L, "USD", "2020-10-10 00:00:43"}), Row.of((Object[])new Object[]{50L, "Yen", "2020-10-10 00:00:44"}), Row.of((Object[])new Object[]{3L, "Euro", "2020-10-10 00:00:45"})}).producedAfterRestore(new Row[]{Row.of((Object[])new Object[]{1L, "Euro", "2020-10-10 00:00:58"}), Row.of((Object[])new Object[]{1L, "USD", "2020-10-10 00:00:58"})}).build();
    static final SourceTestStep ORDERS_WITH_NESTED_ID = ((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"OrdersNestedId").addSchema(new String[]{"amount bigint", "nested_row ROW<currency STRING>", "nested_map MAP<STRING NOT NULL, STRING>", "order_time STRING", "rowtime as TO_TIMESTAMP(order_time) ", "WATERMARK FOR rowtime AS rowtime"})).producedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{2L, Row.of((Object[])new Object[]{"Euro"}), TemporalJoinTestPrograms.mapOf("currency", "Euro"), "2020-10-10 00:00:42"}), Row.of((Object[])new Object[]{1L, Row.of((Object[])new Object[]{"usd"}), TemporalJoinTestPrograms.mapOf("currency", "USD"), "2020-10-10 00:00:43"}), Row.of((Object[])new Object[]{50L, Row.of((Object[])new Object[]{"Yen"}), TemporalJoinTestPrograms.mapOf("currency", "Yen"), "2020-10-10 00:00:44"}), Row.of((Object[])new Object[]{3L, Row.of((Object[])new Object[]{"Euro"}), TemporalJoinTestPrograms.mapOf("currency", "Euro"), "2020-10-10 00:00:45"})}).producedAfterRestore(new Row[]{Row.of((Object[])new Object[]{1L, Row.of((Object[])new Object[]{"Euro"}), TemporalJoinTestPrograms.mapOf("currency", "Euro"), "2020-10-10 00:00:58"}), Row.of((Object[])new Object[]{1L, Row.of((Object[])new Object[]{"usd"}), TemporalJoinTestPrograms.mapOf("currency", "USD"), "2020-10-10 00:00:58"})}).build();
    static final SourceTestStep RATES = ((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"RatesHistory").addSchema(new String[]{"currency STRING", "rate bigint", "rate_time STRING", "rowtime as TO_TIMESTAMP(rate_time) ", "WATERMARK FOR rowtime AS rowtime", "PRIMARY KEY(currency) NOT ENFORCED"})).producedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{"USD", 102L, "2020-10-10 00:00:41"}), Row.of((Object[])new Object[]{"Euro", 114L, "2020-10-10 00:00:41"}), Row.of((Object[])new Object[]{"Yen", 1L, "2020-10-10 00:00:41"}), Row.of((Object[])new Object[]{"Euro", 116L, "2020-10-10 00:00:45"}), Row.of((Object[])new Object[]{"Euro", 119L, "2020-10-10 00:00:47"})}).producedAfterRestore(new Row[]{Row.of((Object[])new Object[]{"USD", 103L, "2020-10-10 00:00:58"}), Row.of((Object[])new Object[]{"Euro", 120L, "2020-10-10 00:00:59"})}).build();
    static final SinkTestStep AMOUNTS = ((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"MySink").addSchema(new String[]{"amount bigint"})).consumedBeforeRestore(new String[]{"+I[102]", "+I[228]", "+I[348]", "+I[50]"}).consumedAfterRestore(new String[]{"+I[103]", "+I[119]"}).build();
    static final TableTestProgram TEMPORAL_JOIN_TABLE_JOIN = TableTestProgram.of((String)"temporal-join-table-join", (String)"validates temporal join with a table").setupTableSource(ORDERS).setupTableSource(RATES).setupTableSink(AMOUNTS).runSql("INSERT INTO MySink SELECT amount * r.rate FROM Orders AS o JOIN RatesHistory FOR SYSTEM_TIME AS OF o.rowtime AS r ON o.currency = r.currency ").build();
    static final TableTestProgram TEMPORAL_JOIN_TABLE_JOIN_NESTED_KEY = TableTestProgram.of((String)"temporal-join-table-join-nested-key", (String)"validates temporal join with a table when the join keys comes from a nested row").setupTableSource(ORDERS_WITH_NESTED_ID).setupTableSource(RATES).setupTableSink(AMOUNTS).runSql("INSERT INTO MySink SELECT amount * r.rate FROM OrdersNestedId AS o JOIN RatesHistory FOR SYSTEM_TIME AS OF o.rowtime AS r ON (case when o.nested_row.currency = 'usd' then upper(o.nested_row.currency) ELSE o.nested_row.currency END) = r.currency ").build();
    static final TableTestProgram TEMPORAL_JOIN_TABLE_JOIN_KEY_FROM_MAP = TableTestProgram.of((String)"temporal-join-table-join-key-from-map", (String)"validates temporal join with a table when the join key comes from a map value").setupTableSource(ORDERS_WITH_NESTED_ID).setupTableSource(RATES).setupTableSink(AMOUNTS).runSql("INSERT INTO MySink SELECT amount * r.rate FROM OrdersNestedId AS o JOIN RatesHistory FOR SYSTEM_TIME AS OF o.rowtime AS r ON o.nested_map['currency'] = r.currency ").build();
    static final TableTestProgram TEMPORAL_JOIN_TEMPORAL_FUNCTION = TableTestProgram.of((String)"temporal-join-temporal-function", (String)"validates temporal join with a temporal function").setupTableSource(ORDERS).setupTableSource(RATES).setupTemporarySystemTemporalTableFunction("Rates", "RatesHistory", (Expression)Expressions.$((String)"rowtime"), (Expression)Expressions.$((String)"currency")).setupTableSink(AMOUNTS).runSql("INSERT INTO MySink SELECT amount * r.rate FROM Orders AS o,  LATERAL TABLE (Rates(o.rowtime)) AS r WHERE o.currency = r.currency ").build();

    private static Map<String, String> mapOf(String key, String value) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(key, value);
        return map;
    }
}

