/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LocalDateTimeSerializer;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.api.dataview.ListView;
import org.apache.flink.table.api.dataview.MapView;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.planner.plan.nodes.exec.serde.DataTypeJsonSerdeTest;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeTestUtil;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.apache.flink.table.planner.typeutils.DataViewUtils;
import org.apache.flink.table.runtime.typeutils.ExternalSerializer;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DayTimeIntervalType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.NullType;
import org.apache.flink.table.types.logical.RawType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.logical.SymbolType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.YearMonthIntervalType;
import org.apache.flink.table.types.logical.ZonedTimestampType;
import org.apache.flink.table.types.utils.DataTypeFactoryMock;
import org.apache.flink.table.utils.CatalogManagerMocks;
import org.apache.flink.types.Row;
import org.apache.flink.util.jackson.JacksonMapperFactory;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@Execution(value=ExecutionMode.CONCURRENT)
public class LogicalTypeJsonSerdeTest {
    private static final StructuredType STRUCTURED_TYPE = StructuredType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)CatalogManagerMocks.DEFAULT_CATALOG, (String)CatalogManagerMocks.DEFAULT_DATABASE, (String)"MyType")).description("My original type.").build();
    private static final StructuredType UPDATED_STRUCTURED_TYPE = StructuredType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)CatalogManagerMocks.DEFAULT_CATALOG, (String)CatalogManagerMocks.DEFAULT_DATABASE, (String)"MyType")).description("My original type with update description.").build();

    @ParameterizedTest
    @MethodSource(value={"testLogicalTypeSerde"})
    public void testLogicalTypeSerde(LogicalType logicalType) throws IOException {
        SerdeContext serdeContext = JsonSerdeTestUtil.configuredSerdeContext();
        String json = JsonSerdeTestUtil.toJson(serdeContext, logicalType);
        LogicalType actual = JsonSerdeTestUtil.toObject(serdeContext, json, LogicalType.class);
        Assertions.assertThat((Object)actual).isEqualTo((Object)logicalType);
    }

    @Test
    public void testIdentifierSerde() throws IOException {
        DataTypeFactoryMock dataTypeFactoryMock = new DataTypeFactoryMock();
        TableConfig tableConfig = TableConfig.getDefault();
        CatalogManager catalogManager = CatalogManagerMocks.preparedCatalogManager().dataTypeFactory((DataTypeFactory)dataTypeFactoryMock).build();
        SerdeContext serdeContext = JsonSerdeTestUtil.configuredSerdeContext(catalogManager, tableConfig);
        tableConfig.set(TableConfigOptions.PLAN_COMPILE_CATALOG_OBJECTS, (Object)TableConfigOptions.CatalogPlanCompilation.IDENTIFIER);
        String minimalJson = JsonSerdeTestUtil.toJson(serdeContext, STRUCTURED_TYPE);
        Assertions.assertThat((String)minimalJson).isEqualTo("\"`default_catalog`.`default_database`.`MyType`\"");
        tableConfig.set(TableConfigOptions.PLAN_RESTORE_CATALOG_OBJECTS, (Object)TableConfigOptions.CatalogPlanRestore.IDENTIFIER);
        dataTypeFactoryMock.logicalType = Optional.empty();
        Assertions.assertThatThrownBy(() -> JsonSerdeTestUtil.toObject(serdeContext, minimalJson, LogicalType.class)).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(ValidationException.class, (String)"No type found.")});
        tableConfig.set(TableConfigOptions.PLAN_RESTORE_CATALOG_OBJECTS, (Object)TableConfigOptions.CatalogPlanRestore.IDENTIFIER);
        dataTypeFactoryMock.logicalType = Optional.of(STRUCTURED_TYPE);
        Assertions.assertThat((Object)JsonSerdeTestUtil.toObject(serdeContext, minimalJson, LogicalType.class)).isEqualTo((Object)STRUCTURED_TYPE);
        tableConfig.set(TableConfigOptions.PLAN_COMPILE_CATALOG_OBJECTS, (Object)TableConfigOptions.CatalogPlanCompilation.ALL);
        String maximumJson = JsonSerdeTestUtil.toJson(serdeContext, STRUCTURED_TYPE);
        JsonNode maximumJsonNode = JacksonMapperFactory.createObjectMapper().readTree(maximumJson);
        Assertions.assertThat((Iterable)maximumJsonNode.get("attributes")).isNotNull();
        Assertions.assertThat((String)maximumJsonNode.get("description").asText()).isEqualTo("My original type.");
        tableConfig.set(TableConfigOptions.PLAN_RESTORE_CATALOG_OBJECTS, (Object)TableConfigOptions.CatalogPlanRestore.IDENTIFIER);
        dataTypeFactoryMock.logicalType = Optional.empty();
        Assertions.assertThatThrownBy(() -> JsonSerdeTestUtil.toObject(serdeContext, maximumJson, LogicalType.class)).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(ValidationException.class, (String)"No type found.")});
        tableConfig.set(TableConfigOptions.PLAN_RESTORE_CATALOG_OBJECTS, (Object)TableConfigOptions.CatalogPlanRestore.IDENTIFIER);
        dataTypeFactoryMock.logicalType = Optional.of(UPDATED_STRUCTURED_TYPE);
        Assertions.assertThat((Object)JsonSerdeTestUtil.toObject(serdeContext, maximumJson, LogicalType.class)).isEqualTo((Object)UPDATED_STRUCTURED_TYPE);
        tableConfig.set(TableConfigOptions.PLAN_RESTORE_CATALOG_OBJECTS, (Object)TableConfigOptions.CatalogPlanRestore.ALL);
        dataTypeFactoryMock.logicalType = Optional.of(UPDATED_STRUCTURED_TYPE);
        Assertions.assertThat((Object)JsonSerdeTestUtil.toObject(serdeContext, maximumJson, LogicalType.class)).isEqualTo((Object)STRUCTURED_TYPE);
    }

    private static List<LogicalType> testLogicalTypeSerde() {
        List<LogicalType> types = Arrays.asList(new BooleanType(), new TinyIntType(), new SmallIntType(), new IntType(), new BigIntType(), new FloatType(), new DoubleType(), new DecimalType(10), new DecimalType(15, 5), CharType.ofEmptyLiteral(), new CharType(), new CharType(5), VarCharType.ofEmptyLiteral(), new VarCharType(), new VarCharType(5), BinaryType.ofEmptyLiteral(), new BinaryType(), new BinaryType(100), VarBinaryType.ofEmptyLiteral(), new VarBinaryType(), new VarBinaryType(100), new DateType(), new TimeType(), new TimeType(3), new TimestampType(), new TimestampType(3), new LocalZonedTimestampType(false, TimestampKind.PROCTIME, 3), new TimestampType(false, TimestampKind.ROWTIME, 3), new ZonedTimestampType(), new ZonedTimestampType(3), new ZonedTimestampType(false, TimestampKind.ROWTIME, 3), new LocalZonedTimestampType(), new LocalZonedTimestampType(3), new LocalZonedTimestampType(false, TimestampKind.PROCTIME, 3), new LocalZonedTimestampType(false, TimestampKind.ROWTIME, 3), new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.DAY_TO_HOUR), new DayTimeIntervalType(false, DayTimeIntervalType.DayTimeResolution.DAY_TO_HOUR, 3, 6), new YearMonthIntervalType(YearMonthIntervalType.YearMonthResolution.YEAR_TO_MONTH), new YearMonthIntervalType(false, YearMonthIntervalType.YearMonthResolution.MONTH, 2), new ZonedTimestampType(), new LocalZonedTimestampType(), new LocalZonedTimestampType(false, TimestampKind.PROCTIME, 3), new SymbolType(), new ArrayType((LogicalType)new IntType(false)), new ArrayType((LogicalType)new LocalZonedTimestampType(false, TimestampKind.ROWTIME, 3)), new ArrayType((LogicalType)new ZonedTimestampType(false, TimestampKind.ROWTIME, 3)), new ArrayType((LogicalType)new TimestampType()), new ArrayType((LogicalType)CharType.ofEmptyLiteral()), new ArrayType((LogicalType)VarCharType.ofEmptyLiteral()), new ArrayType((LogicalType)BinaryType.ofEmptyLiteral()), new ArrayType((LogicalType)VarBinaryType.ofEmptyLiteral()), new MapType((LogicalType)new BigIntType(), (LogicalType)new IntType(false)), new MapType((LogicalType)new TimestampType(false, TimestampKind.ROWTIME, 3), (LogicalType)new ZonedTimestampType()), new MapType((LogicalType)CharType.ofEmptyLiteral(), (LogicalType)CharType.ofEmptyLiteral()), new MapType((LogicalType)VarCharType.ofEmptyLiteral(), (LogicalType)VarCharType.ofEmptyLiteral()), new MapType((LogicalType)BinaryType.ofEmptyLiteral(), (LogicalType)BinaryType.ofEmptyLiteral()), new MapType((LogicalType)VarBinaryType.ofEmptyLiteral(), (LogicalType)VarBinaryType.ofEmptyLiteral()), new MultisetType((LogicalType)new IntType(false)), new MultisetType((LogicalType)new TimestampType()), new MultisetType((LogicalType)new TimestampType(true, TimestampKind.ROWTIME, 3)), new MultisetType((LogicalType)CharType.ofEmptyLiteral()), new MultisetType((LogicalType)VarCharType.ofEmptyLiteral()), new MultisetType((LogicalType)BinaryType.ofEmptyLiteral()), new MultisetType((LogicalType)VarBinaryType.ofEmptyLiteral()), RowType.of((LogicalType[])new LogicalType[]{new BigIntType(), new IntType(false), new VarCharType(200)}), RowType.of((LogicalType[])new LogicalType[]{new BigIntType(), new IntType(false), new VarCharType(200)}, (String[])new String[]{"f1", "f2", "f3"}), RowType.of((LogicalType[])new LogicalType[]{new TimestampType(false, TimestampKind.ROWTIME, 3), new TimestampType(false, TimestampKind.REGULAR, 3), new ZonedTimestampType(false, TimestampKind.ROWTIME, 3), new ZonedTimestampType(false, TimestampKind.REGULAR, 3), new LocalZonedTimestampType(false, TimestampKind.ROWTIME, 3), new LocalZonedTimestampType(false, TimestampKind.PROCTIME, 3), new LocalZonedTimestampType(false, TimestampKind.REGULAR, 3)}), RowType.of((LogicalType[])new LogicalType[]{CharType.ofEmptyLiteral(), VarCharType.ofEmptyLiteral(), BinaryType.ofEmptyLiteral(), VarBinaryType.ofEmptyLiteral()}), StructuredType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"cat", (String)"db", (String)"structuredType"), DataTypeJsonSerdeTest.PojoClass.class).attributes(Arrays.asList(new StructuredType.StructuredAttribute("f0", (LogicalType)new IntType(true)), new StructuredType.StructuredAttribute("f1", (LogicalType)new BigIntType(true)), new StructuredType.StructuredAttribute("f2", (LogicalType)new VarCharType(200), "desc"))).comparison(StructuredType.StructuredComparison.FULL).setFinal(false).setInstantiable(false).superType(StructuredType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"cat", (String)"db", (String)"structuredType2")).attributes(Collections.singletonList(new StructuredType.StructuredAttribute("f0", (LogicalType)new BigIntType(false)))).build()).description("description for StructuredType").build(), StructuredType.newBuilder(DataTypeJsonSerdeTest.PojoClass.class).attributes(Arrays.asList(new StructuredType.StructuredAttribute("f0", (LogicalType)new IntType(true)), new StructuredType.StructuredAttribute("f1", (LogicalType)new BigIntType(true)), new StructuredType.StructuredAttribute("f2", (LogicalType)new VarCharType(200), "desc"))).build(), DistinctType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"cat", (String)"db", (String)"distinctType"), (LogicalType)new VarCharType(5)).build(), DistinctType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"cat", (String)"db", (String)"distinctType"), (LogicalType)new VarCharType(false, 5)).build(), new RawType(LocalDateTime.class, (TypeSerializer)LocalDateTimeSerializer.INSTANCE), new RawType(Row.class, (TypeSerializer)ExternalSerializer.of((DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.INT(), DataTypes.STRING()}))));
        ArrayList<LogicalType> mutableTypes = new ArrayList<LogicalType>(types);
        LogicalTypeJsonSerdeTest.addRawTypesForMapView(mutableTypes, (LogicalType)new VarCharType(100), (LogicalType)new VarCharType(100));
        LogicalTypeJsonSerdeTest.addRawTypesForMapView(mutableTypes, (LogicalType)new VarCharType(100), (LogicalType)new BigIntType());
        LogicalTypeJsonSerdeTest.addRawTypesForMapView(mutableTypes, (LogicalType)new BigIntType(), (LogicalType)new VarCharType(100));
        LogicalTypeJsonSerdeTest.addRawTypesForMapView(mutableTypes, (LogicalType)new BigIntType(), (LogicalType)new BigIntType());
        LogicalTypeJsonSerdeTest.addRawTypesForListView(mutableTypes, (LogicalType)new VarCharType(100));
        LogicalTypeJsonSerdeTest.addRawTypesForListView(mutableTypes, (LogicalType)new BigIntType());
        mutableTypes.add(DataViewUtils.adjustDataViews((DataType)MapView.newMapViewDataType((DataType)DataTypes.STRING().toInternal(), (DataType)((DataType)DataTypes.STRING().bridgedTo(byte[].class))), (boolean)false).getLogicalType());
        ArrayList<LogicalType> allTypes = new ArrayList<LogicalType>();
        for (LogicalType type : mutableTypes) {
            allTypes.add(type.copy(true));
            allTypes.add(type.copy(false));
        }
        allTypes.add((LogicalType)new NullType());
        return allTypes;
    }

    private static void addRawTypesForMapView(List<LogicalType> types, LogicalType keyType, LogicalType valueType) {
        for (boolean hasStateBackedDataViews : Arrays.asList(true, false)) {
            for (boolean keyNullable : Arrays.asList(true, false)) {
                for (boolean isInternalKeyType : Arrays.asList(true, false)) {
                    for (boolean valueNullable : Arrays.asList(true, false)) {
                        for (boolean isInternalValueType : Arrays.asList(true, false)) {
                            DataType viewDataType = DataViewUtils.adjustDataViews((DataType)MapView.newMapViewDataType((DataType)LogicalTypeJsonSerdeTest.convertToInternalTypeIfNeeded(DataTypes.of((LogicalType)keyType.copy(keyNullable)), isInternalKeyType), (DataType)LogicalTypeJsonSerdeTest.convertToInternalTypeIfNeeded(DataTypes.of((LogicalType)valueType.copy(valueNullable)), isInternalValueType)), (boolean)hasStateBackedDataViews);
                            types.add(viewDataType.getLogicalType());
                        }
                    }
                }
            }
        }
    }

    private static void addRawTypesForListView(List<LogicalType> types, LogicalType elementType) {
        for (boolean hasStateBackedDataViews : Arrays.asList(true, false)) {
            for (boolean elementNullable : Arrays.asList(true, false)) {
                for (boolean isInternalType : Arrays.asList(true, false)) {
                    DataType viewDataType = DataViewUtils.adjustDataViews((DataType)ListView.newListViewDataType((DataType)LogicalTypeJsonSerdeTest.convertToInternalTypeIfNeeded(DataTypes.of((LogicalType)elementType.copy(elementNullable)), isInternalType)), (boolean)hasStateBackedDataViews);
                    types.add(viewDataType.getLogicalType());
                }
            }
        }
    }

    private static DataType convertToInternalTypeIfNeeded(DataType dataType, boolean isInternalType) {
        return isInternalType ? dataType.toInternal() : dataType;
    }
}

