/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.util.Collections;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectWriter;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeGraph;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeTestUtil;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeUtil;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.apache.flink.table.types.DataType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ExecNodeGraphJsonSerializerTest {
    ExecNodeGraphJsonSerializerTest() {
    }

    @Test
    void testSerializingUnsupportedNode() {
        ObjectWriter objectWriter = JsonSerdeUtil.createObjectWriter((SerdeContext)JsonSerdeTestUtil.configuredSerdeContext());
        Assertions.assertThatThrownBy(() -> objectWriter.writeValueAsString((Object)new ExecNodeGraph(FlinkVersion.v1_18, Collections.singletonList(new NoAnnotationNode())))).hasMessageContaining("Can not serialize ExecNode with id: 10. Missing type, this is a bug, please file a ticket");
    }

    private static class NoAnnotationNode
    extends ExecNodeBase<RowData> {
        NoAnnotationNode() {
            super(10, ExecNodeContext.newContext(NoAnnotationNode.class), (ReadableConfig)new Configuration(), Collections.emptyList(), DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a", (DataType)DataTypes.INT())}).getLogicalType(), "");
            this.setInputEdges(Collections.emptyList());
        }

        protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
            return null;
        }
    }
}

