/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.operator;

import java.util.Optional;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.nodes.exec.operator.OperatorNameTestBase;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.junit.jupiter.api.TestTemplate;
import scala.Option;

class BatchOperatorNameTest
extends OperatorNameTestBase {
    BatchOperatorNameTest() {
    }

    @Override
    protected TableTestUtil getTableTestUtil() {
        return this.batchTestUtil(TableConfig.getDefault());
    }

    @TestTemplate
    void testBoundedStreamScan() {
        DataStreamSource dataStream = this.util.getStreamEnv().fromElements((Object[])new Integer[]{1, 2, 3, 4, 5});
        TableTestUtil.createTemporaryView(this.tEnv, "MyTable", dataStream, (Option<Expression[]>)JavaScalaConversionUtil.toScala(Optional.empty()), (Option<boolean[]>)JavaScalaConversionUtil.toScala(Optional.empty()), (Option<FlinkStatistic>)JavaScalaConversionUtil.toScala(Optional.empty()));
        this.verifyQuery("SELECT * FROM MyTable");
    }

    @TestTemplate
    void testHashAggregate() {
        this.createTestSource();
        this.verifyQuery("SELECT a, count(distinct b) as b FROM MyTable GROUP BY a");
    }

    @TestTemplate
    void testSortAggregate() {
        this.tEnv.getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashAgg");
        this.createTestSource();
        this.verifyQuery("SELECT a, count(distinct b) as b FROM MyTable GROUP BY a");
    }

    @TestTemplate
    void testSortWindowAggregate() {
        this.createSourceWithTimeAttribute();
        this.verifyQuery("SELECT\n  b,\n  TUMBLE_END(rowtime, INTERVAL '15' MINUTE) as window_end,\n  FIRST_VALUE(a)\nFROM MyTable\nGROUP BY b, TUMBLE(rowtime, INTERVAL '15' MINUTE)");
    }

    @TestTemplate
    void testHashJoin() {
        this.testJoinInternal();
    }

    @TestTemplate
    void testNestedLoopJoin() {
        this.tEnv.getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin, SortMergeJoin");
        this.testJoinInternal();
    }

    @TestTemplate
    void testSortMergeJoin() {
        this.tEnv.getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin, NestedLoopJoin");
        this.testJoinInternal();
    }

    @TestTemplate
    void testMultiInput() {
        this.createTestSource("A");
        this.createTestSource("B");
        this.createTestSource("C");
        this.verifyQuery("SELECT * FROM A, B, C where A.a = B.a and A.a = C.a");
    }

    @TestTemplate
    void testLimit() {
        this.createTestSource();
        this.verifyQuery("select * from MyTable limit 10");
    }

    @TestTemplate
    void testSortLimit() {
        this.createTestSource();
        this.verifyQuery("select * from MyTable order by a limit 10");
    }

    @TestTemplate
    void testMatch() {
        this.createSourceWithTimeAttribute();
        String sql = "SELECT T.aid, T.bid, T.cid\n     FROM MyTable MATCH_RECOGNIZE (\n             ORDER BY proctime\n             MEASURES\n             `A\"`.a AS aid,\n             l.a AS bid,\n             C.a AS cid\n             PATTERN (`A\"` l C)\n             DEFINE\n                 `A\"` AS a = 1,\n                 l AS b = 2,\n                 C AS c = 'c'\n     ) AS T";
        this.verifyQuery(sql);
    }
}

