/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.common;

import java.util.Arrays;
import org.apache.flink.table.catalog.TableDistribution;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.test.program.SinkTestStep;
import org.apache.flink.table.test.program.SourceTestStep;
import org.apache.flink.table.test.program.TableTestProgram;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;

public class TableSinkTestPrograms {
    public static final Row[] BEFORE_DATA = new Row[]{Row.of((Object[])new Object[]{1, 1L, "hi"}), Row.of((Object[])new Object[]{2, 2L, "hello"}), Row.of((Object[])new Object[]{3, 2L, "hello world"})};
    public static final Row[] AFTER_DATA = new Row[]{Row.of((Object[])new Object[]{4, 4L, "foo"}), Row.of((Object[])new Object[]{5, 2L, "foo bar"})};
    public static final String[] SOURCE_SCHEMA = new String[]{"a INT", "b BIGINT", "c VARCHAR"};
    public static final TableTestProgram SINK_BUCKETING_WITH_COUNT = TableSinkTestPrograms.buildBucketingTest("with-count", TableDistribution.ofUnknown((int)3));
    public static final TableTestProgram SINK_BUCKETING_WITH_KEYS_AND_COUNT = TableSinkTestPrograms.buildBucketingTest("with-keys-and-count", TableDistribution.ofUnknown(Arrays.asList("a"), (Integer)3));
    public static final TableTestProgram SINK_BUCKETING_HASH_WITH_KEYS_AND_COUNT = TableSinkTestPrograms.buildBucketingTest("hash-with-keys-with-count", TableDistribution.ofHash(Arrays.asList("a"), (Integer)3));
    public static final TableTestProgram SINK_BUCKETING_HASH_WITH_KEYS_AND_WITHOUT_COUNT = TableSinkTestPrograms.buildBucketingTest("range_with_keys_without_count", TableDistribution.ofHash(Arrays.asList("a"), null));
    public static final TableTestProgram SINK_PARTITION = TableTestProgram.of((String)"sink-partition", (String)"validates sink partition").setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"source_t").addSchema(SOURCE_SCHEMA)).producedBeforeRestore(BEFORE_DATA).producedAfterRestore(AFTER_DATA).build()).setupTableSink(((SinkTestStep.Builder)((SinkTestStep.Builder)((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"a INT", "b BIGINT", "p BIGINT NOT NULL", "c VARCHAR"})).addPartitionKeys(new String[]{"b"})).addOption("partition-list", "b:1;b:2;b:3;b:4")).consumedBeforeRestore(new String[]{"+I[1, 2, 1, hi]", "+I[2, 2, 2, hello]", "+I[3, 2, 2, hello world]"}).consumedAfterRestore(new String[]{"+I[4, 2, 4, foo]", "+I[5, 2, 2, foo bar]"}).build()).runSql("INSERT INTO sink_t PARTITION (b=2) SELECT * FROM source_t").build();
    public static final TableTestProgram SINK_OVERWRITE = TableTestProgram.of((String)"sink-overwrite", (String)"validates sink with overwrite").setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"source_t").addSchema(SOURCE_SCHEMA)).producedBeforeRestore(BEFORE_DATA).producedAfterRestore(AFTER_DATA).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"a INT", "b BIGINT", "c VARCHAR"})).consumedBeforeRestore(new String[]{"+I[1, 1, hi]", "+I[2, 2, hello]", "+I[3, 2, hello world]"}).consumedAfterRestore(new String[]{"+I[4, 4, foo]", "+I[5, 2, foo bar]"}).build()).runSql("INSERT OVERWRITE sink_t SELECT * FROM source_t").build();
    public static final TableTestProgram SINK_WRITING_METADATA = TableTestProgram.of((String)"sink-writing-metadata", (String)"validates writing metadata to sink").setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"source_t").addSchema(SOURCE_SCHEMA)).producedBeforeRestore(BEFORE_DATA).producedAfterRestore(AFTER_DATA).build()).setupTableSink(((SinkTestStep.Builder)((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"a INT", "b BIGINT", "c VARCHAR METADATA"})).addOption("writable-metadata", "c:STRING")).consumedBeforeRestore(new String[]{"+I[1, 1, hi]", "+I[2, 2, hello]", "+I[3, 2, hello world]"}).consumedAfterRestore(new String[]{"+I[4, 4, foo]", "+I[5, 2, foo bar]"}).build()).runSql("INSERT INTO sink_t SELECT * FROM source_t").build();
    public static final TableTestProgram SINK_NDF_PRIMARY_KEY = TableTestProgram.of((String)"sink-ndf-primary-key", (String)"validates sink with ndf and different primary key").setupTemporaryCatalogFunction("ndf", JavaUserDefinedScalarFunctions.NonDeterministicUdf.class).setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"source_t").addSchema(SOURCE_SCHEMA)).producedBeforeRestore(BEFORE_DATA).producedAfterRestore(AFTER_DATA).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"a INT", "b BIGINT", "c VARCHAR", "PRIMARY KEY(c) NOT ENFORCED"})).consumedBeforeRestore(new String[]{"+I[1, 1, hi--1170105035]", "+I[2, 2, hello-234785527]", "+I[3, 2, hello world--1360544799]"}).consumedAfterRestore(new String[]{"+I[4, 4, foo--1170105035]", "+I[5, 2, foo bar-234785527]"}).build()).runSql("INSERT INTO sink_t SELECT a, b, ndf(c) FROM source_t").build();
    public static final TableTestProgram SINK_PARTIAL_INSERT = TableTestProgram.of((String)"sink-partial-insert", (String)"validates sink with partial insert").setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"source_t").addSchema(SOURCE_SCHEMA)).producedBeforeRestore(BEFORE_DATA).producedAfterRestore(AFTER_DATA).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"a INT", "b BIGINT", "c VARCHAR", "d DECIMAL(10,2)", "e DOUBLE"})).consumedBeforeRestore(new String[]{"+I[1, 1, hi, null, null]", "+I[2, 2, hello, null, null]", "+I[3, 2, hello world, null, null]"}).consumedAfterRestore(new String[]{"+I[4, 4, foo, null, null]", "+I[5, 2, foo bar, null, null]"}).build()).runSql("INSERT INTO sink_t (a, b, c) SELECT a, b, c FROM source_t").build();
    public static final TableTestProgram SINK_UPSERT = TableTestProgram.of((String)"sink-upsert", (String)"validates sink with primary key").setupTableSource(((SourceTestStep.Builder)((SourceTestStep.Builder)((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"source_t").addOption("changelog-mode", "I,UA,D")).addSchema(SOURCE_SCHEMA)).addSchema(new String[]{"PRIMARY KEY (a) NOT ENFORCED"})).producedBeforeRestore(BEFORE_DATA).producedAfterRestore(new Row[]{Row.ofKind((RowKind)RowKind.DELETE, (Object[])new Object[]{1, 1L, "hi"}), Row.of((Object[])new Object[]{4, 4L, "foo"})}).build()).setupTableSink(((SinkTestStep.Builder)((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"a INT", "b BIGINT", "c VARCHAR"})).addSchema(new String[]{"PRIMARY KEY (a) NOT ENFORCED"})).consumedBeforeRestore(new String[]{"+I[1, 1, hi]", "+I[2, 2, hello]", "+I[3, 2, hello world]"}).consumedAfterRestore(new String[]{"-D[1, 1, hi]", "+I[4, 4, foo]"}).build()).runSql("INSERT INTO sink_t SELECT * FROM source_t").build();

    private static TableTestProgram buildBucketingTest(String suffix, TableDistribution distribution) {
        return TableTestProgram.of((String)("sink-bucketing_" + suffix), (String)"validates sink bucketing").setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"source_t").addSchema(SOURCE_SCHEMA)).producedBeforeRestore(BEFORE_DATA).producedAfterRestore(AFTER_DATA).build()).setupTableSink(((SinkTestStep.Builder)((SinkTestStep.Builder)((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"a INT", "b BIGINT", "c VARCHAR"})).addDistribution(distribution)).addPartitionKeys(new String[]{"b"})).consumedBeforeRestore(new String[]{"+I[1, 1, hi]", "+I[2, 2, hello]", "+I[3, 2, hello world]"}).consumedAfterRestore(new String[]{"+I[4, 4, foo]", "+I[5, 2, foo bar]"}).build()).runSql("INSERT INTO sink_t SELECT * FROM source_t").build();
    }
}

