/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.metadata;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.table.plan.stats.ColumnStats;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.calcite.FlinkRexBuilder;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeSystem;
import org.apache.flink.table.planner.delegation.PlannerContext;
import org.apache.flink.table.planner.plan.metadata.AggCallSelectivityEstimator;
import org.apache.flink.table.planner.plan.metadata.AggCallSelectivityEstimatorTest$;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMetadataQuery;
import org.apache.flink.table.planner.plan.metadata.MockMetaTable;
import org.apache.flink.table.planner.plan.metadata.SelectivityEstimator;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic$;
import org.apache.flink.table.planner.utils.PlannerMocks;
import org.apache.flink.util.Preconditions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\rmc\u0001B\u001d;\u0001%CQ\u0001\u0015\u0001\u0005\u0002ECq\u0001\u0016\u0001C\u0002\u0013%Q\u000b\u0003\u0004e\u0001\u0001\u0006IA\u0016\u0005\bK\u0002\u0011\r\u0011\"\u0003g\u0011\u0019\u0011\b\u0001)A\u0005O\"Q1\u000f\u0001I\u0001\u0002\u0007\u0005\u000b\u0011\u0002;\t\u000fi\u0004!\u0019!C\u0001w\"1A\u0010\u0001Q\u0001\n]Dq! \u0001C\u0002\u0013\u00051\u0010\u0003\u0004\u007f\u0001\u0001\u0006Ia\u001e\u0005\b\u007f\u0002\u0011\r\u0011\"\u0001|\u0011\u001d\t\t\u0001\u0001Q\u0001\n]D\u0011\"a\u0001\u0001\u0005\u0004%\t!!\u0002\t\u0011\u0005E\u0001\u0001)A\u0005\u0003\u000fA\u0011\"a\u0005\u0001\u0001\u0004%\t!!\u0006\t\u0013\u0005u\u0001\u00011A\u0005\u0002\u0005}\u0001\u0002CA\u0015\u0001\u0001\u0006K!a\u0006\t\u0013\u0005-\u0002A1A\u0005\u0002\u00055\u0002\u0002CA\u001f\u0001\u0001\u0006I!a\f\t\u0013\u0005}\u0002A1A\u0005\u0002\u0005\u0005\u0003\u0002CA%\u0001\u0001\u0006I!a\u0011\t\u0017\u0005-\u0003\u00011AA\u0002\u0013\u0005\u0011Q\n\u0005\f\u00037\u0002\u0001\u0019!a\u0001\n\u0003\ti\u0006C\u0006\u0002b\u0001\u0001\r\u0011!Q!\n\u0005=\u0003bBA2\u0001\u0011\u0005\u0011Q\r\u0005\b\u0003{\u0002A\u0011BA@\u0011%\t\t\nAI\u0001\n\u0013\t\u0019\nC\u0004\u0002*\u0002!I!a+\t\u000f\u0005%\u0006\u0001\"\u0003\u0002f\"9\u0011Q\u001e\u0001\u0005\n\u0005=\bb\u0002B\u0004\u0001\u0011%!\u0011\u0002\u0005\b\u0005+\u0001A\u0011\u0002B\f\u0011\u001d\u0011\u0019\u0004\u0001C\u0005\u0005kA\u0011B!0\u0001#\u0003%IAa0\t\u0013\t\r\u0007!%A\u0005\n\t}\u0006\"\u0003Bc\u0001E\u0005I\u0011\u0002Bd\u0011%\u0011Y\rAI\u0001\n\u0013\u0011i\rC\u0005\u0003R\u0002\t\n\u0011\"\u0003\u0003T\"I!\u0011\u001d\u0001\u0012\u0002\u0013%!1\u001d\u0005\b\u0005c\u0004A\u0011\u0002Bz\u0011%\u0019\u0019\u0002AI\u0001\n\u0013\u0011y\fC\u0005\u0004\u0016\u0001\t\n\u0011\"\u0003\u0004\u0018!911\u0004\u0001\u0005\u0002\u0005\u0015\u0004bBB\u0013\u0001\u0011\u0005\u0011Q\r\u0005\b\u0007S\u0001A\u0011AA3\u0011\u001d\u0019i\u0003\u0001C\u0001\u0003KBqa!\r\u0001\t\u0003\t)\u0007C\u0004\u00046\u0001!\t!!\u001a\t\u000f\re\u0002\u0001\"\u0001\u0002f!91Q\b\u0001\u0005\u0002\u0005\u0015\u0004bBB!\u0001\u0011\u0005\u0011Q\r\u0005\b\u0007\u000b\u0002A\u0011AA3\u000f\u001d\u0019IE\u000fE\u0001\u0007\u00172a!\u000f\u001e\t\u0002\r5\u0003B\u0002)7\t\u0003\u0019y\u0005C\u0004\u0004RY\"\t!!\u001a\u0003?\u0005;wmQ1mYN+G.Z2uSZLG/_#ti&l\u0017\r^8s)\u0016\u001cHO\u0003\u0002<y\u0005AQ.\u001a;bI\u0006$\u0018M\u0003\u0002>}\u0005!\u0001\u000f\\1o\u0015\ty\u0004)A\u0004qY\u0006tg.\u001a:\u000b\u0005\u0005\u0013\u0015!\u0002;bE2,'BA\"E\u0003\u00151G.\u001b8l\u0015\t)e)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u000f\u0006\u0019qN]4\u0004\u0001M\u0011\u0001A\u0013\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0002\u001b\u0006)1oY1mC&\u0011q\n\u0014\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\u0011\u0006CA*\u0001\u001b\u0005Q\u0014!D1mY\u001aKW\r\u001c3OC6,7/F\u0001W!\r9&\fX\u0007\u00021*\u0011\u0011\fT\u0001\u000bG>dG.Z2uS>t\u0017BA.Y\u0005\r\u0019V-\u001d\t\u0003;\nl\u0011A\u0018\u0006\u0003?\u0002\fA\u0001\\1oO*\t\u0011-\u0001\u0003kCZ\f\u0017BA2_\u0005\u0019\u0019FO]5oO\u0006q\u0011\r\u001c7GS\u0016dGMT1nKN\u0004\u0013!D1mY\u001aKW\r\u001c3UsB,7/F\u0001h!\r9&\f\u001b\t\u0003SBl\u0011A\u001b\u0006\u0003W2\fA\u0001^=qK*\u0011QN\\\u0001\u0004gFd'BA8E\u0003\u001d\u0019\u0017\r\\2ji\u0016L!!\u001d6\u0003\u0017M\u000bH\u000eV=qK:\u000bW.Z\u0001\u000fC2dg)[3mIRK\b/Z:!\u0003\rAH%\r\t\u0006\u0017V<xo^\u0005\u0003m2\u0013a\u0001V;qY\u0016\u001c\u0004CA&y\u0013\tIHJA\u0002J]R\f\u0001B\\1nK~KG\r_\u000b\u0002o\u0006Ia.Y7f?&$\u0007\u0010I\u0001\u000bC6|WO\u001c;`S\u0012D\u0018aC1n_VtGoX5eq\u0002\n\u0011\u0002\u001d:jG\u0016|\u0016\u000e\u001a=\u0002\u0015A\u0014\u0018nY3`S\u0012D\b%A\u0006usB,g)Y2u_JLXCAA\u0004!\u0011\tI!!\u0004\u000e\u0005\u0005-!BA8?\u0013\u0011\ty!a\u0003\u0003!\u0019c\u0017N\\6UsB,g)Y2u_JL\u0018\u0001\u0004;za\u00164\u0015m\u0019;pef\u0004\u0013A\u0003:fq\n+\u0018\u000e\u001c3feV\u0011\u0011q\u0003\t\u0005\u0003\u0013\tI\"\u0003\u0003\u0002\u001c\u0005-!a\u0004$mS:\\'+\u001a=Ck&dG-\u001a:\u0002\u001dI,\u0007PQ;jY\u0012,'o\u0018\u0013fcR!\u0011\u0011EA\u0014!\rY\u00151E\u0005\u0004\u0003Ka%\u0001B+oSRD\u0001b\u001d\t\u0002\u0002\u0003\u0007\u0011qC\u0001\fe\u0016D()^5mI\u0016\u0014\b%A\u0006sK2$\u0015\r^1UsB,WCAA\u0018!\u0011\t\t$!\u000f\u000e\u0005\u0005M\"bA6\u00026)\u0019\u0011q\u00078\u0002\u0007I,G.\u0003\u0003\u0002<\u0005M\"a\u0003*fY\u0012\u000bG/\u0019+za\u0016\fAB]3m\t\u0006$\u0018\rV=qK\u0002\n!!\\9\u0016\u0005\u0005\r\u0003cA*\u0002F%\u0019\u0011q\t\u001e\u0003+\u0019c\u0017N\\6SK2lU\r^1eCR\f\u0017+^3ss\u0006\u0019Q.\u001d\u0011\u0002\tM\u001c\u0017M\\\u000b\u0003\u0003\u001f\u0002B!!\u0015\u0002X5\u0011\u00111\u000b\u0006\u0005\u0003+\n)$\u0001\u0003d_J,\u0017\u0002BA-\u0003'\u0012\u0011\u0002V1cY\u0016\u001c6-\u00198\u0002\u0011M\u001c\u0017M\\0%KF$B!!\t\u0002`!A1oFA\u0001\u0002\u0004\ty%A\u0003tG\u0006t\u0007%A\u0003tKR,\b\u000f\u0006\u0002\u0002\"!\u001a\u0011$!\u001b\u0011\t\u0005-\u0014\u0011P\u0007\u0003\u0003[RA!a\u001c\u0002r\u0005\u0019\u0011\r]5\u000b\t\u0005M\u0014QO\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\t9HR\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003w\niG\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\"\\8dWN\u001b\u0017M\u001c\u000b\u0005\u0003\u001f\n\t\tC\u0005\u0002\u0004j\u0001\n\u00111\u0001\u0002\u0006\u0006I1\u000f^1uSN$\u0018n\u0019\t\u0005\u0003\u000f\u000bi)\u0004\u0002\u0002\n*\u0019\u00111\u0012\u001f\u0002\u000bM$\u0018\r^:\n\t\u0005=\u0015\u0011\u0012\u0002\u000f\r2Lgn[*uCRL7\u000f^5d\u0003IiwnY6TG\u0006tG\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005U%\u0006BAC\u0003/[#!!'\u0011\t\u0005m\u0015QU\u0007\u0003\u0003;SA!a(\u0002\"\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003Gc\u0015AC1o]>$\u0018\r^5p]&!\u0011qUAO\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0010GJ,\u0017\r^3BO\u001e\u0014XmZ1uKR1\u0011QVAZ\u0003{\u0003B!!\u0015\u00020&!\u0011\u0011WA*\u0005%\tum\u001a:fO\u0006$X\rC\u0004\u00026r\u0001\r!a.\u0002\u0011\u001d\u0014x.\u001e9TKR\u0004BaSA]o&\u0019\u00111\u0018'\u0003\u000b\u0005\u0013(/Y=\t\u000f\u0005}F\u00041\u0001\u0002B\u0006\u00012/\u001d7BO\u001e4UO\\,ji\"\f%o\u001a\t\u0007\u0003\u0007\f\u0019.a6\u000f\t\u0005\u0015\u0017q\u001a\b\u0005\u0003\u000f\fi-\u0004\u0002\u0002J*\u0019\u00111\u001a%\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0015bAAi\u0019\u00069\u0001/Y2lC\u001e,\u0017bA.\u0002V*\u0019\u0011\u0011\u001b'\u0011\r-\u000bI.!8x\u0013\r\tY\u000e\u0014\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\u0005}\u0017\u0011]\u0007\u0002Y&\u0019\u00111\u001d7\u0003\u001dM\u000bH.Q4h\rVt7\r^5p]RA\u0011QVAt\u0003S\fY\u000fC\u0004\u0002Lu\u0001\r!a\u0014\t\u000f\u0005UV\u00041\u0001\u00028\"9\u0011qX\u000fA\u0002\u0005\u0005\u0017\u0001F2sK\u0006$XMT;nKJL7\rT5uKJ\fG\u000e\u0006\u0003\u0002r\u0006u\b\u0003BAz\u0003sl!!!>\u000b\u0007\u0005]h.A\u0002sKbLA!a?\u0002v\nQ!+\u001a=MSR,'/\u00197\t\u000f\u0005}h\u00041\u0001\u0003\u0002\u0005\u0019a.^7\u0011\u0007-\u0013\u0019!C\u0002\u0003\u00061\u0013A\u0001T8oO\u0006q1M]3bi\u0016Le\u000e];u%\u00164G\u0003\u0002B\u0006\u0005#\u0001B!a=\u0003\u000e%!!qBA{\u0005-\u0011V\r_%oaV$(+\u001a4\t\r\tMq\u00041\u0001x\u0003\u0015Ig\u000eZ3y\u0003)\u0019'/Z1uK\u000e\u000bG\u000e\u001c\u000b\u0007\u00053\u0011yB!\u000b\u0011\t\u0005M(1D\u0005\u0005\u0005;\t)PA\u0004SKbtu\u000eZ3\t\u000f\t\u0005\u0002\u00051\u0001\u0003$\u0005Aq\u000e]3sCR|'\u000f\u0005\u0003\u0002`\n\u0015\u0012b\u0001B\u0014Y\nY1+\u001d7Pa\u0016\u0014\u0018\r^8s\u0011\u001d\u0011Y\u0003\ta\u0001\u0005[\tQ!\u001a=qeN\u0004Ra\u0013B\u0018\u00053I1A!\rM\u0005)a$/\u001a9fCR,GMP\u0001\u0012GJ,\u0017\r^3D_2,XN\\*uCR\u001cHC\u0004B\u001c\u0005\u0007\u0012iG!\u001d\u0003~\t%%Q\u0016\t\u0005\u0005s\u0011y$\u0004\u0002\u0003<)!\u00111\u0012B\u001f\u0015\ti\u0004)\u0003\u0003\u0003B\tm\"aC\"pYVlgn\u0015;biND\u0011B!\u0012\"!\u0003\u0005\rAa\u0012\u0002\u00079$g\u000fE\u0003L\u0005\u0013\u0012i%C\u0002\u0003L1\u0013aa\u00149uS>t\u0007\u0003\u0002B(\u0005OrAA!\u0015\u0003f9!!1\u000bB2\u001d\u0011\u0011)F!\u0019\u000f\t\t]#q\f\b\u0005\u00053\u0012iF\u0004\u0003\u0002H\nm\u0013\"A$\n\u0005\u00153\u0015BA\"E\u0013\t\t%)\u0003\u0002@\u0001&\u0019\u0011\u0011\u001b \n\t\t%$1\u000e\u0002\u0006\u00152{gn\u001a\u0006\u0004\u0003#t\u0004\"\u0003B8CA\u0005\t\u0019\u0001B$\u0003%qW\u000f\u001c7D_VtG\u000fC\u0005\u0003t\u0005\u0002\n\u00111\u0001\u0003v\u00051\u0011M^4MK:\u0004Ra\u0013B%\u0005o\u0002BAa\u0014\u0003z%!!1\u0010B6\u0005\u001dQEi\\;cY\u0016D\u0011Ba \"!\u0003\u0005\rA!!\u0002\r5\f\u0007\u0010T3o!\u0015Y%\u0011\nBB!\ri&QQ\u0005\u0004\u0005\u000fs&aB%oi\u0016<WM\u001d\u0005\n\u0005\u0017\u000b\u0003\u0013!a\u0001\u0005\u001b\u000b1!\\5o!\u0015Y%\u0011\nBHa\u0011\u0011\tJa'\u0011\u000bu\u0013\u0019Ja&\n\u0007\tUeL\u0001\u0006D_6\u0004\u0018M]1cY\u0016\u0004BA!'\u0003\u001c2\u0001A\u0001\u0004BO\u0005\u0013\u000b\t\u0011!A\u0003\u0002\t}%aA0%cE!!\u0011\u0015BT!\rY%1U\u0005\u0004\u0005Kc%a\u0002(pi\"Lgn\u001a\t\u0004\u0017\n%\u0016b\u0001BV\u0019\n\u0019\u0011I\\=\t\u0013\t=\u0016\u0005%AA\u0002\tE\u0016aA7bqB)1J!\u0013\u00034B\"!Q\u0017B]!\u0015i&1\u0013B\\!\u0011\u0011IJ!/\u0005\u0019\tm&QVA\u0001\u0002\u0003\u0015\tAa(\u0003\u0007}##'A\u000ede\u0016\fG/Z\"pYVlgn\u0015;biN$C-\u001a4bk2$H%M\u000b\u0003\u0005\u0003TCAa\u0012\u0002\u0018\u0006Y2M]3bi\u0016\u001cu\u000e\\;n]N#\u0018\r^:%I\u00164\u0017-\u001e7uII\n1d\u0019:fCR,7i\u001c7v[:\u001cF/\u0019;tI\u0011,g-Y;mi\u0012\u001aTC\u0001BeU\u0011\u0011)(a&\u00027\r\u0014X-\u0019;f\u0007>dW/\u001c8Ti\u0006$8\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011yM\u000b\u0003\u0003\u0002\u0006]\u0015aG2sK\u0006$XmQ8mk6t7\u000b^1ug\u0012\"WMZ1vYR$S'\u0006\u0002\u0003V*\"!q[AL!\u0015Y%\u0011\nBma\u0011\u0011YNa8\u0011\u000bu\u0013\u0019J!8\u0011\t\te%q\u001c\u0003\f\u0005;3\u0013\u0011!A\u0001\u0006\u0003\u0011y*A\u000ede\u0016\fG/Z\"pYVlgn\u0015;biN$C-\u001a4bk2$HEN\u000b\u0003\u0005KTCAa:\u0002\u0018B)1J!\u0013\u0003jB\"!1\u001eBx!\u0015i&1\u0013Bw!\u0011\u0011IJa<\u0005\u0017\tmv%!A\u0001\u0002\u000b\u0005!qT\u0001\u0015GJ,\u0017\r^3GY&t7n\u0015;bi&\u001cH/[2\u0015\r\u0005\u0015%Q\u001fB}\u0011%\u00119\u0010\u000bI\u0001\u0002\u0004\u00119%\u0001\u0005s_^\u001cu.\u001e8u\u0011%\u0011Y\u0010\u000bI\u0001\u0002\u0004\u0011i0\u0001\u0005d_2\u001cF/\u0019;t!\u0015Y%\u0011\nB\u0000!!\u0019\ta!\u0003\u0004\u0010\t]b\u0002BB\u0002\u0007\u000b\u00012!a2M\u0013\r\u00199\u0001T\u0001\u0007!J,G-\u001a4\n\t\r-1Q\u0002\u0002\u0004\u001b\u0006\u0004(bAB\u0004\u0019B!1\u0011AB\t\u0013\r\u00197QB\u0001\u001fGJ,\u0017\r^3GY&t7n\u0015;bi&\u001cH/[2%I\u00164\u0017-\u001e7uIE\nad\u0019:fCR,g\t\\5oWN#\u0018\r^5ti&\u001cG\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\re!\u0006\u0002B\u007f\u0003/\u000b\u0011\u0003^3tiN+XnV5uQ\u0016\u000bX/\u00197tQ\rY3q\u0004\t\u0005\u0003W\u001a\t#\u0003\u0003\u0004$\u00055$\u0001\u0002+fgR\f1\u0003^3tiN+XnV5uQ2+7o\u001d+iC:D3\u0001LB\u0010\u0003u!Xm\u001d;Tk6<\u0016\u000e\u001e5MKN\u001cH\u000b[1o\u001fJ,\u0015/^1mgR{\u0007fA\u0017\u0004 \u00051B/Z:u'Vlw+\u001b;i\u000fJ,\u0017\r^3s)\"\fg\u000eK\u0002/\u0007?\ta\u0004^3tiN+XnV5uQ\u001e\u0013X-\u0019;feRC\u0017M\\(s\u000bF,\u0018\r\\:)\u0007=\u001ay\"\u0001\u0006uKN$X*\u0019=NS:D3\u0001MB\u0010\u0003\u001d!Xm\u001d;Bm\u001eD3!MB\u0010\u0003%!Xm\u001d;D_VtG\u000fK\u00023\u0007?\tq\u0001^3ti\u0006sG\rK\u00024\u0007?\ta\u0001^3ti>\u0013\bf\u0001\u001b\u0004 \u0005y\u0012iZ4DC2d7+\u001a7fGRLg/\u001b;z\u000bN$\u0018.\\1u_J$Vm\u001d;\u0011\u0005M34C\u0001\u001cK)\t\u0019Y%A\u0005cK\u001a|'/Z!mY\"\u001a\u0001h!\u0016\u0011\t\u0005-4qK\u0005\u0005\u00073\niGA\u0005CK\u001a|'/Z!mY\u0002")
public class AggCallSelectivityEstimatorTest {
    private final Seq<String> allFieldNames = (Seq)new .colon.colon((Object)"name", (List)new .colon.colon((Object)"amount", (List)new .colon.colon((Object)"price", (List)Nil$.MODULE$)));
    private final Seq<SqlTypeName> allFieldTypes = (Seq)new .colon.colon((Object)SqlTypeName.VARCHAR, (List)new .colon.colon((Object)SqlTypeName.INTEGER, (List)new .colon.colon((Object)SqlTypeName.DOUBLE, (List)Nil$.MODULE$)));
    private final /* synthetic */ Tuple3 x$1;
    private final int name_idx;
    private final int amount_idx;
    private final int price_idx;
    private final FlinkTypeFactory typeFactory;
    private FlinkRexBuilder rexBuilder;
    private final RelDataType relDataType;
    private final FlinkRelMetadataQuery mq;
    private TableScan scan;

    @BeforeAll
    public static void beforeAll() {
        AggCallSelectivityEstimatorTest$.MODULE$.beforeAll();
    }

    private Seq<String> allFieldNames() {
        return this.allFieldNames;
    }

    private Seq<SqlTypeName> allFieldTypes() {
        return this.allFieldTypes;
    }

    public int name_idx() {
        return this.name_idx;
    }

    public int amount_idx() {
        return this.amount_idx;
    }

    public int price_idx() {
        return this.price_idx;
    }

    public FlinkTypeFactory typeFactory() {
        return this.typeFactory;
    }

    public FlinkRexBuilder rexBuilder() {
        return this.rexBuilder;
    }

    public void rexBuilder_$eq(FlinkRexBuilder x$1) {
        this.rexBuilder = x$1;
    }

    public RelDataType relDataType() {
        return this.relDataType;
    }

    public FlinkRelMetadataQuery mq() {
        return this.mq;
    }

    public TableScan scan() {
        return this.scan;
    }

    public void scan_$eq(TableScan x$1) {
        this.scan = x$1;
    }

    @BeforeEach
    public void setup() {
        this.scan_$eq(this.mockScan(this.mockScan$default$1()));
    }

    private TableScan mockScan(FlinkStatistic statistic) {
        SchemaPlus rootSchema = CalciteSchema.createRootSchema((boolean)true, (boolean)false).plus();
        MockMetaTable table = new MockMetaTable(this.relDataType(), statistic);
        rootSchema.add("test", (Table)table);
        PlannerContext plannerContext = PlannerMocks.newBuilder().withRootSchema(CalciteSchema.from((SchemaPlus)rootSchema)).build().getPlannerContext();
        FlinkRelBuilder relBuilder = plannerContext.createRelBuilder();
        relBuilder.clear();
        return (TableScan)relBuilder.scan(Arrays.asList((Object[])new String[]{"test"})).build();
    }

    private FlinkStatistic mockScan$default$1() {
        return FlinkStatistic$.MODULE$.UNKNOWN();
    }

    private Aggregate createAggregate(int[] groupSet, Seq<Tuple2<SqlAggFunction, Object>> sqlAggFunWithArg) {
        return this.createAggregate(this.scan(), groupSet, sqlAggFunWithArg);
    }

    private Aggregate createAggregate(TableScan scan, int[] groupSet, Seq<Tuple2<SqlAggFunction, Object>> sqlAggFunWithArg) {
        Seq aggCalls = (Seq)sqlAggFunWithArg.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                SqlAggFunction sqlAggFun = (SqlAggFunction)tuple2._1();
                int arg = tuple2._2$mcI$sp();
                SqlAggFunction sqlAggFunction = sqlAggFun;
                SqlAggFunction sqlAggFunction2 = SqlStdOperatorTable.COUNT;
                SqlAggFunction sqlAggFunction3 = sqlAggFunction;
                RelDataType aggCallType = !(sqlAggFunction2 != null ? !sqlAggFunction2.equals(sqlAggFunction3) : sqlAggFunction3 != null) ? this.typeFactory().createSqlType(SqlTypeName.BIGINT) : ((RelDataTypeField)scan.getRowType().getFieldList().get(arg)).getType();
                return AggregateCall.create((SqlAggFunction)sqlAggFun, (boolean)false, (boolean)false, (boolean)false, (java.util.List)ImmutableList.of((Object)arg), (int)-1, null, (RelCollation)RelCollations.EMPTY, (int)groupSet.length, (RelNode)scan, (RelDataType)aggCallType, (String)((String)scan.getRowType().getFieldNames().get(arg)));
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
        return LogicalAggregate.create((RelNode)scan, (java.util.List)ImmutableList.of(), (ImmutableBitSet)ImmutableBitSet.of((int[])groupSet), null, (java.util.List)ImmutableList.copyOf((Object[])((Object[])aggCalls.toArray(ClassTag$.MODULE$.apply(AggregateCall.class)))));
    }

    private RexLiteral createNumericLiteral(long num) {
        return this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(num));
    }

    private RexInputRef createInputRef(int index) {
        RelDataType relDataType = this.typeFactory().createSqlType((SqlTypeName)this.allFieldTypes().apply(index));
        RelDataType relDataTypeWithNullability = this.typeFactory().createTypeWithNullability(relDataType, false);
        return this.rexBuilder().makeInputRef(relDataTypeWithNullability, index);
    }

    private RexNode createCall(SqlOperator operator, Seq<RexNode> exprs) {
        Preconditions.checkArgument((boolean)exprs.nonEmpty());
        return this.rexBuilder().makeCall(operator, (RexNode[])exprs.toArray(ClassTag$.MODULE$.apply(RexNode.class)));
    }

    private ColumnStats createColumnStats(Option<Long> ndv, Option<Long> nullCount, Option<Double> avgLen, Option<Integer> maxLen, Option<Comparable<?>> min, Option<Comparable<?>> max) {
        return ColumnStats.Builder.builder().setNdv((Long)ndv.getOrElse((Function0 & Serializable & scala.Serializable)() -> null)).setNullCount((Long)nullCount.getOrElse((Function0 & Serializable & scala.Serializable)() -> null)).setAvgLen((Double)avgLen.getOrElse((Function0 & Serializable & scala.Serializable)() -> null)).setMaxLen((Integer)maxLen.getOrElse((Function0 & Serializable & scala.Serializable)() -> null)).setMax((Comparable)max.orNull(Predef$.MODULE$.$conforms())).setMin((Comparable)min.orNull(Predef$.MODULE$.$conforms())).build();
    }

    private Option<Long> createColumnStats$default$1() {
        return None$.MODULE$;
    }

    private Option<Long> createColumnStats$default$2() {
        return None$.MODULE$;
    }

    private Option<Double> createColumnStats$default$3() {
        return None$.MODULE$;
    }

    private Option<Integer> createColumnStats$default$4() {
        return None$.MODULE$;
    }

    private Option<Comparable<?>> createColumnStats$default$5() {
        return None$.MODULE$;
    }

    private Option<Comparable<?>> createColumnStats$default$6() {
        return None$.MODULE$;
    }

    private FlinkStatistic createFlinkStatistic(Option<Long> rowCount, Option<scala.collection.immutable.Map<String, ColumnStats>> colStats) {
        Predef$.MODULE$.require(rowCount.isDefined(), (Function0 & Serializable & scala.Serializable)() -> "rowCount must be non null now");
        TableStats tableStats = colStats.isDefined() ? new TableStats(Predef$.MODULE$.Long2long((Long)rowCount.get()), JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)colStats.get())) : new TableStats(Predef$.MODULE$.Long2long((Long)rowCount.get()), null);
        return FlinkStatistic$.MODULE$.builder().tableStats(tableStats).build();
    }

    private Option<Long> createFlinkStatistic$default$1() {
        return None$.MODULE$;
    }

    private Option<scala.collection.immutable.Map<String, ColumnStats>> createFlinkStatistic$default$2() {
        return None$.MODULE$;
    }

    @Test
    public void testSumWithEquals() {
        Aggregate agg1 = this.createAggregate(new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), (List)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx())), (List)Nil$.MODULE$))));
        SelectivityEstimator se = new SelectivityEstimator((RelNode)agg1, this.mq());
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(50L)}));
        AggCallSelectivityEstimator estimator1 = new AggCallSelectivityEstimator((RelNode)agg1, this.mq());
        Assertions.assertEquals((Object)se.defaultEqualsSelectivity(), (Object)estimator1.evaluate(predicate1));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20))))}))));
        Aggregate agg2 = this.createAggregate(this.mockScan(statistic1), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), (List)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx())), (List)Nil$.MODULE$))));
        AggCallSelectivityEstimator estimator2 = new AggCallSelectivityEstimator((RelNode)agg2, this.mq());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.025)), (Object)estimator2.evaluate(predicate1));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(5L)}));
        Assertions.assertEquals((Object)estimator1.defaultAggCallSelectivity(), (Object)estimator2.evaluate(predicate2));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)None$.MODULE$))}))));
        Aggregate agg3 = this.createAggregate(this.mockScan(statistic2), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), (List)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx())), (List)Nil$.MODULE$))));
        AggCallSelectivityEstimator estimator3 = new AggCallSelectivityEstimator((RelNode)agg3, this.mq());
        Assertions.assertEquals((Object)se.defaultEqualsSelectivity(), (Object)estimator3.evaluate(predicate1));
        FlinkStatistic statistic3 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$))}))));
        Aggregate agg4 = this.createAggregate(this.mockScan(statistic3), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), (List)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx())), (List)Nil$.MODULE$))));
        AggCallSelectivityEstimator estimator4 = new AggCallSelectivityEstimator((RelNode)agg4, this.mq());
        Assertions.assertEquals((Object)se.defaultEqualsSelectivity(), (Object)estimator4.evaluate(predicate1));
    }

    @Test
    public void testSumWithLessThan() {
        Aggregate agg1 = this.createAggregate(new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), (List)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx())), (List)Nil$.MODULE$))));
        SelectivityEstimator se = new SelectivityEstimator((RelNode)agg1, this.mq());
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(50L)}));
        AggCallSelectivityEstimator estimator1 = new AggCallSelectivityEstimator((RelNode)agg1, this.mq());
        Assertions.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate1));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20))))}))));
        Aggregate agg2 = this.createAggregate(this.mockScan(statistic1), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), (List)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx())), (List)Nil$.MODULE$))));
        AggCallSelectivityEstimator estimator2 = new AggCallSelectivityEstimator((RelNode)agg2, this.mq());
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(5L)}));
        Assertions.assertEquals((Object)estimator2.defaultAggCallSelectivity(), (Object)estimator2.evaluate(predicate2));
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(100L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - BoxesRunTime.unboxToDouble((Object)estimator1.defaultAggCallSelectivity().get())))), (Object)estimator2.evaluate(predicate3));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.25)), (Object)estimator2.evaluate(predicate1));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)None$.MODULE$))}))));
        Aggregate agg3 = this.createAggregate(this.mockScan(statistic2), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), (List)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx())), (List)Nil$.MODULE$))));
        AggCallSelectivityEstimator estimator3 = new AggCallSelectivityEstimator((RelNode)agg3, this.mq());
        Assertions.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator3.evaluate(predicate1));
    }

    @Test
    public void testSumWithLessThanOrEqualsTo() {
        Aggregate agg1 = this.createAggregate(new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), (List)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx())), (List)Nil$.MODULE$))));
        SelectivityEstimator se = new SelectivityEstimator((RelNode)agg1, this.mq());
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(50L)}));
        AggCallSelectivityEstimator estimator1 = new AggCallSelectivityEstimator((RelNode)agg1, this.mq());
        Assertions.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate1));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20))))}))));
        Aggregate agg2 = this.createAggregate(this.mockScan(statistic1), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), (List)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx())), (List)Nil$.MODULE$))));
        AggCallSelectivityEstimator estimator2 = new AggCallSelectivityEstimator((RelNode)agg2, this.mq());
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(5L)}));
        Assertions.assertEquals((Object)estimator2.defaultAggCallSelectivity(), (Object)estimator2.evaluate(predicate2));
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(100L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - BoxesRunTime.unboxToDouble((Object)estimator1.defaultAggCallSelectivity().get())))), (Object)estimator2.evaluate(predicate3));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.25)), (Object)estimator2.evaluate(predicate1));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)None$.MODULE$))}))));
        Aggregate agg3 = this.createAggregate(this.mockScan(statistic2), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), (List)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx())), (List)Nil$.MODULE$))));
        AggCallSelectivityEstimator estimator3 = new AggCallSelectivityEstimator((RelNode)agg3, this.mq());
        Assertions.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator3.evaluate(predicate1));
    }

    @Test
    public void testSumWithGreaterThan() {
        Aggregate agg1 = this.createAggregate(new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), (List)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx())), (List)Nil$.MODULE$))));
        SelectivityEstimator se = new SelectivityEstimator((RelNode)agg1, this.mq());
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(50L)}));
        AggCallSelectivityEstimator estimator1 = new AggCallSelectivityEstimator((RelNode)agg1, this.mq());
        Assertions.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate1));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20))))}))));
        Aggregate agg2 = this.createAggregate(this.mockScan(statistic1), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), (List)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx())), (List)Nil$.MODULE$))));
        AggCallSelectivityEstimator estimator2 = new AggCallSelectivityEstimator((RelNode)agg2, this.mq());
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(100L)}));
        Assertions.assertEquals((Object)estimator2.defaultAggCallSelectivity(), (Object)estimator2.evaluate(predicate2));
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(5L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - BoxesRunTime.unboxToDouble((Object)estimator1.defaultAggCallSelectivity().get())))), (Object)estimator2.evaluate(predicate3));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.75)), (Object)estimator2.evaluate(predicate1));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)None$.MODULE$))}))));
        Aggregate agg3 = this.createAggregate(this.mockScan(statistic2), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), (List)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx())), (List)Nil$.MODULE$))));
        AggCallSelectivityEstimator estimator3 = new AggCallSelectivityEstimator((RelNode)agg3, this.mq());
        Assertions.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator3.evaluate(predicate1));
    }

    @Test
    public void testSumWithGreaterThanOrEquals() {
        Aggregate agg1 = this.createAggregate(new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), (List)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx())), (List)Nil$.MODULE$))));
        SelectivityEstimator se = new SelectivityEstimator((RelNode)agg1, this.mq());
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(50L)}));
        AggCallSelectivityEstimator estimator1 = new AggCallSelectivityEstimator((RelNode)agg1, this.mq());
        Assertions.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate1));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20))))}))));
        Aggregate agg2 = this.createAggregate(this.mockScan(statistic1), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), (List)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx())), (List)Nil$.MODULE$))));
        AggCallSelectivityEstimator estimator2 = new AggCallSelectivityEstimator((RelNode)agg2, this.mq());
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(100L)}));
        Assertions.assertEquals((Object)estimator2.defaultAggCallSelectivity(), (Object)estimator2.evaluate(predicate2));
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(5L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - BoxesRunTime.unboxToDouble((Object)estimator1.defaultAggCallSelectivity().get())))), (Object)estimator2.evaluate(predicate3));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.75)), (Object)estimator2.evaluate(predicate1));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)None$.MODULE$))}))));
        Aggregate agg3 = this.createAggregate(this.mockScan(statistic2), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), (List)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx())), (List)Nil$.MODULE$))));
        AggCallSelectivityEstimator estimator3 = new AggCallSelectivityEstimator((RelNode)agg3, this.mq());
        Assertions.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator3.evaluate(predicate1));
    }

    @Test
    public void testMaxMin() {
        Aggregate agg1 = this.createAggregate(new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.MAX, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), (List)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.MIN, (Object)BoxesRunTime.boxToInteger((int)this.price_idx())), (List)Nil$.MODULE$))));
        SelectivityEstimator se = new SelectivityEstimator((RelNode)agg1, this.mq());
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(15L)}));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(2), this.createNumericLiteral(10L)}));
        AggCallSelectivityEstimator estimator1 = new AggCallSelectivityEstimator((RelNode)agg1, this.mq());
        Assertions.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate1));
        Assertions.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate2));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(20L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.double2Double(1.0)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.double2Double(30.0))))}))));
        Aggregate agg2 = this.createAggregate(this.mockScan(statistic1), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.MAX, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), (List)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.MIN, (Object)BoxesRunTime.boxToInteger((int)this.price_idx())), (List)Nil$.MODULE$))));
        AggCallSelectivityEstimator estimator2 = new AggCallSelectivityEstimator((RelNode)agg2, this.mq());
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(15L)}));
        RexNode predicate4 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(2), this.createNumericLiteral(50L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.1)), (Object)estimator2.evaluate(predicate3));
        Assertions.assertEquals((Object)estimator2.defaultAggCallSelectivity(), (Object)estimator2.evaluate(predicate4));
        RexNode predicate5 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(100L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - BoxesRunTime.unboxToDouble((Object)estimator1.defaultAggCallSelectivity().get())))), (Object)estimator2.evaluate(predicate5));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.5)), (Object)estimator2.evaluate(predicate1));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.3103448275862069)), (Object)estimator2.evaluate(predicate2));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)None$.MODULE$))}))));
        Aggregate agg3 = this.createAggregate(this.mockScan(statistic2), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.MIN, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), (List)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.MAX, (Object)BoxesRunTime.boxToInteger((int)this.price_idx())), (List)Nil$.MODULE$))));
        AggCallSelectivityEstimator estimator3 = new AggCallSelectivityEstimator((RelNode)agg3, this.mq());
        Assertions.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator3.evaluate(predicate1));
        Assertions.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator3.evaluate(predicate2));
    }

    @Test
    public void testAvg() {
        Aggregate agg1 = this.createAggregate(new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.AVG, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), (List)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.AVG, (Object)BoxesRunTime.boxToInteger((int)this.price_idx())), (List)Nil$.MODULE$))));
        SelectivityEstimator se = new SelectivityEstimator((RelNode)agg1, this.mq());
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(15L)}));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(2), this.createNumericLiteral(10L)}));
        AggCallSelectivityEstimator estimator1 = new AggCallSelectivityEstimator((RelNode)agg1, this.mq());
        Assertions.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate1));
        Assertions.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate2));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(20L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.double2Double(1.0)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.double2Double(30.0))))}))));
        Aggregate agg2 = this.createAggregate(this.mockScan(statistic1), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.AVG, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), (List)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.AVG, (Object)BoxesRunTime.boxToInteger((int)this.price_idx())), (List)Nil$.MODULE$))));
        AggCallSelectivityEstimator estimator2 = new AggCallSelectivityEstimator((RelNode)agg2, this.mq());
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(15L)}));
        RexNode predicate4 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(2), this.createNumericLiteral(50L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.1)), (Object)estimator2.evaluate(predicate3));
        Assertions.assertEquals((Object)estimator2.defaultAggCallSelectivity(), (Object)estimator2.evaluate(predicate4));
        RexNode predicate5 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(100L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - BoxesRunTime.unboxToDouble((Object)estimator1.defaultAggCallSelectivity().get())))), (Object)estimator2.evaluate(predicate5));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.5)), (Object)estimator2.evaluate(predicate1));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.3103448275862069)), (Object)estimator2.evaluate(predicate2));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)None$.MODULE$))}))));
        Aggregate agg3 = this.createAggregate(this.mockScan(statistic2), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.AVG, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), (List)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.AVG, (Object)BoxesRunTime.boxToInteger((int)this.price_idx())), (List)Nil$.MODULE$))));
        AggCallSelectivityEstimator estimator3 = new AggCallSelectivityEstimator((RelNode)agg3, this.mq());
        Assertions.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator3.evaluate(predicate1));
        Assertions.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator3.evaluate(predicate2));
    }

    @Test
    public void testCount() {
        Aggregate agg1 = this.createAggregate(new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.COUNT, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), (List)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.COUNT, (Object)BoxesRunTime.boxToInteger((int)this.price_idx())), (List)Nil$.MODULE$))));
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(6L)}));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(2), this.createNumericLiteral(5L)}));
        AggCallSelectivityEstimator estimator1 = new AggCallSelectivityEstimator((RelNode)agg1, this.mq());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.9526830054771714)), (Object)estimator1.evaluate(predicate1));
        Assertions.assertEquals((Object)estimator1.defaultAggCallSelectivity(), (Object)estimator1.evaluate(predicate2));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(20L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.double2Double(1.0)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.double2Double(30.0))))}))));
        Aggregate agg2 = this.createAggregate(this.mockScan(statistic1), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.COUNT, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), (List)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.COUNT, (Object)BoxesRunTime.boxToInteger((int)this.price_idx())), (List)Nil$.MODULE$))));
        AggCallSelectivityEstimator estimator2 = new AggCallSelectivityEstimator((RelNode)agg2, this.mq());
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(6L)}));
        RexNode predicate4 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(2), this.createNumericLiteral(10L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.16666666666666666)), (Object)estimator2.evaluate(predicate3));
        Assertions.assertEquals((Object)estimator2.defaultAggCallSelectivity(), (Object)estimator2.evaluate(predicate4));
        RexNode predicate5 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(10L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - BoxesRunTime.unboxToDouble((Object)estimator1.defaultAggCallSelectivity().get())))), (Object)estimator2.evaluate(predicate5));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.3333333333333333)), (Object)estimator2.evaluate(predicate1));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.5)), (Object)estimator2.evaluate(predicate2));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)None$.MODULE$))}))));
        Aggregate agg3 = this.createAggregate(this.mockScan(statistic2), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.COUNT, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), (List)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.COUNT, (Object)BoxesRunTime.boxToInteger((int)this.price_idx())), (List)Nil$.MODULE$))));
        AggCallSelectivityEstimator estimator3 = new AggCallSelectivityEstimator((RelNode)agg3, this.mq());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.3333333333333333)), (Object)estimator3.evaluate(predicate1));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.5)), (Object)estimator3.evaluate(predicate2));
    }

    @Test
    public void testAnd() {
        Aggregate agg1 = this.createAggregate(new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), (List)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx())), (List)Nil$.MODULE$))));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(20L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.double2Double(1.0)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.double2Double(30.0))))}))));
        Aggregate agg = this.createAggregate(this.mockScan(statistic1), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), (List)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx())), (List)Nil$.MODULE$))));
        AggCallSelectivityEstimator estimator = new AggCallSelectivityEstimator((RelNode)agg, this.mq());
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.AND, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(50L)})), this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(2), this.createNumericLiteral(10L)}))}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.23706896551724138)), (Object)estimator.evaluate(predicate));
    }

    @Test
    public void testOr() {
        Aggregate agg1 = this.createAggregate(new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), (List)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx())), (List)Nil$.MODULE$))));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(20L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.double2Double(1.0)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.double2Double(30.0))))}))));
        Aggregate agg = this.createAggregate(this.mockScan(statistic1), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), (List)new .colon.colon((Object)new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx())), (List)Nil$.MODULE$))));
        AggCallSelectivityEstimator estimator = new AggCallSelectivityEstimator((RelNode)agg, this.mq());
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.OR, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(50L)})), this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(2), this.createNumericLiteral(10L)}))}));
        double s1 = 0.25;
        double s2 = 0.9482758620689655;
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(s1 + s2 - s1 * s2))), (Object)estimator.evaluate(predicate));
    }

    public AggCallSelectivityEstimatorTest() {
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2));
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        int name_idx = BoxesRunTime.unboxToInt((Object)tuple3._1());
        int amount_idx = BoxesRunTime.unboxToInt((Object)tuple3._2());
        int price_idx = BoxesRunTime.unboxToInt((Object)tuple3._3());
        this.x$1 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)name_idx), (Object)BoxesRunTime.boxToInteger((int)amount_idx), (Object)BoxesRunTime.boxToInteger((int)price_idx));
        this.name_idx = BoxesRunTime.unboxToInt((Object)this.x$1._1());
        this.amount_idx = BoxesRunTime.unboxToInt((Object)this.x$1._2());
        this.price_idx = BoxesRunTime.unboxToInt((Object)this.x$1._3());
        this.typeFactory = new FlinkTypeFactory(Thread.currentThread().getContextClassLoader(), (RelDataTypeSystem)FlinkTypeSystem.INSTANCE);
        this.rexBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        this.relDataType = this.typeFactory().createStructType(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)this.allFieldTypes().map((Function1 & Serializable & scala.Serializable)typeName -> this.typeFactory().createSqlType(typeName), Seq$.MODULE$.canBuildFrom())), JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList(this.allFieldNames()));
        this.mq = FlinkRelMetadataQuery.instance();
    }
}

