/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.hints.batch;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.flink.shaded.curator5.org.apache.curator.shaded.com.google.common.collect.Lists;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.SqlParserException;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.planner.hint.JoinStrategy;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.PlanKind;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.logging.log4j.util.Strings;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Enumeration;
import scala.Function0;
import scala.runtime.BoxedUnit;

public abstract class JoinHintTestBase
extends TableTestBase {
    protected BatchTableTestUtil util;
    private final List<String> allJoinHintNames = Lists.newArrayList((Object[])JoinStrategy.values()).stream().filter(hint -> hint != JoinStrategy.LOOKUP).map(JoinStrategy::getJoinHintName).collect(Collectors.toList());

    @BeforeEach
    void before() {
        this.util = this.batchTestUtil(TableConfig.getDefault());
        this.util.tableEnv().executeSql("CREATE TABLE T1 (\n  a1 BIGINT,\n  b1 VARCHAR\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)");
        this.util.tableEnv().executeSql("CREATE TABLE T2 (\n  a2 BIGINT,\n  b2 VARCHAR\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)");
        this.util.tableEnv().executeSql("CREATE TABLE T3 (\n  a3 BIGINT,\n  b3 VARCHAR\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)");
        this.util.tableEnv().executeSql("CREATE View V4 as select a3 as a4, b3 as b4 from T3");
        this.util.tableEnv().executeSql("create view V5 as select T1.* from T1 join T2 on T1.a1 = T2.a2");
    }

    protected abstract String getTestSingleJoinHint();

    protected abstract String getDisabledOperatorName();

    protected void verifyRelPlanByCustom(String sql) {
        this.util.doVerifyPlan(sql, new ExplainDetail[0], false, new Enumeration.Value[]{PlanKind.AST(), PlanKind.OPT_REL()}, true);
    }

    protected void verifyRelPlanByCustom(StatementSet set) {
        this.util.doVerifyPlan(set, new ExplainDetail[0], false, new Enumeration.Value[]{PlanKind.AST(), PlanKind.OPT_REL()}, (Function0<BoxedUnit>)((Function0)() -> BoxedUnit.UNIT), true);
    }

    protected List<String> getOtherJoinHints() {
        return this.allJoinHintNames.stream().filter(name -> !name.equals(this.getTestSingleJoinHint())).collect(Collectors.toList());
    }

    @Test
    void testSimpleJoinHintWithLeftSideAsBuildSide() {
        String sql = "select /*+ %s(T1) */* from T1 join T2 on T1.a1 = T2.a2";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testSimpleJoinHintWithRightSideAsBuildSide() {
        String sql = "select /*+ %s(T2) */* from T1 join T2 on T1.a1 = T2.a2";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintWithMultiJoinAndFirstSideAsBuildSide1() {
        String sql = "select /*+ %s(T1, T2) */* from T1, T2, T3 where T1.a1 = T2.a2 and T1.b1 = T3.b3";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintWithMultiJoinAndFirstSideAsBuildSide2() {
        String sql = "select /*+ %s(T1, T2) */* from T1, T2, T3 where T1.a1 = T2.a2 and T2.b2 = T3.b3";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintWithMultiJoinAndSecondThirdSideAsBuildSides1() {
        String sql = "select /*+ %s(T2, T3) */* from T1, T2, T3 where T1.a1 = T2.a2 and T1.b1 = T3.b3";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintWithMultiJoinAndSecondThirdSideAsBuildSides2() {
        String sql = "select /*+ %s(T2, T3) */* from T1, T2, T3 where T1.a1 = T2.a2 and T2.b2 = T3.b3";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintWithMultiJoinAndFirstThirdSideAsBuildSides() {
        String sql = "select /*+ %s(T1, T3) */* from T1, T2, T3 where T1.a1 = T2.a2 and T2.b2 = T3.b3";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintWithUnknownTable() {
        String sql = "select /*+ %s(T99) */* from T1 join T2 on T1.a1 = T2.a2";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()))).isInstanceOf(ValidationException.class)).hasMessageContaining("The options of following hints cannot match the name of input tables or views: \n`%s` in `%s`", new Object[]{"T99", this.getTestSingleJoinHint()});
    }

    @Test
    void testJoinHintWithUnknownTableNameMixedWithValidTableNames1() {
        String sql = "select /*+ %s(T1, T99) */* from T1 join T2 on T1.a1 = T2.a2";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()))).isInstanceOf(ValidationException.class)).hasMessageContaining("The options of following hints cannot match the name of input tables or views: \n`%s` in `%s`", new Object[]{"T99", this.getTestSingleJoinHint()});
    }

    @Test
    void testJoinHintWithUnknownTableNameMixedWithValidTableNames2() {
        String sql = "select /*+ %s(T1, T99, T2) */* from T1 join T2 on T1.a1 = T2.a2";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()))).isInstanceOf(ValidationException.class)).hasMessageContaining("The options of following hints cannot match the name of input tables or views: \n`%s` in `%s`", new Object[]{"T99", this.getTestSingleJoinHint()});
    }

    @Test
    void testJoinHintWithMultiUnknownTableNamesMixedWithValidTableNames() {
        String sql = "select /*+ %s(T1, T99, T98) */* from T1 join T2 on T1.a1 = T2.a2";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()))).isInstanceOf(ValidationException.class)).hasMessageContaining("The options of following hints cannot match the name of input tables or views: \n`%s` in `%s`", new Object[]{"T98, T99", this.getTestSingleJoinHint()});
    }

    @Test
    void testJoinHintWithView() {
        String sql = "select /*+ %s(V4) */* from T1 join V4 on T1.a1 = V4.a4";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintWithUnknownView() {
        String sql = "select /*+ %s(V99) */* from T1 join V4 on T1.a1 = V4.a4";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()))).isInstanceOf(ValidationException.class)).hasMessageContaining("The options of following hints cannot match the name of input tables or views: \n`%s` in `%s`", new Object[]{"V99", this.getTestSingleJoinHint()});
    }

    @Test
    void testJoinHintWithEquiPred() {
        String sql = "select /*+ %s(T1) */* from T1, T2 where T1.a1 = T2.a2";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintWithEquiPredAndFilter() {
        String sql = "select /*+ %s(T1) */* from T1, T2 where T1.a1 = T2.a2 and T1.a1 > 1";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintWithEquiAndLocalPred() {
        String sql = "select /*+ %s(T1) */* from T1 inner join T2 on T1.a1 = T2.a2 and T1.a1 < 1";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintWithEquiAndNonEquiPred() {
        String sql = "select /*+ %s(T1) */* from T1 inner join T2 on T1.b1 = T2.b2 and T1.a1 < 1 and T1.a1 < T2.a2";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintWithoutJoinPred() {
        String sql = "select /*+ %s(T1) */* from T1, T2";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintWithNonEquiPred() {
        String sql = "select /*+ %s(T1) */* from T1 inner join T2 on T1.a1 > T2.a2";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintWithLeftJoinAndLeftSideAsBuildSide() {
        String sql = "select /*+ %s(T1) */* from T1 left join T2 on T1.a1 = T2.a2";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintWithLeftJoinAndRightSideAsBuildSide() {
        String sql = "select /*+ %s(T2) */* from T1 left join T2 on T1.a1 = T2.a2";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintWithRightJoinAndLeftSideAsBuildSide() {
        String sql = "select /*+ %s(T1) */* from T1 right join T2 on T1.a1 = T2.a2";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintWithRightJoinAndRightSideAsBuildSide() {
        String sql = "select /*+ %s(T2) */* from T1 right join T2 on T1.a1 = T2.a2";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintWithFullJoinAndLeftSideAsBuildSide() {
        String sql = "select /*+ %s(T1) */* from T1 full join T2 on T1.a1 = T2.a2";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintWithFullJoinAndRightSideAsBuildSide() {
        String sql = "select /*+ %s(T2) */* from T1 full join T2 on T1.a1 = T2.a2";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintWithSemiJoinAndLeftSideAsBuildSide() {
        String sql = "select /*+ %s(T1) */* from T1 where a1 in (select a2 from T2)";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintWithSemiJoinAndRightSideAsBuildSide() {
        String sql = "select /*+ %s(T2) */* from T1 where a1 in (select a2 from T2)";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintWithAntiJoinAndLeftSideAsBuildSide() {
        String sql = "select /*+ %s(T1) */* from T1 where a1 not in (select a2 from T2)";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintWithAntiJoinAndRightSideAsBuildSide() {
        String sql = "select /*+ %s(T2) */* from T1 where a1 not in (select a2 from T2)";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintWithMultiArgsAndLeftSideFirst() {
        String sql = "select /*+ %s(T1, T2) */* from T1 right join T2 on T1.a1 = T2.a2";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintWithMultiArgsAndRightSideFirst() {
        String sql = "select /*+ %s(T2, T1) */* from T1 right join T2 on T1.a1 = T2.a2";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testMultiJoinHints() {
        String sql = "select /*+ %s(T1), %s */* from T1 join T2 on T1.a1 = T2.a2";
        String otherJoinHints = Strings.join((Iterable)this.getOtherJoinHints().stream().map(name -> String.format("%s(T1)", name)).collect(Collectors.toList()), (char)',');
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint(), otherJoinHints));
    }

    @Test
    void testMultiJoinHintsWithTheFirstOneIsInvalid() {
        String sql = "select /*+ %s(T1), NEST_LOOP(T1) */* from T1 join T2 on T1.a1 > T2.a2";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintWithoutAffectingJoinInViewWhileArgsCanBeFoundInOuterJoin() {
        String sql = "select /*+ %s(T1)*/T1.* from T1 join V5 on T1.a1 = V5.a1";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintWithoutAffectingJoinInViewWhileOuterQueryIsNotJoin() {
        String sql = "select /*+ %s(T1)*/* from V5";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintWithoutAffectingJoinInViewWhileRootOfViewIsFilter() {
        this.util.tableEnv().executeSql("create view V2 as select T1.* from T1 join T2 on T1.a1 = T2.a2 where T1.b1 = 'abc'");
        String sql = "select /*+ %s(T1)*/* from V2";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintWithSimpleSumInSelectList() {
        String sql = "select /*+ %s(T1)*/T1.b1, sum(T1.a1) from T1 join T2 on T1.b1 = T2.b2 group by T1.b1";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintWithCastInSelectList() {
        String sql = "select /*+ %s(T1)*/T1.b1, cast(T1.a1 as int) from T1 join T2 on T1.b1 = T2.b2";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintWithoutAffectingJoinInSubQueryWhileArgsCanBeFoundInOuterJoin() {
        String sql = "select /*+ %s(T1)*/T1.* from T1 join (select T1.* from T1 join T2 on T1.a1 = T2.a2) V2 on T1.a1 = V2.a1";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintWithoutAffectingJoinInSubQueryWhileOuterQueryIsNotJoin() {
        String sql = "select /*+ %s(T1)*/* from (select T1.* from T1 join T2 on T1.a1 = T2.a2)";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintWithoutAffectingJoinInSubQueryWhileRootOfSubQueryIsFilter() {
        String sql = "select /*+ %s(T1)*/* from (select T1.* from T1 join T2 on T1.a1 = T2.a2 where T1.b1 = 'abc')";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintWithoutAffectingJoinInSubQueryWhileContainsSumInQueryBlock() {
        String sql = "select /*+ %s(T1)*/T4.a1, (select count(*) from T1 join T3 on T1.a1 = T3.a3) as cnt from (select T1.* from T1 join T2 on T1.a1 = T2.a2 where T1.b1 = 'abc') T4";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintWithoutAffectingJoinInSubQueryWhileContainsUnionAndJoinInSelectList() {
        String sql = "select /*+ %s(T1)*/T4.a1, (select count(*) from T1 join ((select T1.a1 as a3 from T1) union (select a3 from T3)) T3 on T1.a1 = T3.a3 where T3.a3 = 1) as cnt from (select T1.* from T1 join T2 on T1.a1 = T2.a2) T4";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintWithoutAffectingJoinInSubQueryWhileContainsUnionAndJoinInSelectFrom() {
        String sql = "select /*+ %s(T1)*/T4.a1 from (select T1.* from T1 join ((select T1.a1 as a2 from T1) union (select a2 from T2)) T2 on T1.a1 = T2.a2) T4";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintWithTableAlias() {
        String sql = "select /*+ %s(V2)*/T1.* from T1 join (select T1.* from T1 join T2 on T1.a1 = T2.a2) V2 on T1.a1 = V2.a1";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintsWithMultiSameJoinHintsAndSingleArg() {
        String sql = "select /*+ %s(T1), %s(T2) */* from T1 join T2 on T1.a1 = T2.a2";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint(), this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintsWithDuplicatedArgs() {
        String sql = "select /*+ %s(T1, T1) */* from T1 join T2 on T1.a1 = T2.a2";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint(), this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintsWithMultiSameJoinHintsAndMultiArgs() {
        String sql = "select /*+ %s(T1, T2), %s(T2, T1) */* from T1 join T2 on T1.a1 = T2.a2";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint(), this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintsWithMultiHintsThrowException() {
        String sql = "select /*+ %s(T1) */ /*+ %s(T2) */ * from T1 join T2 on T1.a1 = T2.a2";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint(), this.getTestSingleJoinHint()))).isInstanceOf(SqlParserException.class)).hasMessageContaining("SQL parse failed.");
    }

    @Test
    void testJoinHintWithDisabledOperator() {
        this.util.tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)this.getDisabledOperatorName());
        String sql = "select /*+ %s(T1) */* from T1 join T2 on T1.a1 = T2.a2";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintsWithUnion() {
        String sql = "select /*+ %s(T1) */* from T1 join T2 on T1.a1 = T2.a2 union select /*+ %s(T3) */* from T3 join T1 on T3.a3 = T1.a1";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint(), this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintsWithFilter() {
        String sql = "select /*+ %s(T1) */* from T1 join T2 on T1.a1 = T2.a2 where T1.a1 > 5";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintsWithCalc() {
        String sql = "select /*+ %s(T1) */a1 + 1, a1 * 10 from T1 join T2 on T1.a1 = T2.a2";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintInView() {
        this.util.tableEnv().executeSql(String.format("create view V2 as select /*+ %s(T1)*/ T1.* from T1 join T2 on T1.a1 = T2.a2", this.getTestSingleJoinHint()));
        String sql = "select /*+ %s(V2)*/T3.* from T3 join V2 on T3.a3 = V2.a1";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintInMultiLevelView() {
        this.util.tableEnv().executeSql(String.format("create view V2 as select /*+ %s(T1)*/ T1.* from T1 join T2 on T1.a1 = T2.a2", this.getTestSingleJoinHint()));
        this.util.tableEnv().executeSql(String.format("create view V3 as select /*+ %s(V2)*/ T1.* from T1 join V2 on T1.a1 = V2.a1", this.getTestSingleJoinHint()));
        String sql = "select /*+ %s(V3)*/V3.* from V3 join T1 on V3.a1 = T1.a1";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintsOnSameViewWithoutReusingView() {
        this.util.tableEnv().executeSql(String.format("create view V2 as select /*+ %s(T1)*/ T1.* from T1 join T2 on T1.a1 = T2.a2", this.getTestSingleJoinHint()));
        this.util.tableEnv().executeSql("CREATE TABLE S1 (\n  a1 BIGINT,\n  b1 VARCHAR\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)");
        this.util.tableEnv().executeSql("CREATE TABLE S2 (\n  a1 BIGINT,\n  b1 VARCHAR\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)");
        StatementSet set = this.util.tableEnv().createStatementSet();
        set.addInsertSql(String.format("insert into S1 select /*+ %s(V2)*/ T1.* from T1 join V2 on T1.a1 = V2.a1 where V2.a1 > 2", this.getTestSingleJoinHint()));
        set.addInsertSql(String.format("insert into S2 select /*+ %s(T1)*/ T1.* from T1 join V2 on T1.a1 = V2.a1 where V2.a1 > 5", this.getTestSingleJoinHint()));
        this.verifyRelPlanByCustom(set);
    }

    @Test
    void testJoinHintsOnSameViewWithReusingView() {
        this.util.tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_OPTIMIZE_BLOCK_WITH_DIGEST_ENABLED, (Object)true);
        this.util.tableEnv().executeSql(String.format("create view V2 as select /*+ %s(T1)*/ T1.* from T1 join T2 on T1.a1 = T2.a2", this.getTestSingleJoinHint()));
        this.util.tableEnv().executeSql("CREATE TABLE S1 (\n  a1 BIGINT,\n  b1 VARCHAR\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)");
        this.util.tableEnv().executeSql("CREATE TABLE S2 (\n  a1 BIGINT,\n  b1 VARCHAR\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)");
        StatementSet set = this.util.tableEnv().createStatementSet();
        set.addInsertSql(String.format("insert into S1 select /*+ %s(V2)*/ T1.* from T1 join V2 on T1.a1 = V2.a1 where V2.a1 > 2", this.getTestSingleJoinHint()));
        set.addInsertSql(String.format("insert into S2 select /*+ %s(T1)*/ T1.* from T1 join V2 on T1.a1 = V2.a1 where V2.a1 > 5", this.getTestSingleJoinHint()));
        this.verifyRelPlanByCustom(set);
    }

    @Test
    void testJoinHintsOnSameViewWithoutReusingViewBecauseDifferentJoinHints() {
        this.util.tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_OPTIMIZE_BLOCK_WITH_DIGEST_ENABLED, (Object)true);
        this.util.tableEnv().executeSql(String.format("create view V2 as select /*+ %s(T1)*/ T1.* from T1 join T2 on T1.a1 = T2.a2", this.getTestSingleJoinHint()));
        this.util.tableEnv().executeSql(String.format("create view V3 as select /*+ %s(T1)*/ T1.* from T1 join T2 on T1.a1 = T2.a2", this.getOtherJoinHints().get(0)));
        this.util.tableEnv().executeSql("CREATE TABLE S1 (\n  a1 BIGINT,\n  b1 VARCHAR\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)");
        this.util.tableEnv().executeSql("CREATE TABLE S2 (\n  a1 BIGINT,\n  b1 VARCHAR\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)");
        StatementSet set = this.util.tableEnv().createStatementSet();
        set.addInsertSql(String.format("insert into S1 select /*+ %s(V2)*/ T1.* from T1 join V2 on T1.a1 = V2.a1 where V2.a1 > 2", this.getTestSingleJoinHint()));
        set.addInsertSql(String.format("insert into S2 select /*+ %s(T1)*/ T1.* from T1 join V3 on T1.a1 = V3.a1 where V3.a1 > 5", this.getOtherJoinHints().get(0)));
        this.verifyRelPlanByCustom(set);
    }

    @Test
    void testJoinHintWithSubStringViewName1() {
        this.util.tableEnv().executeSql(String.format("create view V2 as select /*+ %s(T1)*/ T1.* from T1 join T2 on T1.a1 = T2.a2", this.getTestSingleJoinHint()));
        this.util.tableEnv().executeSql(String.format("create view V22 as select /*+ %s(V2)*/ T1.* from T1 join V2 on T1.a1 = V2.a1", this.getTestSingleJoinHint()));
        String sql = "select /*+ %s(V22)*/V22.* from V22 join T1 on V22.a1 = T1.a1";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintWithSubStringViewName2() {
        this.util.tableEnv().executeSql(String.format("create view V22 as select /*+ %s(T1)*/ T1.* from T1 join T2 on T1.a1 = T2.a2", this.getTestSingleJoinHint()));
        this.util.tableEnv().executeSql(String.format("create view V2 as select /*+ %s(V22)*/ T1.* from T1 join V22 on T1.a1 = V22.a1", this.getTestSingleJoinHint()));
        String sql = "select /*+ %s(V2)*/V2.* from V2 join T1 on V2.a1 = T1.a1";
        this.verifyRelPlanByCustom(String.format(sql, this.getTestSingleJoinHint()));
    }

    @Test
    void testJoinHintWithoutCaseSensitive() {
        String sql = "select /*+ %s(T1) */* from T1 join T2 on T1.a1 = T2.a2";
        this.verifyRelPlanByCustom(String.format(sql, this.buildCaseSensitiveStr(this.getTestSingleJoinHint())));
    }

    @Test
    void testJoinHintWithJoinHintInSubQuery() {
        String sql = "select * from T1 WHERE a1 IN (select /*+ %s(T2) */ a2 from T2 join T3 on T2.a2 = T3.a3)";
        this.verifyRelPlanByCustom(String.format(sql, this.buildCaseSensitiveStr(this.getTestSingleJoinHint())));
    }

    @Test
    void testJoinHintWithJoinHintInCorrelateAndWithFilter() {
        String sql = "select * from T1 WHERE a1 IN (select /*+ %s(T2) */ a2 from T2 join T3 on T2.a2 = T3.a3 where T1.a1 = T2.a2)";
        this.verifyRelPlanByCustom(String.format(sql, this.buildCaseSensitiveStr(this.getTestSingleJoinHint())));
    }

    @Test
    void testJoinHintWithJoinHintInCorrelateAndWithProject() {
        String sql = "select * from T1 WHERE a1 IN (select /*+ %s(T2) */ a2 + T1.a1 from T2 join T3 on T2.a2 = T3.a3)";
        this.verifyRelPlanByCustom(String.format(sql, this.buildCaseSensitiveStr(this.getTestSingleJoinHint())));
    }

    @Test
    void testJoinHintWithJoinHintInCorrelateAndWithAgg() {
        String sql = "select * from T1 WHERE a1 IN (select /*+ %s(T2) */ count(T2.a2) from T2 join T1 on T2.a2 = T1.a1 group by T1.a1)";
        this.verifyRelPlanByCustom(String.format(sql, this.buildCaseSensitiveStr(this.getTestSingleJoinHint())));
    }

    @Test
    void testJoinHintWithJoinHintInCorrelateAndWithSortLimit() {
        String sql = "select * from T1 WHERE a1 IN (select /*+ %s(T2) */ T2.a2 from T2 join T1 on T2.a2 = T1.a1 order by T1.a1 limit 10)";
        this.verifyRelPlanByCustom(String.format(sql, this.buildCaseSensitiveStr(this.getTestSingleJoinHint())));
    }

    @Test
    public void testJoinHintWithJoinHintInNestedCorrelatedSubQuery() {
        String sql = "select * from T1 WHERE a1 IN (select /*+ %s(T2) */ a2 + T1.a1 from T2 join (select T3.* from T2 join T3 on T2.a2 = T3.a3) T3 on T2.a2 = T3.a3)";
        this.verifyRelPlanByCustom(String.format(sql, this.buildCaseSensitiveStr(this.getTestSingleJoinHint())));
    }

    protected String buildAstPlanWithQueryBlockAlias(List<RelNode> relNodes) {
        StringBuilder astBuilder = new StringBuilder();
        relNodes.forEach(node -> astBuilder.append(System.lineSeparator()).append(FlinkRelOptUtil.toString((RelNode)node, (SqlExplainLevel)SqlExplainLevel.EXPPLAN_ATTRIBUTES, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)true)));
        return astBuilder.toString();
    }

    private String buildCaseSensitiveStr(String str) {
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            boolean needCapitalize = i % 2 == 0;
            chars[i] = needCapitalize ? Character.toUpperCase(chars[i]) : Character.toLowerCase(chars[i]);
        }
        return new String(chars);
    }
}

