/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.common;

import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import net.javacrumbs.jsonunit.core.Option;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.flink.streaming.api.environment.CheckpointConfig;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.graph.StreamGraphGenerator;
import org.apache.flink.streaming.api.lineage.LineageGraph;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class TableLineageGraphTestBase
extends TableTestBase {
    private static final String RESOURCE_PATH = "src/test/resources/lineage-graph/";
    private final ObjectMapper mapper = new ObjectMapper();
    private TableTestUtil util;
    private final String query = "SELECT\n  AVG(a) AS avg_a,\n  COUNT(*) AS cnt,\n  count(b) AS cnt_b,\n  min(b) AS min_b,\n  MAX(c) FILTER (WHERE a > 1) AS max_c\nFROM FirstTable";
    private final String lookupJoin = "";
    private final String union = "(SELECT\n  AVG(a) AS avg_a,\n  COUNT(*) AS cnt,\n  count(b) AS cnt_b,\n  min(b) AS min_b,\n  MAX(c) FILTER (WHERE a > 1) AS max_c\nFROM FirstTable) UNION \n(SELECT\n  AVG(a) AS avg_a,\n  COUNT(*) AS cnt,\n  count(b) AS cnt_b,\n  min(b) AS min_b,\n  MAX(c) FILTER (WHERE a > 1) AS max_c\nFROM SecondTable)";

    protected abstract boolean isBatchMode();

    protected abstract TableTestUtil getTableTestUtil();

    @BeforeEach
    void setup() {
        this.mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.util = this.getTableTestUtil();
        this.util.getTableEnv().executeSql("CREATE TABLE FirstTable (\n  a BIGINT,\n  b INT NOT NULL,\n  c VARCHAR,\n  d BIGINT\n) WITH (\n  'connector' = 'values',\n  'bounded' = '" + this.isBatchMode() + "')");
        this.util.getTableEnv().executeSql("CREATE TABLE SecondTable (\n  a BIGINT,\n  b INT NOT NULL,\n  c VARCHAR,\n  d BIGINT\n) WITH (\n  'connector' = 'values',\n  'bounded' = '" + this.isBatchMode() + "')");
        this.util.getTableEnv().executeSql("CREATE TABLE SinkTable (\n  avg_a DOUBLE,\n  cnt BIGINT,\n  cnt_b BIGINT,\n  min_b BIGINT,\n  max_c VARCHAR\n) WITH (\n  'connector' = 'values',\n  'sink-insert-only' = 'false')");
    }

    @Test
    void testInsertWithSelect() throws Exception {
        List<Transformation<?>> transformations = this.util.generateTransformations(String.format("INSERT INTO SinkTable\n%s", "SELECT\n  AVG(a) AS avg_a,\n  COUNT(*) AS cnt,\n  count(b) AS cnt_b,\n  min(b) AS min_b,\n  MAX(c) FILTER (WHERE a > 1) AS max_c\nFROM FirstTable"));
        LineageGraph lineageGraph = this.generateLineageGraph(transformations);
        this.verify(lineageGraph, this.isBatchMode() ? "query-batch.json" : "query-stream.json");
    }

    @Test
    void testInsertWithUnion() throws Exception {
        List<Transformation<?>> transformations = this.util.generateTransformations(String.format("INSERT INTO SinkTable\n%s", "(SELECT\n  AVG(a) AS avg_a,\n  COUNT(*) AS cnt,\n  count(b) AS cnt_b,\n  min(b) AS min_b,\n  MAX(c) FILTER (WHERE a > 1) AS max_c\nFROM FirstTable) UNION \n(SELECT\n  AVG(a) AS avg_a,\n  COUNT(*) AS cnt,\n  count(b) AS cnt_b,\n  min(b) AS min_b,\n  MAX(c) FILTER (WHERE a > 1) AS max_c\nFROM SecondTable)"));
        LineageGraph lineageGraph = this.generateLineageGraph(transformations);
        this.verify(lineageGraph, this.isBatchMode() ? "union-batch.json" : "union-stream.json");
    }

    private LineageGraph generateLineageGraph(List<Transformation<?>> transformations) {
        StreamGraphGenerator streamGraphGenerator = new StreamGraphGenerator(transformations, new ExecutionConfig(), new CheckpointConfig());
        StreamGraph graph = streamGraphGenerator.generate();
        LineageGraph lineageGraph = graph.getLineageGraph();
        return lineageGraph;
    }

    private void verify(LineageGraph lineageGraph, String jsonPath) throws Exception {
        String json = this.mapper.writeValueAsString((Object)lineageGraph);
        String expected = new String(Files.readAllBytes(Paths.get(RESOURCE_PATH + jsonPath, new String[0])));
        JsonAssertions.assertThatJson((Object)json).when(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)expected);
    }
}

