/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql.agg;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Timestamp;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.batch.sql.agg.OverAggregateTest$;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Ub\u0001\u0002\u0013&\u0001aBQa\u0010\u0001\u0005\u0002\u0001Cqa\u0011\u0001C\u0002\u0013%A\t\u0003\u0004I\u0001\u0001\u0006I!\u0012\u0005\u0006\u0013\u0002!\tA\u0013\u0005\u00069\u0002!\tA\u0013\u0005\u0006=\u0002!\tA\u0013\u0005\u0006A\u0002!\tA\u0013\u0005\u0006E\u0002!\tA\u0013\u0005\u0006I\u0002!\tA\u0013\u0005\u0006M\u0002!\tA\u0013\u0005\u0006Q\u0002!\tA\u0013\u0005\u0006U\u0002!\tA\u0013\u0005\u0006Y\u0002!\tA\u0013\u0005\u0006]\u0002!\tA\u0013\u0005\u0006a\u0002!\tA\u0013\u0005\u0006e\u0002!\tA\u0013\u0005\u0006i\u0002!\tA\u0013\u0005\u0006m\u0002!\tA\u0013\u0005\u0006q\u0002!\tA\u0013\u0005\u0006u\u0002!\tA\u0013\u0005\u0006y\u0002!\tA\u0013\u0005\u0006}\u0002!\tA\u0013\u0005\u0007\u0003\u0003\u0001A\u0011\u0001&\t\r\u0005\u0015\u0001\u0001\"\u0001K\u0011\u0019\tI\u0001\u0001C\u0001\u0015\"1\u0011Q\u0002\u0001\u0005\u0002)Ca!!\u0005\u0001\t\u0003Q\u0005BBA\u000b\u0001\u0011\u0005!\n\u0003\u0004\u0002\u001a\u0001!\tA\u0013\u0005\u0007\u0003;\u0001A\u0011\u0001&\t\r\u0005\u0005\u0002\u0001\"\u0001K\u0011\u0019\t)\u0003\u0001C\u0001\u0015\"1\u0011\u0011\u0006\u0001\u0005\u0002)Ca!!\f\u0001\t\u0003Q\u0005BBA\u0019\u0001\u0011\u0005!JA\tPm\u0016\u0014\u0018iZ4sK\u001e\fG/\u001a+fgRT!AJ\u0014\u0002\u0007\u0005<wM\u0003\u0002)S\u0005\u00191/\u001d7\u000b\u0005)Z\u0013!\u00022bi\u000eD'B\u0001\u0017.\u0003\u0011\u0001H.\u00198\u000b\u00059z\u0013a\u00029mC:tWM\u001d\u0006\u0003aE\nQ\u0001^1cY\u0016T!AM\u001a\u0002\u000b\u0019d\u0017N\\6\u000b\u0005Q*\u0014AB1qC\u000eDWMC\u00017\u0003\ry'oZ\u0002\u0001'\t\u0001\u0011\b\u0005\u0002;{5\t1H\u0003\u0002=[\u0005)Q\u000f^5mg&\u0011ah\u000f\u0002\u000e)\u0006\u0014G.\u001a+fgR\u0014\u0015m]3\u0002\rqJg.\u001b;?)\u0005\t\u0005C\u0001\"\u0001\u001b\u0005)\u0013\u0001B;uS2,\u0012!\u0012\t\u0003u\u0019K!aR\u001e\u0003%\t\u000bGo\u00195UC\ndW\rV3tiV#\u0018\u000e\\\u0001\u0006kRLG\u000eI\u0001(i\u0016\u001cHo\u0014<fe^Kg\u000eZ8x/&$\bn\\;u!\u0006\u0014H/\u001b;j_:\u0014\u0015p\u0014:eKJ\u0014\u0015\u0010F\u0001L!\tau*D\u0001N\u0015\u0005q\u0015!B:dC2\f\u0017B\u0001)N\u0005\u0011)f.\u001b;)\u0005\u0011\u0011\u0006CA*[\u001b\u0005!&BA+W\u0003\r\t\u0007/\u001b\u0006\u0003/b\u000bqA[;qSR,'O\u0003\u0002Zk\u0005)!.\u001e8ji&\u00111\f\u0016\u0002\u0005)\u0016\u001cH/\u0001\u000euKN$xJ^3s/&tGm\\<XSRDw.\u001e;Ge\u0006lW\r\u000b\u0002\u0006%\u0006\u0001C/Z:u\u001fZ,'oV5oI><x+\u001b;i_V$\b+\u0019:uSRLwN\u001c\"zQ\t1!+\u0001\u000buKN$H)\u001a8tKJ\u000bgn[(o\u001fJ$WM\u001d\u0015\u0003\u000fI\u000ba\u0002^3tiJ\u000bgn[(o\u001fZ,'\u000f\u000b\u0002\t%\u00061C/Z:u\t&4g\rU1si&$\u0018n\u001c8LKf\u001cx+\u001b;i'\u0006lWm\u0014:eKJ\\U-_:)\u0005%\u0011\u0016a\n;fgR$\u0015N\u001a4QCJ$\u0018\u000e^5p].+\u0017p],ji\"$\u0015N\u001a4Pe\u0012,'oS3zgFB#A\u0003*\u0002OQ,7\u000f\u001e#jM\u001a\u0004\u0016M\u001d;ji&|gnS3zg^KG\u000f\u001b#jM\u001a|%\u000fZ3s\u0017\u0016L8O\r\u0015\u0003\u0017I\u000bq\u0005^3tiN\u000bW.\u001a)beRLG/[8o\u0017\u0016L8oV5uQ\u0012KgMZ(sI\u0016\u00148*Z=tc!\u0012ABU\u0001(i\u0016\u001cHoU1nKB\u000b'\u000f^5uS>t7*Z=t/&$\b\u000eR5gM>\u0013H-\u001a:LKf\u001c(\u0007\u000b\u0002\u000e%\u00061C/Z:u'\u0006lW\rU1si&$\u0018n\u001c8LKf\u001cx+\u001b;i'\u0006lWm\u0014:eKJ\\U-_:)\u00059\u0011\u0016\u0001\u000e;fgR\u001c\u0016-\\3QCJ$\u0018\u000e^5p].+\u0017p],ji\"\u001c\u0016-\\3Pe\u0012,'oS3zg^KG\u000f[#naRLxJ\u001d3fe\"\u0012qBU\u00015i\u0016\u001cHoU1nKB\u000b'\u000f^5uS>t7*Z=t/&$\bnU1nK>\u0013H-\u001a:LKf\u001cH)\u001b4g\t&\u0014Xm\u0019;j_:\f\u0004F\u0001\tS\u0003Q\"Xm\u001d;TC6,\u0007+\u0019:uSRLwN\\&fsN<\u0016\u000e\u001e5TC6,wJ\u001d3fe.+\u0017p\u001d#jM\u001a$\u0015N]3di&|gN\r\u0015\u0003#I\u000bA\u0006^3tiN\u000bW.\u001a)beRLG/[8o\u0017\u0016L8oV5uQN\u000bW.Z(sI\u0016\u00148*Z=t!J,g-\u001b=)\u0005I\u0011\u0016!\n;fgR|e/\u001a:XS:$wn\u001e\u0019Qe\u0016\u001cW\rZ5oO\u0006sG\r\r$pY2|w/\u001b8hQ\t\u0019\"+A\u0013uKN$xJ^3s/&tGm\\<DkJ\u0014XM\u001c;S_^\fe\u000e\u001a\u0019G_2dwn^5oO\"\u0012ACU\u0001&i\u0016\u001cHo\u0014<fe^Kg\u000eZ8xaA\u0013XmY3eS:<\u0017I\u001c3DkJ\u0014XM\u001c;S_^D#!\u0006*\u0002?Q,7\u000f^(wKJ<\u0016N\u001c3poJ\u000bgnZ3Qe>D\u0017NY5u)f\u0004X\r\u000b\u0002\u0017%\u00069B/Z:u\u001fZ,'oV5oI><(+\u00198hKRK\b/\u001a\u0015\u0003/I\u000bA\u0004^3ti6+H\u000e^5Pm\u0016\u0014x+\u001b8e_^\u0014\u0016M\\4f)f\u0004X\r\u000b\u0002\u0019%\u0006QB/Z:u%><8oV5oI><x+\u001b;i\u001d\u0016<\u0017\r^5wK\"\u0012\u0011DU\u0001\u001di\u0016\u001cHOU1oO\u0016<\u0016N\u001c3po^KG\u000f\u001b(fO\u0006$\u0018N^32Q\tQ\"+\u0001\u000fuKN$(+\u00198hK^Kg\u000eZ8x/&$\bNT3hCRLg/\u001a\u001a)\u0005m\u0011\u0016A\n;fgR\u0014\u0016M\\6SC:<WmV5oI><x+\u001b;i\u0007>l\u0007o\\:ji\u0016|%\u000fZ3sg\"\u0012ADU\u0001\"i\u0016\u001cHOU1oWJ\u000bgnZ3XS:$wn^,ji\"\u001cuN\\:uC:$8/\r\u0015\u0003;I\u000b\u0011\u0005^3tiJ\u000bgn\u001b*b]\u001e,w+\u001b8e_^<\u0016\u000e\u001e5D_:\u001cH/\u00198ugJB#A\b*\u00029Q,7\u000f^(wKJ<\u0016N\u001c3po^KG\u000f[\"p]N$\u0018M\u001c;tg!\u0012qDU\u0001\ri\u0016\u001cH\u000fR5ti&t7\r\u001e\u0015\u0003AI\u000b!\u0004^3ti&sg/\u00197jI>3XM]!hOJ,w-\u0019;j_:D#!\t*\u00027Q,7\u000f^%om\u0006d\u0017\u000eZ(wKJ\fum\u001a:fO\u0006$\u0018n\u001c83Q\t\u0011#+A\tuKN$h*Z:uK\u0012|e/\u001a:BO\u001eD#a\t*")
public class OverAggregateTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testOverWindowWithoutPartitionByOrderBy() {
        this.util().verifyExecPlan("SELECT c, COUNT(*) OVER () FROM MyTable");
    }

    @Test
    public void testOverWindowWithoutFrame() {
        this.util().verifyExecPlan("SELECT c, COUNT(*) OVER (PARTITION BY c) FROM MyTable");
    }

    @Test
    public void testOverWindowWithoutPartitionBy() {
        this.util().verifyExecPlan("SELECT c, SUM(a) OVER (ORDER BY b) FROM MyTable");
    }

    @Test
    public void testDenseRankOnOrder() {
        this.util().verifyExecPlan("SELECT a, DENSE_RANK() OVER (PARTITION BY a ORDER BY proctime) FROM MyTableWithProctime");
    }

    @Test
    public void testRankOnOver() {
        this.util().verifyExecPlan("SELECT a, RANK() OVER (PARTITION BY a ORDER BY proctime) FROM MyTableWithProctime");
    }

    @Test
    public void testDiffPartitionKeysWithSameOrderKeys() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    SUM(a) OVER (PARTITION BY b ORDER BY a),\n        |    MAX(a) OVER (PARTITION BY c ORDER BY a)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testDiffPartitionKeysWithDiffOrderKeys1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    SUM(a) OVER (PARTITION BY b ORDER BY a),\n        |    MAX(a) OVER (PARTITION BY b ORDER BY c),\n        |    AVG(a) OVER (PARTITION BY c ORDER BY a),\n        |    RANK() OVER (PARTITION BY b ORDER BY a),\n        |    MIN(a) OVER (PARTITION BY c ORDER BY a)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testDiffPartitionKeysWithDiffOrderKeys2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    SUM(a) OVER (PARTITION BY b ORDER BY c),\n        |    MAX(a) OVER (PARTITION BY c ORDER BY a),\n        |    MIN(a) OVER (ORDER BY c, a),\n        |    RANK() OVER (PARTITION BY b ORDER BY c),\n        |    AVG(a) OVER (ORDER BY b)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSamePartitionKeysWithDiffOrderKeys1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    SUM(a) OVER (PARTITION BY b ORDER BY c),\n        |    MAX(a) OVER (PARTITION BY b ORDER BY b),\n        |    AVG(a) OVER (PARTITION BY b ORDER BY a),\n        |    RANK() OVER (PARTITION BY b ORDER BY c),\n        |    MIN(a) OVER (PARTITION BY b ORDER BY b)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSamePartitionKeysWithDiffOrderKeys2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    SUM(a) OVER (PARTITION BY b ORDER BY c),\n        |    MAX(a) OVER (PARTITION BY b ORDER BY a),\n        |    AVG(a) OVER (PARTITION BY b ORDER BY a, c),\n        |    RANK() OVER (PARTITION BY b ORDER BY a, b),\n        |    MIN(a) OVER (PARTITION BY b ORDER BY b)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSamePartitionKeysWithSameOrderKeys() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    SUM(a) OVER (PARTITION BY b ORDER BY a),\n        |    MAX(a) OVER (PARTITION BY b ORDER BY a)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSamePartitionKeysWithSameOrderKeysWithEmptyOrder() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    SUM(a) OVER (PARTITION BY b ORDER BY a),\n        |    MIN(a) OVER (PARTITION BY b),\n        |    MAX(a) OVER (PARTITION BY b ORDER BY a)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSamePartitionKeysWithSameOrderKeysDiffDirection1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    SUM(a) OVER (PARTITION BY b ORDER BY a ASC),\n        |    MAX(a) OVER (PARTITION BY b ORDER BY a ASC),\n        |    AVG(a) OVER (PARTITION BY b ORDER BY a DESC),\n        |    RANK() OVER (PARTITION BY b ORDER BY a ASC),\n        |    MIN(a) OVER (PARTITION BY b ORDER BY a DESC)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSamePartitionKeysWithSameOrderKeysDiffDirection2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    RANK() OVER (PARTITION BY b ORDER BY a DESC),\n        |    RANK() OVER (PARTITION BY b ORDER BY a ASC)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSamePartitionKeysWithSameOrderKeysPrefix() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a,\n        |    RANK() OVER (PARTITION BY b ORDER BY c, a DESC),\n        |    RANK() OVER (PARTITION BY b ORDER BY c, b)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testOverWindow0PrecedingAnd0Following() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT c,\n        |    COUNT(*) OVER (PARTITION BY c ORDER BY a ROWS BETWEEN 0 PRECEDING AND 0 FOLLOWING)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testOverWindowCurrentRowAnd0Following() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT c,\n        |    COUNT(*) OVER (PARTITION BY c ORDER BY a ROWS BETWEEN CURRENT ROW AND 0 FOLLOWING)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testOverWindow0PrecedingAndCurrentRow() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT c,\n        |    COUNT(*) OVER (PARTITION BY c ORDER BY a ROWS BETWEEN 0 PRECEDING AND CURRENT ROW)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testOverWindowRangeProhibitType() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    COUNT(*) OVER (PARTITION BY c ORDER BY c RANGE BETWEEN -1 PRECEDING AND 10 FOLLOWING)\n        |FROM MyTable\n      ")).stripMargin();
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.util().verifyExecPlan(sqlQuery));
    }

    @Test
    public void testOverWindowRangeType() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    COUNT(*) OVER (PARTITION BY c ORDER BY a RANGE BETWEEN -1 PRECEDING AND 10 FOLLOWING)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testMultiOverWindowRangeType() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    COUNT(*) OVER (PARTITION BY c ORDER BY a RANGE BETWEEN -1 PRECEDING AND 10 FOLLOWING),\n        |    SUM(a) OVER (PARTITION BY c ORDER BY a),\n        |    RANK() OVER (PARTITION BY c ORDER BY a, c),\n        |    SUM(a) OVER (PARTITION BY c ORDER BY a RANGE BETWEEN 1 PRECEDING AND 10 FOLLOWING),\n        |    COUNT(*) OVER (PARTITION BY c ORDER BY c ROWS BETWEEN 1 PRECEDING AND 10 FOLLOWING)\n        | FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRowsWindowWithNegative() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    COUNT(*) OVER (PARTITION BY c ORDER BY a ROWS BETWEEN -1 PRECEDING AND 10 FOLLOWING)\n        |FROM MyTable\n      ")).stripMargin();
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.util().verifyExecPlan(sqlQuery));
    }

    @Test
    public void testRangeWindowWithNegative1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    COUNT(*) OVER (PARTITION BY c ORDER BY a RANGE BETWEEN -1 PRECEDING AND 10 FOLLOWING)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRangeWindowWithNegative2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    COUNT(*) OVER (PARTITION BY c ORDER BY a RANGE BETWEEN -1 FOLLOWING AND 10 FOLLOWING)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRankRangeWindowWithCompositeOrders() {
        this.util().verifyExecPlan("SELECT RANK() OVER (PARTITION BY c ORDER BY a, c) FROM MyTable");
    }

    @Test
    public void testRankRangeWindowWithConstants1() {
        this.util().verifyExecPlan("SELECT COUNT(1) OVER () FROM MyTable");
    }

    @Test
    public void testRankRangeWindowWithConstants2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    SUM(a) OVER (PARTITION BY c ORDER BY a RANGE BETWEEN -1 FOLLOWING AND 10 FOLLOWING),\n        |    COUNT(1) OVER (PARTITION BY c ORDER BY a RANGE BETWEEN -1 FOLLOWING and 10 FOLLOWING)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testOverWindowWithConstants3() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    COUNT(2) OVER (ORDER BY a),\n        |    COUNT(1) OVER (PARTITION BY c ORDER BY a)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testDistinct() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT SUM(DISTINCT a)\n        |    OVER (PARTITION BY c ORDER BY a RANGE BETWEEN -1 FOLLOWING AND 10 FOLLOWING)\n        |FROM MyTable\n      ")).stripMargin();
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> this.util().verifyExecPlan(sqlQuery));
    }

    @Test
    public void testInvalidOverAggregation() {
        this.util().addTemporarySystemFunction("overAgg", (UserDefinedFunction)new JavaUserDefinedAggFunctions.OverAgg0());
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.util().verifyExecPlan("SELECT overAgg(b, a) FROM MyTable"));
    }

    @Test
    public void testInvalidOverAggregation2() {
        this.util().addTableSource("T", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ts"))}), new CaseClassTypeInfo<Tuple4<Object, Object, String, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Timestamp>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, Object, String, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Object, String, Timestamp>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Timestamp> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)((Timestamp)fields[3]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.batch.sql.agg.OverAggregateTest$$anon$5 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTemporarySystemFunction("overAgg", (UserDefinedFunction)new JavaUserDefinedAggFunctions.OverAgg0());
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.util().verifyExecPlan("SELECT overAgg(b, a) FROM T GROUP BY TUMBLE(ts, INTERVAL '2' HOUR)"));
    }

    @Test
    public void testNestedOverAgg() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TEMPORARY TABLE src (\n                     |  a STRING,\n                     |  b STRING,\n                     |  ts TIMESTAMP_LTZ(3),\n                     |  watermark FOR ts as ts\n                     |) WITH (\n                     |  'connector' = 'values'\n                     |  ,'bounded' = 'true'\n                     |)\n                     |")).stripMargin());
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n                           |SELECT *\n                           |FROM (\n                           | SELECT\n                           |    *, count(*) OVER (PARTITION BY a ORDER BY ts) AS c2\n                           |  FROM (\n                           |    SELECT\n                           |      *, count(*) OVER (PARTITION BY a,b ORDER BY ts) AS c1\n                           |    FROM src\n                           |  )\n                           |)\n                           |")).stripMargin());
    }

    public OverAggregateTest() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.batch.sql.agg.OverAggregateTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTableSource("MyTableWithProctime", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime"))}), new CaseClassTypeInfo<Tuple4<Object, Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.batch.sql.agg.OverAggregateTest$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
    }
}

