/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql.agg;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Timestamp;
import java.util.Collection;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.AggregatePhaseStrategy;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.batch.sql.agg.GroupWindowTest$;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.CountAggFunction;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005Uf\u0001\u0002\u0016,\u0001yB\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\u0006\u001d\u0002!\ta\u0014\u0005\b'\u0002\u0011\r\u0011\"\u0003U\u0011\u0019A\u0006\u0001)A\u0005+\")\u0011\f\u0001C\u00015\")1\u000e\u0001C\u00015\")\u0001\u000f\u0001C\u00015\")!\u000f\u0001C\u00015\")A\u000f\u0001C\u00015\")a\u000f\u0001C\u00015\")\u0001\u0010\u0001C\u00015\")!\u0010\u0001C\u00015\")A\u0010\u0001C\u00015\")a\u0010\u0001C\u00015\"1\u0011\u0011\u0001\u0001\u0005\u0002iCa!!\u0002\u0001\t\u0003Q\u0006BBA\u0005\u0001\u0011\u0005!\f\u0003\u0004\u0002\u000e\u0001!\tA\u0017\u0005\u0007\u0003#\u0001A\u0011\u0001.\t\r\u0005U\u0001\u0001\"\u0001[\u0011\u0019\tI\u0002\u0001C\u00015\"1\u0011Q\u0004\u0001\u0005\u0002iCa!!\t\u0001\t\u0003Q\u0006BBA\u0013\u0001\u0011\u0005!\f\u0003\u0004\u0002*\u0001!\tA\u0017\u0005\u0007\u0003[\u0001A\u0011\u0001.\t\r\u0005E\u0002\u0001\"\u0001[\u0011\u0019\t)\u0004\u0001C\u00015\"1\u0011\u0011\b\u0001\u0005\u0002iCa!!\u0010\u0001\t\u0003Q\u0006BBA!\u0001\u0011\u0005!\f\u0003\u0004\u0002F\u0001!\tA\u0017\u0005\u0007\u0003\u0013\u0002A\u0011\u0001.\t\r\u00055\u0003\u0001\"\u0001[\u0011\u0019\t\t\u0006\u0001C\u00015\"1\u0011Q\u000b\u0001\u0005\u0002iCa!!\u0017\u0001\t\u0003QvaBADW!\u0005\u0011\u0011\u0012\u0004\u0007U-B\t!a#\t\r9;C\u0011AAJ\u0011\u001d\t)j\nC\u0001\u0003/\u0013qb\u0012:pkB<\u0016N\u001c3poR+7\u000f\u001e\u0006\u0003Y5\n1!Y4h\u0015\tqs&A\u0002tc2T!\u0001M\u0019\u0002\u000b\t\fGo\u00195\u000b\u0005I\u001a\u0014\u0001\u00029mC:T!\u0001N\u001b\u0002\u000fAd\u0017M\u001c8fe*\u0011agN\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003qe\nQA\u001a7j].T!AO\u001e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0014aA8sO\u000e\u00011C\u0001\u0001@!\t\u00015)D\u0001B\u0015\t\u00115'A\u0003vi&d7/\u0003\u0002E\u0003\niA+\u00192mKR+7\u000f\u001e\"bg\u0016\f1\"Y4h'R\u0014\u0018\r^3hsB\u0011q\tT\u0007\u0002\u0011*\u0011\u0011JS\u0001\u0007G>tg-[4\u000b\u0005-+\u0014aA1qS&\u0011Q\n\u0013\u0002\u0017\u0003\u001e<'/Z4bi\u0016\u0004\u0006.Y:f'R\u0014\u0018\r^3hs\u00061A(\u001b8jiz\"\"\u0001\u0015*\u0011\u0005E\u0003Q\"A\u0016\t\u000b\u0015\u0013\u0001\u0019\u0001$\u0002\tU$\u0018\u000e\\\u000b\u0002+B\u0011\u0001IV\u0005\u0003/\u0006\u0013!CQ1uG\"$\u0016M\u00197f)\u0016\u001cH/\u0016;jY\u0006)Q\u000f^5mA\u00051!-\u001a4pe\u0016$\u0012a\u0017\t\u00039~k\u0011!\u0018\u0006\u0002=\u0006)1oY1mC&\u0011\u0001-\u0018\u0002\u0005+:LG\u000f\u000b\u0002\u0006EB\u00111-[\u0007\u0002I*\u00111*\u001a\u0006\u0003M\u001e\fqA[;qSR,'O\u0003\u0002iw\u0005)!.\u001e8ji&\u0011!\u000e\u001a\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017!\u0006;fgRDu\u000e],j]\u0012|wOT8PM\u001a\u001cX\r\u001e\u0015\u0003\r5\u0004\"a\u00198\n\u0005=$'\u0001\u0004+fgR$V-\u001c9mCR,\u0017!\u0007;fgR\u001cVm]:j_:<\u0016N\u001c3po:{wJ\u001a4tKRD#aB7\u0002-Q,7\u000f\u001e,be&\f'\r\\3XS:$wn^*ju\u0016D#\u0001C7\u0002IQ,7\u000f\u001e+v[\ndWmV5oI><x+\u001b;i\u0013:4\u0018\r\\5e+\u0012\fumZ!sOND#!C7\u0002%Q,7\u000f^,j]\u0012|w\u000f\u0015:pGRLW.\u001a\u0015\u0003\u00155\f!\u0004^3ti^Kg\u000eZ8x\u0003\u001e<w+\u001b;i\u000fJ|W\u000f]*fiND#aC7\u00029Q,7\u000f\u001e(p\u000fJ|W\u000f]5oOR+XN\u00197j]\u001e<\u0016N\u001c3po\"\u0012A\"\\\u0001\u001bi\u0016\u001cH\u000fV;nE2LgnZ,j]\u0012|woU8si\u0006;w-\r\u0015\u0003\u001b5\f!\u0004^3tiR+XN\u00197j]\u001e<\u0016N\u001c3poN{'\u000f^!hOJB#AD7\u00025Q,7\u000f\u001e+v[\nd\u0017N\\4XS:$wn\u001e%bg\"\fumZ\u0019)\u0005=i\u0017A\u0007;fgR$V/\u001c2mS:<w+\u001b8e_^D\u0015m\u001d5BO\u001e\u0014\u0004F\u0001\tn\u0003\u0001\"Xm\u001d;O_:\u0004\u0016M\u001d;ji&|g.\u001a3Uk6\u0014G.\u001b8h/&tGm\\<)\u0005Ei\u0017!\b;fgR\u0004\u0016M\u001d;ji&|g.\u001a3Uk6\u0014G.\u001b8h/&tGm\\<)\u0005Ii\u0017a\u0007;fgR$V/\u001c2mS:<w+\u001b8e_^<\u0016\u000e\u001e5VI\u0006;w\r\u000b\u0002\u0014[\u0006qB/Z:u)Vl'\r\\5oO^Kg\u000eZ8x/&$\b\u000e\u0015:pGRLW.\u001a\u0015\u0003)5\f1\u0004^3ti:{wI]8va&twm\u00157jI&twmV5oI><\bFA\u000bn\u0003e!Xm\u001d;TY&$\u0017N\\4XS:$wn^*peR\fumZ\u0019)\u0005Yi\u0017!\u0007;fgR\u001cF.\u001b3j]\u001e<\u0016N\u001c3poN{'\u000f^!hOJB#aF7\u00023Q,7\u000f^*mS\u0012LgnZ,j]\u0012|woU8si\u0006;wm\r\u0015\u000315\fA\u0006^3tiNc\u0017\u000eZ5oO^Kg\u000eZ8x'>\u0014H/Q4h/&$\b\u000eU1oK>\u0003H/[7ju\u0006$\u0018n\u001c8)\u0005ei\u0017\u0001\u0007;fgR\u001cF.\u001b3j]\u001e<\u0016N\u001c3po\"\u000b7\u000f[!hO\"\u0012!$\\\u0001 i\u0016\u001cHOT8o!\u0006\u0014H/\u001b;j_:,Gm\u00157jI&twmV5oI><\bFA\u000en\u0003q!Xm\u001d;QCJ$\u0018\u000e^5p]\u0016$7\u000b\\5eS:<w+\u001b8e_^D#\u0001H7\u0002;Q,7\u000f^*mS\u0012LgnZ,j]\u0012|woV5uQB\u0013xn\u0019;j[\u0016D#!H7\u0002?Q,7\u000f\u001e(p]B\u000b'\u000f^5uS>tW\rZ*fgNLwN\\,j]\u0012|w\u000f\u000b\u0002\u001f[\u0006aB/Z:u!\u0006\u0014H/\u001b;j_:,GmU3tg&|gnV5oI><\bFA\u0010n\u0003u!Xm\u001d;TKN\u001c\u0018n\u001c8XS:$wn^,ji\"\u0004&o\\2uS6,\u0007F\u0001\u0011n\u0003E!Xm\u001d;XS:$wn^#oI>sG.\u001f\u0015\u0003C5\fA\u0005^3ti\u0016C\bO]3tg&|gn\u00148XS:$wn\u001e%bm&twMR;oGRLwN\u001c\u0015\u0003E5\fA\u0004^3ti\u0012+7m\\7q_N\f'\r\\3BO\u001e4UO\\2uS>t7\u000f\u000b\u0002$[\u0006\u0019C/Z:u%\u0016$XO\u001d8UsB,\u0017J\u001c4fe\u0016t7-\u001a$pe^Kg\u000eZ8x\u0003\u001e<\u0007F\u0001\u0013n\u0003\u001d\"Xm\u001d;XS:$wn^!hOJ,w-\u0019;f/&$\b\u000eR5gM\u0016\u0014XM\u001c;XS:$wn^:)\u0005\u0015j\u0007f\u0002\u0001\u0002`\u0005-\u0014Q\u000e\t\u0005\u0003C\n9'\u0004\u0002\u0002d)\u0019\u0011Q\r3\u0002\u0013\u0015DH/\u001a8tS>t\u0017\u0002BA5\u0003G\u0012!\"\u0012=uK:$w+\u001b;i\u0003\u00151\u0018\r\\;fY\t\tyg\t\u0002\u0002rA!\u00111OAB\u001b\t\t)H\u0003\u0003\u0002x\u0005e\u0014!\u00049be\u0006lW\r^3sSj,GM\u0003\u0003\u0002|\u0005u\u0014AC3yi\u0016t7/[8og*\u0019\u0001.a \u000b\u0007\u0005\u0005u'A\u0005uKN$X\u000f^5mg&!\u0011QQA;\u0005i\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^#yi\u0016t7/[8o\u0003=9%o\\;q/&tGm\\<UKN$\bCA)('\r9\u0013Q\u0012\t\u00049\u0006=\u0015bAAI;\n1\u0011I\\=SK\u001a$\"!!#\u0002\u0015A\f'/Y7fi\u0016\u00148\u000f\u0006\u0002\u0002\u001aB)\u00111TAR\r6\u0011\u0011Q\u0014\u0006\u0004'\u0006}%BAAQ\u0003\u0011Q\u0017M^1\n\t\u0005\u0015\u0016Q\u0014\u0002\u000b\u0007>dG.Z2uS>t\u0007fB\u0015\u0002*\u0006=\u0016\u0011\u0017\t\u0005\u0003g\nY+\u0003\u0003\u0002.\u0006U$A\u0003)be\u0006lW\r^3sg\u0006!a.Y7fC\t\t\u0019,A\bbO\u001e\u001cFO]1uK\u001eLXh\u001f\u0019~\u0001")
public class GroupWindowTest
extends TableTestBase {
    private final AggregatePhaseStrategy aggStrategy;
    private final BatchTableTestUtil util;

    @Parameters(name="aggStrategy={0}")
    public static Collection<AggregatePhaseStrategy> parameters() {
        return GroupWindowTest$.MODULE$.parameters();
    }

    private BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void before() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_AGG_PHASE_STRATEGY, (Object)this.aggStrategy);
        this.util().addTemporarySystemFunction("countFun", (UserDefinedFunction)new CountAggFunction());
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d"))}), new CaseClassTypeInfo<Tuple4<Object, Timestamp, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Timestamp, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, Timestamp, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Timestamp, Object, Object>>(this, fieldSerializers){

                    public Tuple4<Object, Timestamp, Object, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((Timestamp)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.batch.sql.agg.GroupWindowTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTableSource("MyTable1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ts")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple4<Timestamp, Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Timestamp, Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Timestamp, Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple4<Timestamp, Object, Object, String>>(this, fieldSerializers){

                    public Tuple4<Timestamp, Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple4((Object)((Timestamp)fields[0]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)((String)fields[3]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.batch.sql.agg.GroupWindowTest$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTableSource("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ts"))}), new CaseClassTypeInfo<Tuple5<Object, Object, String, Object, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple5<Object, Object, String, Object, Timestamp>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple5<Object, Object, String, Object, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple5<Object, Object, String, Object, Timestamp>>(this, fieldSerializers){

                    public Tuple5<Object, Object, String, Object, Timestamp> createInstance(Object[] fields) {
                        return new Tuple5((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[3])), (Object)((Timestamp)fields[4]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.batch.sql.agg.GroupWindowTest$$anon$5 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                                |create table MyTable3 (\n                                |  a int,\n                                |  b bigint,\n                                |  c as proctime()\n                                |) with (\n                                |  'connector' = 'COLLECTION'\n                                |)\n                                |")).stripMargin());
    }

    @TestTemplate
    public void testHopWindowNoOffset() {
        String sqlQuery = "SELECT SUM(a) AS sumA, COUNT(b) AS cntB FROM MyTable2 GROUP BY HOP(ts, INTERVAL '1' HOUR, INTERVAL '2' HOUR, TIME '10:00:00')";
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan(sqlQuery)).hasMessageContaining("HOP window with alignment is not supported yet.") instanceof TableException;
    }

    @TestTemplate
    public void testSessionWindowNoOffset() {
        String sqlQuery = "SELECT SUM(a) AS sumA, COUNT(b) AS cntB FROM MyTable2 GROUP BY SESSION(ts, INTERVAL '2' HOUR, TIME '10:00:00')";
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan(sqlQuery)).hasMessageContaining("SESSION window with alignment is not supported yet.") instanceof TableException;
    }

    @TestTemplate
    public void testVariableWindowSize() {
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan("SELECT COUNT(*) FROM MyTable2 GROUP BY TUMBLE(ts, b * INTERVAL '1' MINUTE)")).hasMessageContaining("Only constant window descriptors are supported") instanceof TableException;
    }

    @TestTemplate
    public void testTumbleWindowWithInvalidUdAggArgs() {
        JavaUserDefinedAggFunctions.WeightedAvgWithMerge weightedAvg = new JavaUserDefinedAggFunctions.WeightedAvgWithMerge();
        this.util().addTemporarySystemFunction("weightedAvg", (UserDefinedFunction)weightedAvg);
        String sql = "SELECT weightedAvg(c, a) AS wAvg FROM MyTable2 GROUP BY TUMBLE(ts, INTERVAL '4' MINUTE)";
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan(sql)).hasMessageContaining("SQL validation failed. Invalid function call:\nweightedAvg(STRING, INT)") instanceof ValidationException;
    }

    @TestTemplate
    public void testWindowProctime() {
        String sqlQuery = "SELECT TUMBLE_PROCTIME(ts, INTERVAL '4' MINUTE) FROM MyTable2 GROUP BY TUMBLE(ts, INTERVAL '4' MINUTE), c";
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan(sqlQuery)).hasMessageContaining("PROCTIME window property is not supported in batch queries.") instanceof ValidationException;
    }

    @TestTemplate
    public void testWindowAggWithGroupSets() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*),\n        |    TUMBLE_END(ts, INTERVAL '15' MINUTE) + INTERVAL '1' MINUTE\n        |FROM MyTable1\n        |    GROUP BY rollup(TUMBLE(ts, INTERVAL '15' MINUTE), b)\n    ")).stripMargin();
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> this.util().verifyRelPlanNotExpected(sql, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TUMBLE(ts"})));
    }

    @TestTemplate
    public void testNoGroupingTumblingWindow() {
        String sqlQuery = "SELECT AVG(c), SUM(a) FROM MyTable GROUP BY TUMBLE(b, INTERVAL '3' SECOND)";
        this.util().verifyExecPlan(sqlQuery);
    }

    @TestTemplate
    public void testTumblingWindowSortAgg1() {
        String sqlQuery = "SELECT MAX(c) FROM MyTable1 GROUP BY a, TUMBLE(ts, INTERVAL '3' SECOND)";
        this.util().verifyExecPlan(sqlQuery);
    }

    @TestTemplate
    public void testTumblingWindowSortAgg2() {
        String sqlQuery = "SELECT AVG(c), countFun(a) FROM MyTable GROUP BY a, d, TUMBLE(b, INTERVAL '3' SECOND)";
        this.util().verifyExecPlan(sqlQuery);
    }

    @TestTemplate
    public void testTumblingWindowHashAgg1() {
        String sqlQuery = "SELECT COUNT(c) FROM MyTable1 GROUP BY a, TUMBLE(ts, INTERVAL '3' SECOND)";
        this.util().verifyExecPlan(sqlQuery);
    }

    @TestTemplate
    public void testTumblingWindowHashAgg2() {
        String sql = "SELECT AVG(c), COUNT(a) FROM MyTable GROUP BY a, d, TUMBLE(b, INTERVAL '3' SECOND)";
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testNonPartitionedTumblingWindow() {
        String sqlQuery = "SELECT SUM(a) AS sumA, COUNT(b) AS cntB FROM MyTable2 GROUP BY TUMBLE(ts, INTERVAL '2' HOUR)";
        this.util().verifyExecPlan(sqlQuery);
    }

    @TestTemplate
    public void testPartitionedTumblingWindow() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_START(ts, INTERVAL '4' MINUTE),\n        |    TUMBLE_END(ts, INTERVAL '4' MINUTE),\n        |    TUMBLE_ROWTIME(ts, INTERVAL '4' MINUTE),\n        |    c,\n        |    SUM(a) AS sumA,\n        |    MIN(b) AS minB\n        |FROM MyTable2\n        |    GROUP BY TUMBLE(ts, INTERVAL '4' MINUTE), c\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @TestTemplate
    public void testTumblingWindowWithUdAgg() {
        this.util().addTemporarySystemFunction("weightedAvg", (UserDefinedFunction)new JavaUserDefinedAggFunctions.WeightedAvgWithMerge());
        String sql = "SELECT weightedAvg(b, a) AS wAvg FROM MyTable2 GROUP BY TUMBLE(ts, INTERVAL '4' MINUTE)";
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testTumblingWindowWithProctime() {
        String sql = "select sum(a), max(b) from MyTable3 group by TUMBLE(c, INTERVAL '1' SECOND)";
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan(sql)).hasMessageContaining("Window can not be defined over a proctime attribute column for batch mode") instanceof ValidationException;
    }

    @TestTemplate
    public void testNoGroupingSlidingWindow() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT SUM(a),\n        |    HOP_START(b, INTERVAL '3' SECOND, INTERVAL '3' SECOND),\n        |    HOP_END(b, INTERVAL '3' SECOND, INTERVAL '3' SECOND)\n        |FROM MyTable\n        |    GROUP BY HOP(b, INTERVAL '3' SECOND, INTERVAL '3' SECOND)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @TestTemplate
    public void testSlidingWindowSortAgg1() {
        String sqlQuery = "SELECT MAX(c) FROM MyTable1 GROUP BY a, HOP(ts, INTERVAL '3' SECOND, INTERVAL '1' HOUR)";
        this.util().verifyExecPlan(sqlQuery);
    }

    @TestTemplate
    public void testSlidingWindowSortAgg2() {
        String sqlQuery = "SELECT MAX(c) FROM MyTable1 GROUP BY b, HOP(ts, INTERVAL '0.111' SECOND(1,3), INTERVAL '1' SECOND)";
        this.util().verifyExecPlan(sqlQuery);
    }

    @TestTemplate
    public void testSlidingWindowSortAgg3() {
        String sqlQuery = "SELECT countFun(c) FROM MyTable  GROUP BY a, d, HOP(b, INTERVAL '3' SECOND, INTERVAL '1' HOUR)";
        this.util().verifyExecPlan(sqlQuery);
    }

    @TestTemplate
    public void testSlidingWindowSortAggWithPaneOptimization() {
        String sqlQuery = "SELECT COUNT(c) FROM MyTable1 GROUP BY a, HOP(ts, INTERVAL '3' SECOND, INTERVAL '1' HOUR)";
        this.util().verifyExecPlan(sqlQuery);
    }

    @TestTemplate
    public void testSlidingWindowHashAgg() {
        String sqlQuery = "SELECT count(c) FROM MyTable1 GROUP BY b, HOP(ts, INTERVAL '3' SECOND, INTERVAL '1' HOUR)";
        this.util().verifyExecPlan(sqlQuery);
    }

    @TestTemplate
    public void testNonPartitionedSlidingWindow() {
        String sqlQuery = "SELECT SUM(a) AS sumA, COUNT(b) AS cntB FROM MyTable2 GROUP BY HOP(ts, INTERVAL '15' MINUTE, INTERVAL '90' MINUTE)";
        this.util().verifyExecPlan(sqlQuery);
    }

    @TestTemplate
    public void testPartitionedSlidingWindow() {
        String sqlQuery = "SELECT   c,   HOP_END(ts, INTERVAL '1' HOUR, INTERVAL '3' HOUR),   HOP_START(ts, INTERVAL '1' HOUR, INTERVAL '3' HOUR),   HOP_ROWTIME(ts, INTERVAL '1' HOUR, INTERVAL '3' HOUR),   SUM(a) AS sumA,   AVG(b) AS avgB FROM MyTable2 GROUP BY HOP(ts, INTERVAL '1' HOUR, INTERVAL '3' HOUR), d, c";
        this.util().verifyExecPlan(sqlQuery);
    }

    @TestTemplate
    public void testSlidingWindowWithProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |select sum(a), max(b)\n         |from MyTable3\n         |group by HOP(c, INTERVAL '1' SECOND, INTERVAL '1' MINUTE)\n         |")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan(sql)).hasMessageContaining("Window can not be defined over a proctime attribute column for batch mode") instanceof ValidationException;
    }

    @TestTemplate
    public void testNonPartitionedSessionWindow() {
        String sqlQuery = "SELECT COUNT(*) AS cnt FROM MyTable2 GROUP BY SESSION(ts, INTERVAL '30' MINUTE)";
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan(sqlQuery)).hasMessageContaining("Cannot generate a valid execution plan for the given query") instanceof TableException;
    }

    @TestTemplate
    public void testPartitionedSessionWindow() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT c, d,\n        |    SESSION_START(ts, INTERVAL '12' HOUR),\n        |    SESSION_END(ts, INTERVAL '12' HOUR),\n        |    SESSION_ROWTIME(ts, INTERVAL '12' HOUR),\n        |    SUM(a) AS sumA,\n        |    MIN(b) AS minB\n        |FROM MyTable2\n        |    GROUP BY SESSION(ts, INTERVAL '12' HOUR), c, d\n      ")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan(sqlQuery)).hasMessageContaining("Cannot generate a valid execution plan for the given query") instanceof TableException;
    }

    @TestTemplate
    public void testSessionWindowWithProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |select sum(a), max(b)\n         |from MyTable3\n         |group by SESSION(c, INTERVAL '1' MINUTE)\n         |")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan(sql)).hasMessageContaining("Window can not be defined over a proctime attribute column for batch mode") instanceof ValidationException;
    }

    @TestTemplate
    public void testWindowEndOnly() {
        String sqlQuery = "SELECT TUMBLE_END(ts, INTERVAL '4' MINUTE) FROM MyTable2 GROUP BY TUMBLE(ts, INTERVAL '4' MINUTE), c";
        this.util().verifyExecPlan(sqlQuery);
    }

    @TestTemplate
    public void testExpressionOnWindowHavingFunction() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*),\n        |    HOP_START(ts, INTERVAL '15' MINUTE, INTERVAL '1' MINUTE)\n        |FROM MyTable2\n        |    GROUP BY HOP(ts, INTERVAL '15' MINUTE, INTERVAL '1' MINUTE)\n        |    HAVING\n        |     SUM(a) > 0 AND\n        |     QUARTER(HOP_START(ts, INTERVAL '15' MINUTE, INTERVAL '1' MINUTE)) = 1\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testDecomposableAggFunctions() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT VAR_POP(b),\n        |    VAR_SAMP(b),\n        |    STDDEV_POP(b),\n        |    STDDEV_SAMP(b),\n        |    TUMBLE_START(ts, INTERVAL '15' MINUTE),\n        |    TUMBLE_END(ts, INTERVAL '15' MINUTE)\n        |FROM MyTable1\n        |    GROUP BY TUMBLE(ts, INTERVAL '15' MINUTE)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testReturnTypeInferenceForWindowAgg() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  SUM(correct) AS s,\n        |  AVG(correct) AS a,\n        |  TUMBLE_START(b, INTERVAL '15' MINUTE) AS wStart\n        |FROM (\n        |  SELECT CASE a\n        |      WHEN 1 THEN 1\n        |      ELSE 99\n        |    END AS correct, b\n        |  FROM MyTable\n        |)\n        |GROUP BY TUMBLE(b, INTERVAL '15' MINUTE)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testWindowAggregateWithDifferentWindows() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH window_1h AS (\n        |    SELECT 1\n        |    FROM MyTable2\n        |    GROUP BY HOP(`ts`, INTERVAL '1' HOUR, INTERVAL '1' HOUR)\n        |),\n        |\n        |window_2h AS (\n        |    SELECT 1\n        |    FROM MyTable2\n        |    GROUP BY HOP(`ts`, INTERVAL '1' HOUR, INTERVAL '2' HOUR)\n        |)\n        |\n        |(SELECT * FROM window_1h)\n        |UNION ALL\n        |(SELECT * FROM window_2h)\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    public GroupWindowTest(AggregatePhaseStrategy aggStrategy) {
        this.aggStrategy = aggStrategy;
        this.util = this.batchTestUtil(this.batchTestUtil$default$1());
    }
}

