/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql.adaptive;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.BatchExecutionOptions;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.batch.sql.adaptive.AdaptiveJoinTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001m3AAD\b\u0001E!)\u0011\u0006\u0001C\u0001U!9Q\u0006\u0001b\u0001\n\u0013q\u0003B\u0002\u001a\u0001A\u0003%q\u0006C\u00034\u0001\u0011\u0005A\u0007C\u0003G\u0001\u0011\u0005A\u0007C\u0003L\u0001\u0011\u0005A\u0007C\u0003N\u0001\u0011\u0005A\u0007C\u0003P\u0001\u0011\u0005A\u0007C\u0003R\u0001\u0011\u0005A\u0007C\u0003T\u0001\u0011\u0005A\u0007C\u0003V\u0001\u0011\u0005A\u0007C\u0003X\u0001\u0011\u0005A\u0007C\u0003Z\u0001\u0011\u0005AG\u0001\tBI\u0006\u0004H/\u001b<f\u0015>Lg\u000eV3ti*\u0011\u0001#E\u0001\tC\u0012\f\u0007\u000f^5wK*\u0011!cE\u0001\u0004gFd'B\u0001\u000b\u0016\u0003\u0015\u0011\u0017\r^2i\u0015\t1r#\u0001\u0003qY\u0006t'B\u0001\r\u001a\u0003\u001d\u0001H.\u00198oKJT!AG\u000e\u0002\u000bQ\f'\r\\3\u000b\u0005qi\u0012!\u00024mS:\\'B\u0001\u0010 \u0003\u0019\t\u0007/Y2iK*\t\u0001%A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001GA\u0011AeJ\u0007\u0002K)\u0011aeF\u0001\u0006kRLGn]\u0005\u0003Q\u0015\u0012Q\u0002V1cY\u0016$Vm\u001d;CCN,\u0017A\u0002\u001fj]&$h\bF\u0001,!\ta\u0003!D\u0001\u0010\u0003\u0011)H/\u001b7\u0016\u0003=\u0002\"\u0001\n\u0019\n\u0005E*#A\u0005\"bi\u000eDG+\u00192mKR+7\u000f^+uS2\fQ!\u001e;jY\u0002\naAY3g_J,G#A\u001b\u0011\u0005YJT\"A\u001c\u000b\u0003a\nQa]2bY\u0006L!AO\u001c\u0003\tUs\u0017\u000e\u001e\u0015\u0003\tq\u0002\"!\u0010#\u000e\u0003yR!a\u0010!\u0002\u0007\u0005\u0004\u0018N\u0003\u0002B\u0005\u00069!.\u001e9ji\u0016\u0014(BA\" \u0003\u0015QWO\\5u\u0013\t)eH\u0001\u0006CK\u001a|'/Z#bG\"\fq\u0003^3ti^KG\u000f[*ik\u001a4G.\u001a%bg\"Tu.\u001b8)\u0005\u0015A\u0005CA\u001fJ\u0013\tQeH\u0001\u0003UKN$\u0018\u0001\u0007;fgR<\u0016\u000e\u001e5TQV4g\r\\3NKJ<WMS8j]\"\u0012a\u0001S\u0001\u001ci\u0016\u001cHoV5uQN#\u0018\r^5d\u0005J|\u0017\rZ2bgRTu.\u001b8)\u0005\u001dA\u0015\u0001\t;fgR<\u0016\u000e\u001e5Ce>\fGmY1ti*{\u0017N\u001c*v]RLW.Z(oYfD#\u0001\u0003%\u0002-Q,7\u000f\u001e&pS:<\u0016\u000e\u001e5V]&|g.\u00138qkRD#!\u0003%\u0002YQ,7\u000f^*ik\u001a4G.\u001a&pS:<\u0016\u000e\u001e5G_J<\u0018M\u001d3G_J\u001cuN\\:fGV$\u0018N^3ICND\u0007F\u0001\u0006I\u0003e!Xm\u001d;K_&tw+\u001b;i\u001bVdG/\u001b9mK&s\u0007/\u001e;)\u0005-A\u0015\u0001\n;fgR\fE-\u00199uSZ,'j\\5o/&$\bNQ1uG\"TuN\u0019*fG>4XM]=)\u00051A\u0015!\u000e;fgR\fE-\u00199uSZ,'j\\5o/&$\b.\u00113baRLg/Z*lK^,Gm\u00149uS6L'0\u0019;j_:,e.\u00192mK\u0012D#!\u0004%")
public class AdaptiveJoinTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void before() {
        this.util().addTableSource("T", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d"))}), new CaseClassTypeInfo<Tuple4<Object, Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.batch.sql.adaptive.AdaptiveJoinTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTableSource("T1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a1")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b1")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c1")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d1"))}), new CaseClassTypeInfo<Tuple4<Object, Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.batch.sql.adaptive.AdaptiveJoinTest$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTableSource("T2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a2")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b2")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c2")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d2"))}), new CaseClassTypeInfo<Tuple4<Object, Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.batch.sql.adaptive.AdaptiveJoinTest$$anon$5 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTableSource("T3", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a3")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b3")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c3")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d3"))}), new CaseClassTypeInfo<Tuple4<Object, Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.plan.batch.sql.adaptive.AdaptiveJoinTest$$anon$7 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().tableConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_ADAPTIVE_BROADCAST_JOIN_STRATEGY, (Object)OptimizerConfigOptions.AdaptiveBroadcastJoinStrategy.AUTO);
    }

    @Test
    public void testWithShuffleHashJoin() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        String sql = "SELECT * FROM T1, T2 WHERE a1 = a2";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testWithShuffleMergeJoin() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,ShuffleHashJoin");
        String sql = "SELECT * FROM T1, T2 WHERE a1 = a2";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testWithStaticBroadcastJoin() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"SortMergeJoin,ShuffleHashJoin,NestedLoopJoin");
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, (Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE));
        String sql = "SELECT * FROM T1, T2 WHERE a1 = a2";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testWithBroadcastJoinRuntimeOnly() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin");
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, (Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE));
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_ADAPTIVE_BROADCAST_JOIN_STRATEGY, (Object)OptimizerConfigOptions.AdaptiveBroadcastJoinStrategy.RUNTIME_ONLY);
        String sql = "SELECT * FROM T1, T2 WHERE a1 = a2";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinWithUnionInput() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM\n        |  (SELECT a FROM (SELECT a1 as a FROM T1) UNION ALL (SELECT a2 as a FROM T2)) Y\n        |  LEFT JOIN T ON T.a = Y.a\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testShuffleJoinWithForwardForConsecutiveHash() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_MULTIPLE_INPUT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  r AS (SELECT * FROM T1, T2, T3 WHERE a1 = a2 and a1 = a3)\n        |SELECT sum(b1) FROM r group by a1\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinWithMultipleInput() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM\n        |  (SELECT a FROM T1 JOIN T ON a = a1) t1\n        |  INNER JOIN\n        |  (SELECT d2 FROM T JOIN T2 ON d2 = a) t2\n        |ON t1.a = t2.d2\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testAdaptiveJoinWithBatchJobRecovery() {
        this.util().tableEnv().getConfig().set(BatchExecutionOptions.JOB_RECOVERY_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sql = "SELECT * FROM T1, T2 WHERE a1 = a2";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testAdaptiveJoinWithAdaptiveSkewedOptimizationEnabled() {
        this.util().tableConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_ADAPTIVE_BROADCAST_JOIN_STRATEGY, (Object)OptimizerConfigOptions.AdaptiveBroadcastJoinStrategy.NONE);
        this.util().tableConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_ADAPTIVE_SKEWED_JOIN_OPTIMIZATION_STRATEGY, (Object)OptimizerConfigOptions.AdaptiveSkewedJoinOptimizationStrategy.AUTO);
        String sql = "SELECT * FROM T1, T2 WHERE a1 = a2";
        this.util().verifyExecPlan(sql);
    }
}

