/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.expressions.utils.Func0$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.types.AbstractDataType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001}3A\u0001E\t\u0001E!)\u0011\u0006\u0001C\u0001U!9Q\u0006\u0001b\u0001\n\u0013q\u0003B\u0002\u001a\u0001A\u0003%q\u0006C\u00034\u0001\u0011\u0005A\u0007C\u0003G\u0001\u0011\u0005A\u0007C\u0003L\u0001\u0011\u0005A\u0007C\u0003N\u0001\u0011\u0005A\u0007C\u0003P\u0001\u0011\u0005A\u0007C\u0003R\u0001\u0011\u0005A\u0007C\u0003T\u0001\u0011\u0005A\u0007C\u0003V\u0001\u0011\u0005A\u0007C\u0003X\u0001\u0011\u0005A\u0007C\u0003Z\u0001\u0011\u0005A\u0007C\u0003\\\u0001\u0011\u0005A\u0007C\u0003^\u0001\u0011\u0005AGA\u0007UC\ndWmU2b]R+7\u000f\u001e\u0006\u0003%M\t1a]9m\u0015\t!R#A\u0003cCR\u001c\u0007N\u0003\u0002\u0017/\u0005!\u0001\u000f\\1o\u0015\tA\u0012$A\u0004qY\u0006tg.\u001a:\u000b\u0005iY\u0012!\u0002;bE2,'B\u0001\u000f\u001e\u0003\u00151G.\u001b8l\u0015\tqr$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002A\u0005\u0019qN]4\u0004\u0001M\u0011\u0001a\t\t\u0003I\u001dj\u0011!\n\u0006\u0003M]\tQ!\u001e;jYNL!\u0001K\u0013\u0003\u001bQ\u000b'\r\\3UKN$()Y:f\u0003\u0019a\u0014N\\5u}Q\t1\u0006\u0005\u0002-\u00015\t\u0011#\u0001\u0003vi&dW#A\u0018\u0011\u0005\u0011\u0002\u0014BA\u0019&\u0005I\u0011\u0015\r^2i)\u0006\u0014G.\u001a+fgR,F/\u001b7\u0002\u000bU$\u0018\u000e\u001c\u0011\u0002\r\t,gm\u001c:f)\u0005)\u0004C\u0001\u001c:\u001b\u00059$\"\u0001\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005i:$\u0001B+oSRD#\u0001\u0002\u001f\u0011\u0005u\"U\"\u0001 \u000b\u0005}\u0002\u0015aA1qS*\u0011\u0011IQ\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u0019u$A\u0003kk:LG/\u0003\u0002F}\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002!Q,7\u000f\u001e#E\u0019R\u000b'\r\\3TG\u0006t\u0007FA\u0003I!\ti\u0014*\u0003\u0002K}\t!A+Z:u\u0003e!Xm\u001d;TG\u0006twJ\\+oE>,h\u000eZ3e'>,(oY3)\u0005\u0019A\u0015!\u0007;fgR\u001c6-\u00198P]\u000eC\u0017M\\4fY><7k\\;sG\u0016D#a\u0002%\u0002-Q,7\u000f^*dC:|e.\u00169tKJ$8k\\;sG\u0016D#\u0001\u0003%\u00023Q,7\u000f\u001e#E\u0019^KG\u000f[\"p[B,H/\u001a3D_2,XN\u001c\u0015\u0003\u0013!\u000b!\u0005^3ti\u0012#EjV5uQ^\u000bG/\u001a:nCJ\\7i\\7qkR,GmQ8mk6t\u0007F\u0001\u0006I\u0003M!Xm\u001d;E\t2;\u0016\u000e\u001e5Qe>\u001cG/[7fQ\tY\u0001*\u0001\u0012uKN$H+\u00192mK\u0006\u0003\u0018nU2b]^KG\u000f[\"p[B,H/\u001a3D_2,XN\u001c\u0015\u0003\u0019!\u000bQ\u0004^3tiR\u000b'\r\\3Ba&\u001c6-\u00198XSRDw+\u0019;fe6\f'o\u001b\u0015\u0003\u001b!\u000bq\u0003^3tiR\u000b'\r\\3Ba&\u001c6-\u00198XSRDG\t\u0012')\u00059A\u0015A\t;fgR$\u0016M\u00197f\u0003BL7kY1o/&$\b\u000eV3na>\u0014\u0018M]=UC\ndW\r\u000b\u0002\u0010\u0011\u0002")
public class TableScanTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void before() {
        this.util().addTemporarySystemFunction("my_udf", (UserDefinedFunction)Func0$.MODULE$);
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |create table computed_column_t(\n                     |  a int,\n                     |  b varchar,\n                     |  c as a + 1,\n                     |  d as to_timestamp(b),\n                     |  e as my_udf(a)\n                     |) with (\n                     |  'connector' = 'values',\n                     |  'bounded' = 'true'\n                     |)\n       ")).stripMargin());
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |create table c_watermark_t(\n                     |  a int,\n                     |  b varchar,\n                     |  c as a + 1,\n                     |  d as to_timestamp(b),\n                     |  e as my_udf(a),\n                     |  WATERMARK FOR d AS d - INTERVAL '0.001' SECOND\n                     |) with (\n                     |  'connector' = 'values',\n                     |  'bounded' = 'true'\n                     |)\n       ")).stripMargin());
    }

    @Test
    public void testDDLTableScan() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE src (\n                    |  ts TIMESTAMP(3),\n                    |  a INT,\n                    |  b DOUBLE,\n                    |  WATERMARK FOR ts AS ts - INTERVAL '0.001' SECOND\n                    |) WITH (\n                    |  'connector' = 'values',\n                    |  'bounded' = 'true'\n                    |)\n      ")).stripMargin());
        this.util().verifyExecPlan("SELECT * FROM src WHERE a > 1");
    }

    @Test
    public void testScanOnUnboundedSource() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE src (\n                    |  ts TIMESTAMP(3),\n                    |  a INT,\n                    |  b DOUBLE,\n                    |  WATERMARK FOR ts AS ts - INTERVAL '0.001' SECOND\n                    |) WITH (\n                    |  'connector' = 'values',\n                    |  'bounded' = 'false'\n                    |)\n      ")).stripMargin());
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan("SELECT * FROM src WHERE a > 1")).hasMessageContaining("Querying an unbounded table 'default_catalog.default_database.src' in batch mode is not allowed. The table source is unbounded.") instanceof ValidationException;
    }

    @Test
    public void testScanOnChangelogSource() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE src (\n                    |  ts TIMESTAMP(3),\n                    |  a INT,\n                    |  b DOUBLE\n                    |) WITH (\n                    |  'connector' = 'values',\n                    |  'bounded' = 'true',\n                    |  'changelog-mode' = 'I,UA,UB'\n                    |)\n      ")).stripMargin());
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan("SELECT * FROM src WHERE a > 1")).hasMessageContaining("Querying a table in batch mode is currently only possible for INSERT-only table sources. But the source for table 'default_catalog.default_database.src' produces other changelog messages than just INSERT.") instanceof TableException;
    }

    @Test
    public void testScanOnUpsertSource() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE src (\n                    |  id STRING,\n                    |  a INT,\n                    |  b DOUBLE,\n                    |  PRIMARY KEY (id) NOT ENFORCED\n                    |) WITH (\n                    |  'connector' = 'values',\n                    |  'bounded' = 'true',\n                    |  'changelog-mode' = 'UA,D'\n                    |)\n      ")).stripMargin());
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan("SELECT * FROM src WHERE a > 1")).hasMessageContaining("Querying a table in batch mode is currently only possible for INSERT-only table sources. But the source for table 'default_catalog.default_database.src' produces other changelog messages than just INSERT.") instanceof TableException;
    }

    @Test
    public void testDDLWithComputedColumn() {
        this.util().verifyExecPlan("SELECT * FROM computed_column_t");
    }

    @Test
    public void testDDLWithWatermarkComputedColumn() {
        this.util().verifyExecPlan("SELECT * FROM c_watermark_t");
    }

    @Test
    public void testDDLWithProctime() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n         |create table proctime_t (\n         | a int,\n         | b varchar,\n         | c as a + 1,\n         | d as to_timestamp(b),\n         | e as my_udf(a),\n         | ptime as proctime()\n         |) with (\n         |  'connector' = 'values',\n         |  'bounded' = 'true'\n         |)\n      ")).stripMargin());
        this.util().verifyExecPlan("SELECT * FROM proctime_t");
    }

    @Test
    public void testTableApiScanWithComputedColumn() {
        this.util().verifyExecPlan(this.util().tableEnv().from("computed_column_t"));
    }

    @Test
    public void testTableApiScanWithWatermark() {
        this.util().verifyExecPlan(this.util().tableEnv().from("c_watermark_t"));
    }

    @Test
    public void testTableApiScanWithDDL() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |create table t1(\n                     |  a int,\n                     |  b varchar\n                     |) with (\n                     |  'connector' = 'values',\n                     |  'bounded' = 'true'\n                     |)\n       ")).stripMargin());
        this.util().verifyExecPlan(this.util().tableEnv().from("t1"));
    }

    @Test
    public void testTableApiScanWithTemporaryTable() {
        this.util().tableEnv().createTemporaryTable("t1", TableDescriptor.forConnector((String)"datagen").schema(Schema.newBuilder().column("word", (AbstractDataType)DataTypes.STRING()).build()).option("number-of-rows", "1").build());
        this.util().verifyExecPlan(this.util().tableEnv().from("t1"));
    }
}

