/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.connector.sink.abilities.SupportsRowLevelDelete;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.collection.Seq;

@ExtendWith(value={ParameterizedTestExtension.class})
class RowLevelDeleteTest
extends TableTestBase {
    private final SupportsRowLevelDelete.RowLevelDeleteMode deleteMode;
    private final Seq<ExplainDetail> explainDetails = JavaScalaConversionUtil.toScala(Collections.singletonList(ExplainDetail.JSON_EXECUTION_PLAN));
    private BatchTableTestUtil util;

    @Parameters(name="deleteMode = {0}")
    private static Collection<SupportsRowLevelDelete.RowLevelDeleteMode> data() {
        return Arrays.asList(SupportsRowLevelDelete.RowLevelDeleteMode.DELETED_ROWS, SupportsRowLevelDelete.RowLevelDeleteMode.REMAINING_ROWS);
    }

    RowLevelDeleteTest(SupportsRowLevelDelete.RowLevelDeleteMode deleteMode) {
        this.deleteMode = deleteMode;
    }

    @BeforeEach
    void before() {
        this.util = this.batchTestUtil(TableConfig.getDefault());
        this.util.tableEnv().getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, (Object)12);
    }

    @TestTemplate
    void testDeleteWithoutFilter() {
        this.createTableForDelete();
        this.util.verifyExplainInsert("DELETE FROM t", this.explainDetails);
    }

    @TestTemplate
    void testDeleteWithFilter() {
        this.createTableForDelete();
        this.util.verifyExplainInsert("DELETE FROM t where a = 1 and b = '123'", this.explainDetails);
    }

    @TestTemplate
    void testDeleteWithSubQuery() {
        this.createTableForDelete();
        this.util.verifyExplainInsert("DELETE FROM t where b = '123' and a = (select count(*) from t)", this.explainDetails);
    }

    @TestTemplate
    void testDeleteWithCustomColumns() {
        this.util.tableEnv().executeSql(String.format("CREATE TABLE t (a int, b string, c double) WITH ('connector' = 'test-update-delete', 'required-columns-for-delete' = 'b;c', 'delete-mode' = '%s', 'support-delete-push-down' = 'false') ", this.deleteMode));
        this.util.verifyExplainInsert("DELETE FROM t where b = '123'", this.explainDetails);
    }

    @TestTemplate
    void testDeleteWithMetaColumns() {
        this.util.tableEnv().executeSql(String.format("CREATE TABLE t (a int, b string, c double) WITH ('connector' = 'test-update-delete', 'required-columns-for-delete' = 'meta_f1;meta_k2;b', 'delete-mode' = '%s', 'support-delete-push-down' = 'false') ", this.deleteMode));
        this.util.verifyExplainInsert("DELETE FROM t where b = '123'", this.explainDetails);
    }

    private void createTableForDelete() {
        this.util.tableEnv().executeSql(String.format("CREATE TABLE t (a int, b string) WITH ('connector' = 'test-update-delete', 'delete-mode' = '%s', 'support-delete-push-down' = 'false') ", this.deleteMode));
    }
}

