/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionImpl;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.expressions.utils.Func1$;
import org.apache.flink.table.planner.factories.TestValuesCatalog;
import org.apache.flink.table.planner.plan.batch.sql.PartitionableSourceTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001\u0002\u000b\u0016\u0001\u0019B\u0001\"\f\u0001\u0003\u0006\u0004%\tA\f\u0005\tk\u0001\u0011\t\u0011)A\u0005_!Aa\u0007\u0001BC\u0002\u0013\u0005a\u0006\u0003\u00058\u0001\t\u0005\t\u0015!\u00030\u0011\u0015A\u0004\u0001\"\u0001:\u0011\u001dq\u0004A1A\u0005\n}Baa\u0011\u0001!\u0002\u0013\u0001\u0005\"\u0002#\u0001\t\u0003)\u0005\"\u0002+\u0001\t\u0003)\u0005\"B-\u0001\t\u0003)\u0005\"B.\u0001\t\u0003)\u0005\"B/\u0001\t\u0003)\u0005\"B0\u0001\t\u0003)\u0005\"B1\u0001\t\u0003)\u0005\"B2\u0001\t\u0003)u!\u0002>\u0016\u0011\u0003Yh!\u0002\u000b\u0016\u0011\u0003a\bB\u0002\u001d\u0012\t\u0003\t\t\u0001C\u0004\u0002\u0004E!\t!!\u0002\u0003/A\u000b'\u000f^5uS>t\u0017M\u00197f'>,(oY3UKN$(B\u0001\f\u0018\u0003\r\u0019\u0018\u000f\u001c\u0006\u00031e\tQAY1uG\"T!AG\u000e\u0002\tAd\u0017M\u001c\u0006\u00039u\tq\u0001\u001d7b]:,'O\u0003\u0002\u001f?\u0005)A/\u00192mK*\u0011\u0001%I\u0001\u0006M2Lgn\u001b\u0006\u0003E\r\na!\u00199bG\",'\"\u0001\u0013\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u00019\u0003C\u0001\u0015,\u001b\u0005I#B\u0001\u0016\u001c\u0003\u0015)H/\u001b7t\u0013\ta\u0013FA\u0007UC\ndW\rV3ti\n\u000b7/Z\u0001\u0016g>,(oY3GKR\u001c\u0007\u000eU1si&$\u0018n\u001c8t+\u0005y\u0003C\u0001\u00194\u001b\u0005\t$\"\u0001\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\n$a\u0002\"p_2,\u0017M\\\u0001\u0017g>,(oY3GKR\u001c\u0007\u000eU1si&$\u0018n\u001c8tA\u0005\u0001Ro]3DCR\fGn\\4GS2$XM]\u0001\u0012kN,7)\u0019;bY><g)\u001b7uKJ\u0004\u0013A\u0002\u001fj]&$h\bF\u0002;yu\u0002\"a\u000f\u0001\u000e\u0003UAQ!L\u0003A\u0002=BQAN\u0003A\u0002=\nA!\u001e;jYV\t\u0001\t\u0005\u0002)\u0003&\u0011!)\u000b\u0002\u0013\u0005\u0006$8\r\u001b+bE2,G+Z:u+RLG.A\u0003vi&d\u0007%A\u0003tKR,\b\u000fF\u0001G!\t\u0001t)\u0003\u0002Ic\t!QK\\5uQ\tA!\n\u0005\u0002L%6\tAJ\u0003\u0002N\u001d\u0006\u0019\u0011\r]5\u000b\u0005=\u0003\u0016a\u00026va&$XM\u001d\u0006\u0003#\u000e\nQA[;oSRL!a\u0015'\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0012uKN$8+[7qY\u0016\u0004\u0016M\u001d;ji&|gNR5fY\u0012\u0004&/\u001a3jG\u0006$X-\r\u0015\u0003\u0013Y\u0003\"aS,\n\u0005ac%\u0001\u0004+fgR$V-\u001c9mCR,\u0017A\u000b;fgR\u0004\u0016M\u001d;jC2\u0004\u0016M\u001d;ji&|gNR5fY\u0012\u0004&/\u001a3jG\u0006$X\rU;tQ\u0012{wO\u001c\u0015\u0003\u0015Y\u000b1\u0004^3ti^KG\u000f[+eM\u0006sGMV5siV\fGnQ8mk6t\u0007FA\u0006W\u0003e!Xm\u001d;V]\u000e|gN^3si\u0016$W\t\u001f9sKN\u001c\u0018n\u001c8)\u000511\u0016a\r;fgR\u0004Vo\u001d5E_^t\u0007+\u0019:uSRLwN\\!oI\u001aKG\u000e^3sg\u000e{g\u000e^1j]B\u000b'\u000f^5uS>t7*Z=tQ\tia+A$uKN$\b+^:i\t><h\u000eU1si&$\u0018n\u001c8B]\u00124\u0015\u000e\u001c;feN\u001cuN\u001c;bS:\u0004\u0016M\u001d;ji&|gnS3zg^KG\u000f[*j]\u001edW\r\u0015:pU\u0016\u001cG/[8oQ\tqa+\u0001\u0011uKN$\b+^:i\t><hNT8o\u000bbL7\u000f^3oiB\u000b'\u000f^5uS>t\u0007FA\bWQ\u0011\u0001a\r\\7\u0011\u0005\u001dTW\"\u00015\u000b\u0005%d\u0015!C3yi\u0016t7/[8o\u0013\tY\u0007N\u0001\u0006FqR,g\u000eZ,ji\"\fQA^1mk\u0016d\u0013A\\\u0012\u0002_B\u0011\u0001\u000f_\u0007\u0002c*\u0011!o]\u0001\u000ea\u0006\u0014\u0018-\\3uKJL'0\u001a3\u000b\u0005Q,\u0018AC3yi\u0016t7/[8og*\u0011\u0011K\u001e\u0006\u0003o~\t\u0011\u0002^3tiV$\u0018\u000e\\:\n\u0005e\f(A\u0007)be\u0006lW\r^3sSj,G\rV3ti\u0016CH/\u001a8tS>t\u0017a\u0006)beRLG/[8oC\ndWmU8ve\u000e,G+Z:u!\tY\u0014c\u0005\u0002\u0012{B\u0011\u0001G`\u0005\u0003\u007fF\u0012a!\u00118z%\u00164G#A>\u0002\u0015A\f'/Y7fi\u0016\u00148\u000f\u0006\u0002\u0002\bA1\u0011\u0011BA\t\u0003+i!!a\u0003\u000b\u0007y\niA\u0003\u0002\u0002\u0010\u0005!!.\u0019<b\u0013\u0011\t\u0019\"a\u0003\u0003\u0015\r{G\u000e\\3di&|g\u000eE\u00031\u0003/\tY\"C\u0002\u0002\u001aE\u0012Q!\u0011:sCf\u00042\u0001MA\u000f\u0013\r\ty\"\r\u0002\u0004\u0003:L\bfB\n\u0002$\u0005%\u00121\u0006\t\u0004a\u0006\u0015\u0012bAA\u0014c\nQ\u0001+\u0019:b[\u0016$XM]:\u0002\t9\fW.Z\u0011\u0003\u0003[\tqf]8ve\u000e,g)\u001a;dQB\u000b'\u000f^5uS>t7/P>1{2\u0002So]3DCR\fGn\\4GS2$XM]\u001f|cu\u0004")
public class PartitionableSourceTest
extends TableTestBase {
    private final boolean sourceFetchPartitions;
    private final boolean useCatalogFilter;
    private final BatchTableTestUtil util;

    @Parameters(name="sourceFetchPartitions={0}, useCatalogFilter={1}")
    public static Collection<Object[]> parameters() {
        return PartitionableSourceTest$.MODULE$.parameters();
    }

    public boolean sourceFetchPartitions() {
        return this.sourceFetchPartitions;
    }

    public boolean useCatalogFilter() {
        return this.useCatalogFilter;
    }

    private BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        String partitionableTable = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE PartitionableTable (\n        |  id int,\n        |  name string,\n        |  part1 string,\n        |  part2 int,\n        |  virtualField as part2 + 1)\n        |  partitioned by (part1, part2)\n        |  with (\n        |    'connector' = 'values',\n        |    'bounded' = 'true',\n        |    'partition-list' = '%s'\n        |)\n        |")).stripMargin();
        String partitionableAndFilterableTable = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE PartitionableAndFilterableTable (\n        |  id int,\n        |  name string,\n        |  part1 string,\n        |  part2 int,\n        |  virtualField as part2 + 1)\n        |  partitioned by (part1, part2)\n        |  with (\n        |    'connector' = 'values',\n        |    'bounded' = 'true',\n        |    'partition-list' = '%s',\n        |    'filterable-fields' = 'id;part1;part2'\n        |)\n        |")).stripMargin();
        if (this.sourceFetchPartitions()) {
            String partitions = "part1:A,part2:1;part1:A,part2:2;part1:B,part2:3;part1:C,part2:1";
            this.util().tableEnv().executeSql(String.format(partitionableTable, partitions));
            this.util().tableEnv().executeSql(String.format(partitionableAndFilterableTable, partitions));
            return;
        }
        TestValuesCatalog catalog = new TestValuesCatalog("test_catalog", "test_database", this.useCatalogFilter());
        this.util().tableEnv().registerCatalog("test_catalog", (Catalog)catalog);
        this.util().tableEnv().useCatalog("test_catalog");
        this.util().tableEnv().executeSql(String.format(partitionableTable, ""));
        this.util().tableEnv().executeSql(String.format(partitionableAndFilterableTable, ""));
        ObjectPath partitionableTablePath = ObjectPath.fromString((String)"test_database.PartitionableTable");
        ObjectPath partitionableAndFilterableTablePath = ObjectPath.fromString((String)"test_database.PartitionableAndFilterableTable");
        Seq partitions = (Seq)new .colon.colon((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"A"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"1")}))), (List)new .colon.colon((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"A"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"2")}))), (List)new .colon.colon((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"B"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"3")}))), (List)new .colon.colon((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"C"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"1")}))), (List)Nil$.MODULE$))));
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            PartitionableSourceTest.$anonfun$setup$1(catalog, partitionableTablePath, partitionableAndFilterableTablePath, partition);
            return BoxedUnit.UNIT;
        });
    }

    @TestTemplate
    public void testSimplePartitionFieldPredicate1() {
        this.util().verifyExecPlan("SELECT * FROM PartitionableTable WHERE part1 = 'A'");
    }

    @TestTemplate
    public void testPartialPartitionFieldPredicatePushDown() {
        this.util().verifyExecPlan("SELECT * FROM PartitionableTable WHERE (id > 2 OR part1 = 'A') AND part2 > 1");
    }

    @TestTemplate
    public void testWithUdfAndVirtualColumn() {
        this.util().addTemporarySystemFunction("MyUdf", (UserDefinedFunction)Func1$.MODULE$);
        this.util().verifyExecPlan("SELECT * FROM PartitionableTable WHERE id > 2 AND MyUdf(part2) < 3");
    }

    @TestTemplate
    public void testUnconvertedExpression() {
        this.util().verifyExecPlan("select * from PartitionableTable where trim(part1) = 'A' and part2 > 1");
    }

    @TestTemplate
    public void testPushDownPartitionAndFiltersContainPartitionKeys() {
        this.util().verifyExecPlan("select * from PartitionableAndFilterableTable where part1 = 'A' and part2 > 1 and id > 1");
    }

    @TestTemplate
    public void testPushDownPartitionAndFiltersContainPartitionKeysWithSingleProjection() {
        this.util().verifyExecPlan("select name from PartitionableAndFilterableTable where part1 = 'A' and part2 > 1 and id > 1");
    }

    @TestTemplate
    public void testPushDownNonExistentPartition() {
        this.util().verifyExecPlan("SELECT * FROM PartitionableTable WHERE part2 = 4");
    }

    public static final /* synthetic */ void $anonfun$setup$1(TestValuesCatalog catalog$1, ObjectPath partitionableTablePath$1, ObjectPath partitionableAndFilterableTablePath$1, scala.collection.immutable.Map partition) {
        CatalogPartitionSpec catalogPartitionSpec = new CatalogPartitionSpec(JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)partition));
        CatalogPartitionImpl catalogPartition = new CatalogPartitionImpl(new HashMap(), "");
        catalog$1.createPartition(partitionableTablePath$1, catalogPartitionSpec, (CatalogPartition)catalogPartition, true);
        catalog$1.createPartition(partitionableAndFilterableTablePath$1, catalogPartitionSpec, (CatalogPartition)catalogPartition, true);
    }

    public PartitionableSourceTest(boolean sourceFetchPartitions, boolean useCatalogFilter) {
        this.sourceFetchPartitions = sourceFetchPartitions;
        this.useCatalogFilter = useCatalogFilter;
        this.util = this.batchTestUtil(this.batchTestUtil$default$1());
    }
}

