/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.BatchShuffleMode;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.mocks.MockSource;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.batch.sql.MultipleInputCreationTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005Me\u0001B\u000f\u001f\u0001=B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\")A\u000b\u0001C\u0001+\"9!\f\u0001b\u0001\n\u0013Y\u0006BB0\u0001A\u0003%A\fC\u0003a\u0001\u0011\u0005\u0011\rC\u0003s\u0001\u0011\u0005\u0011\rC\u0003x\u0001\u0011\u0005\u0011\rC\u0003z\u0001\u0011\u0005\u0011\rC\u0003|\u0001\u0011\u0005\u0011\rC\u0003~\u0001\u0011\u0005\u0011\rC\u0003\u0000\u0001\u0011\u0005\u0011\r\u0003\u0004\u0002\u0004\u0001!\t!\u0019\u0005\u0007\u0003\u000f\u0001A\u0011A1\t\r\u0005-\u0001\u0001\"\u0001b\u0011\u0019\ty\u0001\u0001C\u0001C\"1\u00111\u0003\u0001\u0005\u0002\u0005Da!a\u0006\u0001\t\u0003\t\u0007BBA\u000e\u0001\u0011\u0005\u0011\r\u0003\u0004\u0002 \u0001!\t!\u0019\u0005\u0007\u0003G\u0001A\u0011A1\t\r\u0005\u001d\u0002\u0001\"\u0001b\u0011\u0019\tY\u0003\u0001C\u0001C\"1\u0011q\u0006\u0001\u0005\u0002\u0005<q!a\u0017\u001f\u0011\u0003\tiF\u0002\u0004\u001e=!\u0005\u0011q\f\u0005\u0007)j!\t!a\u001a\t\u000f\u0005%$\u0004\"\u0001\u0002l\tIR*\u001e7uSBdW-\u00138qkR\u001c%/Z1uS>tG+Z:u\u0015\ty\u0002%A\u0002tc2T!!\t\u0012\u0002\u000b\t\fGo\u00195\u000b\u0005\r\"\u0013\u0001\u00029mC:T!!\n\u0014\u0002\u000fAd\u0017M\u001c8fe*\u0011q\u0005K\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003S)\nQA\u001a7j].T!a\u000b\u0017\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0013aA8sO\u000e\u00011C\u0001\u00011!\t\tD'D\u00013\u0015\t\u0019D%A\u0003vi&d7/\u0003\u00026e\tiA+\u00192mKR+7\u000f\u001e\"bg\u0016\f1b\u001d5vM\u001adW-T8eKB\u0011\u0001(P\u0007\u0002s)\u0011!hO\u0001\u0007G>lWn\u001c8\u000b\u0005qB\u0013aA1qS&\u0011a(\u000f\u0002\u0011\u0005\u0006$8\r[*ik\u001a4G.Z'pI\u0016\fQb]2iK\u0012,H.\u001a:UsB,\u0007CA!R\u001d\t\u0011eJ\u0004\u0002D\u0019:\u0011Ai\u0013\b\u0003\u000b*s!AR%\u000e\u0003\u001dS!\u0001\u0013\u0018\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0013BA\u0016-\u0013\tI#&\u0003\u0002NQ\u0005i1m\u001c8gS\u001e,(/\u0019;j_:L!a\u0014)\u0002#){'-T1oC\u001e,'o\u00149uS>t7O\u0003\u0002NQ%\u0011!k\u0015\u0002\u000e'\u000eDW\rZ;mKJ$\u0016\u0010]3\u000b\u0005=\u0003\u0016A\u0002\u001fj]&$h\bF\u0002W1f\u0003\"a\u0016\u0001\u000e\u0003yAQAN\u0002A\u0002]BQaP\u0002A\u0002\u0001\u000bA!\u001e;jYV\tA\f\u0005\u00022;&\u0011aL\r\u0002\u0013\u0005\u0006$8\r\u001b+bE2,G+Z:u+RLG.A\u0003vi&d\u0007%\u0001\u0004cK\u001a|'/\u001a\u000b\u0002EB\u00111MZ\u0007\u0002I*\tQ-A\u0003tG\u0006d\u0017-\u0003\u0002hI\n!QK\\5uQ\t1\u0011\u000e\u0005\u0002ka6\t1N\u0003\u0002=Y*\u0011QN\\\u0001\bUV\u0004\u0018\u000e^3s\u0015\tyG&A\u0003kk:LG/\u0003\u0002rW\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002-Q,7\u000f\u001e\"bg&\u001cW*\u001e7uSBdW-\u00138qkRD#a\u0002;\u0011\u0005),\u0018B\u0001<l\u00051!Vm\u001d;UK6\u0004H.\u0019;f\u0003Y!Xm\u001d;NC:LX*\u001e7uSBdW-\u00138qkR\u001c\bF\u0001\u0005u\u0003Y!Xm\u001d;K_&tw+\u001b;i\u0003\u001e<\u0017i\u001d)s_\n,\u0007FA\u0005u\u0003Q\"Xm\u001d;LK\u0016\u0004X*\u001e7uSBdW-\u00138qkR<\u0016\u000e\u001e5P]\u0016lU-\u001c2fe\u001a{'o\u00115bS:\f'\r\\3T_V\u00148-\u001a\u0015\u0003\u0015Q\fA\u0005^3ti\u00063x.\u001b3J]\u000edW\u000fZ5oOVs\u0017n\u001c8Ge>l\u0017J\u001c9viNKG-\u001a\u0015\u0003\u0017Q\f!\u0005^3ti&s7\r\\;eKVs\u0017n\u001c8G_J\u001c\u0005.Y5oC\ndWmU8ve\u000e,\u0007F\u0001\u0007u\u00035\"Xm\u001d;Bm>LG-\u00138dYV$\u0017N\\4DC2\u001c\u0017I\u001a;fe:{gn\u00115bS:\f'\r\\3T_V\u00148-\u001a\u0015\u0003\u001bQ\f\u0011\u0005^3ti&s7\r\\;eK\u000e\u000bGn\u0019$pe\u000eC\u0017-\u001b8bE2,7k\\;sG\u0016D#A\u0004;\u00027Q,7\u000f^!w_&$\u0017J\\2mk\u0012LgnZ*j]\u001edW\r^8oQ\tyA/\u0001\ruKN$hj\u001c)sS>\u0014\u0018\u000e^=D_:\u001cHO]1j]RD#\u0001\u0005;\u0002#Q,7\u000f\u001e*fY\u0006$X\rZ%oaV$8\u000f\u000b\u0002\u0012i\u0006AB/Z:u%\u0016d\u0017\r^3e\u0013:\u0004X\u000f^:XSRD\u0017iZ4)\u0005I!\u0018\u0001\u0007;fgR\u0014V-\\8wKJ+G-\u001e8eC:$XK\\5p]\"\u00121\u0003^\u0001#i\u0016\u001cHOU3n_Z,wJ\\3J]B,Ho\u00149fe\u0006$xN\u001d$s_6\u0014vn\u001c;)\u0005Q!\u0018!\n;fgR\u001cE.Z1o+BlU\u000f\u001c;ja2,\u0017J\u001c9vi^KG\u000f[(oK6+WNY3sQ\t)B/A\nuKN$8*Z3q+N,g-\u001e7V]&|g\u000e\u000b\u0002\u0017i\u00061C/Z:u\t\u0016\fG\r\\8dW\u000e\u000bWo]3e\u0005f,\u0005p\u00195b]\u001e,\u0017J\\!oG\u0016\u001cHo\u001c:)\u0005]!\u0018AG2sK\u0006$Xm\u00115bS:\f'\r\\3UC\ndWmU8ve\u000e,\u0007f\u0002\u0001\u00024\u0005}\u0012\u0011\t\t\u0005\u0003k\tY$\u0004\u0002\u00028)\u0019\u0011\u0011H6\u0002\u0013\u0015DH/\u001a8tS>t\u0017\u0002BA\u001f\u0003o\u0011!\"\u0012=uK:$w+\u001b;i\u0003\u00151\u0018\r\\;fY\t\t\u0019e\t\u0002\u0002FA!\u0011qIA,\u001b\t\tIE\u0003\u0003\u0002L\u00055\u0013!\u00049be\u0006lW\r^3sSj,GM\u0003\u0003\u0002P\u0005E\u0013AC3yi\u0016t7/[8og*\u0019q.a\u0015\u000b\u0007\u0005U\u0003&A\u0005uKN$X\u000f^5mg&!\u0011\u0011LA%\u0005i\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^#yi\u0016t7/[8o\u0003eiU\u000f\u001c;ja2,\u0017J\u001c9vi\u000e\u0013X-\u0019;j_:$Vm\u001d;\u0011\u0005]S2c\u0001\u000e\u0002bA\u00191-a\u0019\n\u0007\u0005\u0015DM\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003;\n!\u0002]1sC6,G/\u001a:t)\t\ti\u0007E\u0003d\u0003_\n\u0019(C\u0002\u0002r\u0011\u0014Q!\u0011:sCf\u0004RaYA8\u0003k\u0002B!a\u001e\u0002\u00026\u0011\u0011\u0011\u0010\u0006\u0005\u0003w\ni(\u0001\u0003mC:<'BAA@\u0003\u0011Q\u0017M^1\n\t\u0005\r\u0015\u0011\u0010\u0002\u0007\u001f\nTWm\u0019;)\u000fq\t9)!$\u0002\u0010B!\u0011qIAE\u0013\u0011\tY)!\u0013\u0003\u0015A\u000b'/Y7fi\u0016\u00148/\u0001\u0003oC6,\u0017EAAI\u0003\u0011\u001a\b.\u001e4gY\u0016lu\u000eZ3;Am\u0004T\u0010\f\u0011tG\",G-\u001e7feRK\b/\u001a\u001e!wFj\b")
public class MultipleInputCreationTest
extends TableTestBase {
    private final BatchShuffleMode shuffleMode;
    private final JobManagerOptions.SchedulerType schedulerType;
    private final BatchTableTestUtil util;

    @Parameters(name="shuffleMode: {0}, schedulerType: {1}")
    public static Object[][] parameters() {
        return MultipleInputCreationTest$.MODULE$.parameters();
    }

    private BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void before() {
        this.util().addTableSource("x", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "nx"))}), new CaseClassTypeInfo<Tuple4<Object, Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.batch.sql.MultipleInputCreationTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTableSource("y", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ny"))}), new CaseClassTypeInfo<Tuple4<Object, Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.batch.sql.MultipleInputCreationTest$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTableSource("z", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "i")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "nz"))}), new CaseClassTypeInfo<Tuple4<Object, Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.batch.sql.MultipleInputCreationTest$$anon$5 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addDataStream("t", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.plan.batch.sql.MultipleInputCreationTest$$anon$7 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().tableConfig().set(ExecutionOptions.BATCH_SHUFFLE_MODE, (Object)this.shuffleMode);
        this.util().tableConfig().set(JobManagerOptions.SCHEDULER, (Object)this.schedulerType);
    }

    @TestTemplate
    public void testBasicMultipleInput() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM\n        |  (SELECT a FROM x INNER JOIN y ON x.a = y.d) T1\n        |  INNER JOIN\n        |  (SELECT d FROM y INNER JOIN t ON y.d = t.a) T2\n        |  ON T1.a = T2.d\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testManyMultipleInputs() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin,SortAgg");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (\n        |    SELECT a, ny, nz FROM x\n        |      LEFT JOIN y ON x.a = y.ny\n        |      LEFT JOIN z ON x.a = z.nz),\n        |  T2 AS (\n        |    SELECT T1.a AS a, t.b AS b, d, T1.ny AS ny, nz FROM T1\n        |      LEFT JOIN t ON T1.a = t.a\n        |      INNER JOIN y ON T1.a = y.d),\n        |  T3 AS (\n        |    SELECT T1.a AS a, t.b AS b, d, T1.ny AS ny, nz FROM T1\n        |      LEFT JOIN y ON T1.a = y.d\n        |      INNER JOIN t ON T1.a = t.a),\n        |  T4 AS (SELECT b, SUM(d) AS sd, SUM(ny) AS sy, SUM(nz) AS sz FROM T2 GROUP BY b),\n        |  T5 AS (SELECT b, SUM(d) AS sd, SUM(ny) AS sy, SUM(nz) AS sz FROM T3 GROUP BY b)\n        |SELECT * FROM\n        |  (SELECT t.b, sd, sy, sz FROM T4 LEFT JOIN t ON T4.b = t.b)\n        |  UNION ALL\n        |  (SELECT y.e, sd, sy, sz FROM T5 LEFT JOIN y ON T5.b = y.e)\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testJoinWithAggAsProbe() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin,SortAgg");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH T AS (SELECT a, d FROM x INNER JOIN y ON x.a = y.d)\n        |SELECT * FROM\n        |  (SELECT a, COUNT(*) AS cnt FROM T GROUP BY a) T1\n        |  LEFT JOIN\n        |  (SELECT d, SUM(a) AS sm FROM T GROUP BY d) T2\n        |  ON T1.a = T2.d\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testKeepMultipleInputWithOneMemberForChainableSource() {
        this.createChainableTableSource();
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin");
        String sql = "SELECT * FROM chainable LEFT JOIN x ON chainable.a = x.a";
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testAvoidIncludingUnionFromInputSide() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM\n        |  (SELECT a FROM (SELECT a FROM x) UNION ALL (SELECT a FROM t)) T1\n        |  LEFT JOIN y ON T1.a = y.d\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testIncludeUnionForChainableSource() {
        this.createChainableTableSource();
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM\n        |  (SELECT a FROM (SELECT a FROM chainable) UNION ALL (SELECT a FROM t)) T1\n        |  LEFT JOIN y ON T1.a = y.d\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testAvoidIncludingCalcAfterNonChainableSource() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM x\n        |  LEFT JOIN y ON x.a = y.d\n        |  LEFT JOIN t ON x.a = t.a\n        |  WHERE x.b > 10\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testIncludeCalcForChainableSource() {
        this.createChainableTableSource();
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM chainable\n        |  LEFT JOIN y ON chainable.a = y.d\n        |  LEFT JOIN t ON chainable.a = t.a\n        |  WHERE chainable.a > 10\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testAvoidIncludingSingleton() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin,HashAgg");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (SELECT COUNT(*) AS cnt FROM z),\n        |  T2 AS (\n        |    SELECT a FROM\n        |      (SELECT a FROM x INNER JOIN y ON x.a = y.d)\n        |      UNION ALL\n        |      (SELECT a FROM t FULL JOIN T1 ON t.a > T1.cnt))\n        |SELECT a FROM T2 LEFT JOIN z ON T2.a = z.g\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testNoPriorityConstraint() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,NestedLoopJoin");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM x\n        |  INNER JOIN y ON x.a = y.d\n        |  INNER JOIN t ON x.a = t.a\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testRelatedInputs() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (SELECT x.a AS a, y.d AS b FROM y LEFT JOIN x ON y.d = x.a),\n        |  T2 AS (\n        |    SELECT a, b FROM\n        |      (SELECT a, b FROM T1)\n        |      UNION ALL\n        |      (SELECT x.a AS a, x.b AS b FROM x))\n        |SELECT * FROM T2 LEFT JOIN t ON T2.a = t.a\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testRelatedInputsWithAgg() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin,SortAgg");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (SELECT x.a AS a, y.d AS b FROM y LEFT JOIN x ON y.d = x.a),\n        |  T2 AS (\n        |    SELECT a, b FROM\n        |      (SELECT a, b FROM T1)\n        |      UNION ALL\n        |      (SELECT COUNT(x.a) AS a, x.b AS b FROM x GROUP BY x.b))\n        |SELECT * FROM T2 LEFT JOIN t ON T2.a = t.a\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testRemoveRedundantUnion() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin,SortAgg");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (SELECT COUNT(*) AS cnt FROM x GROUP BY a),\n        |  T2 AS (SELECT COUNT(*) AS cnt FROM y GROUP BY d),\n        |  T3 AS (SELECT a AS cnt FROM x INNER JOIN y ON x.a = y.d),\n        |  T4 AS (SELECT b AS cnt FROM x INNER JOIN y ON x.b = y.e)\n        |SELECT cnt FROM\n        |  (SELECT cnt FROM (SELECT cnt FROM T1) UNION ALL (SELECT cnt FROM T2))\n        |  UNION ALL\n        |  (SELECT cnt FROM (SELECT cnt FROM T3) UNION ALL (SELECT cnt FROM T4))\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testRemoveOneInputOperatorFromRoot() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (SELECT a FROM x INNER JOIN y ON x.a = y.d),\n        |  T2 AS (SELECT b FROM x INNER JOIN y ON x.b = y.e)\n        |SELECT * FROM\n        |  (SELECT a, b FROM T1 LEFT JOIN T2 ON T1.a = T2.b)\n        |  UNION ALL\n        |  (SELECT a, b FROM x)\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testCleanUpMultipleInputWithOneMember() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (SELECT a FROM x INNER JOIN y ON x.a = y.d)\n        |SELECT * FROM\n        |  (SELECT a, a + 1 FROM T1)\n        |  UNION ALL\n        |  (SELECT a, b FROM x)\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testKeepUsefulUnion() {
        this.createChainableTableSource();
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (SELECT chainable.a AS a FROM chainable LEFT JOIN x ON chainable.a = x.a),\n        |  T2 AS (SELECT chainable.a AS a FROM chainable LEFT JOIN y ON chainable.a = y.d)\n        |SELECT * FROM\n        |  (SELECT a FROM T1)\n        |  UNION ALL\n        |  (SELECT a FROM T2)\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testDeadlockCausedByExchangeInAncestor() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH T1 AS (\n        |  SELECT x1.*, x2.a AS k, (x1.b + x2.b) AS v\n        |  FROM x x1 LEFT JOIN x x2 ON x1.a = x2.a WHERE x2.a > 0)\n        |SELECT x.a, x.b, T1.* FROM x LEFT JOIN T1 ON x.a = T1.k WHERE x.a > 0 AND T1.v = 0\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    public void createChainableTableSource() {
        DataStreamSource dataStream = this.util().getStreamEnv().fromSource((Source)new MockSource(Boundedness.BOUNDED, 1), WatermarkStrategy.noWatermarks(), "chainable");
        TableTestUtil$.MODULE$.createTemporaryView(this.util().tableEnv(), "chainable", dataStream, (Option<Expression[]>)new Some((Object)new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}), TableTestUtil$.MODULE$.createTemporaryView$default$5(), TableTestUtil$.MODULE$.createTemporaryView$default$6());
    }

    public MultipleInputCreationTest(BatchShuffleMode shuffleMode, JobManagerOptions.SchedulerType schedulerType) {
        this.shuffleMode = shuffleMode;
        this.schedulerType = schedulerType;
        this.util = this.batchTestUtil(this.batchTestUtil$default$1());
    }
}

