/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.match;

import java.time.Duration;
import org.apache.flink.cep.nfa.aftermatch.AfterMatchSkipStrategy;
import org.apache.flink.cep.pattern.Pattern;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.match.PatternTranslatorTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Y3A!\u0005\n\u0001?!)A\u0005\u0001C\u0001K!)q\u0005\u0001C\u0001Q!)!\b\u0001C\u0001Q!)A\b\u0001C\u0001Q!)a\b\u0001C\u0001Q!)\u0001\t\u0001C\u0001Q!)!\t\u0001C\u0001Q!)A\t\u0001C\u0001Q!)a\t\u0001C\u0001Q!)\u0001\n\u0001C\u0001Q!)!\n\u0001C\u0001Q!)A\n\u0001C\u0001Q!)a\n\u0001C\u0001Q!)\u0001\u000b\u0001C\u0001Q!)!\u000b\u0001C\u0001Q!)A\u000b\u0001C\u0001Q\t)\u0002+\u0019;uKJtGK]1og2\fGo\u001c:UKN$(BA\n\u0015\u0003\u0015i\u0017\r^2i\u0015\t)b#A\u0004qY\u0006tg.\u001a:\u000b\u0005]A\u0012!\u0002;bE2,'BA\r\u001b\u0003\u00151G.\u001b8l\u0015\tYB$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002;\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\t\t\u0003C\tj\u0011AE\u0005\u0003GI\u0011\u0011\u0004U1ui\u0016\u0014h\u000e\u0016:b]Nd\u0017\r^8s)\u0016\u001cHOQ1tK\u00061A(\u001b8jiz\"\u0012A\n\t\u0003C\u0001\tQb]5na2,\u0007+\u0019;uKJtG#A\u0015\u0011\u0005)jS\"A\u0016\u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005A\u0002\"!\r\u001d\u000e\u0003IR!a\r\u001b\u0002\u0007\u0005\u0004\u0018N\u0003\u00026m\u00059!.\u001e9ji\u0016\u0014(BA\u001c\u001d\u0003\u0015QWO\\5u\u0013\tI$G\u0001\u0003UKN$\u0018A\u0004;fgR\fe\r^3s\u001b\u0006$8\r\u001b\u0015\u0003\u0007A\nq\u0002^3tiF+\u0018M\u001c;jM&,'o\u001d\u0015\u0003\tA\nA\u0002^3ti>\u0003H/[8oC2D#!\u0002\u0019\u0002\u001bQ,7\u000f\u001e*fYV\u001cG/\u00198uQ\t1\u0001'A\u000fuKN$8i\u001c8ue>d7\t[1sg&s\u0007+\u0019;uKJtg*Y7fQ\t9\u0001'\u0001\tuKN$x+\u001b;iS:\u001cE.Y;tK\"\u0012\u0001\u0002M\u0001(i\u0016\u001cHoV5uQ&t7\t\\1vg\u0016<\u0016\u000e\u001e5ZK\u0006\u0014Xj\u001c8uQJ+7o\u001c7vi&|g\u000e\u000b\u0002\na\u0005\tC/Z:u%\u0016dWo\u0019;b]R|\u0005\u000f^5p]\u0006dgj\u001c;TkB\u0004xN\u001d;fI\"\u0012!\u0002M\u0001!i\u0016\u001cHo\u0012:pkB\u0004\u0016\r\u001e;fe:\u001c\u0018I]3O_R\u001cV\u000f\u001d9peR,G\r\u000b\u0002\fa\u0005yB/Z:u!\u0016\u0014X.\u001e;bi&|gn]!sK:{GoU;qa>\u0014H/\u001a3)\u00051\u0001\u0014!\b;fgR,\u0005p\u00197vg&|gn]!sK:{GoU;qa>\u0014H/\u001a3)\u00055\u0001\u0014a\b;fgR\fE\u000e^3s]\u0006$\u0018n\u001c8t\u0003J,gj\u001c;TkB\u0004xN\u001d;fI\"\u0012a\u0002M\u0001#i\u0016\u001cH\u000f\u00155zg&\u001c\u0017\r\\(gMN,Go]!sK:{GoU;qa>\u0014H/\u001a3)\u0005=\u0001\u0014\u0001\t;fgR\u0004\u0016\r\u001e;fe:4\u0016M]5bE2,7/T;ti\n+WK\\5rk\u0016D#\u0001\u0005\u0019")
public class PatternTranslatorTest
extends PatternTranslatorTestBase {
    @Test
    public void simplePattern() {
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   PATTERN (A B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<RowData, ? extends RowData>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).next("B"));
    }

    @Test
    public void testAfterMatch() {
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   AFTER MATCH SKIP TO NEXT ROW\n        |   PATTERN (A B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<RowData, ? extends RowData>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).next("B"));
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   AFTER MATCH SKIP TO LAST A\n        |   PATTERN (A B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<RowData, ? extends RowData>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToLast((String)"A").throwExceptionOnMiss()).next("B"));
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   AFTER MATCH SKIP TO FIRST A\n        |   PATTERN (A B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<RowData, ? extends RowData>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToFirst((String)"A").throwExceptionOnMiss()).next("B"));
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   AFTER MATCH SKIP PAST LAST ROW\n        |   PATTERN (A B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<RowData, ? extends RowData>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipPastLastEvent()).next("B"));
    }

    @Test
    public void testQuantifiers() {
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   PATTERN (A{2,} B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<RowData, ? extends RowData>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).timesOrMore(2).consecutive().greedy().next("B"));
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   PATTERN (A+ B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<RowData, ? extends RowData>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).oneOrMore().consecutive().greedy().next("B"));
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   PATTERN (A{2,6} B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<RowData, ? extends RowData>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).times(2, 6).consecutive().greedy().next("B"));
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   PATTERN (A{2})\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<RowData, ? extends RowData>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).times(2).consecutive());
    }

    @Test
    public void testOptional() {
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   PATTERN (A* B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<RowData, ? extends RowData>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).oneOrMore().consecutive().greedy().optional().next("B"));
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   PATTERN (A? B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<RowData, ? extends RowData>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).optional().next("B"));
    }

    @Test
    public void testReluctant() {
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   PATTERN (A{2,}? B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<RowData, ? extends RowData>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).timesOrMore(2).consecutive().next("B"));
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   PATTERN (A+? B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<RowData, ? extends RowData>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).oneOrMore().consecutive().next("B"));
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   PATTERN (A{2,6}? B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<RowData, ? extends RowData>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).times(2, 6).consecutive().next("B"));
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   PATTERN (A*? B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<RowData, ? extends RowData>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).oneOrMore().consecutive().optional().next("B"));
    }

    @Test
    public void testControlCharsInPatternName() {
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |  ORDER BY proctime\n        |  MEASURES\n        |    `A\"`.f0 AS aid\n        |  PATTERN (`A\"`? l C)\n        |  DEFINE\n        |    `A\"` as `A\"`.f0 = 1\n        |) AS T\n        |")).stripMargin(), (Pattern<RowData, ? extends RowData>)Pattern.begin((String)"A\"", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).optional().next("l").next("C"));
    }

    @Test
    public void testWithinClause() {
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |  ORDER BY proctime\n        |  MEASURES\n        |    A.f0 AS aid\n        |  PATTERN (A B) WITHIN INTERVAL '10 00:00:00.004' DAY TO SECOND\n        |  DEFINE\n        |    A as A.f0 = 1\n        |) AS T\n        |")).stripMargin(), (Pattern<RowData, ? extends RowData>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).next("B").within(Duration.ofMillis(864000004L)));
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |  ORDER BY proctime\n        |  MEASURES\n        |    A.f0 AS aid\n        |  PATTERN (A B) WITHIN INTERVAL '10 00' DAY TO HOUR\n        |  DEFINE\n        |    A as A.f0 = 1\n        |) AS T\n        |")).stripMargin(), (Pattern<RowData, ? extends RowData>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).next("B").within(Duration.ofMillis(864000000L)));
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |  ORDER BY proctime\n        |  MEASURES\n        |    A.f0 AS aid\n        |  PATTERN (A B) WITHIN INTERVAL '10' MINUTE\n        |  DEFINE\n        |    A as A.f0 = 1\n        |) AS T\n        |")).stripMargin(), (Pattern<RowData, ? extends RowData>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).next("B").within(Duration.ofMillis(600000L)));
    }

    @Test
    public void testWithinClauseWithYearMonthResolution() {
        Assertions.assertThatThrownBy(() -> this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n            |  ORDER BY proctime\n            |  MEASURES\n            |    A.f0 AS aid\n            |  PATTERN (A B) WITHIN INTERVAL '2-10' YEAR TO MONTH\n            |  DEFINE\n            |    A as A.f0 = 1\n            |) AS T\n            |")).stripMargin(), null)).isInstanceOf(TableException.class);
    }

    @Test
    public void testReluctantOptionalNotSupported() {
        Assertions.assertThatThrownBy(() -> this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n            |   ORDER BY proctime\n            |   MEASURES\n            |     A.f0 as aF0\n            |   PATTERN (A?? B)\n            |   DEFINE\n            |     A as A.f0 = 1\n            |)")).stripMargin(), null)).isInstanceOf(TableException.class);
    }

    @Test
    public void testGroupPatternsAreNotSupported() {
        Assertions.assertThatThrownBy(() -> this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n            |   ORDER BY proctime\n            |   MEASURES\n            |     A.f0 as aF0\n            |   PATTERN ((A B)+ C)\n            |   DEFINE\n            |     A as A.f0 = 1\n            |)")).stripMargin(), null)).isInstanceOf(TableException.class);
    }

    @Test
    public void testPermutationsAreNotSupported() {
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n              |   ORDER BY proctime\n              |   MEASURES\n              |     A.f0 AS aF0\n              |   PATTERN (PERMUTE(A  C))\n              |   DEFINE\n              |     A AS A.f0 = 1\n              |)")).stripMargin(), null)).withMessageContaining("Currently, CEP doesn't support PERMUTE patterns.");
    }

    @Test
    public void testExclusionsAreNotSupported() {
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n              |   ORDER BY proctime\n              |   MEASURES\n              |     A.f0 AS aF0\n              |   PATTERN (A { - B - }  C)\n              |   DEFINE\n              |     A AS A.f0 = 1\n              |)")).stripMargin(), null)).withMessageContaining("Currently, CEP doesn't support '{-' '-}' patterns.");
    }

    @Test
    public void testAlternationsAreNotSupported() {
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n              |   ORDER BY proctime\n              |   MEASURES\n              |     A.f0 AS aF0\n              |   PATTERN (( A | B )  C)\n              |   DEFINE\n              |     A AS A.f0 = 1\n              |)")).stripMargin(), null)).withMessageContaining("Currently, CEP doesn't support branching patterns.");
    }

    @Test
    public void testPhysicalOffsetsAreNotSupported() {
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n              |   ORDER BY proctime\n              |   MEASURES\n              |     A.f0 AS aF0\n              |   PATTERN (A)\n              |   DEFINE\n              |     A AS PREV(A.f0) = 1\n              |)")).stripMargin(), null)).withMessageContaining("Flink does not support physical offsets within partition.");
    }

    @Test
    public void testPatternVariablesMustBeUnique() {
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n              |   ORDER BY proctime\n              |   MEASURES\n              |     A.f0 AS aF0\n              |   PATTERN (A B A)\n              |   DEFINE\n              |     A AS A.f0 = 1\n              |)")).stripMargin(), null)).withMessageContaining("Pattern variables must be unique. That might change in the future.");
    }
}

