/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.hint;

import java.util.Collections;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.hint.ClearQueryHintsWithInvalidPropagationShuttleTestBase;
import org.apache.flink.table.planner.hint.FlinkHints;
import org.apache.flink.table.planner.plan.nodes.exec.spec.LookupJoinHintTestUtil;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ClearJoinHintsWithCapitalizeQueryHintsShuttleTest
extends ClearQueryHintsWithInvalidPropagationShuttleTestBase {
    ClearJoinHintsWithCapitalizeQueryHintsShuttleTest() {
    }

    @Override
    TableTestUtil getTableTestUtil() {
        return this.streamTestUtil(TableConfig.getDefault());
    }

    @Override
    boolean isBatchMode() {
        return false;
    }

    @Override
    @BeforeEach
    void before() throws Exception {
        super.before();
        this.util.tableEnv().executeSql("CREATE TABLE src (\n  a BIGINT,  pts AS PROCTIME()\n) WITH (\n 'connector' = 'values'\n)");
        this.util.tableEnv().executeSql("CREATE TABLE lookup (\n  a BIGINT\n) WITH (\n 'connector' = 'values'\n)");
        this.enableCapitalize();
    }

    @Test
    void testClearCaseInsensitiveLookupHint() {
        CorrelationId cid = this.builder.getCluster().createCorrel();
        RelDataType aType = this.builder.getTypeFactory().createStructType(Collections.singletonList(this.builder.getTypeFactory().createSqlType(SqlTypeName.BIGINT)), Collections.singletonList("a"));
        RelDataType ptsType = this.builder.getTypeFactory().createStructType(Collections.singletonList(this.builder.getTypeFactory().createProctimeIndicatorType(false)), Collections.singletonList("pts"));
        RelNode root = FlinkHints.capitalizeQueryHints((RelNode)this.builder.scan(new String[]{"src"}).scan(new String[]{"lookup"}).snapshot(this.builder.getRexBuilder().makeCall((SqlOperator)FlinkSqlOperatorTable.PROCTIME, new RexNode[0])).filter(new RexNode[]{this.builder.equals(this.builder.field(this.builder.getRexBuilder().makeCorrel(aType, cid), "a"), (RexNode)this.builder.getRexBuilder().makeInputRef(aType, 0))}).correlate(JoinRelType.INNER, cid, new RexNode[]{this.builder.getRexBuilder().makeInputRef(aType, 0), this.builder.getRexBuilder().makeInputRef(ptsType, 1)}).project(new RexNode[]{this.builder.field(1, 0, "a")}).hints(new RelHint[]{RelHint.builder((String)"ALIAS").hintOption("t1").build()}).hints(new RelHint[]{RelHint.builder((String)"lookUp").hintOptions(LookupJoinHintTestUtil.getLookupJoinHintOptions("d", true, false)).build()}).build());
        this.verifyRelPlan(root);
    }
}

