/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.DecimalDataUtils;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.planner.functions.aggfunctions.AggFunctionTestBase;
import org.apache.flink.table.runtime.functions.aggregate.MaxWithRetractAggFunction;
import org.junit.jupiter.api.Nested;

final class MaxWithRetractAggFunctionTest {
    MaxWithRetractAggFunctionTest() {
    }

    static abstract class NumberMaxWithRetractAggFunctionTest<T>
    extends MaxWithRetractAggFunctionTestBase<T> {
        NumberMaxWithRetractAggFunctionTest() {
        }

        protected abstract T getMinValue();

        protected abstract T getMaxValue();

        protected abstract T getValue(String var1);

        @Override
        protected List<List<T>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(this.getValue("1"), null, this.getMaxValue(), this.getValue("-99"), this.getValue("3"), this.getValue("56"), this.getValue("0"), this.getMinValue(), this.getValue("-20"), this.getValue("17"), null), Arrays.asList(null, null, null, null, null, null), Arrays.asList(null, this.getValue("10")));
        }

        @Override
        protected List<T> getExpectedResults() {
            return Arrays.asList(this.getMaxValue(), null, this.getValue("10"));
        }
    }

    static abstract class MaxWithRetractAggFunctionTestBase<T>
    extends AggFunctionTestBase<T, T, MaxWithRetractAggFunction.MaxWithRetractAccumulator<T>> {
        MaxWithRetractAggFunctionTestBase() {
        }

        @Override
        protected Class<?> getAccClass() {
            return MaxWithRetractAggFunction.MaxWithRetractAccumulator.class;
        }

        @Override
        protected Method getAccumulateFunc() throws NoSuchMethodException {
            return this.getAggregator().getClass().getMethod("accumulate", this.getAccClass(), Comparable.class);
        }

        @Override
        protected Method getRetractFunc() throws NoSuchMethodException {
            return this.getAggregator().getClass().getMethod("retract", this.getAccClass(), Comparable.class);
        }
    }

    @Nested
    final class TimeMaxWithRetractAggFunctionTest
    extends MaxWithRetractAggFunctionTestBase<Integer> {
        TimeMaxWithRetractAggFunctionTest() {
        }

        @Override
        protected List<List<Integer>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(0, 1000, 100, null, 10), Arrays.asList(null, null, null, null, null), Arrays.asList(null, 1));
        }

        @Override
        protected List<Integer> getExpectedResults() {
            return Arrays.asList(1000, null, 1);
        }

        @Override
        protected AggregateFunction<Integer, MaxWithRetractAggFunction.MaxWithRetractAccumulator<Integer>> getAggregator() {
            return new MaxWithRetractAggFunction(DataTypes.TIME((int)0).getLogicalType());
        }
    }

    @Nested
    final class DateMaxWithRetractAggFunctionTest
    extends MaxWithRetractAggFunctionTestBase<Integer> {
        DateMaxWithRetractAggFunctionTest() {
        }

        @Override
        protected List<List<Integer>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(0, 1000, 100, null, 10), Arrays.asList(null, null, null, null, null), Arrays.asList(null, 1));
        }

        @Override
        protected List<Integer> getExpectedResults() {
            return Arrays.asList(1000, null, 1);
        }

        @Override
        protected AggregateFunction<Integer, MaxWithRetractAggFunction.MaxWithRetractAccumulator<Integer>> getAggregator() {
            return new MaxWithRetractAggFunction(DataTypes.DATE().getLogicalType());
        }
    }

    @Nested
    final class LocalTimestamp9MaxWithRetractAggFunctionTest
    extends MaxWithRetractAggFunctionTestBase<TimestampData> {
        LocalTimestamp9MaxWithRetractAggFunctionTest() {
        }

        @Override
        protected List<List<TimestampData>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(TimestampData.fromEpochMillis((long)0L, (int)0), TimestampData.fromEpochMillis((long)1000L, (int)0), TimestampData.fromEpochMillis((long)1000L, (int)1), TimestampData.fromEpochMillis((long)100L, (int)0), null, TimestampData.fromEpochMillis((long)10L, (int)0)), Arrays.asList(null, null, null, null, null), Arrays.asList(null, TimestampData.fromEpochMillis((long)1L, (int)0), TimestampData.fromEpochMillis((long)1L, (int)1)));
        }

        @Override
        protected List<TimestampData> getExpectedResults() {
            return Arrays.asList(TimestampData.fromEpochMillis((long)1000L, (int)1), null, TimestampData.fromEpochMillis((long)1L, (int)1));
        }

        @Override
        protected AggregateFunction<TimestampData, MaxWithRetractAggFunction.MaxWithRetractAccumulator<TimestampData>> getAggregator() {
            return new MaxWithRetractAggFunction(DataTypes.TIMESTAMP_LTZ((int)9).getLogicalType());
        }
    }

    @Nested
    final class LocalTimestampMaxWithRetractAggFunctionTest
    extends MaxWithRetractAggFunctionTestBase<TimestampData> {
        LocalTimestampMaxWithRetractAggFunctionTest() {
        }

        @Override
        protected List<List<TimestampData>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(TimestampData.fromEpochMillis((long)0L), TimestampData.fromEpochMillis((long)1000L), TimestampData.fromEpochMillis((long)100L), null, TimestampData.fromEpochMillis((long)10L)), Arrays.asList(null, null, null, null, null), Arrays.asList(null, TimestampData.fromEpochMillis((long)1L)));
        }

        @Override
        protected List<TimestampData> getExpectedResults() {
            return Arrays.asList(TimestampData.fromEpochMillis((long)1000L), null, TimestampData.fromEpochMillis((long)1L));
        }

        @Override
        protected AggregateFunction<TimestampData, MaxWithRetractAggFunction.MaxWithRetractAccumulator<TimestampData>> getAggregator() {
            return new MaxWithRetractAggFunction(DataTypes.TIMESTAMP_LTZ((int)3).getLogicalType());
        }
    }

    @Nested
    final class Timestamp9MaxWithRetractAggFunctionTest
    extends MaxWithRetractAggFunctionTestBase<TimestampData> {
        Timestamp9MaxWithRetractAggFunctionTest() {
        }

        @Override
        protected List<List<TimestampData>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(TimestampData.fromEpochMillis((long)0L, (int)0), TimestampData.fromEpochMillis((long)1000L, (int)0), TimestampData.fromEpochMillis((long)1000L, (int)1), TimestampData.fromEpochMillis((long)100L, (int)0), null, TimestampData.fromEpochMillis((long)10L, (int)0)), Arrays.asList(null, null, null, null, null), Arrays.asList(null, TimestampData.fromEpochMillis((long)1L, (int)0), TimestampData.fromEpochMillis((long)1L, (int)1)));
        }

        @Override
        protected List<TimestampData> getExpectedResults() {
            return Arrays.asList(TimestampData.fromEpochMillis((long)1000L, (int)1), null, TimestampData.fromEpochMillis((long)1L, (int)1));
        }

        @Override
        protected AggregateFunction<TimestampData, MaxWithRetractAggFunction.MaxWithRetractAccumulator<TimestampData>> getAggregator() {
            return new MaxWithRetractAggFunction(DataTypes.TIMESTAMP((int)9).getLogicalType());
        }
    }

    @Nested
    final class TimestampMaxWithRetractAggFunctionTest
    extends MaxWithRetractAggFunctionTestBase<TimestampData> {
        TimestampMaxWithRetractAggFunctionTest() {
        }

        @Override
        protected List<List<TimestampData>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(TimestampData.fromEpochMillis((long)0L), TimestampData.fromEpochMillis((long)1000L), TimestampData.fromEpochMillis((long)100L), null, TimestampData.fromEpochMillis((long)10L)), Arrays.asList(null, null, null, null, null), Arrays.asList(null, TimestampData.fromEpochMillis((long)1L)));
        }

        @Override
        protected List<TimestampData> getExpectedResults() {
            return Arrays.asList(TimestampData.fromEpochMillis((long)1000L), null, TimestampData.fromEpochMillis((long)1L));
        }

        @Override
        protected AggregateFunction<TimestampData, MaxWithRetractAggFunction.MaxWithRetractAccumulator<TimestampData>> getAggregator() {
            return new MaxWithRetractAggFunction(DataTypes.TIMESTAMP((int)3).getLogicalType());
        }
    }

    @Nested
    final class StringMaxWithRetractAggFunctionTest
    extends MaxWithRetractAggFunctionTestBase<StringData> {
        StringMaxWithRetractAggFunctionTest() {
        }

        @Override
        protected List<List<StringData>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(StringData.fromString((String)"abc"), StringData.fromString((String)"def"), StringData.fromString((String)"ghi"), null, StringData.fromString((String)"jkl"), null, StringData.fromString((String)"zzz")), Arrays.asList(null, null), Arrays.asList(null, StringData.fromString((String)"a")), Arrays.asList(StringData.fromString((String)"x"), null, StringData.fromString((String)"e")));
        }

        @Override
        protected List<StringData> getExpectedResults() {
            return Arrays.asList(StringData.fromString((String)"zzz"), null, StringData.fromString((String)"a"), StringData.fromString((String)"x"));
        }

        @Override
        protected AggregateFunction<StringData, MaxWithRetractAggFunction.MaxWithRetractAccumulator<StringData>> getAggregator() {
            return new MaxWithRetractAggFunction(DataTypes.STRING().getLogicalType());
        }
    }

    @Nested
    final class DecimalMaxWithRetractAggFunctionTest
    extends MaxWithRetractAggFunctionTestBase<DecimalData> {
        private int precision = 20;
        private int scale = 6;

        DecimalMaxWithRetractAggFunctionTest() {
        }

        @Override
        protected List<List<DecimalData>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(DecimalDataUtils.castFrom((String)"1", (int)this.precision, (int)this.scale), DecimalDataUtils.castFrom((String)"1000.000001", (int)this.precision, (int)this.scale), DecimalDataUtils.castFrom((String)"-1", (int)this.precision, (int)this.scale), DecimalDataUtils.castFrom((String)"-999.998999", (int)this.precision, (int)this.scale), null, DecimalDataUtils.castFrom((String)"0", (int)this.precision, (int)this.scale), DecimalDataUtils.castFrom((String)"-999.999", (int)this.precision, (int)this.scale), null, DecimalDataUtils.castFrom((String)"999.999", (int)this.precision, (int)this.scale)), Arrays.asList(null, null, null, null, null), Arrays.asList(null, DecimalDataUtils.castFrom((String)"0", (int)this.precision, (int)this.scale)));
        }

        @Override
        protected List<DecimalData> getExpectedResults() {
            return Arrays.asList(DecimalDataUtils.castFrom((String)"1000.000001", (int)this.precision, (int)this.scale), null, DecimalDataUtils.castFrom((String)"0", (int)this.precision, (int)this.scale));
        }

        @Override
        protected AggregateFunction<DecimalData, MaxWithRetractAggFunction.MaxWithRetractAccumulator<DecimalData>> getAggregator() {
            return new MaxWithRetractAggFunction(DataTypes.DECIMAL((int)this.precision, (int)this.scale).getLogicalType());
        }
    }

    @Nested
    final class BooleanMaxWithRetractAggFunctionTest
    extends MaxWithRetractAggFunctionTestBase<Boolean> {
        BooleanMaxWithRetractAggFunctionTest() {
        }

        @Override
        protected List<List<Boolean>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(false, false, false), Arrays.asList(true, true, true), Arrays.asList(true, false, null, true, false, true, null), Arrays.asList(null, null, null), Arrays.asList(null, true));
        }

        @Override
        protected List<Boolean> getExpectedResults() {
            return Arrays.asList(false, true, true, null, true);
        }

        @Override
        protected AggregateFunction<Boolean, MaxWithRetractAggFunction.MaxWithRetractAccumulator<Boolean>> getAggregator() {
            return new MaxWithRetractAggFunction(DataTypes.BOOLEAN().getLogicalType());
        }
    }

    @Nested
    final class DoubleMaxWithRetractAggFunctionTest
    extends NumberMaxWithRetractAggFunctionTest<Double> {
        DoubleMaxWithRetractAggFunctionTest() {
        }

        @Override
        protected Double getMinValue() {
            return -8.988465674311579E307;
        }

        @Override
        protected Double getMaxValue() {
            return 8.988465674311579E307;
        }

        @Override
        protected Double getValue(String v) {
            return Double.valueOf(v);
        }

        @Override
        protected AggregateFunction<Double, MaxWithRetractAggFunction.MaxWithRetractAccumulator<Double>> getAggregator() {
            return new MaxWithRetractAggFunction(DataTypes.DOUBLE().getLogicalType());
        }
    }

    @Nested
    final class FloatMaxWithRetractAggFunctionTest
    extends NumberMaxWithRetractAggFunctionTest<Float> {
        FloatMaxWithRetractAggFunctionTest() {
        }

        @Override
        protected Float getMinValue() {
            return Float.valueOf(-1.7014117E38f);
        }

        @Override
        protected Float getMaxValue() {
            return Float.valueOf(1.7014117E38f);
        }

        @Override
        protected Float getValue(String v) {
            return Float.valueOf(v);
        }

        @Override
        protected AggregateFunction<Float, MaxWithRetractAggFunction.MaxWithRetractAccumulator<Float>> getAggregator() {
            return new MaxWithRetractAggFunction(DataTypes.FLOAT().getLogicalType());
        }
    }

    @Nested
    final class LongMaxWithRetractAggFunctionTest
    extends NumberMaxWithRetractAggFunctionTest<Long> {
        LongMaxWithRetractAggFunctionTest() {
        }

        @Override
        protected Long getMinValue() {
            return -9223372036854775807L;
        }

        @Override
        protected Long getMaxValue() {
            return 0x7FFFFFFFFFFFFFFEL;
        }

        @Override
        protected Long getValue(String v) {
            return Long.valueOf(v);
        }

        @Override
        protected AggregateFunction<Long, MaxWithRetractAggFunction.MaxWithRetractAccumulator<Long>> getAggregator() {
            return new MaxWithRetractAggFunction(DataTypes.BIGINT().getLogicalType());
        }
    }

    @Nested
    final class IntMaxWithRetractAggFunctionTest
    extends NumberMaxWithRetractAggFunctionTest<Integer> {
        IntMaxWithRetractAggFunctionTest() {
        }

        @Override
        protected Integer getMinValue() {
            return -2147483647;
        }

        @Override
        protected Integer getMaxValue() {
            return 0x7FFFFFFE;
        }

        @Override
        protected Integer getValue(String v) {
            return Integer.valueOf(v);
        }

        @Override
        protected AggregateFunction<Integer, MaxWithRetractAggFunction.MaxWithRetractAccumulator<Integer>> getAggregator() {
            return new MaxWithRetractAggFunction(DataTypes.INT().getLogicalType());
        }
    }

    @Nested
    final class ShortMaxWithRetractAggFunctionTest
    extends NumberMaxWithRetractAggFunctionTest<Short> {
        ShortMaxWithRetractAggFunctionTest() {
        }

        @Override
        protected Short getMinValue() {
            return (short)-32767;
        }

        @Override
        protected Short getMaxValue() {
            return (short)32766;
        }

        @Override
        protected Short getValue(String v) {
            return Short.valueOf(v);
        }

        @Override
        protected AggregateFunction<Short, MaxWithRetractAggFunction.MaxWithRetractAccumulator<Short>> getAggregator() {
            return new MaxWithRetractAggFunction(DataTypes.SMALLINT().getLogicalType());
        }
    }

    @Nested
    final class ByteMaxWithRetractAggFunctionTest
    extends NumberMaxWithRetractAggFunctionTest<Byte> {
        ByteMaxWithRetractAggFunctionTest() {
        }

        @Override
        protected Byte getMinValue() {
            return (byte)-127;
        }

        @Override
        protected Byte getMaxValue() {
            return (byte)126;
        }

        @Override
        protected Byte getValue(String v) {
            return Byte.valueOf(v);
        }

        @Override
        protected AggregateFunction<Byte, MaxWithRetractAggFunction.MaxWithRetractAccumulator<Byte>> getAggregator() {
            return new MaxWithRetractAggFunction(DataTypes.TINYINT().getLogicalType());
        }
    }
}

