/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.DecimalDataUtils;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.planner.functions.aggfunctions.AggFunctionTestBase;
import org.apache.flink.table.runtime.functions.aggregate.LastValueAggFunction;
import org.junit.jupiter.api.Nested;

final class LastValueAggFunctionWithoutOrderTest {
    LastValueAggFunctionWithoutOrderTest() {
    }

    static abstract class NumberLastValueAggFunctionWithoutOrderTestBase<T>
    extends LastValueAggFunctionWithoutOrderTestBase<T> {
        NumberLastValueAggFunctionWithoutOrderTestBase() {
        }

        protected abstract T getValue(String var1);

        @Override
        protected List<List<T>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(this.getValue("1"), null, this.getValue("-99"), this.getValue("3"), null), Arrays.asList(null, null, null, null), Arrays.asList(null, this.getValue("10"), null, this.getValue("3")));
        }

        @Override
        protected List<T> getExpectedResults() {
            return Arrays.asList(this.getValue("3"), null, this.getValue("3"));
        }
    }

    static abstract class LastValueAggFunctionWithoutOrderTestBase<T>
    extends AggFunctionTestBase<T, T, RowData> {
        LastValueAggFunctionWithoutOrderTestBase() {
        }

        @Override
        protected Class<?> getAccClass() {
            return RowData.class;
        }
    }

    @Nested
    final class StringLastValueAggFunctionWithoutOrderTest
    extends LastValueAggFunctionWithoutOrderTestBase<StringData> {
        StringLastValueAggFunctionWithoutOrderTest() {
        }

        @Override
        protected List<List<StringData>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(StringData.fromString((String)"abc"), StringData.fromString((String)"def"), StringData.fromString((String)"ghi"), null, StringData.fromString((String)"jkl"), null, StringData.fromString((String)"zzz")), Arrays.asList(null, null), Arrays.asList(null, StringData.fromString((String)"a"), null), Arrays.asList(StringData.fromString((String)"x"), null, StringData.fromString((String)"e")));
        }

        @Override
        protected List<StringData> getExpectedResults() {
            return Arrays.asList(StringData.fromString((String)"zzz"), null, StringData.fromString((String)"a"), StringData.fromString((String)"e"));
        }

        @Override
        protected AggregateFunction<StringData, RowData> getAggregator() {
            return new LastValueAggFunction(DataTypes.STRING().getLogicalType());
        }
    }

    @Nested
    final class DecimalLastValueAggFunctionWithoutOrderTest
    extends LastValueAggFunctionWithoutOrderTestBase<DecimalData> {
        private int precision = 20;
        private int scale = 6;

        DecimalLastValueAggFunctionWithoutOrderTest() {
        }

        @Override
        protected List<List<DecimalData>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(DecimalDataUtils.castFrom((String)"1", (int)this.precision, (int)this.scale), DecimalDataUtils.castFrom((String)"1000.000001", (int)this.precision, (int)this.scale), DecimalDataUtils.castFrom((String)"-1", (int)this.precision, (int)this.scale), DecimalDataUtils.castFrom((String)"-999.998999", (int)this.precision, (int)this.scale), null, DecimalDataUtils.castFrom((String)"0", (int)this.precision, (int)this.scale), DecimalDataUtils.castFrom((String)"-999.999", (int)this.precision, (int)this.scale), null, DecimalDataUtils.castFrom((String)"999.999", (int)this.precision, (int)this.scale)), Arrays.asList(null, null, null, null, null), Arrays.asList(null, DecimalDataUtils.castFrom((String)"0", (int)this.precision, (int)this.scale)));
        }

        @Override
        protected List<DecimalData> getExpectedResults() {
            return Arrays.asList(DecimalDataUtils.castFrom((String)"999.999", (int)this.precision, (int)this.scale), null, DecimalDataUtils.castFrom((String)"0", (int)this.precision, (int)this.scale));
        }

        @Override
        protected AggregateFunction<DecimalData, RowData> getAggregator() {
            return new LastValueAggFunction(DataTypes.DECIMAL((int)this.precision, (int)this.scale).getLogicalType());
        }
    }

    @Nested
    final class BooleanLastValueAggFunctionWithoutOrderTest
    extends LastValueAggFunctionWithoutOrderTestBase<Boolean> {
        BooleanLastValueAggFunctionWithoutOrderTest() {
        }

        @Override
        protected List<List<Boolean>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(false, false, false), Arrays.asList(true, true, true), Arrays.asList(true, false, null, true, false, true, null), Arrays.asList(null, null, null), Arrays.asList(null, true));
        }

        @Override
        protected List<Boolean> getExpectedResults() {
            return Arrays.asList(false, true, true, null, true);
        }

        @Override
        protected AggregateFunction<Boolean, RowData> getAggregator() {
            return new LastValueAggFunction(DataTypes.BOOLEAN().getLogicalType());
        }
    }

    @Nested
    final class DoubleLastValueAggFunctionWithoutOrderTest
    extends NumberLastValueAggFunctionWithoutOrderTestBase<Double> {
        DoubleLastValueAggFunctionWithoutOrderTest() {
        }

        @Override
        protected Double getValue(String v) {
            return Double.valueOf(v);
        }

        @Override
        protected AggregateFunction<Double, RowData> getAggregator() {
            return new LastValueAggFunction(DataTypes.DOUBLE().getLogicalType());
        }
    }

    @Nested
    final class FloatLastValueAggFunctionWithoutOrderTest
    extends NumberLastValueAggFunctionWithoutOrderTestBase<Float> {
        FloatLastValueAggFunctionWithoutOrderTest() {
        }

        @Override
        protected Float getValue(String v) {
            return Float.valueOf(v);
        }

        @Override
        protected AggregateFunction<Float, RowData> getAggregator() {
            return new LastValueAggFunction(DataTypes.FLOAT().getLogicalType());
        }
    }

    @Nested
    final class LongLastValueAggFunctionWithoutOrderTest
    extends NumberLastValueAggFunctionWithoutOrderTestBase<Long> {
        LongLastValueAggFunctionWithoutOrderTest() {
        }

        @Override
        protected Long getValue(String v) {
            return Long.valueOf(v);
        }

        @Override
        protected AggregateFunction<Long, RowData> getAggregator() {
            return new LastValueAggFunction(DataTypes.BIGINT().getLogicalType());
        }
    }

    @Nested
    final class IntLastValueAggFunctionWithoutOrderTest
    extends NumberLastValueAggFunctionWithoutOrderTestBase<Integer> {
        IntLastValueAggFunctionWithoutOrderTest() {
        }

        @Override
        protected Integer getValue(String v) {
            return Integer.valueOf(v);
        }

        @Override
        protected AggregateFunction<Integer, RowData> getAggregator() {
            return new LastValueAggFunction(DataTypes.INT().getLogicalType());
        }
    }

    @Nested
    final class ShortLastValueAggFunctionWithoutOrderTest
    extends NumberLastValueAggFunctionWithoutOrderTestBase<Short> {
        ShortLastValueAggFunctionWithoutOrderTest() {
        }

        @Override
        protected Short getValue(String v) {
            return Short.valueOf(v);
        }

        @Override
        protected AggregateFunction<Short, RowData> getAggregator() {
            return new LastValueAggFunction(DataTypes.SMALLINT().getLogicalType());
        }
    }

    @Nested
    final class ByteLastValueAggFunctionWithoutOrderTest
    extends NumberLastValueAggFunctionWithoutOrderTestBase<Byte> {
        ByteLastValueAggFunctionWithoutOrderTest() {
        }

        @Override
        protected Byte getValue(String v) {
            return Byte.valueOf(v);
        }

        @Override
        protected AggregateFunction<Byte, RowData> getAggregator() {
            return new LastValueAggFunction(DataTypes.TINYINT().getLogicalType());
        }
    }
}

