/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Stream;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.planner.functions.BuiltInAggregateFunctionTestBase;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;

class PercentileAggFunctionITCase
extends BuiltInAggregateFunctionTestBase {
    PercentileAggFunctionITCase() {
    }

    @Override
    Stream<BuiltInAggregateFunctionTestBase.TestSpec> getTestCaseSpecs() {
        return Stream.of(this.percentileTestCases()).flatMap(s -> s);
    }

    private Stream<BuiltInAggregateFunctionTestBase.TestSpec> percentileTestCases() {
        return Stream.of(BuiltInAggregateFunctionTestBase.TestSpec.forFunction(BuiltInFunctionDefinitions.PERCENTILE).withDescription("Double value").withSource(DataTypes.ROW((DataType[])new DataType[]{DataTypes.DOUBLE(), DataTypes.INT(), DataTypes.STRING()}), Arrays.asList(Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{1.0, 1, "A"}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{5.0, 2, "A"}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{4.0, 1, "A"}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{2.0, 4, "A"}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{9.0, 3, "A"}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{1.0, 2, "A"}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{4.0, 1, "A"}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{null, 1, "B"}), Row.ofKind((RowKind)RowKind.DELETE, (Object[])new Object[]{null, 1, "B"}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{3.0, null, "B"}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{2.0, 3, "B"}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{2.0, -1, "B"}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{6.0, 2, "B"}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{9.0, 1, "B"}), Row.ofKind((RowKind)RowKind.DELETE, (Object[])new Object[]{9.0, 1, "B"}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{2.0, 3, "B"}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{4.0, 1, "B"}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{1.0, 2, "C"}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{2.0, 1, "C"}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{2.0, -1, "C"}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{2.0, null, "C"}), Row.ofKind((RowKind)RowKind.DELETE, (Object[])new Object[]{2.0, 1, "C"}), Row.ofKind((RowKind)RowKind.DELETE, (Object[])new Object[]{2.0, -1, "C"}), Row.ofKind((RowKind)RowKind.DELETE, (Object[])new Object[]{2.0, null, "C"}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{1.0, 2, "C"}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{2.0, 1, "C"}))).testResult(source -> "SELECT PERCENTILE(f0, 0.5), f2 FROM " + source + " GROUP BY f2", BuiltInAggregateFunctionTestBase.TableApiAggSpec.groupBySelect(Collections.singletonList(Expressions.$((String)"f2")), new Expression[]{(Expression)Expressions.$((String)"f0").percentile((Object)0.5), Expressions.$((String)"f2")}), DataTypes.ROW((DataType[])new DataType[]{DataTypes.DOUBLE(), DataTypes.STRING()}), DataTypes.ROW((DataType[])new DataType[]{DataTypes.DOUBLE(), DataTypes.STRING()}), Arrays.asList(Row.of((Object[])new Object[]{4.0, "A"}), Row.of((Object[])new Object[]{3.5, "B"}), Row.of((Object[])new Object[]{2.0, "C"}))).testResult(source -> "SELECT PERCENTILE(f0, 0.5), PERCENTILE(f0, 0.3), f2 FROM " + source + " GROUP BY f2", BuiltInAggregateFunctionTestBase.TableApiAggSpec.groupBySelect(Collections.singletonList(Expressions.$((String)"f2")), new Expression[]{(Expression)Expressions.$((String)"f0").percentile((Object)0.5), (Expression)Expressions.$((String)"f0").percentile((Object)0.3), Expressions.$((String)"f2")}), DataTypes.ROW((DataType[])new DataType[]{DataTypes.DOUBLE(), DataTypes.DOUBLE(), DataTypes.STRING()}), DataTypes.ROW((DataType[])new DataType[]{DataTypes.DOUBLE(), DataTypes.DOUBLE(), DataTypes.STRING()}), Arrays.asList(Row.of((Object[])new Object[]{4.0, 1.7999999999999998, "A"}), Row.of((Object[])new Object[]{3.5, 2.9, "B"}), Row.of((Object[])new Object[]{2.0, 2.0, "C"}))).testResult(source -> "SELECT PERCENTILE(f0, 0.5, f1), f2 FROM " + source + " GROUP BY f2", BuiltInAggregateFunctionTestBase.TableApiAggSpec.groupBySelect(Collections.singletonList(Expressions.$((String)"f2")), new Expression[]{(Expression)Expressions.$((String)"f0").percentile((Object)0.5, (Object)Expressions.$((String)"f1")), Expressions.$((String)"f2")}), DataTypes.ROW((DataType[])new DataType[]{DataTypes.DOUBLE(), DataTypes.STRING()}), DataTypes.ROW((DataType[])new DataType[]{DataTypes.DOUBLE(), DataTypes.STRING()}), Arrays.asList(Row.of((Object[])new Object[]{3.0, "A"}), Row.of((Object[])new Object[]{6.0, "B"}), Row.of((Object[])new Object[]{2.0, "C"}))).testResult(source -> "SELECT PERCENTILE(f0, ARRAY[0.9, 0.7, 0.3, 1.0]), f2 FROM " + source + " GROUP BY f2", BuiltInAggregateFunctionTestBase.TableApiAggSpec.groupBySelect(Collections.singletonList(Expressions.$((String)"f2")), new Expression[]{(Expression)Expressions.$((String)"f0").percentile((Object)new double[]{0.9, 0.7, 0.3, 1.0}), Expressions.$((String)"f2")}), DataTypes.ROW((DataType[])new DataType[]{DataTypes.ARRAY((DataType)DataTypes.DOUBLE()), DataTypes.STRING()}), DataTypes.ROW((DataType[])new DataType[]{DataTypes.ARRAY((DataType)DataTypes.DOUBLE()), DataTypes.STRING()}), Arrays.asList(Row.of((Object[])new Object[]{new Double[]{6.600000000000001, 4.199999999999999, 1.7999999999999998, 9.0}, "A"}), Row.of((Object[])new Object[]{new Double[]{5.4, 4.199999999999999, 2.9, 6.0}, "B"}), Row.of((Object[])new Object[]{new Double[]{2.0, 2.0, 2.0, 2.0}, "C"}))).testResult(source -> "SELECT PERCENTILE(f0, ARRAY_REMOVE(ARRAY[0.0], 0.0)), f2 FROM " + source + " GROUP BY f2", BuiltInAggregateFunctionTestBase.TableApiAggSpec.groupBySelect(Collections.singletonList(Expressions.$((String)"f2")), new Expression[]{(Expression)Expressions.$((String)"f0").percentile(Expressions.array((Object)0.0, (Object[])new Object[0]).arrayRemove((Object)0.0)), Expressions.$((String)"f2")}), DataTypes.ROW((DataType[])new DataType[]{DataTypes.ARRAY((DataType)DataTypes.DOUBLE()), DataTypes.STRING()}), DataTypes.ROW((DataType[])new DataType[]{DataTypes.ARRAY((DataType)DataTypes.DOUBLE()), DataTypes.STRING()}), Arrays.asList(Row.of((Object[])new Object[]{null, "A"}), Row.of((Object[])new Object[]{null, "B"}), Row.of((Object[])new Object[]{null, "C"}))).testResult(source -> "SELECT PERCENTILE(f0, ARRAY[0.9, 0.7, 0.3, 1.0], f1), f2 FROM " + source + " GROUP BY f2", BuiltInAggregateFunctionTestBase.TableApiAggSpec.groupBySelect(Collections.singletonList(Expressions.$((String)"f2")), new Expression[]{(Expression)Expressions.$((String)"f0").percentile((Object)new double[]{0.9, 0.7, 0.3, 1.0}, (Object)Expressions.$((String)"f1")), Expressions.$((String)"f2")}), DataTypes.ROW((DataType[])new DataType[]{DataTypes.ARRAY((DataType)DataTypes.DOUBLE()), DataTypes.STRING()}), DataTypes.ROW((DataType[])new DataType[]{DataTypes.ARRAY((DataType)DataTypes.DOUBLE()), DataTypes.STRING()}), Arrays.asList(Row.of((Object[])new Object[]{new Double[]{9.0, 5.0, 2.0, 9.0}, "A"}), Row.of((Object[])new Object[]{new Double[]{6.0, 6.0, 5.2, 6.0}, "B"}), Row.of((Object[])new Object[]{new Double[]{2.0, 2.0, 2.0, 2.0}, "C"}))), BuiltInAggregateFunctionTestBase.TestSpec.forFunction(BuiltInFunctionDefinitions.PERCENTILE).withDescription("DecimalData value").withSource(DataTypes.ROW((DataType[])new DataType[]{DataTypes.DECIMAL((int)2, (int)1), DataTypes.STRING()}), Arrays.asList(Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{null, "B"}), Row.ofKind((RowKind)RowKind.DELETE, (Object[])new Object[]{null, "B"}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{BigDecimal.valueOf(3.0), "B"}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{BigDecimal.valueOf(2.0), "B"}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{BigDecimal.valueOf(2.0), "B"}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{BigDecimal.valueOf(9.0), "B"}), Row.ofKind((RowKind)RowKind.DELETE, (Object[])new Object[]{BigDecimal.valueOf(2.0), "B"}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{BigDecimal.valueOf(2.0), "B"}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{BigDecimal.valueOf(5.0), "B"}))).testResult(source -> "SELECT PERCENTILE(f0, 0.1), f1 FROM " + source + " GROUP BY f1", BuiltInAggregateFunctionTestBase.TableApiAggSpec.groupBySelect(Collections.singletonList(Expressions.$((String)"f1")), new Expression[]{(Expression)Expressions.$((String)"f0").percentile((Object)0.1), Expressions.$((String)"f1")}), DataTypes.ROW((DataType[])new DataType[]{DataTypes.DOUBLE(), DataTypes.STRING()}), DataTypes.ROW((DataType[])new DataType[]{DataTypes.DOUBLE(), DataTypes.STRING()}), Arrays.asList(Row.of((Object[])new Object[]{3.4000000000000004, "B"}))), BuiltInAggregateFunctionTestBase.TestSpec.forFunction(BuiltInFunctionDefinitions.PERCENTILE).withDescription("Validation Error").withSource(DataTypes.ROW((DataType[])new DataType[]{DataTypes.DOUBLE(), DataTypes.STRING()}), Arrays.asList(Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{1.0, "A"}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{2.0, "A"}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{3.0, "A"}))).testValidationError(source -> "SELECT PERCENTILE(f0, 1.5), f1 FROM " + source + " GROUP BY f1", BuiltInAggregateFunctionTestBase.TableApiAggSpec.groupBySelect(Collections.singletonList(Expressions.$((String)"f1")), new Expression[]{(Expression)Expressions.$((String)"f0").percentile((Object)1.5), Expressions.$((String)"f1")}), "Invalid input arguments. Expected signatures are:\nPERCENTILE(expr <NUMERIC>, percentage [<NUMERIC NOT NULL> | ARRAY<NUMERIC NOT NULL> NOT NULL])\nPERCENTILE(expr <NUMERIC>, percentage [<NUMERIC NOT NULL> | ARRAY<NUMERIC NOT NULL> NOT NULL], frequency <INTEGER_NUMERIC>)").testValidationError(source -> "SELECT PERCENTILE(f0, -1), f1 FROM " + source + " GROUP BY f1", BuiltInAggregateFunctionTestBase.TableApiAggSpec.groupBySelect(Collections.singletonList(Expressions.$((String)"f1")), new Expression[]{(Expression)Expressions.$((String)"f0").percentile((Object)-1), Expressions.$((String)"f1")}), "Invalid input arguments. Expected signatures are:\nPERCENTILE(expr <NUMERIC>, percentage [<NUMERIC NOT NULL> | ARRAY<NUMERIC NOT NULL> NOT NULL])\nPERCENTILE(expr <NUMERIC>, percentage [<NUMERIC NOT NULL> | ARRAY<NUMERIC NOT NULL> NOT NULL], frequency <INTEGER_NUMERIC>)"), BuiltInAggregateFunctionTestBase.TestSpec.forFunction(BuiltInFunctionDefinitions.PERCENTILE).withDescription("Runtime Error").withSource(DataTypes.ROW((DataType[])new DataType[]{DataTypes.DOUBLE(), DataTypes.STRING()}), Arrays.asList(Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{1.0, "A"}))).testSqlRuntimeError(source -> "SELECT PERCENTILE(f0, 1.0 + 2.0), f1 FROM " + source + " GROUP BY f1", null, IllegalArgumentException.class, "Percentage of PERCENTILE should be between [0.0, 1.0], but was '3.0'.").testSqlRuntimeError(source -> "SELECT PERCENTILE(f0, 1.0 - 2.0, 2), f1 FROM " + source + " GROUP BY f1", null, IllegalArgumentException.class, "Percentage of PERCENTILE should be between [0.0, 1.0], but was '-1.0'.").testSqlRuntimeError(source -> "SELECT PERCENTILE(f0, ARRAY[0.0, 1.5]), f1 FROM " + source + " GROUP BY f1", null, IllegalArgumentException.class, "Percentage of PERCENTILE should be between [0.0, 1.0], but was '1.5'.").testSqlRuntimeError(source -> "SELECT PERCENTILE(f0, ARRAY[0.5, -2.0], 2), f1 FROM " + source + " GROUP BY f1", null, IllegalArgumentException.class, "Percentage of PERCENTILE should be between [0.0, 1.0], but was '-2.0'."));
    }
}

