/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions;

import java.math.BigDecimal;
import java.time.Duration;
import java.util.stream.Stream;
import org.apache.flink.table.api.ApiExpression;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.planner.functions.BuiltInFunctionTestBase;
import org.apache.flink.table.types.AbstractDataType;

class MathFunctionsITCase
extends BuiltInFunctionTestBase {
    MathFunctionsITCase() {
    }

    @Override
    Stream<BuiltInFunctionTestBase.TestSetSpec> getTestSetSpecs() {
        return Stream.of(this.plusTestCases(), this.minusTestCases(), this.divideTestCases(), this.timesTestCases(), this.modTestCases(), this.roundTestCases(), this.truncateTestCases(), this.unhexTestCases()).flatMap(s -> s);
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> plusTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.PLUS).onFieldsWithData(new BigDecimal("1514356320000")).andDataTypes(DataTypes.DECIMAL((int)19, (int)0).notNull()).testResult((Expression)Expressions.$((String)"f0").plus((Object)6), "f0 + 6", new BigDecimal("1514356320006"), DataTypes.DECIMAL((int)20, (int)0).notNull()).testResult((Expression)Expressions.$((String)"f0").plus((Object)Expressions.$((String)"f0")), "f0 + f0", new BigDecimal("3028712640000"), DataTypes.DECIMAL((int)20, (int)0).notNull()));
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> minusTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.MINUS).onFieldsWithData(new BigDecimal("1514356320000")).andDataTypes(new AbstractDataType[]{DataTypes.DECIMAL((int)19, (int)0)}).testResult((Expression)Expressions.$((String)"f0").minus((Object)6), "f0 - 6", new BigDecimal("1514356319994"), (AbstractDataType<?>)DataTypes.DECIMAL((int)20, (int)0)).testResult((Expression)Expressions.$((String)"f0").minus((Object)Expressions.$((String)"f0")), "f0 - f0", new BigDecimal("0"), (AbstractDataType<?>)DataTypes.DECIMAL((int)20, (int)0)));
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> divideTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.DIVIDE).onFieldsWithData(new BigDecimal("1514356320000")).andDataTypes(DataTypes.DECIMAL((int)19, (int)0).notNull()).testResult((Expression)Expressions.$((String)"f0").dividedBy((Object)6), "f0 / 6", new BigDecimal("252392720000.00000000000"), DataTypes.DECIMAL((int)30, (int)11).notNull()).testResult((Expression)Expressions.$((String)"f0").dividedBy((Object)Expressions.$((String)"f0")), "f0 / f0", new BigDecimal("1.0000000000000000000"), DataTypes.DECIMAL((int)38, (int)19).notNull()));
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> timesTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.TIMES).onFieldsWithData(new BigDecimal("1514356320000"), Duration.ofSeconds(2L), 2).andDataTypes(new AbstractDataType[]{DataTypes.DECIMAL((int)19, (int)0), DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.SECOND((int)3)), DataTypes.INT()}).testResult((Expression)Expressions.$((String)"f0").times((Object)6), "f0 * 6", new BigDecimal("9086137920000"), (AbstractDataType<?>)DataTypes.DECIMAL((int)30, (int)0)).testResult((Expression)Expressions.$((String)"f0").times((Object)Expressions.$((String)"f0")), "f0 * f0", new BigDecimal("2293275063923942400000000"), (AbstractDataType<?>)DataTypes.DECIMAL((int)38, (int)0)).testResult((Expression)Expressions.$((String)"f1").times((Object)3), "f1 * 3", Duration.ofSeconds(6L), (AbstractDataType<?>)DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.SECOND((int)3))).testResult((Expression)Expressions.$((String)"f2").times(((ApiExpression)Expressions.lit((Object)3).seconds()).cast(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.SECOND((int)3)))), "f2 * interval '3' second(3)", Duration.ofSeconds(6L), (AbstractDataType<?>)DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.SECOND((int)3))));
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> modTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.MOD).onFieldsWithData(new BigDecimal("1514356320000"), 44L, 3).andDataTypes(new AbstractDataType[]{DataTypes.DECIMAL((int)19, (int)0), DataTypes.BIGINT(), DataTypes.INT()}).testResult((Expression)Expressions.$((String)"f0").mod((Object)Expressions.$((String)"f0")), "MOD(f0, f0)", new BigDecimal(0), (AbstractDataType<?>)DataTypes.DECIMAL((int)19, (int)0)).testResult((Expression)Expressions.$((String)"f0").mod((Object)6), "MOD(f0, 6)", 0, (AbstractDataType<?>)DataTypes.INT()).testResult((Expression)Expressions.$((String)"f1").mod((Object)Expressions.$((String)"f2")), "MOD(f1, f2)", 2, (AbstractDataType<?>)DataTypes.INT()));
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> roundTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.ROUND).onFieldsWithData(new BigDecimal("12345.12345")).testResult((Expression)Expressions.$((String)"f0").round((Object)2), "ROUND(f0, 2)", new BigDecimal("12345.12"), DataTypes.DECIMAL((int)8, (int)2).notNull()));
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> truncateTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.TRUNCATE).onFieldsWithData(new BigDecimal("123.456")).testResult((Expression)Expressions.$((String)"f0").truncate((Object)2), "TRUNCATE(f0, 2)", new BigDecimal("123.45"), DataTypes.DECIMAL((int)6, (int)2).notNull()));
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> unhexTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.UNHEX).onFieldsWithData(new Object[]{null}).andDataTypes(new AbstractDataType[]{DataTypes.STRING()}).testResult((Expression)Expressions.$((String)"f0").unhex(), "UNHEX(f0)", (Object)null, (AbstractDataType<?>)DataTypes.BYTES()).testResult((Expression)Expressions.lit((Object)"").unhex(), "UNHEX('')", new byte[0], (AbstractDataType<?>)DataTypes.BYTES()).testResult((Expression)Expressions.lit((Object)"1").unhex(), "UNHEX('1')", new byte[]{0}, (AbstractDataType<?>)DataTypes.BYTES()).testResult((Expression)Expressions.lit((Object)"146").unhex(), "UNHEX('146')", new byte[]{0, 70}, (AbstractDataType<?>)DataTypes.BYTES()).testResult((Expression)Expressions.lit((Object)"z").unhex(), "UNHEX('z')", (Object)null, (AbstractDataType<?>)DataTypes.BYTES()).testResult((Expression)Expressions.lit((Object)"1-").unhex(), "UNHEX('1-')", (Object)null, (AbstractDataType<?>)DataTypes.BYTES()).testResult((Expression)Expressions.lit((Object)"466C696E6B").unhex(), "UNHEX('466C696E6B')", new byte[]{70, 108, 105, 110, 107}, (AbstractDataType<?>)DataTypes.BYTES()).testResult((Expression)Expressions.lit((Object)"4D7953514C").unhex(), "UNHEX('4D7953514C')", new byte[]{77, 121, 83, 81, 76}, (AbstractDataType<?>)DataTypes.BYTES()).testResult((Expression)Expressions.lit((Object)"\ud83d\ude00").unhex(), "UNHEX('\ud83d\ude00')", (Object)null, (AbstractDataType<?>)DataTypes.BYTES()).testResult((Expression)((ApiExpression)Expressions.lit((Object)"\ud83d\ude00").hex()).unhex(), "UNHEX(HEX('\ud83d\ude00'))", "\ud83d\ude00".getBytes(), (AbstractDataType<?>)DataTypes.BYTES()), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.UNHEX, "Validation Error").onFieldsWithData(1).andDataTypes(new AbstractDataType[]{DataTypes.INT()}).testTableApiValidationError((Expression)Expressions.$((String)"f0").unhex(), "Invalid input arguments. Expected signatures are:\nUNHEX(expr <CHARACTER_STRING>)").testSqlValidationError("UNHEX(f0)", "Invalid input arguments. Expected signatures are:\nUNHEX(expr <CHARACTER_STRING>)"));
    }
}

