/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.api.JsonExistsOnError;
import org.apache.flink.table.api.JsonOnNull;
import org.apache.flink.table.api.JsonQueryOnEmptyOrError;
import org.apache.flink.table.api.JsonQueryWrapper;
import org.apache.flink.table.api.JsonType;
import org.apache.flink.table.api.JsonValueOnEmptyOrError;
import org.apache.flink.table.api.TableRuntimeException;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.planner.functions.BuiltInFunctionTestBase;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;

class JsonFunctionsITCase
extends BuiltInFunctionTestBase {
    JsonFunctionsITCase() {
    }

    @Override
    Stream<BuiltInFunctionTestBase.TestSetSpec> getTestSetSpecs() {
        ArrayList<BuiltInFunctionTestBase.TestSetSpec> testCases = new ArrayList<BuiltInFunctionTestBase.TestSetSpec>();
        testCases.add(JsonFunctionsITCase.jsonExistsSpec());
        testCases.add(JsonFunctionsITCase.jsonValueSpec());
        testCases.addAll(JsonFunctionsITCase.isJsonSpec());
        testCases.addAll(JsonFunctionsITCase.jsonQuerySpec());
        testCases.addAll(JsonFunctionsITCase.jsonStringSpec());
        testCases.addAll(JsonFunctionsITCase.jsonObjectSpec());
        testCases.addAll(JsonFunctionsITCase.jsonArraySpec());
        testCases.addAll(JsonFunctionsITCase.jsonQuoteSpec());
        testCases.addAll(JsonFunctionsITCase.jsonUnquoteSpecWithValidInput());
        testCases.addAll(JsonFunctionsITCase.jsonUnquoteSpecWithInvalidInput());
        return testCases.stream();
    }

    private static BuiltInFunctionTestBase.TestSetSpec jsonExistsSpec() {
        String jsonValue = JsonFunctionsITCase.getJsonFromResource("/json/json-exists.json");
        return BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.JSON_EXISTS).onFieldsWithData(jsonValue).andDataTypes(new AbstractDataType[]{DataTypes.STRING()}).testResult((Expression)Expressions.nullOf((DataType)DataTypes.STRING()).jsonExists("lax $"), "JSON_EXISTS(CAST(NULL AS STRING), 'lax $')", (Object)null, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f0").jsonExists("lax $"), "JSON_EXISTS(f0, 'lax $')", true, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f0").jsonExists("lax $.type"), "JSON_EXISTS(f0, 'lax $.type')", true, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f0").jsonExists("lax $.author.address.city"), "JSON_EXISTS(f0, 'lax $.author.address.city')", true, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f0").jsonExists("lax $.metadata.tags[0]"), "JSON_EXISTS(f0, 'lax $.metadata.tags[0]')", true, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f0").jsonExists("lax $.metadata.tags[3]"), "JSON_EXISTS(f0, 'lax $.metadata.tags[3]')", false, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f0").jsonExists("lax $.metadata.references[0].url"), "JSON_EXISTS(f0, 'lax $.metadata.references[0].url')", true, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f0").jsonExists("lax $.metadata.references[0].invalid"), "JSON_EXISTS(f0, 'lax $.metadata.references[0].invalid')", false, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f0").jsonExists("strict $.invalid", JsonExistsOnError.TRUE), "JSON_EXISTS(f0, 'strict $.invalid' TRUE ON ERROR)", true, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f0").jsonExists("strict $.invalid", JsonExistsOnError.FALSE), "JSON_EXISTS(f0, 'strict $.invalid' FALSE ON ERROR)", false, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f0").jsonExists("strict $.invalid", JsonExistsOnError.UNKNOWN), "JSON_EXISTS(f0, 'strict $.invalid' UNKNOWN ON ERROR)", (Object)null, (AbstractDataType<?>)DataTypes.BOOLEAN()).testSqlRuntimeError("JSON_EXISTS(f0, 'strict $.invalid' ERROR ON ERROR)", TableRuntimeException.class, "No results for path: $['invalid']").testTableApiRuntimeError((Expression)Expressions.$((String)"f0").jsonExists("strict $.invalid", JsonExistsOnError.ERROR), TableRuntimeException.class, "No results for path: $['invalid']");
    }

    private static BuiltInFunctionTestBase.TestSetSpec jsonValueSpec() {
        String jsonValue = JsonFunctionsITCase.getJsonFromResource("/json/json-value.json");
        return BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.JSON_VALUE).onFieldsWithData(jsonValue).andDataTypes(new AbstractDataType[]{DataTypes.STRING()}).testResult((Expression)Expressions.lit(null, (DataType)DataTypes.STRING()).jsonValue("lax $"), "JSON_VALUE(CAST(NULL AS STRING), 'lax $')", (Object)null, (AbstractDataType<?>)DataTypes.STRING(), (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f0").jsonValue("$.longBalance"), "JSON_VALUE(f0, '$.longBalance')", "123456789.987654321", (AbstractDataType<?>)DataTypes.STRING(), (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f0").jsonValue("$.balance"), "JSON_VALUE(f0, '$.balance')", "13.37", (AbstractDataType<?>)DataTypes.STRING(), (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f0").jsonValue("$.type"), "JSON_VALUE(f0, '$.type')", "account", (AbstractDataType<?>)DataTypes.STRING(), (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f0").jsonValue("$.activated", DataTypes.BOOLEAN()), "JSON_VALUE(f0, '$.activated' RETURNING BOOLEAN)", true, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f0").jsonValue("$.age", DataTypes.INT()), "JSON_VALUE(f0, '$.age' RETURNING INT)", 42, (AbstractDataType<?>)DataTypes.INT()).testResult((Expression)Expressions.$((String)"f0").jsonValue("$.balance", DataTypes.DOUBLE()), "JSON_VALUE(f0, '$.balance' RETURNING DOUBLE)", 13.37, (AbstractDataType<?>)DataTypes.DOUBLE()).testResult((Expression)Expressions.$((String)"f0").jsonValue("$.longBalance", DataTypes.DOUBLE()), "JSON_VALUE(f0, '$.longBalance' RETURNING DOUBLE)", 1.2345678998765433E8, (AbstractDataType<?>)DataTypes.DOUBLE()).testResult((Expression)Expressions.$((String)"f0").jsonValue("lax $.invalid", DataTypes.STRING(), JsonValueOnEmptyOrError.NULL, null, JsonValueOnEmptyOrError.ERROR, null), "JSON_VALUE(f0, 'lax $.invalid' NULL ON EMPTY ERROR ON ERROR)", (Object)null, (AbstractDataType<?>)DataTypes.STRING(), (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f0").jsonValue("lax $.invalid", DataTypes.INT(), JsonValueOnEmptyOrError.DEFAULT, (Object)42, JsonValueOnEmptyOrError.ERROR, null), "JSON_VALUE(f0, 'lax $.invalid' RETURNING INTEGER DEFAULT 42 ON EMPTY ERROR ON ERROR)", 42, (AbstractDataType<?>)DataTypes.INT()).testResult((Expression)Expressions.$((String)"f0").jsonValue("strict $.invalid", DataTypes.STRING(), JsonValueOnEmptyOrError.ERROR, null, JsonValueOnEmptyOrError.NULL, null), "JSON_VALUE(f0, 'strict $.invalid' ERROR ON EMPTY NULL ON ERROR)", (Object)null, (AbstractDataType<?>)DataTypes.STRING(), (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f0").jsonValue("strict $.invalid", DataTypes.INT(), JsonValueOnEmptyOrError.NULL, null, JsonValueOnEmptyOrError.DEFAULT, (Object)42), "JSON_VALUE(f0, 'strict $.invalid' RETURNING INTEGER NULL ON EMPTY DEFAULT 42 ON ERROR)", 42, (AbstractDataType<?>)DataTypes.INT()).testResult((Expression)Expressions.$((String)"f0").jsonValue("strict $.['contains blank']", DataTypes.STRING(), JsonValueOnEmptyOrError.NULL, null, JsonValueOnEmptyOrError.DEFAULT, (Object)"wrong"), "JSON_VALUE(f0, 'strict $.[''contains blank'']' NULL ON EMPTY DEFAULT 'wrong' ON ERROR)", "right", (AbstractDataType<?>)DataTypes.STRING());
    }

    private static List<BuiltInFunctionTestBase.TestSetSpec> isJsonSpec() {
        return Arrays.asList(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.IS_JSON).onFieldsWithData(1).andDataTypes(new AbstractDataType[]{DataTypes.INT()}).testSqlValidationError("f0 IS JSON", "Cannot apply 'IS JSON VALUE' to arguments of type '<INTEGER> IS JSON VALUE'. Supported form(s): '<CHARACTER> IS JSON VALUE'").testTableApiValidationError((Expression)Expressions.$((String)"f0").isJson(), String.format("Invalid function call:%nIS_JSON(INT)", new Object[0])), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.IS_JSON).onFieldsWithData(new Object[]{null}).andDataTypes(new AbstractDataType[]{DataTypes.STRING()}).testResult((Expression)Expressions.$((String)"f0").isJson(), "f0 IS JSON", false, DataTypes.BOOLEAN().notNull()), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.IS_JSON).onFieldsWithData("a").andDataTypes(new AbstractDataType[]{DataTypes.STRING()}).testResult((Expression)Expressions.$((String)"f0").isJson(), "f0 IS JSON", false, DataTypes.BOOLEAN().notNull()), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.IS_JSON).onFieldsWithData("\"a\"").andDataTypes(new AbstractDataType[]{DataTypes.STRING()}).testResult((Expression)Expressions.$((String)"f0").isJson(), "f0 IS JSON", true, DataTypes.BOOLEAN().notNull()).testResult((Expression)Expressions.$((String)"f0").isJson(JsonType.VALUE), "f0 IS JSON VALUE", true, DataTypes.BOOLEAN().notNull()).testResult((Expression)Expressions.$((String)"f0").isJson(JsonType.SCALAR), "f0 IS JSON SCALAR", true, DataTypes.BOOLEAN().notNull()).testResult((Expression)Expressions.$((String)"f0").isJson(JsonType.ARRAY), "f0 IS JSON ARRAY", false, DataTypes.BOOLEAN().notNull()).testResult((Expression)Expressions.$((String)"f0").isJson(JsonType.OBJECT), "f0 IS JSON OBJECT", false, DataTypes.BOOLEAN().notNull()), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.IS_JSON).onFieldsWithData("{}").andDataTypes(new AbstractDataType[]{DataTypes.STRING()}).testResult((Expression)Expressions.$((String)"f0").isJson(), "f0 IS JSON", true, DataTypes.BOOLEAN().notNull()).testResult((Expression)Expressions.$((String)"f0").isJson(JsonType.VALUE), "f0 IS JSON VALUE", true, DataTypes.BOOLEAN().notNull()).testResult((Expression)Expressions.$((String)"f0").isJson(JsonType.SCALAR), "f0 IS JSON SCALAR", false, DataTypes.BOOLEAN().notNull()).testResult((Expression)Expressions.$((String)"f0").isJson(JsonType.ARRAY), "f0 IS JSON ARRAY", false, DataTypes.BOOLEAN().notNull()).testResult((Expression)Expressions.$((String)"f0").isJson(JsonType.OBJECT), "f0 IS JSON OBJECT", true, DataTypes.BOOLEAN().notNull()));
    }

    private static List<BuiltInFunctionTestBase.TestSetSpec> jsonQuerySpec() {
        String jsonValue = JsonFunctionsITCase.getJsonFromResource("/json/json-query.json");
        return Arrays.asList(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.JSON_QUERY).onFieldsWithData(new Object[]{null}).andDataTypes(new AbstractDataType[]{DataTypes.STRING()}).testResult((Expression)Expressions.$((String)"f0").jsonQuery("$"), "JSON_QUERY(f0, '$')", (Object)null, (AbstractDataType<?>)DataTypes.STRING()), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.JSON_QUERY).onFieldsWithData("{ \"a\": \"[1,2]\", \"b\": [1,2]}", "{\"a\":[{\"c\":null},{\"c\":\"c2\"}]}").andDataTypes(new AbstractDataType[]{DataTypes.STRING(), DataTypes.STRING()}).testResult((Expression)Expressions.$((String)"f0").jsonQuery("$.b"), "JSON_QUERY(f0, '$.b')", "[1,2]", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f0").jsonQuery("$.b", DataTypes.ARRAY((DataType)DataTypes.STRING())), "JSON_QUERY(f0, '$.b' RETURNING ARRAY<STRING>)", new String[]{"1", "2"}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.STRING())).testResult((Expression)Expressions.$((String)"f0").jsonQuery("$.b", JsonQueryWrapper.CONDITIONAL_ARRAY), "JSON_QUERY(f0, '$.b' WITH CONDITIONAL WRAPPER)", "[1,2]", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f1").jsonQuery("lax $.a[*].c", DataTypes.ARRAY((DataType)DataTypes.STRING()), JsonQueryWrapper.CONDITIONAL_ARRAY, JsonQueryOnEmptyOrError.ERROR, JsonQueryOnEmptyOrError.ERROR), "JSON_QUERY(f1, 'lax $.a[*].c' RETURNING ARRAY<STRING> ERROR ON ERROR ERROR ON EMPTY)", new String[]{null, "c2"}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.STRING())).testResult((Expression)Expressions.$((String)"f0").jsonQuery("$.b", DataTypes.ARRAY((DataType)DataTypes.STRING()), JsonQueryWrapper.CONDITIONAL_ARRAY), "JSON_QUERY(f0, '$.b' RETURNING ARRAY<STRING> WITH CONDITIONAL WRAPPER)", new String[]{"1", "2"}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.STRING())).testSqlValidationError("JSON_QUERY(f0, '$.b' RETURNING ARRAY<INTEGER>  WITH CONDITIONAL WRAPPER ERROR ON ERROR)", " Unsupported array element type 'INTEGER' for RETURNING ARRAY in JSON_QUERY()").testResult((Expression)Expressions.$((String)"f0").jsonQuery("$.a"), "JSON_QUERY(f0, '$.a')", (Object)null, (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f0").jsonQuery("$.a", DataTypes.ARRAY((DataType)DataTypes.STRING())), "JSON_QUERY(f0, '$.a' RETURNING ARRAY<STRING>)", (Object)null, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.STRING())).testResult((Expression)Expressions.$((String)"f0").jsonQuery("$.a", JsonQueryWrapper.CONDITIONAL_ARRAY), "JSON_QUERY(f0, '$.a' WITH CONDITIONAL WRAPPER)", "[\"[1,2]\"]", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f0").jsonQuery("$.a", DataTypes.ARRAY((DataType)DataTypes.STRING()), JsonQueryWrapper.CONDITIONAL_ARRAY), "JSON_QUERY(f0, '$.a' RETURNING ARRAY<STRING> WITH CONDITIONAL WRAPPER)", new String[]{"[1,2]"}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.STRING())).testSqlRuntimeError("JSON_QUERY(f0, '$.a' RETURNING ARRAY<STRING> WITHOUT WRAPPER ERROR ON ERROR)", "Strict jsonpath mode requires array or object value, and the actual value is: ''[1,2]''").testSqlValidationError("JSON_QUERY(f0, '$.a' RETURNING ARRAY<STRING> WITHOUT WRAPPER EMPTY OBJECT ON ERROR)", "Illegal on error behavior 'EMPTY OBJECT' for return type: VARCHAR(2147483647) ARRAY").testSqlValidationError("JSON_QUERY(f0, '$.a' RETURNING ARRAY<STRING> WITHOUT WRAPPER EMPTY OBJECT ON EMPTY)", "Illegal on empty behavior 'EMPTY OBJECT' for return type: VARCHAR(2147483647) ARRAY").testTableApiValidationError((Expression)Expressions.$((String)"f0").jsonQuery("$.a", DataTypes.ARRAY((DataType)DataTypes.STRING()), JsonQueryWrapper.CONDITIONAL_ARRAY, JsonQueryOnEmptyOrError.EMPTY_OBJECT, JsonQueryOnEmptyOrError.EMPTY_ARRAY), "Illegal on empty behavior 'EMPTY OBJECT' for return type: ARRAY<STRING>").testTableApiValidationError((Expression)Expressions.$((String)"f0").jsonQuery("$.a", DataTypes.ARRAY((DataType)DataTypes.STRING()), JsonQueryWrapper.CONDITIONAL_ARRAY, JsonQueryOnEmptyOrError.EMPTY_ARRAY, JsonQueryOnEmptyOrError.EMPTY_OBJECT), "Illegal on error behavior 'EMPTY OBJECT' for return type: ARRAY<STRING>").testResult((Expression)Expressions.$((String)"f0").jsonQuery("$.a", DataTypes.ARRAY((DataType)DataTypes.STRING()), JsonQueryWrapper.WITHOUT_ARRAY, JsonQueryOnEmptyOrError.EMPTY_ARRAY, JsonQueryOnEmptyOrError.EMPTY_ARRAY), "JSON_QUERY(f0, '$.a' RETURNING ARRAY<STRING> WITHOUT WRAPPER EMPTY ARRAY ON ERROR)", new String[0], (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.STRING())), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.JSON_QUERY).onFieldsWithData("{\"items\": [{\"itemId\":1234, \"count\":10}, null, {\"itemId\":4567, \"count\":11}]}", "{\"items\": [[1234, 2345], null, [\"itemId\", \"count\"]]}", "{\"arr\": [\"abc\", null, \"def\"]}").andDataTypes(new AbstractDataType[]{DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING()}).testResult((Expression)Expressions.$((String)"f0").jsonQuery("$.items", DataTypes.ARRAY((DataType)DataTypes.STRING())), "JSON_QUERY(f0, '$.items' RETURNING ARRAY<STRING>)", new String[]{"{\"count\":10,\"itemId\":1234}", null, "{\"count\":11,\"itemId\":4567}"}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.STRING())).testResult((Expression)Expressions.$((String)"f1").jsonQuery("$.items", DataTypes.ARRAY((DataType)DataTypes.STRING())), "JSON_QUERY(f1, '$.items' RETURNING ARRAY<STRING>)", new String[]{"[1234,2345]", null, "[\"itemId\",\"count\"]"}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.STRING())).testResult((Expression)Expressions.$((String)"f2").jsonQuery("$.arr", DataTypes.ARRAY((DataType)DataTypes.STRING())), "JSON_QUERY(f2, '$.arr' RETURNING ARRAY<STRING>)", new String[]{"abc", null, "def"}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.STRING())), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.JSON_QUERY).onFieldsWithData(jsonValue).andDataTypes(new AbstractDataType[]{DataTypes.STRING()}).testResult((Expression)Expressions.$((String)"f0").jsonQuery("$.a1", JsonQueryWrapper.WITHOUT_ARRAY), "JSON_QUERY(f0, '$.a1' WITHOUT WRAPPER)", "[]", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f0").jsonQuery("$.a1", JsonQueryWrapper.CONDITIONAL_ARRAY), "JSON_QUERY(f0, '$.a1' WITH CONDITIONAL WRAPPER)", "[]", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f0").jsonQuery("$.o1", JsonQueryWrapper.CONDITIONAL_ARRAY), "JSON_QUERY(f0, '$.o1' WITH CONDITIONAL WRAPPER)", "[{}]", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f0").jsonQuery("$.a1", JsonQueryWrapper.UNCONDITIONAL_ARRAY), "JSON_QUERY(f0, '$.a1' WITH UNCONDITIONAL WRAPPER)", "[[]]", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f0").jsonQuery("$.n1", JsonQueryWrapper.CONDITIONAL_ARRAY), "JSON_QUERY(f0, '$.n1' WITH CONDITIONAL WRAPPER)", "[1]", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f0").jsonQuery("$.s1", JsonQueryWrapper.CONDITIONAL_ARRAY), "JSON_QUERY(f0, '$.s1' WITH CONDITIONAL WRAPPER)", "[\"Test\"]", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f0").jsonQuery("lax $.err1", JsonQueryWrapper.WITHOUT_ARRAY, JsonQueryOnEmptyOrError.NULL, JsonQueryOnEmptyOrError.NULL), "JSON_QUERY(f0, 'lax $.err1' NULL ON EMPTY)", (Object)null, (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f0").jsonQuery("lax $.err2", JsonQueryWrapper.WITHOUT_ARRAY, JsonQueryOnEmptyOrError.EMPTY_ARRAY, JsonQueryOnEmptyOrError.NULL), "JSON_QUERY(f0, 'lax $.err2' EMPTY ARRAY ON EMPTY)", "[]", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f0").jsonQuery("lax $.err3", JsonQueryWrapper.WITHOUT_ARRAY, JsonQueryOnEmptyOrError.EMPTY_OBJECT, JsonQueryOnEmptyOrError.NULL), "JSON_QUERY(f0, 'lax $.err3' EMPTY OBJECT ON EMPTY)", "{}", (AbstractDataType<?>)DataTypes.STRING()).testSqlRuntimeError("JSON_QUERY(f0, 'lax $.err4' ERROR ON EMPTY)", TableRuntimeException.class, "Empty result of JSON_QUERY function is not allowed").testTableApiRuntimeError((Expression)Expressions.$((String)"f0").jsonQuery("lax $.err5", JsonQueryWrapper.WITHOUT_ARRAY, JsonQueryOnEmptyOrError.ERROR, JsonQueryOnEmptyOrError.NULL), TableRuntimeException.class, "Empty result of JSON_QUERY function is not allowed").testResult((Expression)Expressions.$((String)"f0").jsonQuery("strict $.err6", JsonQueryWrapper.WITHOUT_ARRAY, JsonQueryOnEmptyOrError.NULL, JsonQueryOnEmptyOrError.NULL), "JSON_QUERY(f0, 'strict $.err6' NULL ON ERROR)", (Object)null, (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f0").jsonQuery("strict $.err7", JsonQueryWrapper.WITHOUT_ARRAY, JsonQueryOnEmptyOrError.NULL, JsonQueryOnEmptyOrError.EMPTY_ARRAY), "JSON_QUERY(f0, 'strict $.err7' EMPTY ARRAY ON ERROR)", "[]", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f0").jsonQuery("strict $.err8", JsonQueryWrapper.WITHOUT_ARRAY, JsonQueryOnEmptyOrError.NULL, JsonQueryOnEmptyOrError.EMPTY_OBJECT), "JSON_QUERY(f0, 'strict $.err8' EMPTY OBJECT ON ERROR)", "{}", (AbstractDataType<?>)DataTypes.STRING()).testSqlRuntimeError("JSON_QUERY(f0, 'strict $.err9' ERROR ON ERROR)", TableRuntimeException.class, "No results for path").testTableApiRuntimeError((Expression)Expressions.$((String)"f0").jsonQuery("strict $.err10", JsonQueryWrapper.WITHOUT_ARRAY, JsonQueryOnEmptyOrError.NULL, JsonQueryOnEmptyOrError.ERROR), TableRuntimeException.class, "No results for path"));
    }

    private static List<BuiltInFunctionTestBase.TestSetSpec> jsonStringSpec() {
        HashMap<String, String> mapData = new HashMap<String, String>();
        mapData.put("M1", "V1");
        mapData.put("M2", "V2");
        HashMap<String, Integer> multisetData = new HashMap<String, Integer>();
        multisetData.put("M1", 1);
        multisetData.put("M2", 2);
        return Arrays.asList(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.JSON_STRING).onFieldsWithData(0).testResult((Expression)Expressions.jsonString((Object)Expressions.nullOf((DataType)DataTypes.STRING())), "JSON_STRING(CAST(NULL AS STRING))", null, DataTypes.STRING().nullable()), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.JSON_STRING).onFieldsWithData("V", true, 1, 1.23, 1.23, LocalDateTime.parse("1990-06-02T13:37:42.001"), Instant.parse("1990-06-02T13:37:42.001Z"), Arrays.asList("A1", "A2", "A3"), Row.of((Object[])new Object[]{"R1", Instant.parse("1990-06-02T13:37:42.001Z")}), mapData, multisetData, "Test".getBytes(StandardCharsets.UTF_8), "Test".getBytes(StandardCharsets.UTF_8), Row.of((Object[])new Object[]{Collections.singletonList(Row.of((Object[])new Object[]{1, 2}))})).andDataTypes(DataTypes.STRING().notNull(), DataTypes.BOOLEAN().notNull(), DataTypes.INT().notNull(), DataTypes.DOUBLE().notNull(), DataTypes.DECIMAL((int)3, (int)2).notNull(), DataTypes.TIMESTAMP((int)3).notNull(), DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3).notNull(), DataTypes.ARRAY((DataType)DataTypes.STRING()).notNull(), DataTypes.ROW((DataType[])new DataType[]{DataTypes.STRING(), DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3)}).notNull(), DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.STRING()).notNull(), DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.INT()).notNull(), DataTypes.BINARY((int)4).notNull(), DataTypes.VARBINARY((int)4).notNull(), DataTypes.ROW((DataType[])new DataType[]{DataTypes.ARRAY((DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.INT(), DataTypes.INT()}))}).notNull()).testResult((Expression)Expressions.jsonString((Object)Expressions.$((String)"f0")), "JSON_STRING(f0)", "\"V\"", DataTypes.STRING().notNull()).testResult((Expression)Expressions.jsonString((Object)Expressions.$((String)"f1")), "JSON_STRING(f1)", "true", DataTypes.STRING().notNull()).testResult((Expression)Expressions.jsonString((Object)Expressions.$((String)"f2")), "JSON_STRING(f2)", "1", DataTypes.STRING().notNull()).testResult((Expression)Expressions.jsonString((Object)Expressions.$((String)"f3")), "JSON_STRING(f3)", "1.23", DataTypes.STRING().notNull()).testResult((Expression)Expressions.jsonString((Object)Expressions.$((String)"f4")), "JSON_STRING(f4)", "1.23", DataTypes.STRING().notNull()).testResult((Expression)Expressions.jsonString((Object)Expressions.$((String)"f5")), "JSON_STRING(f5)", "\"1990-06-02T13:37:42.001\"", DataTypes.STRING().notNull()).testResult((Expression)Expressions.jsonString((Object)Expressions.$((String)"f6")), "JSON_STRING(f6)", "\"1990-06-02T13:37:42.001Z\"", DataTypes.STRING().notNull()).testResult((Expression)Expressions.jsonString((Object)Expressions.$((String)"f7")), "JSON_STRING(f7)", "[\"A1\",\"A2\",\"A3\"]", DataTypes.STRING().notNull()).testResult((Expression)Expressions.jsonString((Object)Expressions.$((String)"f8")), "JSON_STRING(f8)", "{\"f0\":\"R1\",\"f1\":\"1990-06-02T13:37:42.001Z\"}", DataTypes.STRING().notNull()).testResult((Expression)Expressions.jsonString((Object)Expressions.$((String)"f9")), "JSON_STRING(f9)", "{\"M1\":\"V1\",\"M2\":\"V2\"}", DataTypes.STRING().notNull()).testResult((Expression)Expressions.jsonString((Object)Expressions.$((String)"f10")), "JSON_STRING(f10)", "{\"M1\":1,\"M2\":2}", DataTypes.STRING().notNull()).testResult((Expression)Expressions.jsonString((Object)Expressions.$((String)"f11")), "JSON_STRING(f11)", "\"VGVzdA==\"", DataTypes.STRING().notNull()).testResult((Expression)Expressions.jsonString((Object)Expressions.$((String)"f12")), "JSON_STRING(f12)", "\"VGVzdA==\"", DataTypes.STRING().notNull()).testResult((Expression)Expressions.jsonString((Object)Expressions.$((String)"f13")), "JSON_STRING(f13)", "{\"f0\":[{\"f0\":1,\"f1\":2}]}", DataTypes.STRING().notNull()));
    }

    private static List<BuiltInFunctionTestBase.TestSetSpec> jsonObjectSpec() {
        HashMap<String, String> mapData = new HashMap<String, String>();
        mapData.put("M1", "V1");
        mapData.put("M2", "V2");
        HashMap<String, Integer> multisetData = new HashMap<String, Integer>();
        multisetData.put("M1", 1);
        multisetData.put("M2", 2);
        return Arrays.asList(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.JSON_OBJECT).onFieldsWithData(0).testResult(JsonFunctionsITCase.resultSpec((Expression)Expressions.jsonObject((JsonOnNull)JsonOnNull.NULL, (Object[])new Object[0]), "JSON_OBJECT()", "{}", DataTypes.STRING().notNull(), DataTypes.STRING().notNull()), JsonFunctionsITCase.resultSpec((Expression)Expressions.jsonObject((JsonOnNull)JsonOnNull.NULL, (Object[])new Object[]{"K", Expressions.nullOf((DataType)DataTypes.STRING())}), "JSON_OBJECT(KEY 'K' VALUE CAST(NULL AS STRING) NULL ON NULL)", "{\"K\":null}", DataTypes.STRING().notNull(), DataTypes.STRING().notNull()), JsonFunctionsITCase.resultSpec((Expression)Expressions.jsonObject((JsonOnNull)JsonOnNull.ABSENT, (Object[])new Object[]{"K", Expressions.nullOf((DataType)DataTypes.STRING())}), "JSON_OBJECT(KEY 'K' VALUE CAST(NULL AS STRING) ABSENT ON NULL)", "{}", DataTypes.STRING().notNull(), DataTypes.STRING().notNull())), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.JSON_OBJECT).onFieldsWithData("V", true, 1, 1.23, 1.23, LocalDateTime.parse("1990-06-02T13:37:42.001"), Instant.parse("1990-06-02T13:37:42.001Z"), Arrays.asList("A1", "A2", "A3"), Row.of((Object[])new Object[]{"R1", Instant.parse("1990-06-02T13:37:42.001Z")}), mapData, multisetData, "Test".getBytes(StandardCharsets.UTF_8), "Test".getBytes(StandardCharsets.UTF_8), Row.of((Object[])new Object[]{Collections.singletonList(Row.of((Object[])new Object[]{1, 2}))})).andDataTypes(new AbstractDataType[]{DataTypes.STRING(), DataTypes.BOOLEAN(), DataTypes.INT(), DataTypes.DOUBLE(), DataTypes.DECIMAL((int)3, (int)2), DataTypes.TIMESTAMP((int)3), DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3), DataTypes.ARRAY((DataType)DataTypes.STRING()), DataTypes.ROW((DataType[])new DataType[]{DataTypes.STRING(), DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3)}), DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.STRING()), DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.INT()), DataTypes.BINARY((int)4), DataTypes.VARBINARY((int)4), DataTypes.ROW((DataType[])new DataType[]{DataTypes.ARRAY((DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.INT(), DataTypes.INT()}))})}).withFunction(CreateMultiset.class).withFunction(CreateStructuredType.class).withFunction(CreateInternalRow.class).testResult((Expression)Expressions.jsonObject((JsonOnNull)JsonOnNull.NULL, (Object[])new Object[]{"A", Expressions.$((String)"f0"), "B", Expressions.$((String)"f1"), "C", Expressions.$((String)"f2"), "D", Expressions.$((String)"f3"), "E", Expressions.$((String)"f4"), "F", Expressions.$((String)"f5"), "G", Expressions.$((String)"f6"), "H", Expressions.$((String)"f7"), "I", Expressions.$((String)"f8"), "J", Expressions.$((String)"f9"), "K", Expressions.call((String)"CreateMultiset", (Object[])new Object[]{Expressions.$((String)"f10")}), "L", Expressions.$((String)"f11"), "M", Expressions.$((String)"f12"), "N", Expressions.$((String)"f13"), "O", Expressions.jsonObject((JsonOnNull)JsonOnNull.NULL, (Object[])new Object[]{"A", "B"}), "P", Expressions.jsonArray((JsonOnNull)JsonOnNull.NULL, (Object[])new Object[]{"A", Expressions.jsonObject((JsonOnNull)JsonOnNull.NULL, (Object[])new Object[]{"K", "V"})}), "Q", Expressions.call((String)"CreateStructuredType", (Object[])new Object[]{Expressions.$((String)"f0"), Expressions.$((String)"f2"), Expressions.$((String)"f9")}), "R", Expressions.call((String)"CreateInternalRow", (Object[])new Object[]{Expressions.$((String)"f0"), Expressions.nullOf((DataType)DataTypes.INT())})}), "JSON_OBJECT('A' VALUE f0, 'B' VALUE f1, 'C' VALUE f2, 'D' VALUE f3, 'E' VALUE f4, 'F' VALUE f5, 'G' VALUE f6, 'H' VALUE f7, 'I' VALUE f8, 'J' VALUE f9, 'K' VALUE CreateMultiset(f10), 'L' VALUE f11, 'M' VALUE f12, 'N' VALUE f13, 'O' VALUE JSON_OBJECT(KEY 'A' VALUE 'B'), 'P' VALUE JSON_ARRAY('A', JSON_OBJECT('K' VALUE 'V')), 'Q' VALUE CreateStructuredType(f0, f2, f9), 'R' VALUE CreateInternalRow(f0, NULL))", "{\"A\":\"V\",\"B\":true,\"C\":1,\"D\":1.23,\"E\":1.23,\"F\":\"1990-06-02T13:37:42.001\",\"G\":\"1990-06-02T13:37:42.001Z\",\"H\":[\"A1\",\"A2\",\"A3\"],\"I\":{\"f0\":\"R1\",\"f1\":\"1990-06-02T13:37:42.001Z\"},\"J\":{\"M1\":\"V1\",\"M2\":\"V2\"},\"K\":{\"M1\":1,\"M2\":2},\"L\":\"VGVzdA==\",\"M\":\"VGVzdA==\",\"N\":{\"f0\":[{\"f0\":1,\"f1\":2}]},\"O\":{\"A\":\"B\"},\"P\":[\"A\",{\"K\":\"V\"}],\"Q\":{\"age\":1,\"name\":\"V\",\"payload\":{\"M1\":\"V1\",\"M2\":\"V2\"}},\"R\":{\"f0\":\"V\",\"f1\":null}}", DataTypes.STRING().notNull(), DataTypes.STRING().notNull()));
    }

    private static List<BuiltInFunctionTestBase.TestSetSpec> jsonQuoteSpec() {
        return Arrays.asList(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.JSON_QUOTE).onFieldsWithData(0).testResult((Expression)Expressions.nullOf((DataType)DataTypes.STRING()).jsonQuote(), "JSON_QUOTE(CAST(NULL AS STRING))", null, DataTypes.STRING().nullable()), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.JSON_QUOTE).onFieldsWithData("V", "\"null\"", "[1, 2, 3]", "This is a \t test \n with special characters: \" \\ \b \f \r A", "\"kv_pair_test\": \"\\b\\f\\r\"", "\ttab and fwd slash /", "\\u006z will not be escaped", "\u2260 will be escaped", null).andDataTypes(DataTypes.STRING().notNull(), DataTypes.STRING().notNull(), DataTypes.STRING().notNull(), DataTypes.STRING().notNull(), DataTypes.STRING().notNull(), DataTypes.STRING().notNull(), DataTypes.STRING().notNull(), DataTypes.STRING().notNull(), DataTypes.STRING().nullable()).testResult((Expression)Expressions.$((String)"f0").jsonQuote(), "JSON_QUOTE(f0)", "\"V\"", DataTypes.STRING().notNull()).testResult((Expression)Expressions.$((String)"f1").jsonQuote(), "JSON_QUOTE(f1)", "\"\\\"null\\\"\"", DataTypes.STRING().notNull()).testResult((Expression)Expressions.$((String)"f2").jsonQuote(), "JSON_QUOTE(f2)", "\"[1, 2, 3]\"", DataTypes.STRING().notNull()).testResult((Expression)Expressions.$((String)"f3").jsonQuote(), "JSON_QUOTE(f3)", "\"This is a \\t test \\n with special characters: \\\" \\\\ \\b \\f \\r A\"", DataTypes.STRING().notNull()).testResult((Expression)Expressions.$((String)"f4").jsonQuote(), "JSON_QUOTE(f4)", "\"\\\"kv_pair_test\\\": \\\"\\\\b\\\\f\\\\r\\\"\"", DataTypes.STRING().notNull()).testResult((Expression)Expressions.$((String)"f5").jsonQuote(), "JSON_QUOTE(f5)", "\"\\ttab and fwd slash \\/\"", DataTypes.STRING().notNull()).testResult((Expression)Expressions.$((String)"f6").jsonQuote(), "JSON_QUOTE(f6)", "\"\\\\u006z will not be escaped\"", DataTypes.STRING().notNull()).testResult((Expression)Expressions.$((String)"f7").jsonQuote(), "JSON_QUOTE(f7)", "\"\\u2260 will be escaped\"", DataTypes.STRING().notNull()).testResult((Expression)Expressions.$((String)"f8").jsonQuote(), "JSON_QUOTE(f8)", null, DataTypes.STRING().nullable()));
    }

    private static List<BuiltInFunctionTestBase.TestSetSpec> jsonUnquoteSpecWithValidInput() {
        return Arrays.asList(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.JSON_UNQUOTE).onFieldsWithData(0).testResult((Expression)Expressions.nullOf((DataType)DataTypes.STRING()).jsonQuote(), "JSON_UNQUOTE(CAST(NULL AS STRING))", null, DataTypes.STRING().nullable()), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.JSON_UNQUOTE).onFieldsWithData("\"abc\"", "\"[\"abc\"]\"", "\"[\"\\u0041\"]\"", "\"\\u0041\"", "\"[\"\\t\\u0032\"]\"", "\"[\"This is a \\t test \\n with special characters: \\b \\f \\r \\u0041\"]\"", "\"\"\"", "\"\"\ufffa\"", "\"a unicode \u2260\"", "\"valid unicode literal \\uD801\\uDC00\"", "[1,2,3]", "[]", "[\"string\",2]", "{\"key\":\"value\"}", "{\"key\":[\"complex\"]}", "{\"key\":1}", "1", "true", null).andDataTypes(DataTypes.STRING().notNull(), DataTypes.STRING().notNull(), DataTypes.STRING().notNull(), DataTypes.STRING().notNull(), DataTypes.STRING().notNull(), DataTypes.STRING().notNull(), DataTypes.STRING().notNull(), DataTypes.STRING().notNull(), DataTypes.STRING().notNull(), DataTypes.STRING().notNull(), DataTypes.STRING().notNull(), DataTypes.STRING().notNull(), DataTypes.STRING().notNull(), DataTypes.STRING().notNull(), DataTypes.STRING().notNull(), DataTypes.STRING().notNull(), DataTypes.STRING().notNull(), DataTypes.STRING().notNull(), DataTypes.STRING().nullable()).testResult((Expression)Expressions.$((String)"f0").jsonUnquote(), "JSON_UNQUOTE(f0)", "abc", DataTypes.STRING().notNull()).testResult((Expression)Expressions.$((String)"f1").jsonUnquote(), "JSON_UNQUOTE(f1)", "[\"abc\"]", DataTypes.STRING().notNull()).testResult((Expression)Expressions.$((String)"f2").jsonUnquote(), "JSON_UNQUOTE(f2)", "[\"A\"]", DataTypes.STRING().notNull()).testResult((Expression)Expressions.$((String)"f3").jsonUnquote(), "JSON_UNQUOTE(f3)", "A", DataTypes.STRING().notNull()).testResult((Expression)Expressions.$((String)"f4").jsonUnquote(), "JSON_UNQUOTE(f4)", "[\"\t2\"]", DataTypes.STRING().notNull()).testResult((Expression)Expressions.$((String)"f5").jsonUnquote(), "JSON_UNQUOTE(f5)", "[\"This is a \t test \n with special characters: \b \f \r A\"]", DataTypes.STRING().notNull()).testResult((Expression)Expressions.$((String)"f6").jsonUnquote(), "JSON_UNQUOTE(f6)", "\"", DataTypes.STRING().notNull()).testResult((Expression)Expressions.$((String)"f7").jsonUnquote(), "JSON_UNQUOTE(f7)", "\"\ufffa", DataTypes.STRING().notNull()).testResult((Expression)Expressions.$((String)"f8").jsonUnquote(), "JSON_UNQUOTE(f8)", "a unicode \u2260", DataTypes.STRING().notNull()).testResult((Expression)Expressions.$((String)"f9").jsonUnquote(), "JSON_UNQUOTE(f9)", "valid unicode literal \ud801\udc00", DataTypes.STRING().notNull()).testResult((Expression)Expressions.$((String)"f10").jsonUnquote(), "JSON_UNQUOTE(f10)", "[1,2,3]", DataTypes.STRING().notNull()).testResult((Expression)Expressions.$((String)"f11").jsonUnquote(), "JSON_UNQUOTE(f11)", "[]", DataTypes.STRING().notNull()).testResult((Expression)Expressions.$((String)"f12").jsonUnquote(), "JSON_UNQUOTE(f12)", "[\"string\",2]", DataTypes.STRING().notNull()).testResult((Expression)Expressions.$((String)"f13").jsonUnquote(), "JSON_UNQUOTE(f13)", "{\"key\":\"value\"}", DataTypes.STRING().notNull()).testResult((Expression)Expressions.$((String)"f14").jsonUnquote(), "JSON_UNQUOTE(f14)", "{\"key\":[\"complex\"]}", DataTypes.STRING().notNull()).testResult((Expression)Expressions.$((String)"f15").jsonUnquote(), "JSON_UNQUOTE(f15)", "{\"key\":1}", DataTypes.STRING().notNull()).testResult((Expression)Expressions.$((String)"f16").jsonUnquote(), "JSON_UNQUOTE(f16)", "1", DataTypes.STRING().notNull()).testResult((Expression)Expressions.$((String)"f17").jsonUnquote(), "JSON_UNQUOTE(f17)", "true", DataTypes.STRING().notNull()).testResult((Expression)Expressions.$((String)"f18").jsonUnquote(), "JSON_UNQUOTE(f18)", null, DataTypes.STRING().nullable()));
    }

    private static List<BuiltInFunctionTestBase.TestSetSpec> jsonUnquoteSpecWithInvalidInput() {
        return Arrays.asList(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.JSON_UNQUOTE).onFieldsWithData(0).testResult((Expression)Expressions.nullOf((DataType)DataTypes.STRING()).jsonQuote(), "JSON_UNQUOTE(CAST(NULL AS STRING))", null, DataTypes.STRING().nullable()), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.JSON_UNQUOTE).onFieldsWithData("\"invalid json string pass through \\u006z\"", "\"invalid unicode literal and invalid json through \\u23\"", "\"invalid unicode literal and invalid json pass through \\u\u2260FFF\"", "\"invalid unicode literal but valid json pass through \"\"\\uzzzz\"", "\"[1,2,3]", "\"[1, 2, 3}", "\"", "[", "[}", "", null).andDataTypes(DataTypes.STRING().notNull(), DataTypes.STRING().notNull(), DataTypes.STRING().notNull(), DataTypes.STRING().notNull(), DataTypes.STRING().notNull(), DataTypes.STRING().notNull(), DataTypes.STRING().notNull(), DataTypes.STRING().notNull(), DataTypes.STRING().notNull(), DataTypes.STRING().notNull(), DataTypes.STRING().nullable()).testResult((Expression)Expressions.$((String)"f0").jsonUnquote(), "JSON_UNQUOTE(f0)", "\"invalid json string pass through \\u006z\"", DataTypes.STRING().notNull()).testResult((Expression)Expressions.$((String)"f1").jsonUnquote(), "JSON_UNQUOTE(f1)", "\"invalid unicode literal and invalid json through \\u23\"", DataTypes.STRING().notNull()).testResult((Expression)Expressions.$((String)"f2").jsonUnquote(), "JSON_UNQUOTE(f2)", "\"invalid unicode literal and invalid json pass through \\u\u2260FFF\"", DataTypes.STRING().notNull()).testResult((Expression)Expressions.$((String)"f3").jsonUnquote(), "JSON_UNQUOTE(f3)", "\"invalid unicode literal but valid json pass through \"\"\\uzzzz\"", DataTypes.STRING().notNull()).testResult((Expression)Expressions.$((String)"f4").jsonUnquote(), "JSON_UNQUOTE(f4)", "\"[1,2,3]", DataTypes.STRING().notNull()).testResult((Expression)Expressions.$((String)"f5").jsonUnquote(), "JSON_UNQUOTE(f5)", "\"[1, 2, 3}", DataTypes.STRING().notNull()).testResult((Expression)Expressions.$((String)"f6").jsonUnquote(), "JSON_UNQUOTE(f6)", "\"", DataTypes.STRING().notNull()).testResult((Expression)Expressions.$((String)"f7").jsonUnquote(), "JSON_UNQUOTE(f7)", "[", DataTypes.STRING().notNull()).testResult((Expression)Expressions.$((String)"f8").jsonUnquote(), "JSON_UNQUOTE(f8)", "[}", DataTypes.STRING().notNull()).testResult((Expression)Expressions.$((String)"f9").jsonUnquote(), "JSON_UNQUOTE(f9)", "", DataTypes.STRING().notNull()).testResult((Expression)Expressions.$((String)"f10").jsonQuote(), "JSON_UNQUOTE(f10)", null, DataTypes.STRING().nullable()));
    }

    private static List<BuiltInFunctionTestBase.TestSetSpec> jsonArraySpec() {
        HashMap<String, String> mapData = new HashMap<String, String>();
        mapData.put("M1", "V1");
        mapData.put("M2", "V2");
        HashMap<String, Integer> multisetData = new HashMap<String, Integer>();
        multisetData.put("M1", 1);
        multisetData.put("M2", 2);
        return Arrays.asList(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.JSON_ARRAY).onFieldsWithData(0).testResult((Expression)Expressions.jsonArray((JsonOnNull)JsonOnNull.NULL, (Object[])new Object[0]), "JSON_ARRAY()", "[]", DataTypes.STRING().notNull(), DataTypes.STRING().notNull()).testResult((Expression)Expressions.jsonArray((JsonOnNull)JsonOnNull.NULL, (Object[])new Object[]{Expressions.nullOf((DataType)DataTypes.STRING())}), "JSON_ARRAY(CAST(NULL AS STRING) NULL ON NULL)", "[null]", DataTypes.STRING().notNull(), DataTypes.STRING().notNull()).testResult((Expression)Expressions.jsonArray((JsonOnNull)JsonOnNull.ABSENT, (Object[])new Object[]{Expressions.nullOf((DataType)DataTypes.STRING())}), "JSON_ARRAY(CAST(NULL AS STRING) ABSENT ON NULL)", "[]", DataTypes.STRING().notNull(), DataTypes.STRING().notNull()), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.JSON_ARRAY).onFieldsWithData("V", true, 1, 1.23, 1.23, LocalDateTime.parse("1990-06-02T13:37:42.001"), Instant.parse("1990-06-02T13:37:42.001Z"), Arrays.asList("A1", "A2", "A3"), Row.of((Object[])new Object[]{"R1", Instant.parse("1990-06-02T13:37:42.001Z")}), mapData, multisetData, "Test".getBytes(StandardCharsets.UTF_8), "Test".getBytes(StandardCharsets.UTF_8), Row.of((Object[])new Object[]{Collections.singletonList(Row.of((Object[])new Object[]{1, 2}))})).andDataTypes(new AbstractDataType[]{DataTypes.STRING(), DataTypes.BOOLEAN(), DataTypes.INT(), DataTypes.DOUBLE(), DataTypes.DECIMAL((int)3, (int)2), DataTypes.TIMESTAMP((int)3), DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3), DataTypes.ARRAY((DataType)DataTypes.STRING()), DataTypes.ROW((DataType[])new DataType[]{DataTypes.STRING(), DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3)}), DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.STRING()), DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.INT()), DataTypes.BINARY((int)4), DataTypes.VARBINARY((int)4), DataTypes.ROW((DataType[])new DataType[]{DataTypes.ARRAY((DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.INT(), DataTypes.INT()}))})}).withFunction(CreateMultiset.class).withFunction(CreateStructuredType.class).testResult((Expression)Expressions.jsonArray((JsonOnNull)JsonOnNull.NULL, (Object[])new Object[]{Expressions.$((String)"f0"), Expressions.$((String)"f1"), Expressions.$((String)"f2"), Expressions.$((String)"f3"), Expressions.$((String)"f4"), Expressions.$((String)"f5"), Expressions.$((String)"f6"), Expressions.$((String)"f7"), Expressions.$((String)"f8"), Expressions.$((String)"f9"), Expressions.call((String)"CreateMultiset", (Object[])new Object[]{Expressions.$((String)"f10")}), Expressions.$((String)"f11"), Expressions.$((String)"f12"), Expressions.$((String)"f13"), Expressions.jsonArray((JsonOnNull)JsonOnNull.NULL, (Object[])new Object[]{"V"}), Expressions.jsonObject((JsonOnNull)JsonOnNull.NULL, (Object[])new Object[]{"K", Expressions.jsonArray((JsonOnNull)JsonOnNull.NULL, (Object[])new Object[]{"V"})}), Expressions.call((String)"CreateStructuredType", (Object[])new Object[]{Expressions.$((String)"f0"), Expressions.$((String)"f2"), Expressions.$((String)"f9")})}), "JSON_ARRAY(f0, f1, f2, f3, f4, f5, f6, f7, f8, f9, CreateMultiset(f10), f11, f12, f13, JSON_ARRAY('V'), JSON_OBJECT('K' VALUE JSON_ARRAY('V')), CreateStructuredType(f0, f2, f9))", "[\"V\",true,1,1.23,1.23,\"1990-06-02T13:37:42.001\",\"1990-06-02T13:37:42.001Z\",[\"A1\",\"A2\",\"A3\"],{\"f0\":\"R1\",\"f1\":\"1990-06-02T13:37:42.001Z\"},{\"M1\":\"V1\",\"M2\":\"V2\"},{\"M1\":1,\"M2\":2},\"VGVzdA==\",\"VGVzdA==\",{\"f0\":[{\"f0\":1,\"f1\":2}]},[\"V\"],{\"K\":[\"V\"]},{\"age\":1,\"name\":\"V\",\"payload\":{\"M1\":\"V1\",\"M2\":\"V2\"}}]", DataTypes.STRING().notNull(), DataTypes.STRING().notNull()));
    }

    private static String getJsonFromResource(String fileName) {
        InputStream jsonResource = JsonFunctionsITCase.class.getResourceAsStream(fileName);
        if (jsonResource == null) {
            throw new IllegalStateException(String.format("%s: Missing test data.", JsonFunctionsITCase.class.getName()));
        }
        try {
            return IOUtils.toString((InputStream)jsonResource, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class CreateMultiset
    extends ScalarFunction {
        @DataTypeHint(value="MULTISET<STRING>")
        public Map<String, Integer> eval(Map<String, Integer> map) {
            return map;
        }
    }

    public static class CreateStructuredType
    extends ScalarFunction {
        public MyPojo eval(String name, Integer age, Map<String, String> payload) {
            return new MyPojo(name, age, payload);
        }
    }

    public static class CreateInternalRow
    extends ScalarFunction {
        @DataTypeHint(value="ROW<f0 STRING, f1 INT>")
        public RowData eval(String name, Integer age) {
            return GenericRowData.of((Object[])new Object[]{StringData.fromString((String)name), age});
        }
    }

    public static class MyPojo {
        public final String name;
        public final Integer age;
        public final Map<String, String> payload;

        public MyPojo(String name, Integer age, Map<String, String> payload) {
            this.name = name;
            this.age = age;
            this.payload = payload;
        }
    }
}

