/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions.validation;

import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.expressions.utils.ScalarOperatorsTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Symbol;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001\u00013A\u0001C\u0005\u00011!)q\u0004\u0001C\u0001A!)1\u0005\u0001C\u0001I!)a\u0007\u0001C\u0001I!)\u0001\b\u0001C\u0001I!)!\b\u0001C\u0001I!)A\b\u0001C\u0001I!)a\b\u0001C\u0001I\ti2kY1mCJ|\u0005/\u001a:bi>\u00148OV1mS\u0012\fG/[8o)\u0016\u001cHO\u0003\u0002\u000b\u0017\u0005Qa/\u00197jI\u0006$\u0018n\u001c8\u000b\u00051i\u0011aC3yaJ,7o]5p]NT!AD\b\u0002\u000fAd\u0017M\u001c8fe*\u0011\u0001#E\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003%M\tQA\u001a7j].T!\u0001F\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0012aA8sO\u000e\u00011C\u0001\u0001\u001a!\tQR$D\u0001\u001c\u0015\ta2\"A\u0003vi&d7/\u0003\u0002\u001f7\t92kY1mCJ|\u0005/\u001a:bi>\u00148\u000fV3ti\n\u000b7/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0005\u0002\"A\t\u0001\u000e\u0003%\tq\u0003^3ti&3\u0017J\u001c<bY&$G+\u001f9fgN\u001b\u0017\r\\1\u0015\u0003\u0015\u0002\"AJ\u0015\u000e\u0003\u001dR\u0011\u0001K\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001d\u0012A!\u00168ji\"\u0012!\u0001\f\t\u0003[Qj\u0011A\f\u0006\u0003_A\n1!\u00199j\u0015\t\t$'A\u0004kkBLG/\u001a:\u000b\u0005M*\u0012!\u00026v]&$\u0018BA\u001b/\u0005\u0011!Vm\u001d;\u00029Q,7\u000f^%om\u0006d\u0017\u000eZ*ue&twmQ8na\u0006\u0014\u0018n]8oc!\u00121\u0001L\u0001\u001di\u0016\u001cH/\u00138wC2LGm\u0015;sS:<7i\\7qCJL7o\u001c83Q\t!A&A\fuKN$\u0018J\u001c#jM\u001a,'/\u001a8u\u001fB,'/\u00198eg\"\u0012Q\u0001L\u0001)i\u0016\u001cHOQ3uo\u0016,gnV5uQ\u0012KgMZ3sK:$x\n]3sC:$G+\u001f9f'\u000e\fG.\u0019\u0015\u0003\r1\n!\u0006^3tiR+W\u000e]8sC2$\u0016\u0010]3FcV\fGn]%om\u0006d\u0017\u000eZ*ue&tw\rT5uKJ\fG\u000e\u000b\u0002\bY\u0001")
public class ScalarOperatorsValidationTest
extends ScalarOperatorsTestBase {
    @Test
    public void testIfInvalidTypesScala() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testTableApi(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).$amp$amp(package$.MODULE$.boolean2Literal(true))).$qmark(package$.MODULE$.int2Literal(5), package$.MODULE$.string2Literal("false")), "FAIL"));
    }

    @Test
    public void testInvalidStringComparison1() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testTableApi(package$.MODULE$.LiteralStringExpression("w").$eq$eq$eq(package$.MODULE$.int2Literal(4)), "FAIL"));
    }

    @Test
    public void testInvalidStringComparison2() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testTableApi(package$.MODULE$.LiteralStringExpression("w").$greater(package$.MODULE$.LiteralIntExpression(4).toExpr()), "FAIL"));
    }

    @Test
    public void testInDifferentOperands() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).in((Object[])new Expression[]{package$.MODULE$.string2Literal("Hi"), package$.MODULE$.string2Literal("Hello world"), package$.MODULE$.string2Literal("Comment#1")}), "FAIL"));
    }

    @Test
    public void testBetweenWithDifferentOperandTypeScala() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testTableApi((Expression)package$.MODULE$.LiteralIntExpression(2).between((Object)package$.MODULE$.int2Literal(1), (Object)package$.MODULE$.string2Literal("a")), "FAIL"));
    }

    @Test
    public void testTemporalTypeEqualsInvalidStringLiteral() {
        this.testExpectedSqlException("f15 = 'invalid'", "Error when casting CHAR(7) NOT NULL to DATE", ValidationException.class);
        this.testExpectedSqlException("'invalid' = f15", "Error when casting CHAR(7) NOT NULL to DATE", ValidationException.class);
        this.testExpectedSqlException("f21 = 'invalid'", "Error when casting CHAR(7) NOT NULL to TIME", ValidationException.class);
        this.testExpectedSqlException("'invalid' = f21", "Error when casting CHAR(7) NOT NULL to TIME", ValidationException.class);
        this.testExpectedSqlException("f22 = 'invalid'", "Error when casting CHAR(7) NOT NULL to TIMESTAMP(6)", ValidationException.class);
        this.testExpectedSqlException("'invalid' = f22", "Error when casting CHAR(7) NOT NULL to TIMESTAMP(6)", ValidationException.class);
    }
}

