/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions.validation;

import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.expressions.utils.MapTypeTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Symbol;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001u2Aa\u0002\u0005\u0001/!)a\u0004\u0001C\u0001?!)!\u0005\u0001C\u0001G!)Q\u0007\u0001C\u0001G!)q\u0007\u0001C\u0001G!)\u0011\b\u0001C\u0001G!)1\b\u0001C\u0001G\t)R*\u00199UsB,g+\u00197jI\u0006$\u0018n\u001c8UKN$(BA\u0005\u000b\u0003)1\u0018\r\\5eCRLwN\u001c\u0006\u0003\u00171\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011QBD\u0001\ba2\fgN\\3s\u0015\ty\u0001#A\u0003uC\ndWM\u0003\u0002\u0012%\u0005)a\r\\5oW*\u00111\u0003F\u0001\u0007CB\f7\r[3\u000b\u0003U\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\r\u0011\u0005eaR\"\u0001\u000e\u000b\u0005mQ\u0011!B;uS2\u001c\u0018BA\u000f\u001b\u0005=i\u0015\r\u001d+za\u0016$Vm\u001d;CCN,\u0017A\u0002\u001fj]&$h\bF\u0001!!\t\t\u0003!D\u0001\t\u0003A!Xm\u001d;Xe>twmS3z)f\u0004X\rF\u0001%!\t)\u0003&D\u0001'\u0015\u00059\u0013!B:dC2\f\u0017BA\u0015'\u0005\u0011)f.\u001b;)\u0005\tY\u0003C\u0001\u00174\u001b\u0005i#B\u0001\u00180\u0003\r\t\u0007/\u001b\u0006\u0003aE\nqA[;qSR,'O\u0003\u00023)\u0005)!.\u001e8ji&\u0011A'\f\u0002\u0005)\u0016\u001cH/\u0001\u0010uKN$\u0018J\\2peJ,7\r^'baRK\b/Z\"p[B\f'/[:p]\"\u00121aK\u0001\u001ei\u0016\u001cH/\u00168tkB\u0004xN\u001d;fI\u000e{W\u000e]1sSN|g\u000eV=qK\"\u0012AaK\u0001\ri\u0016\u001cH/R7qifl\u0015\r\u001d\u0015\u0003\u000b-\nQ\u0005^3tiVs7/\u001e9q_J$X\rZ'ba&k\u0007\u000f\\5dSR$\u0016\u0010]3DCN$8+\u001d7)\u0005\u0019Y\u0003")
public class MapTypeValidationTest
extends MapTypeTestBase {
    @Test
    public void testWrongKeyType() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).at((Object)package$.MODULE$.int2Literal(12)), "f2[12]", "FAIL"));
    }

    @Test
    public void testIncorrectMapTypeComparison() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3"))), "f1 = f3", "FAIL"));
    }

    @Test
    public void testUnsupportedComparisonType() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).$bang$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2"))), "f6 != f2", "FAIL"));
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testSqlApi("f6 <> f2", "FAIL"));
    }

    @Test
    public void testEmptyMap() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testAllApis(package$.MODULE$.string2Literal("FAIL"), "MAP[]", "FAIL"));
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testSqlApi("MAP[]", "FAIL"));
    }

    @Test
    public void testUnsupportedMapImplicitTypeCastSql() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testSqlApi("MAP['k1', 'string', 'k2', 12]", "FAIL"));
    }
}

