/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.expressions.utils.ScalarOperatorsTestBase;
import org.junit.jupiter.api.Test;
import scala.Symbol;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001)3A\u0001D\u0007\u00015!)\u0011\u0005\u0001C\u0001E!)Q\u0005\u0001C\u0001M!)\u0001\b\u0001C\u0001M!)!\b\u0001C\u0001M!)A\b\u0001C\u0001M!)a\b\u0001C\u0001M!)\u0001\t\u0001C\u0001M!)!\t\u0001C\u0001M!)A\t\u0001C\u0001M!)a\t\u0001C\u0001M!)\u0001\n\u0001C\u0001M\t\u00192kY1mCJ|\u0005/\u001a:bi>\u00148\u000fV3ti*\u0011abD\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0011#\u00059\u0001\u000f\\1o]\u0016\u0014(B\u0001\n\u0014\u0003\u0015!\u0018M\u00197f\u0015\t!R#A\u0003gY&t7N\u0003\u0002\u0017/\u00051\u0011\r]1dQ\u0016T\u0011\u0001G\u0001\u0004_J<7\u0001A\n\u0003\u0001m\u0001\"\u0001H\u0010\u000e\u0003uQ!AH\u0007\u0002\u000bU$\u0018\u000e\\:\n\u0005\u0001j\"aF*dC2\f'o\u00149fe\u0006$xN]:UKN$()Y:f\u0003\u0019a\u0014N\\5u}Q\t1\u0005\u0005\u0002%\u00015\tQ\"\u0001\u0004uKN$\u0018J\u001c\u000b\u0002OA\u0011\u0001fK\u0007\u0002S)\t!&A\u0003tG\u0006d\u0017-\u0003\u0002-S\t!QK\\5uQ\t\u0011a\u0006\u0005\u00020m5\t\u0001G\u0003\u00022e\u0005\u0019\u0011\r]5\u000b\u0005M\"\u0014a\u00026va&$XM\u001d\u0006\u0003k]\tQA[;oSRL!a\u000e\u0019\u0003\tQ+7\u000f^\u0001\u0014i\u0016\u001cHoQ8na\u0006\u0014Xm\u00149fe\u0006$xN\u001d\u0015\u0003\u00079\n\u0011\u0005^3ti\u001a+hn\u0019;j_:<\u0016\u000e\u001e5C_>dW-\u00198FqB\u0014Xm]:j_:D#\u0001\u0002\u0018\u0002)Q,7\u000f^(uQ\u0016\u0014X\t\u001f9sKN\u001c\u0018n\u001c8tQ\t)a&\u0001\nuKN$XK\\1ssBcWo]'j]V\u001c\bF\u0001\u0004/\u0003\r\"Xm\u001d;UK6\u0004xN]1m)f\u0004X-R9vC2\u001c8\u000b\u001e:j]\u001ed\u0015\u000e^3sC2D#a\u0002\u0018\u0002AQ,7\u000f\u001e+f[B|'/\u00197UsB,W)];bYN\u001cFO]5oORK\b/\u001a\u0015\u0003\u00119\n\u0001\u0005^3tiRKW.\u001a)pS:$H+\u001f9f\u001d>$X)];bYN\u001cFO]5oO\"\u0012\u0011BL\u0001\u0019i\u0016\u001cH/T8sK\u0016\u000bX/\u00197B]\u0012tuN\\#rk\u0006d\u0007F\u0001\u0006/\u0003-!Xm\u001d;Uef\u001c\u0015m\u001d;)\u0005-q\u0003")
public class ScalarOperatorsTest
extends ScalarOperatorsTestBase {
    @Test
    public void testIn() {
        this.testSqlApi("f2 IN (1, 2, 42)", "TRUE");
        this.testSqlApi("CAST (f0 AS DECIMAL) IN (42.0, 2.00, 3.01, 1.000000)", "TRUE");
        this.testSqlApi("f10 IN ('This is a test String.', 'String', 'Hello world', 'Comment#1')", "TRUE");
        this.testSqlApi("f14 IN ('This is a test String.', 'String', 'Hello world')", "NULL");
        this.testSqlApi("f15 IN (DATE '1996-11-10')", "TRUE");
        this.testSqlApi("f15 IN (DATE '1996-11-10', DATE '1996-11-11')", "TRUE");
        this.testSqlApi("f7 IN (f16, f17)", "TRUE");
    }

    @Test
    public void testCompareOperator() {
        this.testSqlApi("f18 > f19", "TRUE");
        this.testSqlApi("f18 >= f19", "TRUE");
        this.testSqlApi("f18 < f19", "FALSE");
        this.testSqlApi("f18 <= f19", "FALSE");
        this.testSqlApi("f18 = f18", "TRUE");
        this.testSqlApi("f19 < f20", "TRUE");
        this.testSqlApi("x'68656C6C6F20636F6465' < x'68656C6C6F2063617374'", "FALSE");
        this.testSqlApi("x'68656C6C6F20636F6465' > x'68656C6C6F2063617374'", "TRUE");
    }

    @Test
    public void testFunctionWithBooleanExpression() {
        this.testSqlApi("IFNULL(f18 > f19, false)", "TRUE");
        this.testSqlApi("IFNULL(f18 >= f19, false)", "TRUE");
        this.testSqlApi("IFNULL(f18 < f19, true)", "FALSE");
        this.testSqlApi("IFNULL(f18 <= f19, true)", "FALSE");
        this.testSqlApi("IFNULL(f18 = f18, false)", "TRUE");
        this.testSqlApi("IFNULL((f6 is false) and f11, true) ", "FALSE");
        this.testSqlApi("IFNULL((f6 is true) or f11, false) ", "TRUE");
        this.testSqlApi("IFNULL(not f11, false) ", "TRUE");
        this.testSqlApi("IFNULL(f6 is true, false) ", "TRUE");
        this.testSqlApi("IFNULL(f6 is not true, true) ", "FALSE");
        this.testSqlApi("IFNULL(f6 is false, true) ", "FALSE");
        this.testSqlApi("IFNULL(f6 is not false, false) ", "TRUE");
    }

    @Test
    public void testOtherExpressions() {
        this.testSqlApi("CASE WHEN f13.f1 IS NULL THEN 'a' ELSE 'b' END", "a");
        this.testSqlApi("CASE WHEN f13.f1 IS NOT NULL THEN 'a' ELSE 'b' END", "b");
        this.testSqlApi("f13 IS NULL", "FALSE");
        this.testSqlApi("f13 IS NOT NULL", "TRUE");
        this.testSqlApi("f13.f0 IS NULL", "FALSE");
        this.testSqlApi("f13.f0 IS NOT NULL", "TRUE");
        this.testSqlApi("f13.f1 IS NULL", "TRUE");
        this.testSqlApi("f13.f1 IS NOT NULL", "FALSE");
        this.testSqlApi("true", "TRUE");
        this.testSqlApi("fAlse", "FALSE");
        this.testSqlApi("tRuE", "TRUE");
        this.testSqlApi("CASE 11 WHEN 1 THEN 'a' ELSE 'b' END", "b");
        this.testSqlApi("CASE 2 WHEN 1 THEN 'a' ELSE 'b' END", "b");
        this.testSqlApi("CASE 1 WHEN 1, 2 THEN '1 or 2' WHEN 2 THEN 'not possible' WHEN 3, 2 THEN '3' ELSE 'none of the above' END", "1 or 2");
        this.testSqlApi("CASE 2 WHEN 1, 2 THEN '1 or 2' WHEN 2 THEN 'not possible' WHEN 3, 2 THEN '3' ELSE 'none of the above' END", "1 or 2");
        this.testSqlApi("CASE 3 WHEN 1, 2 THEN '1 or 2' WHEN 2 THEN 'not possible' WHEN 3, 2 THEN '3' ELSE 'none of the above' END", "3");
        this.testSqlApi("CASE 4 WHEN 1, 2 THEN '1 or 2' WHEN 2 THEN 'not possible' WHEN 3, 2 THEN '3' ELSE 'none of the above' END", "none of the above");
        this.testSqlApi("CASE WHEN 'a'='a' THEN 1 END", "1");
        this.testSqlApi("CASE 2 WHEN 1 THEN 'a' WHEN 2 THEN 'bcd' END", "bcd");
        this.testSqlApi("CASE 1 WHEN 1 THEN 'a' WHEN 2 THEN 'bcd' END", "a");
        this.testSqlApi("CASE f2 WHEN 1 THEN 11 WHEN 2 THEN 4 ELSE NULL END", "11");
        this.testSqlApi("CASE f7 WHEN 1 THEN 11 WHEN 2 THEN 4 ELSE NULL END", "NULL");
        this.testSqlApi("CASE 42 WHEN 1 THEN 'a' WHEN 2 THEN 'bcd' END", "NULL");
        this.testSqlApi("CASE 1 WHEN 1 THEN true WHEN 2 THEN false ELSE NULL END", "TRUE");
        this.testSqlApi("IF(true, TRY_CAST ('non-numeric' AS BIGINT), 0)", "NULL");
    }

    @Test
    public void testUnaryPlusMinus() {
        this.testSqlApi("-f0", "-1");
        this.testSqlApi("+f0", "1");
        this.testSqlApi("-f1", "-1");
        this.testSqlApi("+f1", "1");
        this.testSqlApi("-f2", "-1");
        this.testSqlApi("+f2", "1");
        this.testSqlApi("-f3", "-1");
        this.testSqlApi("+f3", "1");
        this.testSqlApi("-f4", "-1.0");
        this.testSqlApi("+f4", "1.0");
        this.testSqlApi("-f5", "-1.0");
        this.testSqlApi("+f5", "1.0");
        this.testSqlApi("-f17", "-10.0");
        this.testSqlApi("+f17", "10.0");
    }

    @Test
    public void testTemporalTypeEqualsStringLiteral() {
        this.testSqlApi("f15 = '1996-11-10'", "TRUE");
        this.testSqlApi("f15 = '1996-11-11'", "FALSE");
        this.testSqlApi("'1996-11-10' = f15", "TRUE");
        this.testSqlApi("'1996-11-11' = f15", "FALSE");
        this.testSqlApi("f21 = '12:34:56'", "TRUE");
        this.testSqlApi("f21 = '13:34:56'", "FALSE");
        this.testSqlApi("'12:34:56' = f21", "TRUE");
        this.testSqlApi("'13:34:56' = f21", "FALSE");
        this.testSqlApi("TYPEOF(f22)", "TIMESTAMP(6)");
        this.testSqlApi("f22 = '1996-11-10 12:34:56'", "TRUE");
        this.testSqlApi("f22 = '1996-11-10 12:34:57'", "FALSE");
        this.testSqlApi("f22 = cast(null as string)", "NULL");
        this.testSqlApi("'1996-11-10 12:34:56' = f22", "TRUE");
        this.testSqlApi("'1996-11-10 12:34:57' = f22", "FALSE");
        this.testSqlApi("cast(null as string) = f22", "NULL");
        this.testSqlApi("TYPEOF(f23)", "TIMESTAMP_LTZ(6)");
        this.testSqlApi("f23 = '1996-11-10 12:34:56'", "TRUE");
        this.testSqlApi("f23 = '1996-11-10 12:34:57'", "FALSE");
        this.testSqlApi("f23 = cast(null as string)", "NULL");
        this.testSqlApi("'1996-11-10 12:34:56' = f23", "TRUE");
        this.testSqlApi("'1996-11-10 12:34:57' = f23", "FALSE");
        this.testSqlApi("cast(null as string) = f23", "NULL");
    }

    @Test
    public void testTemporalTypeEqualsStringType() {
        this.testSqlApi("f15 = date_format(cast(f15 as timestamp), 'yyyy-MM-dd')", "TRUE");
        this.testSqlApi("f15 = date_format(cast(f15 as timestamp) + interval '1' day, 'yyyy-MM-dd')", "FALSE");
        this.testSqlApi("f15 = uuid()", "NULL");
        this.testSqlApi("date_format(cast(f15 as timestamp), 'yyyy-MM-dd') = f15", "TRUE");
        this.testSqlApi("date_format(cast(f15 as timestamp) + interval '1' day, 'yyyy-MM-dd') = f15", "FALSE");
        this.testSqlApi("uuid() = f15", "NULL");
        this.testSqlApi("f21 = date_format(cast(f21 as timestamp), 'HH:mm:ss')", "TRUE");
        this.testSqlApi("f21 = date_format(cast(f21 as timestamp) + interval '1' hour, 'HH:mm:ss')", "FALSE");
        this.testSqlApi("f21 = uuid()", "NULL");
        this.testSqlApi("date_format(cast(f21 as timestamp), 'HH:mm:ss') = f21", "TRUE");
        this.testSqlApi("date_format(cast(f21 as timestamp) + interval '1' hour, 'HH:mm:ss') = f21", "FALSE");
        this.testSqlApi("uuid() = f21", "NULL");
        this.testSqlApi("f22 = date_format(f22, 'yyyy-MM-dd HH:mm:ss')", "TRUE");
        this.testSqlApi("f22 = date_format(f22 + interval '1' second, 'yyyy-MM-dd HH:mm:ss')", "FALSE");
        this.testSqlApi("f22 = uuid()", "NULL");
        this.testSqlApi("date_format(f22, 'yyyy-MM-dd HH:mm:ss') = f22", "TRUE");
        this.testSqlApi("date_format(f22 + interval '1' second, 'yyyy-MM-dd HH:mm:ss') = f22", "FALSE");
        this.testSqlApi("uuid() = f22", "NULL");
        this.testSqlApi("cast(f22 as timestamp_ltz) = date_format(f22, 'yyyy-MM-dd HH:mm:ss')", "TRUE");
        this.testSqlApi("cast(f22 as timestamp_ltz) = date_format(f22 + interval '1' second, 'yyyy-MM-dd HH:mm:ss')", "FALSE");
        this.testSqlApi("cast(f22 as timestamp_ltz) = uuid()", "NULL");
        this.testSqlApi("date_format(f22, 'yyyy-MM-dd HH:mm:ss') = cast(f22 as timestamp_ltz)", "TRUE");
        this.testSqlApi("date_format(f22 + interval '1' second, 'yyyy-MM-dd HH:mm:ss') = cast(f22 as timestamp_ltz)", "FALSE");
        this.testSqlApi("uuid() = cast(f22 as timestamp_ltz)", "NULL");
        this.testSqlApi("f23 = date_format(f23, 'yyyy-MM-dd HH:mm:ss')", "TRUE");
        this.testSqlApi("f23 = date_format(f23 + interval '1' second, 'yyyy-MM-dd HH:mm:ss')", "FALSE");
        this.testSqlApi("f23 = uuid()", "NULL");
        this.testSqlApi("date_format(f23, 'yyyy-MM-dd HH:mm:ss') = f23", "TRUE");
        this.testSqlApi("date_format(f23 + interval '1' second, 'yyyy-MM-dd HH:mm:ss') = f23", "FALSE");
        this.testSqlApi("uuid() = f23", "NULL");
    }

    @Test
    public void testTimePointTypeNotEqualsString() {
        this.testSqlApi("NOT(f15 = '1996-11-10')", "FALSE");
        this.testSqlApi("NOT(f15 = '1996-11-11')", "TRUE");
        this.testSqlApi("NOT('1996-11-10' = f15)", "FALSE");
        this.testSqlApi("NOT('1996-11-11' = f15)", "TRUE");
        this.testSqlApi("NOT(f21 = '12:34:56')", "FALSE");
        this.testSqlApi("NOT(f21 = '13:34:56')", "TRUE");
        this.testSqlApi("NOT('12:34:56' = f21)", "FALSE");
        this.testSqlApi("NOT('13:34:56' = f21)", "TRUE");
        this.testSqlApi("TYPEOF(f22)", "TIMESTAMP(6)");
        this.testSqlApi("NOT(f22 = '1996-11-10 12:34:56')", "FALSE");
        this.testSqlApi("NOT(f22 = '1996-11-10 12:34:57')", "TRUE");
        this.testSqlApi("NOT(f22 = cast(null as string))", "NULL");
        this.testSqlApi("NOT('1996-11-10 12:34:56' = f22)", "FALSE");
        this.testSqlApi("NOT('1996-11-10 12:34:57' = f22)", "TRUE");
        this.testSqlApi("NOT(cast(null as string) = f22)", "NULL");
        this.testSqlApi("TYPEOF(f23)", "TIMESTAMP_LTZ(6)");
        this.testSqlApi("f23 = '1996-11-10 12:34:56'", "TRUE");
        this.testSqlApi("f23 = '1996-11-10 12:34:57'", "FALSE");
        this.testSqlApi("f23 = cast(null as string)", "NULL");
        this.testSqlApi("'1996-11-10 12:34:56' = f23", "TRUE");
        this.testSqlApi("'1996-11-10 12:34:57' = f23", "FALSE");
        this.testSqlApi("cast(null as string) = f23", "NULL");
        this.testSqlApi("NOT(f15 = date_format(cast(f15 as timestamp), 'yyyy-MM-dd'))", "FALSE");
        this.testSqlApi("NOT(f15 = date_format(cast(f15 as timestamp) + interval '1' day, 'yyyy-MM-dd'))", "TRUE");
        this.testSqlApi("NOT(f15 = uuid())", "NULL");
        this.testSqlApi("NOT(date_format(cast(f15 as timestamp), 'yyyy-MM-dd') = f15)", "FALSE");
        this.testSqlApi("NOT(date_format(cast(f15 as timestamp) + interval '1' day, 'yyyy-MM-dd')) = f15", "TRUE");
        this.testSqlApi("NOT(uuid() = f15)", "NULL");
        this.testSqlApi("NOT(f21 = date_format(cast(f21 as timestamp), 'HH:mm:ss'))", "FALSE");
        this.testSqlApi("NOT(f21 = date_format(cast(f21 as timestamp) + interval '1' hour, 'HH:mm:ss'))", "TRUE");
        this.testSqlApi("NOT(f21 = uuid())", "NULL");
        this.testSqlApi("NOT(date_format(cast(f21 as timestamp), 'HH:mm:ss') = f21)", "FALSE");
        this.testSqlApi("NOT(date_format(cast(f21 as timestamp) + interval '1' hour, 'HH:mm:ss') = f21)", "TRUE");
        this.testSqlApi("NOT(uuid() = f21)", "NULL");
        this.testSqlApi("NOT(f22 = date_format(f22, 'yyyy-MM-dd HH:mm:ss'))", "FALSE");
        this.testSqlApi("NOT(f22 = date_format(f22 + interval '1' second, 'yyyy-MM-dd HH:mm:ss'))", "TRUE");
        this.testSqlApi("NOT(f22 = uuid())", "NULL");
        this.testSqlApi("NOT(date_format(f22, 'yyyy-MM-dd HH:mm:ss') = f22)", "FALSE");
        this.testSqlApi("NOT(date_format(f22 + interval '1' second, 'yyyy-MM-dd HH:mm:ss') = f22)", "TRUE");
        this.testSqlApi("NOT(uuid() = f22)", "NULL");
        this.testSqlApi("NOT(cast(f22 as timestamp_ltz) = date_format(f22, 'yyyy-MM-dd HH:mm:ss'))", "FALSE");
        this.testSqlApi("NOT(cast(f22 as timestamp_ltz) = date_format(f22 + interval '1' second, 'yyyy-MM-dd HH:mm:ss'))", "TRUE");
        this.testSqlApi("NOT(cast(f22 as timestamp_ltz) = uuid())", "NULL");
        this.testSqlApi("NOT(date_format(f22, 'yyyy-MM-dd HH:mm:ss') = cast(f22 as timestamp_ltz))", "FALSE");
        this.testSqlApi("NOT(date_format(f22 + interval '1' second, 'yyyy-MM-dd HH:mm:ss') = cast(f22 as timestamp_ltz))", "TRUE");
        this.testSqlApi("NOT(uuid() = cast(f22 as timestamp_ltz))", "NULL");
        this.testSqlApi("NOT(f23 = date_format(f23, 'yyyy-MM-dd HH:mm:ss'))", "FALSE");
        this.testSqlApi("NOT(f23 = date_format(f23 + interval '1' second, 'yyyy-MM-dd HH:mm:ss'))", "TRUE");
        this.testSqlApi("NOT(f23 = uuid())", "NULL");
        this.testSqlApi("NOT(date_format(f23, 'yyyy-MM-dd HH:mm:ss') = f23)", "FALSE");
        this.testSqlApi("NOT(date_format(f23 + interval '1' second, 'yyyy-MM-dd HH:mm:ss') = f23)", "TRUE");
        this.testSqlApi("NOT(uuid() = f23)", "NULL");
    }

    @Test
    public void testMoreEqualAndNonEqual() {
        this.testSqlApi("f10 = 'String'", "TRUE");
        this.testSqlApi("f10 = 'string'", "FALSE");
        this.testSqlApi("f10 = NULL", "NULL");
        this.testSqlApi("f10 = CAST(NULL AS STRING)", "NULL");
        this.testSqlApi("'String' = f10", "TRUE");
        this.testSqlApi("'string' = f10", "FALSE");
        this.testSqlApi("NULL = f10", "NULL");
        this.testSqlApi("CAST(NULL AS STRING) = f10", "NULL");
        this.testSqlApi("NOT(f10 = 'String')", "FALSE");
        this.testSqlApi("NOT(f10 = 'string')", "TRUE");
        this.testSqlApi("NOT(f10 = NULL)", "NULL");
        this.testSqlApi("NOT(f10 = CAST(NULL AS STRING))", "NULL");
        this.testSqlApi("NOT('String' = f10)", "FALSE");
        this.testSqlApi("NOT('string' = f10)", "TRUE");
        this.testSqlApi("NOT(NULL = f10)", "NULL");
        this.testSqlApi("NOT(CAST(NULL AS STRING) = f10)", "NULL");
        this.testSqlApi("f2 = 1", "TRUE");
        this.testSqlApi("f2 = 2", "FALSE");
        this.testSqlApi("f2 = NULL", "NULL");
        this.testSqlApi("f2 = CAST(NULL AS INT)", "NULL");
        this.testSqlApi("1 = f2", "TRUE");
        this.testSqlApi("2 = f2", "FALSE");
        this.testSqlApi("NULL = f2", "NULL");
        this.testSqlApi("CAST(NULL AS INT) = f2", "NULL");
        this.testSqlApi("NOT(f2 = 1)", "FALSE");
        this.testSqlApi("NOT(f2 = 2)", "TRUE");
        this.testSqlApi("NOT(f2 = NULL)", "NULL");
        this.testSqlApi("NOT(f2 = CAST(NULL AS INT))", "NULL");
        this.testSqlApi("NOT(1 = f2)", "FALSE");
        this.testSqlApi("NOT(2 = f2)", "TRUE");
        this.testSqlApi("NOT(NULL = f2)", "NULL");
        this.testSqlApi("NOT(CAST(NULL AS INT) = f2)", "NULL");
        this.testSqlApi("f24 = ARRAY['hello', 'world']", "TRUE");
        this.testSqlApi("f24 = ARRAY['hello1', 'world']", "FALSE");
        this.testSqlApi("f24 = NULL", "NULL");
        this.testSqlApi("f24 = CAST(NULL AS ARRAY<STRING>)", "NULL");
        this.testSqlApi("ARRAY['hello', 'world'] = f24", "TRUE");
        this.testSqlApi("ARRAY['hello1', 'world'] = f24", "FALSE");
        this.testSqlApi("NULL = f24", "NULL");
        this.testSqlApi("CAST(NULL AS ARRAY<STRING>) = f24", "NULL");
        this.testSqlApi("NOT(f24 = ARRAY['hello', 'world'])", "FALSE");
        this.testSqlApi("NOT(f24 = ARRAY['hello1', 'world'])", "TRUE");
        this.testSqlApi("NOT(f24 = NULL)", "NULL");
        this.testSqlApi("NOT(f24 = CAST(NULL AS ARRAY<STRING>))", "NULL");
        this.testSqlApi("NOT(ARRAY['hello', 'world'] = f24)", "FALSE");
        this.testSqlApi("NOT(ARRAY['hello1', 'world'] = f24)", "TRUE");
        this.testSqlApi("NOT(NULL = f24)", "NULL");
        this.testSqlApi("NOT(CAST(NULL AS ARRAY<STRING>)) = f24", "NULL");
        this.testSqlApi("f25 = MAP['a', 1, 'b', 2]", "TRUE");
        this.testSqlApi("f25 = MAP['a', 3, 'b', 2]", "FALSE");
        this.testSqlApi("f25 = NULL", "NULL");
        this.testSqlApi("f25 = CAST(NULL AS MAP<STRING, INT>)", "NULL");
        this.testSqlApi("MAP['a', 1, 'b', 2] = f25", "TRUE");
        this.testSqlApi("MAP['a', 3, 'b', 2] = f25", "FALSE");
        this.testSqlApi("NULL = f25", "NULL");
        this.testSqlApi("CAST(NULL AS MAP<STRING, INT>) = f25", "NULL");
        this.testSqlApi("NOT(f25 = MAP['a', 1, 'b', 2])", "FALSE");
        this.testSqlApi("NOT(f25 = MAP['a', 3, 'b', 2])", "TRUE");
        this.testSqlApi("NOT(f25 = NULL)", "NULL");
        this.testSqlApi("NOT(f25 = CAST(NULL AS MAP<STRING, INT>))", "NULL");
        this.testSqlApi("NOT(MAP['a', 1, 'b', 2] = f25)", "FALSE");
        this.testSqlApi("NOT(MAP['a', 3, 'b', 2] = f25)", "TRUE");
        this.testSqlApi("NOT(NULL = f25)", "NULL");
        this.testSqlApi("NOT(CAST(NULL AS MAP<STRING, INT>) = f25)", "NULL");
        this.testSqlApi("f27 = f29", "TRUE");
        this.testSqlApi("f27 = f28", "FALSE");
        this.testSqlApi("f27 = NULL", "NULL");
        this.testSqlApi("f29 = f27", "TRUE");
        this.testSqlApi("f28 = f27", "FALSE");
        this.testSqlApi("NULL = f27", "NULL");
        this.testSqlApi("NOT(f27 = f29)", "FALSE");
        this.testSqlApi("NOT(f27 = f28)", "TRUE");
        this.testSqlApi("NOT(f27 = NULL)", "NULL");
        this.testSqlApi("NOT(f29 = f27)", "FALSE");
        this.testSqlApi("NOT(f28 = f27)", "TRUE");
        this.testSqlApi("NOT(NULL = f27)", "NULL");
        this.testSqlApi("f30 = ROW('abc', 'def')", "TRUE");
        this.testSqlApi("f30 = ROW('abc', 'xyz')", "FALSE");
        this.testSqlApi("f30 = NULL", "NULL");
        this.testSqlApi("f30 = CAST(NULL AS ROW<f0 STRING, f1 STRING>)", "NULL");
        this.testSqlApi("ROW('abc', 'def') = f30", "TRUE");
        this.testSqlApi("ROW('abc', 'xyz') = f30", "FALSE");
        this.testSqlApi("CAST(NULL AS ROW<f0 STRING, f1 STRING>) = f30", "NULL");
        this.testSqlApi("NOT(f30 = ROW('abc', 'def'))", "FALSE");
        this.testSqlApi("NOT(f30 = ROW('abc', 'xyz'))", "TRUE");
        this.testSqlApi("NOT(f30 = NULL)", "NULL");
        this.testSqlApi("NOT(f30 = CAST(NULL AS ROW<f0 STRING, f1 STRING>))", "NULL");
        this.testSqlApi("NOT(ROW('abc', 'def') = f30)", "FALSE");
        this.testSqlApi("NOT(ROW('abc', 'xyz') = f30)", "TRUE");
        this.testSqlApi("NOT(CAST(NULL AS ROW<f0 STRING, f1 STRING>) = f30)", "NULL");
        this.testSqlApi("f31 = f33", "TRUE");
        this.testSqlApi("f31 = f32", "FALSE");
        this.testSqlApi("f31 = NULL", "NULL");
        this.testSqlApi("f31 = f34", "NULL");
        this.testSqlApi("f31 = CAST(NULL AS INTERVAL DAY)", "NULL");
        this.testSqlApi("f33 = f31", "TRUE");
        this.testSqlApi("f32 = f31", "FALSE");
        this.testSqlApi("NULL = f31", "NULL");
        this.testSqlApi("f34 = f31", "NULL");
        this.testSqlApi("CAST(NULL AS INTERVAL DAY) = f31", "NULL");
        this.testSqlApi("NOT(f31 = f33)", "FALSE");
        this.testSqlApi("NOT(f31 = f32)", "TRUE");
        this.testSqlApi("NOT(f31 = NULL)", "NULL");
        this.testSqlApi("NOT(f31 = f34)", "NULL");
        this.testSqlApi("NOT(f31 = CAST(NULL AS INTERVAL DAY))", "NULL");
        this.testSqlApi("NOT(f33 = f31)", "FALSE");
        this.testSqlApi("NOT(f32 = f31)", "TRUE");
        this.testSqlApi("NOT(NULL = f31)", "NULL");
        this.testSqlApi("NOT(f34 = f31)", "NULL");
        this.testSqlApi("NOT(CAST(NULL AS INTERVAL DAY) = f31)", "NULL");
    }

    @Test
    public void testTryCast() {
        this.testAllApis((Expression)package$.MODULE$.LiteralStringExpression("non-numeric").tryCast(DataTypes.BIGINT()), "TRY_CAST ('non-numeric' AS BIGINT)", "NULL");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f10")).tryCast(DataTypes.BIGINT()), "TRY_CAST (f10 AS BIGINT)", "NULL");
    }
}

