/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions;

import java.io.Serializable;
import java.util.Random;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.TimeIntervalUnit;
import org.apache.flink.table.expressions.TimePointUnit;
import org.apache.flink.table.legacy.api.Types;
import org.apache.flink.table.planner.expressions.utils.ScalarTypesTestBase;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tuf\u0001\u00025j\u0001YDQ! \u0001\u0005\u0002yDq!a\u0001\u0001\t\u0003\t)\u0001C\u0004\u0002*\u0001!\t!!\u0002\t\u000f\u00055\u0002\u0001\"\u0001\u0002\u0006!9\u0011\u0011\u0007\u0001\u0005\u0002\u0005\u0015\u0001bBA\u001b\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003s\u0001A\u0011AA\u0003\u0011\u001d\ti\u0004\u0001C\u0001\u0003\u000bAq!!\u0011\u0001\t\u0003\t)\u0001C\u0004\u0002F\u0001!\t!!\u0002\t\u000f\u0005%\u0003\u0001\"\u0001\u0002\u0006!9\u0011Q\n\u0001\u0005\u0002\u0005\u0015\u0001bBA)\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003+\u0002A\u0011AA\u0003\u0011\u001d\tI\u0006\u0001C\u0001\u0003\u000bAq!!\u0018\u0001\t\u0003\t)\u0001C\u0004\u0002b\u0001!\t!!\u0002\t\u000f\u0005\u0015\u0004\u0001\"\u0001\u0002\u0006!9\u0011\u0011\u000e\u0001\u0005\u0002\u0005\u0015\u0001bBA7\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003c\u0002A\u0011AA\u0003\u0011\u001d\t)\b\u0001C\u0001\u0003\u000bAq!!\u001f\u0001\t\u0003\t)\u0001C\u0004\u0002~\u0001!\t!!\u0002\t\u000f\u0005\u0005\u0005\u0001\"\u0001\u0002\u0006!9\u0011Q\u0011\u0001\u0005\u0002\u0005\u0015\u0001bBAE\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003\u001b\u0003A\u0011AA\u0003\u0011\u001d\t\t\n\u0001C\u0001\u0003\u000bAq!!&\u0001\t\u0003\t)\u0001C\u0004\u0002\u001a\u0002!\t!!\u0002\t\u000f\u0005u\u0005\u0001\"\u0001\u0002\u0006!9\u0011\u0011\u0015\u0001\u0005\u0002\u0005\u0015\u0001bBAS\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003S\u0003A\u0011AA\u0003\u0011\u001d\ti\u000b\u0001C\u0001\u0003\u000bAq!!-\u0001\t\u0003\t)\u0001C\u0004\u00026\u0002!\t!!\u0002\t\u000f\u0005e\u0006\u0001\"\u0001\u0002\u0006!9\u0011Q\u0018\u0001\u0005\u0002\u0005\u0015\u0001bBAa\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003\u000b\u0004A\u0011AA\u0003\u0011\u001d\tI\r\u0001C\u0001\u0003\u000bAq!!4\u0001\t\u0003\t)\u0001C\u0004\u0002R\u0002!\t!!\u0002\t\u000f\u0005U\u0007\u0001\"\u0001\u0002\u0006!9\u0011\u0011\u001c\u0001\u0005\u0002\u0005\u0015\u0001bBAo\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003C\u0004A\u0011AA\u0003\u0011\u001d\t)\u000f\u0001C\u0001\u0003\u000bAq!!;\u0001\t\u0003\t)\u0001C\u0004\u0002n\u0002!\t!!\u0002\t\u000f\u0005E\b\u0001\"\u0001\u0002\u0006!9\u0011Q\u001f\u0001\u0005\u0002\u0005\u0015\u0001bBA}\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003{\u0004A\u0011AA\u0003\u0011\u001d\u0011\t\u0001\u0001C\u0001\u0003\u000bAqA!\u0002\u0001\t\u0003\t)\u0001C\u0004\u0003\n\u0001!\t!!\u0002\t\u000f\t5\u0001\u0001\"\u0001\u0002\u0006!9!\u0011\u0003\u0001\u0005\u0002\u0005\u0015\u0001b\u0002B\u000b\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u00053\u0001A\u0011AA\u0003\u0011\u001d\u0011i\u0002\u0001C\u0001\u0003\u000bAqA!\t\u0001\t\u0003\t)\u0001C\u0004\u0003&\u0001!\t!!\u0002\t\u000f\t%\u0002\u0001\"\u0001\u0002\u0006!9!Q\u0006\u0001\u0005\u0002\u0005\u0015\u0001b\u0002B\u0019\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0005k\u0001A\u0011AA\u0003\u0011\u001d\u0011I\u0004\u0001C\u0001\u0003\u000bAqA!\u0010\u0001\t\u0003\t)\u0001C\u0004\u0003B\u0001!\t!!\u0002\t\u000f\t\u0015\u0003\u0001\"\u0001\u0002\u0006!9!\u0011\n\u0001\u0005\u0002\u0005\u0015\u0001b\u0002B'\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0005#\u0002A\u0011AA\u0003\u0011\u001d\u0011)\u0006\u0001C\u0001\u0003\u000bAqA!\u0017\u0001\t\u0003\t)\u0001C\u0004\u0003^\u0001!\t!!\u0002\t\u000f\t\u0005\u0004\u0001\"\u0001\u0002\u0006!9!Q\r\u0001\u0005\u0002\u0005\u0015\u0001b\u0002B5\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0005[\u0002A\u0011AA\u0003\u0011\u001d\u0011\t\b\u0001C\u0001\u0003\u000bAqA!\u001e\u0001\t\u0003\t)\u0001C\u0004\u0003z\u0001!\t!!\u0002\t\u000f\tu\u0004\u0001\"\u0001\u0002\u0006!9!\u0011\u0011\u0001\u0005\u0002\u0005\u0015\u0001b\u0002BC\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0005\u0013\u0003A\u0011AA\u0003\u0011\u001d\u0011i\t\u0001C\u0001\u0003\u000bAqA!%\u0001\t\u0003\t)\u0001C\u0004\u0003\u0016\u0002!\t!!\u0002\t\u000f\te\u0005\u0001\"\u0001\u0002\u0006!9!Q\u0014\u0001\u0005\u0002\u0005\u0015\u0001b\u0002BQ\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0005K\u0003A\u0011AA\u0003\u0011\u001d\u0011I\u000b\u0001C\u0001\u0003\u000bAqA!,\u0001\t\u0003\t)\u0001C\u0004\u00032\u0002!\t!!\u0002\t\u000f\tU\u0006\u0001\"\u0001\u0002\u0006!9!\u0011\u0018\u0001\u0005\u0002\u0005\u0015!aE*dC2\f'OR;oGRLwN\\:UKN$(B\u00016l\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u00051l\u0017a\u00029mC:tWM\u001d\u0006\u0003]>\fQ\u0001^1cY\u0016T!\u0001]9\u0002\u000b\u0019d\u0017N\\6\u000b\u0005I\u001c\u0018AB1qC\u000eDWMC\u0001u\u0003\ry'oZ\u0002\u0001'\t\u0001q\u000f\u0005\u0002yw6\t\u0011P\u0003\u0002{S\u0006)Q\u000f^5mg&\u0011A0\u001f\u0002\u0014'\u000e\fG.\u0019:UsB,7\u000fV3ti\n\u000b7/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u00042!!\u0001\u0001\u001b\u0005I\u0017a\u0003;fgR|e/\u001a:mCf$\"!a\u0002\u0011\t\u0005%\u0011qB\u0007\u0003\u0003\u0017Q!!!\u0004\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005E\u00111\u0002\u0002\u0005+:LG\u000fK\u0002\u0003\u0003+\u0001B!a\u0006\u0002&5\u0011\u0011\u0011\u0004\u0006\u0005\u00037\ti\"A\u0002ba&TA!a\b\u0002\"\u00059!.\u001e9ji\u0016\u0014(bAA\u0012g\u0006)!.\u001e8ji&!\u0011qEA\r\u0005\u0011!Vm\u001d;\u0002\u0019Q,7\u000f\u001e)pg&$\u0018n\u001c8)\u0007\r\t)\"\u0001\u0006uKN$Hj\\2bi\u0016D3\u0001BA\u000b\u0003!!Xm\u001d;MK\u001a$\bfA\u0003\u0002\u0016\u0005IA/Z:u%&<\u0007\u000e\u001e\u0015\u0004\r\u0005U\u0011!\u0003;fgR\f5oY5jQ\r9\u0011QC\u0001\u0011i\u0016\u001cH\u000fT3gi\u0006sGMU5hQRD3\u0001CA\u000b\u0003%!Xm\u001d;J]N$(\u000fK\u0002\n\u0003+\tQ\u0002^3tiN+(m\u001d;sS:<\u0007f\u0001\u0006\u0002\u0016\u0005YA/Z:u%\u0016\u0004H.Y2fQ\rY\u0011QC\u0001\ti\u0016\u001cH\u000f\u0016:j[\"\u001aA\"!\u0006\u0002\u0013Q,7\u000f\u001e'Ue&l\u0007fA\u0007\u0002\u0016\u0005IA/Z:u%R\u0013\u0018.\u001c\u0015\u0004\u001d\u0005U\u0011A\u0004;fgR\u001c\u0005.\u0019:MK:<G\u000f\u001b\u0015\u0004\u001f\u0005U\u0011!\u0004;fgR,\u0006\u000f]3s\u0007\u0006\u001cX\rK\u0002\u0011\u0003+\tQ\u0002^3ti2{w/\u001a:DCN,\u0007fA\t\u0002\u0016\u0005YA/Z:u\u0013:LGoQ1qQ\r\u0011\u0012QC\u0001\u000bi\u0016\u001cHoQ8oG\u0006$\bfA\n\u0002\u0016\u0005AA/Z:u\u0019&\\W\rK\u0002\u0015\u0003+\t1\u0002^3ti:{G\u000fT5lK\"\u001aQ#!\u0006\u0002%Q,7\u000f\u001e'jW\u0016<\u0016\u000e\u001e5Fg\u000e\f\u0007/\u001a\u0015\u0004-\u0005U\u0011!\u0006;fgRtu\u000e\u001e'jW\u0016<\u0016\u000e\u001e5Fg\u000e\f\u0007/\u001a\u0015\u0004/\u0005U\u0011a\u0003;fgR\u001c\u0016.\\5mCJD3\u0001GA\u000b\u00039!Xm\u001d;O_R\u001c\u0016.\\5mCJD3!GA\u000b\u0003U!Xm\u001d;TS6LG.\u0019:XSRDWi]2ba\u0016D3AGA\u000b\u0003a!Xm\u001d;O_R\u001c\u0016.\\5mCJ<\u0016\u000e\u001e5Fg\u000e\f\u0007/\u001a\u0015\u00047\u0005U\u0011a\u0004;fgRlU\u000f\u001c;j\u0007>t7-\u0019;)\u0007q\t)\"\u0001\u0007uKN$8i\u001c8dCR<6\u000fK\u0002\u001e\u0003+\t\u0011\u0003^3tiJ+w-\u001a=q%\u0016\u0004H.Y2fQ\rq\u0012QC\u0001\u0012i\u0016\u001cHOU3hKb\u0004X\t\u001f;sC\u000e$\bfA\u0010\u0002\u0016\u0005iA/Z:u\u0015N|g.U;pi\u0016D3\u0001IA\u000b\u0003u!Xm\u001d;Kg>tWK\\9v_R,w+\u001b;i-\u0006d\u0017\u000eZ%oaV$\bfA\u0011\u0002\u0016\u0005iC/Z:u\u0015N|g.U;pi\u00164u\u000e\u001c7po\u0016$')_+ocV|G/\u001a*fiV\u0014hn](sS\u001eLg.\u00197)\u0007\t\n)\"A\u0010uKN$(j]8o+:\fXo\u001c;f/&$\b.\u00138wC2LG-\u00138qkRD3aIA\u000b\u00039!Xm\u001d;Ge>l')Y:fmQB3\u0001JA\u000b\u00031!Xm\u001d;U_\n\u000b7/\u001a\u001c5Q\r)\u0013QC\u0001\u000ei\u0016\u001cHoU;c'R\u0014\u0018N\\4)\u0007\u0019\n)\"\u0001\u0005uKN$H\nU1eQ\r9\u0013QC\u0001\ti\u0016\u001cHO\u0015)bI\"\u001a\u0001&!\u0006\u0002\u0019Q,7\u000f\u001e)beN,WK\u001d7)\u0007%\n)\"\u0001\u0006uKN$(+\u001a9fCRD3AKA\u000b\u0003-!Xm\u001d;SKZ,'o]3)\u0007-\n)\"\u0001\buKN$8\u000b\u001d7ji&sG-\u001a=)\u00071\n)\"\u0001\u0007uKN$\b*Y:i\u0007>$W\rK\u0002.\u0003+\tq\u0001^3ti6#U\u0007K\u0002/\u0003+\t!\u0002^3tiJ+w-\u001a=qQ\ry\u0013QC\u0001\bi\u0016\u001cH\u000fS3yQ\r\u0001\u0014QC\u0001\bi\u0016\u001cHOQ5oQ\r\t\u0014QC\u0001\ti\u0016\u001cH/V+J\t\"\u001a!'!\u0006\u0002\u0019Q,7\u000f\u001e+sk:\u001c\u0017\r^3)\u0007M\n)\"A\u0004uKN$X\t\u001f9)\u0007Q\n)\"A\u0005uKN$Hj\\42a!\u001aQ'!\u0006\u0002\u0013Q,7\u000f\u001e)po\u0016\u0014\bf\u0001\u001c\u0002\u0016\u0005AA/Z:u'F\u0014H\u000fK\u00028\u0003+\t\u0001\u0002^3ti\u000e{7\u000f\u001b\u0015\u0004q\u0005U\u0011A\u0002;fgRde\u000eK\u0002:\u0003+\tq\u0001^3ti\u0006\u00137\u000fK\u0002;\u0003+\tq\u0003^3ti\u0006\u0013\u0018\u000e\u001e5nKRL7M\u00127p_J\u001cU-\u001b7)\u0007m\n)\"A\u0004uKN$8+\u001b8)\u0007q\n)\"A\u0004uKN$8i\\:)\u0007u\n)\"\u0001\u0005uKN$8+\u001b8iQ\rq\u0014QC\u0001\bi\u0016\u001cH\u000fV1oQ\ry\u0014QC\u0001\ti\u0016\u001cH\u000fV1oQ\"\u001a\u0001)!\u0006\u0002\u000fQ,7\u000f^\"pi\"\u001a\u0011)!\u0006\u0002\u0011Q,7\u000f^!tS:D3AQA\u000b\u0003!!Xm\u001d;BG>\u001c\bfA\"\u0002\u0016\u0005AA/Z:u\u0003R\fg\u000eK\u0002E\u0003+\t\u0011\u0002^3ti\u0006#\u0018M\u001c\u001a)\u0007\u0015\u000b)\"A\u0006uKN$H)Z4sK\u0016\u001c\bf\u0001$\u0002\u0016\u0005YA/Z:u%\u0006$\u0017.\u00198tQ\r9\u0015QC\u0001\ti\u0016\u001cHoU5h]\"\u001a\u0001*!\u0006\u0002\u0013Q,7\u000f\u001e*pk:$\u0007fA%\u0002\u0016\u00051A/Z:u!&D3ASA\u000b\u0003Y!Xm\u001d;SC:$\u0017I\u001c3SC:$\u0017J\u001c;fO\u0016\u0014\bfA&\u0002\u0016\u0005)A/Z:u\u000b\"\u001aA*!\u0006\u0002\u000fQ,7\u000f\u001e'pO\"\u001aQ*!\u0006\u0002\u0011Q,7\u000f\u001e'pOJB3ATA\u000b\u0003\u001d!Xm\u001d;DQJD3aTA\u000b\u0003-!Xm\u001d;FqR\u0014\u0018m\u0019;)\u0007A\u000b)\"A\tuKN$H+Z7q_J\fGN\u00127p_JD3!UA\u000b\u0003Q!Xm\u001d;DkJ\u0014XM\u001c;US6,\u0007k\\5oi\"\u001a!+!\u0006\u0002\u0019Q,7\u000f^(wKJd\u0017\r]:)\u0007M\u000b)\"A\u0006uKN$\u0018+^1si\u0016\u0014\bf\u0001+\u0002\u0016\u0005\tB/Z:u)&lWm\u001d;b[B$\u0015N\u001a4)\u0007U\u000b)\"\u0001\tuKN$H+[7fgR\fW\u000e]!eI\"\u001aa+!\u0006\u0002\u001fQ,7\u000f\u001e+p)&lWm\u001d;b[BD3aVA\u000b\u0003)!Xm\u001d;U_\u0012\u000bG/\u001a\u0015\u00041\u0006U\u0011!\u0005;fgRD\u0015m\u001d5Gk:\u001cG/[8og\"\u001a\u0011,!\u0006\u0002#Q,7\u000f^%t)J,X-S:GC2\u001cX\rK\u0002[\u0003+\t1\u0004^3tiN#(/\u001b8h\rVt7\r^5p]N<\u0016\u000e\u001e5Ok2d\u0007fA.\u0002\u0016\u0005qA/Z:u\u0007>$WmR3o\u001dB+\u0005f\u0001/\u0002\u0016\u0005\u0011B/Z:u\u001dVdGNQ5h\t\u0016\u001c\u0017.\\1mQ\ri\u0016QC\u0001\u0014i\u0016\u001cH/\u00128d_\u0012,\u0017I\u001c3EK\u000e|G-\u001a\u0015\u0004=\u0006U\u0011a\u0004;fgR\u001cFO]5oOR{W*\u00199)\u0007}\u000b)\"\u0001\u0004uKN$\u0018J\u001a\u0015\u0004A\u0006U\u0011!\u0004;fgR\u0014\u0016M\u001c3B]\u0012Le\rK\u0002b\u0003+\tQ\u0002^3ti&3G)Z2j[\u0006d\u0007f\u00012\u0002\u0016\u0005iA/Z:u\u0013N$UmY5nC2D3aYA\u000b\u0003-!Xm\u001d;Jg\u0012Kw-\u001b;)\u0007\u0011\f)\"A\u0006uKN$\u0018j]!ma\"\f\u0007fA3\u0002\u0016\u0005\u0019B/Z:u%\u0006<H+\u001f9f\u000bF,\u0018\r\\5us\"\u001aa-!\u0006\u0002SQ,7\u000f^*ue&twMR;oGRLwN\\!oI\u0016C\bO]3tg&|gNU3tk2$H+\u001f9fQ\r9\u0017Q\u0003")
public class ScalarFunctionsTest
extends ScalarTypesTestBase {
    @Test
    public void testOverlay() {
        Seq cases = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3(org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("xxxxxtest").overlay((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("xxxx"), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(6)), (Object)"OVERLAY('xxxxxtest' PLACING 'xxxx' FROM 6)", (Object)"xxxxxxxxx"), new Tuple3(org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("xxxxxtest").overlay((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("xxxx"), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(6), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(2)), (Object)"OVERLAY('xxxxxtest' PLACING 'xxxx' FROM 6 FOR 2)", (Object)"xxxxxxxxxst"), new Tuple3(org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("123456789").overlay((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("abc"), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(100), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(2)), (Object)"OVERLAY('123456789' PLACING 'It' FROM -1 FOR 4)", (Object)"123456789"), new Tuple3(org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("123456789").overlay((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("abc"), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(-1), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(2)), (Object)"OVERLAY('123456789' PLACING 'It' FROM -1 FOR 2)", (Object)"123456789"), new Tuple3(org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("123456789").overlay((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("abc"), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(2), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(100)), (Object)"OVERLAY('123456789' PLACING 'abc' FROM 2 FOR 100)", (Object)"1abc"), new Tuple3(org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("123456789").overlay((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("abc"), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(2), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(-1)), (Object)"OVERLAY('123456789' PLACING 'abc' FROM 2 FOR -1)", (Object)"1abc"), new Tuple3(org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("123456789").overlay((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("abc"), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(100), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(-1)), (Object)"OVERLAY('123456789' PLACING 'abc' FROM 100 FOR -1)", (Object)"123456789"), new Tuple3(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"f0"}))).$((Seq)Nil$.MODULE$)).overlay((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("It"), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(4)), (Object)"OVERLAY(f0 PLACING 'It' FROM 1 FOR 4)", (Object)"It is a test String."), new Tuple3(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"f0"}))).$((Seq)Nil$.MODULE$)).overlay((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("It"), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(-1), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(4)), (Object)"OVERLAY(f0 PLACING 'It' FROM -1 FOR 4)", (Object)"This is a test String."), new Tuple3(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"f0"}))).$((Seq)Nil$.MODULE$)).overlay((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("It"), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(100), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(4)), (Object)"OVERLAY(f0 PLACING 'It' FROM 100 FOR 4)", (Object)"This is a test String."), new Tuple3(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"f0"}))).$((Seq)Nil$.MODULE$)).overlay((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("It"), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(-1), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(2)), (Object)"OVERLAY(f0 PLACING 'It' FROM -1 FOR 2)", (Object)"This is a test String."), new Tuple3(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"f0"}))).$((Seq)Nil$.MODULE$)).overlay((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("It"), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(100), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(2)), (Object)"OVERLAY(f0 PLACING 'It' FROM 100 FOR 2)", (Object)"This is a test String."), new Tuple3(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"f0"}))).$((Seq)Nil$.MODULE$)).overlay((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("IS"), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(6), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(100)), (Object)"OVERLAY(f0 PLACING 'IS' FROM 6 FOR 100)", (Object)"This IS"), new Tuple3(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"f0"}))).$((Seq)Nil$.MODULE$)).overlay((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("IS"), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(6), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(-1)), (Object)"OVERLAY(f0 PLACING 'IS' FROM 6 FOR -1)", (Object)"This IS"), new Tuple3(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"f40"}))).$((Seq)Nil$.MODULE$)).overlay((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("It"), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(4)), (Object)"OVERLAY(f40 PLACING 'It' FROM 1 FOR 2)", (Object)"NULL")}));
        cases.foreach((Function1 & Serializable & scala.Serializable)x -> {
            this.testAllApis((Expression)x._1(), (String)x._2(), (String)x._3());
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPosition() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("test").position((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("xxxtest")), "POSITION('test' IN 'xxxtest')", "4");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("testx").position((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("xxxtest")), "POSITION('testx' IN 'xxxtest')", "0");
        this.testSqlApi("POSITION('aa' IN 'aaads')", "1");
        this.testSqlApi("position('aa' in 'aaads')", "1");
    }

    @Test
    public void testLocate() {
        this.testSqlApi("locate('test', 'xxxtest')", "4");
        this.testSqlApi("locate('testx', 'xxxtest')", "0");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("aa").locate((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("aaads")), "LOCATE('aa', 'aaads')", "1");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("aa").locate((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("aaads"), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(2)), "LOCATE('aa', 'aaads', 2)", "2");
    }

    @Test
    public void testLeft() {
        this.testSqlApi("`LEFT`(f0, 2)", "Th");
        this.testSqlApi("`LEFT`(f0, 100)", "This is a test String.");
        this.testSqlApi("`LEFT`(f0, -2)", "");
        this.testSqlApi("`LEFT`(f0, 0)", "");
        this.testSqlApi("`LEFT`(f0, CAST(null as Integer))", "NULL");
        this.testSqlApi("`LEFT`(CAST(null as VARCHAR), -2)", "NULL");
        this.testSqlApi("`LEFT`(CAST(null as VARCHAR), 2)", "NULL");
    }

    @Test
    public void testRight() {
        this.testSqlApi("`right`(f0, 2)", "g.");
        this.testSqlApi("`right`(f0, 100)", "This is a test String.");
        this.testSqlApi("`right`(f0, -2)", "");
        this.testSqlApi("`right`(f0, 0)", "");
        this.testSqlApi("`right`(f0, CAST(null as Integer))", "NULL");
        this.testSqlApi("`right`(CAST(null as VARCHAR), -2)", "NULL");
        this.testSqlApi("`right`(CAST(null as VARCHAR), 2)", "NULL");
    }

    @Test
    public void testAscii() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("efg").ascii(), "ASCII('efg')", "101");
        this.testSqlApi("ascii('abcdef')", "97");
        this.testSqlApi("ascii('')", "0");
        this.testSqlApi("ascii(cast (null AS VARCHAR))", "NULL");
        this.testSqlApi("ascii('val_238') = ascii('val_239')", "TRUE");
    }

    @Test
    public void testLeftAndRight() {
        String str = "Hello";
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression(str).left((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(3)), new StringBuilder(11).append("LEFT('").append(str).append("', 3)").toString(), "Hel");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression(str).right((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(3)), new StringBuilder(12).append("RIGHT('").append(str).append("', 3)").toString(), "llo");
    }

    @Test
    public void testInstr() {
        this.testSqlApi("instr('Corporate Floor', 'or', 3, 2)", "14");
        this.testSqlApi("instr('Corporate Floor', 'or', -3, 2)", "2");
        this.testSqlApi("instr('Tech on the net', 'e')", "2");
        this.testSqlApi("instr('Tech on the net', 'e', 1, 2)", "11");
        this.testSqlApi("instr('Tech on the net', 'e', 1, 3)", "14");
        this.testSqlApi("instr('Tech on the net', 'e', -3, 2)", "2");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("myteststring").instr((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("st")), "instr('myteststring', 'st')", "5");
        this.testSqlApi("instr(cast (null AS VARCHAR), 'e')", "NULL");
        this.testSqlApi("instr('e', cast (null AS VARCHAR))", "NULL");
        this.testSqlApi("instr('val_238', '_') = instr('val_239', '_')", "TRUE");
        this.testSqlApi("instr('val_239', '_')", "4");
    }

    @Test
    public void testSubstring() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).substring((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(2)), "SUBSTRING(f0, 2)", "his is a test String.");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).substring((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(2), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(5)), "SUBSTRING(f0, 2, 5)", "his i");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).substring((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1), (Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7"))), "SUBSTRING(f0, 1, f7)", "Thi");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).substring(org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(1).cast(DataTypes.TINYINT()), (Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7"))), "SUBSTRING(f0, CAST(1 AS TINYINT), f7)", "Thi");
        this.testSqlApi("SUBSTRING(f0 FROM 2 FOR 1)", "h");
        this.testSqlApi("SUBSTRING(f0 FROM 2)", "his is a test String.");
        this.testSqlApi("SUBSTRING(f0 FROM -2)", "g.");
        this.testSqlApi("SUBSTRING(f0 FROM -2 FOR 1)", "g");
        this.testSqlApi("SUBSTRING(f0 FROM -2 FOR 0)", "");
    }

    @Test
    public void testReplace() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).replace((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal(" "), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("_")), "REPLACE(f0, ' ', '_')", "This_is_a_test_String.");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).replace((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("i"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("")), "REPLACE(f0, 'i', '')", "Ths s a test Strng.");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")).replace((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("i"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("")), "REPLACE(f33, 'i', '')", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).replace((Object)org.apache.flink.table.api.package$.MODULE$.nullOf(DataTypes.STRING()), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("")), "REPLACE(f0, NULLIF('', ''), '')", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).replace((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal(" "), (Object)org.apache.flink.table.api.package$.MODULE$.nullOf(DataTypes.STRING())), "REPLACE(f0, ' ', NULLIF('', ''))", "NULL");
    }

    @Test
    public void testTrim() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f8")).trim(), "TRIM(f8)", "This is a test String.");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f8")).trim(true, true, org.apache.flink.table.api.package$.MODULE$.string2Literal(" ")), "TRIM(f8)", "This is a test String.");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f8")).trim(false, true, org.apache.flink.table.api.package$.MODULE$.string2Literal(" ")), "TRIM(TRAILING FROM f8)", " This is a test String.");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).trim(true, true, org.apache.flink.table.api.package$.MODULE$.string2Literal(".")), "TRIM(BOTH '.' FROM f0)", "This is a test String");
        this.testSqlApi("trim(BOTH 'abc' FROM 'abcddcba')", "dd");
        this.testSqlApi("trim(BOTH 'abd' FROM 'abcddcba')", "cddc");
        this.testSqlApi("trim(BOTH '\u5f00\u5fc3' FROM '\u5fc3\u60c5\u5f00\u5f00\u5fc3\u5fc3')", "\u60c5");
        this.testSqlApi("trim(BOTH '\u5f00\u5fc3' FROM '\u5fc3\u60c5\u5f00\u5f00\u5fc3\u5fc3')", "\u60c5");
        this.testSqlApi("trim(LEADING  from '  example  ')", "example  ");
        this.testSqlApi("trim(TRAILING from '  example  ')", "  example");
        this.testSqlApi("trim(BOTH     from '  example  ')", "example");
        this.testSqlApi("trim(LEADING  'e' from 'example')", "xample");
        this.testSqlApi("trim(TRAILING 'e' from 'example')", "exampl");
        this.testSqlApi("trim(BOTH     'e' from 'example')", "xampl");
        this.testSqlApi("trim(BOTH     'xyz' from 'example')", "example");
    }

    @Test
    public void testLTrim() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f8")).ltrim(), "LTRIM(f8)", "This is a test String. ");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).ltrim((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("This ")), "LTRIM(f0, 'This ')", "a test String.");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("abcddcba").ltrim((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("abc")), "ltrim('abcddcba', 'abc')", "ddcba");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("abcddcba").ltrim((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("abd")), "LTRIM('abcddcba', 'abd')", "cddcba");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("\u5fc3\u60c5\u5f00\u5f00\u5fc3\u5fc3").ltrim((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("\u5f00\u5fc3")), "ltrim('\u5fc3\u60c5\u5f00\u5f00\u5fc3\u5fc3', '\u5f00\u5fc3')", "\u60c5\u5f00\u5f00\u5fc3\u5fc3");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("abcddcba").ltrim((Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33"))), "LTRIM('abcddcba', f33)", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")).ltrim((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("abcddcba")), "LTRIM(f33, 'abcddcba')", "NULL");
    }

    @Test
    public void testRTrim() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f8")).rtrim(), "rtrim(f8)", " This is a test String.");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).rtrim((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("String. ")), "RTRIM(f0, 'String. ')", "This is a tes");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("abcddcba").rtrim((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("abc")), "rtrim('abcddcba', 'abc')", "abcdd");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("abcddcba").rtrim((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("abd")), "RTRIM('abcddcba', 'abd')", "abcddc");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("\u5fc3\u60c5\u5f00\u5f00\u5fc3\u5fc3").rtrim((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("\u5f00\u5fc3")), "rtrim('\u5fc3\u60c5\u5f00\u5f00\u5fc3\u5fc3', '\u5f00\u5fc3')", "\u5fc3\u60c5");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("abcddcba").rtrim((Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33"))), "RTRIM('abcddcba', f33)", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")).rtrim((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("abcddcba")), "RTRIM(f33, 'abcddcba')", "NULL");
    }

    @Test
    public void testCharLength() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).charLength(), "CHAR_LENGTH(f0)", "22");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).charLength(), "CHARACTER_LENGTH(f0)", "22");
    }

    @Test
    public void testUpperCase() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).upperCase(), "UPPER(f0)", "THIS IS A TEST STRING.");
    }

    @Test
    public void testLowerCase() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).lowerCase(), "LOWER(f0)", "this is a test string.");
    }

    @Test
    public void testInitCap() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).initCap(), "INITCAP(f0)", "This Is A Test String.");
        this.testSqlApi("INITCAP('ab')", "Ab");
        this.testSqlApi("INITCAP('a B')", "A B");
        this.testSqlApi("INITCAP('fLinK')", "Flink");
    }

    @Test
    public void testConcat() {
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).$plus(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0"))), "f0||f0", "This is a test String.This is a test String.");
    }

    @Test
    public void testLike() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("Th_s%")), "f0 LIKE 'Th_s%'", "TRUE");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%is a%")), "f0 LIKE '%is a%'", "TRUE");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("abcxxxdef").like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("abcx%")), "'abcxxxdef' LIKE 'abcx%'", "TRUE");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("abcxxxdef").like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%%def")), "'abcxxxdef' LIKE '%%def'", "TRUE");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("abcxxxdef").like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("abcxxxdef")), "'abcxxxdef' LIKE 'abcxxxdef'", "TRUE");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("abcxxxdef").like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%xdef")), "'abcxxxdef' LIKE '%xdef'", "TRUE");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("abcxxxdef").like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("abc%def%")), "'abcxxxdef' LIKE 'abc%def%'", "TRUE");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("abcxxxdef").like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%abc%def")), "'abcxxxdef' LIKE '%abc%def'", "TRUE");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("abcxxxdef").like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%abc%def%")), "'abcxxxdef' LIKE '%abc%def%'", "TRUE");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("abcxxxdef").like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("abc%def")), "'abcxxxdef' LIKE 'abc%def'", "TRUE");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("abcxxxdef").like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("abdxxxdef")), "'abcxxxdef' LIKE 'abdxxxdef'", "FALSE");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("abcxxxdef").like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%xqef")), "'abcxxxdef' LIKE '%xqef'", "FALSE");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("abcxxxdef").like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("abc%qef%")), "'abcxxxdef' LIKE 'abc%qef%'", "FALSE");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("abcxxxdef").like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%abc%qef")), "'abcxxxdef' LIKE '%abc%qef'", "FALSE");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("abcxxxdef").like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%abc%qef%")), "'abcxxxdef' LIKE '%abc%qef%'", "FALSE");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("abcxxxdef").like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("abc%qef")), "'abcxxxdef' LIKE 'abc%qef'", "FALSE");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("TE_ST").like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%E_S%")), "'TE_ST' LIKE '%E_S%'", "TRUE");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("TE-ST").like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%E_S%")), "'TE-ST' LIKE '%E_S%'", "TRUE");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("TE_ST").like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%E\\_S%")), "'TE_ST' LIKE '%E\\_S%'", "TRUE");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("TE-ST").like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%E\\_S%")), "'TE-ST' LIKE '%E\\_S%'", "FALSE");
    }

    @Test
    public void testNotLike() {
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("Th_s%"))).unary_$bang(), "f0 NOT LIKE 'Th_s%'", "FALSE");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%is a%"))).unary_$bang(), "f0 NOT LIKE '%is a%'", "FALSE");
        this.testSqlApi("'TE_ST' NOT LIKE '%E_S%'", "FALSE");
        this.testSqlApi("'TE-ST' NOT LIKE '%E_S%'", "FALSE");
        this.testSqlApi("'TE_ST' NOT LIKE '%E\\_S%'", "FALSE");
        this.testSqlApi("'TE-ST' NOT LIKE '%E\\_S%'", "TRUE");
    }

    @Test
    public void testLikeWithEscape() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f23")).like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("&%Th_s%"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("&")), "f23 LIKE '&%Th_s%' ESCAPE '&'", "TRUE");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f23")).like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("&%%is a%"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("&")), "f23 LIKE '&%%is a%' ESCAPE '&'", "TRUE");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("Th_s%"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("&")), "f0 LIKE 'Th_s%' ESCAPE '&'", "TRUE");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%is a%"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("&")), "f0 LIKE '%is a%' ESCAPE '&'", "TRUE");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("TE-ST").like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%E#_S%"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("#")), "'TE-ST' LIKE '%E#_S%' ESCAPE '#'", "FALSE");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("TE_ST").like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%E#_S%"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("#")), "'TE_ST' LIKE '%E#_S%' ESCAPE '#'", "TRUE");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("TE-ST").like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%E__S%"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("_")), "'TE-ST' LIKE '%E__S%' ESCAPE '_'", "FALSE");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("TE_ST").like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%E__S%"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("_")), "'TE_ST' LIKE '%E__S%' ESCAPE '_'", "TRUE");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("TE-ST").like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("TE%_ST"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%")), "'TE-ST' LIKE 'TE%_ST' ESCAPE '%'", "FALSE");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("TE_ST").like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("TE%_ST"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%")), "'TE_ST' LIKE 'TE%_ST' ESCAPE '%'", "TRUE");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("TE-ST").like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%E\\_S%"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("\\")), "'TE-ST' LIKE '%E\\_S%' ESCAPE '\\'", "FALSE");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("TE_ST").like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%E\\_S%"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("\\")), "'TE_ST' LIKE '%E\\_S%' ESCAPE '\\'", "TRUE");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("TE-ST").like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%E._S%"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal(".")), "'TE-ST' LIKE '%E._S%' ESCAPE '.'", "FALSE");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("TE_ST").like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%E._S%"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal(".")), "'TE_ST' LIKE '%E._S%' ESCAPE '.'", "TRUE");
        this.testExpectedAllApisException((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("TE-ST").like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%E_S%"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("ab")), "'TE-ST' LIKE '%E_S%' ESCAPE 'ab'", "Invalid escape", RuntimeException.class);
        this.testExpectedAllApisException((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("TE-ST").like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%E_S%"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("\\c")), "'TE-ST' LIKE '%E_S%' ESCAPE '\\c'", "Invalid escape", RuntimeException.class);
        this.testExpectedAllApisException((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("TE-ST").like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%E_S%&"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("&")), "'TE-ST' LIKE '%E_S%&' ESCAPE '&'", "", RuntimeException.class);
        this.testExpectedAllApisException((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("TE-ST").like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%E&-S%"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("&")), "'TE-ST' LIKE '%E&-S%' ESCAPE '&'", "Invalid escape", RuntimeException.class);
        this.testExpectedAllApisException((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("TE-ST").like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%E_S%"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("_")), "'TE-ST' LIKE '%E_S%' ESCAPE '_'", "Invalid escape", RuntimeException.class);
    }

    @Test
    public void testNotLikeWithEscape() {
        this.testSqlApi("f23 NOT LIKE '&%Th_s%' ESCAPE '&'", "FALSE");
        this.testSqlApi("f23 NOT LIKE '&%%is a%' ESCAPE '&'", "FALSE");
        this.testSqlApi("f0 NOT LIKE 'Th_s%' ESCAPE '&'", "FALSE");
        this.testSqlApi("f0 NOT LIKE '%is a%' ESCAPE '&'", "FALSE");
        this.testSqlApi("'TE-ST' NOT LIKE '%E#_S%' ESCAPE '#'", "TRUE");
        this.testSqlApi("'TE_ST' NOT LIKE '%E#_S%' ESCAPE '#'", "FALSE");
        this.testSqlApi("'TE-ST' NOT LIKE '%E__S%' ESCAPE '_'", "TRUE");
        this.testSqlApi("'TE_ST' NOT LIKE '%E__S%' ESCAPE '_'", "FALSE");
        this.testSqlApi("'TE-ST' NOT LIKE 'TE%_ST' ESCAPE '%'", "TRUE");
        this.testSqlApi("'TE_ST' NOT LIKE 'TE%_ST' ESCAPE '%'", "FALSE");
        this.testSqlApi("'TE-ST' NOT LIKE '%E\\_S%' ESCAPE '\\'", "TRUE");
        this.testSqlApi("'TE_ST' NOT LIKE '%E\\_S%' ESCAPE '\\'", "FALSE");
        this.testSqlApi("'TE-ST' NOT LIKE '%E._S%' ESCAPE '.'", "TRUE");
        this.testSqlApi("'TE_ST' NOT LIKE '%E._S%' ESCAPE '.'", "FALSE");
        this.testExpectedAllApisException(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("TE-ST").like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%E_S%"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("ab"))).unary_$bang(), "'TE-ST' NOT LIKE '%E_S%' ESCAPE 'ab'", "Invalid escape", RuntimeException.class);
        this.testExpectedAllApisException(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("TE-ST").like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%E_S%"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("\\c"))).unary_$bang(), "'TE-ST' NOT LIKE '%E_S%' ESCAPE '\\c'", "Invalid escape", RuntimeException.class);
        this.testExpectedAllApisException(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("TE-ST").like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%E_S%&"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("&"))).unary_$bang(), "'TE-ST' NOT LIKE '%E_S%&' ESCAPE '&'", "", RuntimeException.class);
        this.testExpectedAllApisException(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("TE-ST").like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%E&-S%"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("&"))).unary_$bang(), "'TE-ST' NOT LIKE '%E&-S%' ESCAPE '&'", "Invalid escape", RuntimeException.class);
        this.testExpectedAllApisException(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("TE-ST").like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%E_S%"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("_"))).unary_$bang(), "'TE-ST' NOT LIKE '%E_S%' ESCAPE '_'", "Invalid escape", RuntimeException.class);
    }

    @Test
    public void testSimilar() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).similar((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("_*")), "f0 SIMILAR TO '_*'", "TRUE");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).similar((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("This (is)? a (test)+ Strin_*")), "f0 SIMILAR TO 'This (is)? a (test)+ Strin_*'", "TRUE");
    }

    @Test
    public void testNotSimilar() {
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).similar((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("_*"))).unary_$bang(), "f0 NOT SIMILAR TO '_*'", "FALSE");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).similar((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("This (is)? a (test)+ Strin_*"))).unary_$bang(), "f0 NOT SIMILAR TO 'This (is)? a (test)+ Strin_*'", "FALSE");
    }

    @Test
    public void testSimilarWithEscape() {
        this.testSqlApi("f24 SIMILAR TO '&*&__*' ESCAPE '&'", "TRUE");
        this.testSqlApi("f0 SIMILAR TO '_*' ESCAPE '&'", "TRUE");
        this.testSqlApi("f24 SIMILAR TO '&*&_This (is)? a (test)+ Strin_*' ESCAPE '&'", "TRUE");
        this.testSqlApi("f0 SIMILAR TO 'This (is)? a (test)+ Strin_*' ESCAPE '&'", "TRUE");
    }

    @Test
    public void testNotSimilarWithEscape() {
        this.testSqlApi("f24 NOT SIMILAR TO '&*&__*' ESCAPE '&'", "FALSE");
        this.testSqlApi("f0 NOT SIMILAR TO '_*' ESCAPE '&'", "FALSE");
        this.testSqlApi("f24 NOT SIMILAR TO '&*&_This (is)? a (test)+ Strin_*' ESCAPE '&'", "FALSE");
        this.testSqlApi("f0 NOT SIMILAR TO 'This (is)? a (test)+ Strin_*' ESCAPE '&'", "FALSE");
    }

    @Test
    public void testMultiConcat() {
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.concat(org.apache.flink.table.api.package$.MODULE$.string2Literal("xx"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33"))})), "CONCAT('xx', f33)", "NULL");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.concat(org.apache.flink.table.api.package$.MODULE$.string2Literal("AA"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.string2Literal("BB"), org.apache.flink.table.api.package$.MODULE$.string2Literal("CC"), org.apache.flink.table.api.package$.MODULE$.string2Literal("---")})), "CONCAT('AA','BB','CC','---')", "AABBCC---");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.concat(org.apache.flink.table.api.package$.MODULE$.string2Literal("x~x"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.string2Literal("b~b"), org.apache.flink.table.api.package$.MODULE$.string2Literal("c~~~~c"), org.apache.flink.table.api.package$.MODULE$.string2Literal("---")})), "CONCAT('x~x','b~b','c~~~~c','---')", "x~xb~bc~~~~c---");
        this.testSqlApi("concat(f35)", "a");
        this.testSqlApi("concat(f35,f36)", "ab");
        this.testSqlApi("concat(f35,f36,f33)", "NULL");
    }

    @Test
    public void testConcatWs() {
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.concat_ws(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")), org.apache.flink.table.api.package$.MODULE$.string2Literal("AA"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "CONCAT_WS(f33, 'AA')", "NULL");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.concat_ws(org.apache.flink.table.api.package$.MODULE$.string2Literal("~~~~"), org.apache.flink.table.api.package$.MODULE$.string2Literal("AA"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "concat_ws('~~~~','AA')", "AA");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.concat_ws(org.apache.flink.table.api.package$.MODULE$.string2Literal("~"), org.apache.flink.table.api.package$.MODULE$.string2Literal("AA"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.string2Literal("BB")})), "concat_ws('~','AA','BB')", "AA~BB");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.concat_ws(org.apache.flink.table.api.package$.MODULE$.string2Literal("~"), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.string2Literal("AA"), org.apache.flink.table.api.package$.MODULE$.string2Literal("BB"), org.apache.flink.table.api.package$.MODULE$.string2Literal(""), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")), org.apache.flink.table.api.package$.MODULE$.string2Literal("CC")})), "concat_ws('~',f33, 'AA','BB','',f33, 'CC')", "AA~BB~~CC");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.concat_ws(org.apache.flink.table.api.package$.MODULE$.string2Literal("~~~~"), org.apache.flink.table.api.package$.MODULE$.string2Literal("Flink"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")), org.apache.flink.table.api.package$.MODULE$.string2Literal("xx"), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33"))})), "CONCAT_WS('~~~~','Flink', f33, 'xx', f33, f33)", "Flink~~~~xx");
        this.testSqlApi("concat_ws('||', f35, f36, f33)", "a||b");
    }

    @Test
    public void testRegexpReplace() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("foobar").regexpReplace((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("oo|ar"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("abc")), "regexp_replace('foobar', 'oo|ar', 'abc')", "fabcbabc");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("foofar").regexpReplace((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("^f"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("")), "regexp_replace('foofar', '^f', '')", "oofar");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("foobar").regexpReplace((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("^f*.*r$"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("")), "regexp_replace('foobar', '^f*.*r$', '')", "");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("foo1bar2").regexpReplace((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("\\d"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("")), "regexp_replace('foobar', '\\d', '')", "foobar");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("foobar").regexpReplace((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("\\w"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("")), "regexp_replace('foobar', '\\w', '')", "");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("fooobar").regexpReplace((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("oo"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("$")), "regexp_replace('fooobar', 'oo', '$')", "f$obar");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("foobar").regexpReplace((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("oo"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("\\")), "regexp_replace('foobar', 'oo', '\\')", "f\\bar");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")).regexpReplace((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("oo|ar"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("")), "REGEXP_REPLACE(f33, 'oo|ar', '')", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("foobar").regexpReplace((Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("")), "REGEXP_REPLACE('foobar', f33, '')", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("foobar").regexpReplace((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("oo|ar"), (Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33"))), "REGEXP_REPLACE('foobar', 'oo|ar', f33)", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.nullOf(Types.STRING())).regexpReplace((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("oo|ar"), (Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33"))), "REGEXP_REPLACE(CAST(NULL AS VARCHAR), 'oo|ar', f33)", "NULL");
    }

    @Test
    public void testRegexpExtract() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("foothebar").regexpExtract((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("foo(.*?)(bar)"), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(2)), "REGEXP_EXTRACT('foothebar', 'foo(.*?)(bar)', 2)", "bar");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("foothebar").regexpExtract((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("foo(.*?)(bar)"), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(0)), "REGEXP_EXTRACT('foothebar', 'foo(.*?)(bar)', 0)", "foothebar");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("foothebar").regexpExtract((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("foo(.*?)(bar)"), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), "REGEXP_EXTRACT('foothebar', 'foo(.*?)(bar)', 1)", "the");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("foothebar").regexpExtract((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("foo([\\w]+)"), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), "REGEXP_EXTRACT('foothebar', 'foo([\\w]+)', 1)", "thebar");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("foothebar").regexpExtract((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("foo([\\d]+)"), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), "REGEXP_EXTRACT('foothebar', 'foo([\\d]+)', 1)", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")).regexpExtract((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("foo(.*?)(bar)"), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(2)), "REGEXP_EXTRACT(f33, 'foo(.*?)(bar)', 2)", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("foothebar").regexpExtract((Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(2)), "REGEXP_EXTRACT('foothebar', f33, 2)", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("foothebar").regexpExtract((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("foo(.*?)(bar)")), "REGEXP_EXTRACT('foothebar', 'foo(.*?)(bar)')", "foothebar");
    }

    @Test
    public void testJsonQuote() {
        this.testSqlApi("JSON_QUOTE('null')", "\"null\"");
        this.testSqlApi("JSON_QUOTE('\"null\"')", "\"\\\"null\\\"\"");
        this.testSqlApi("JSON_QUOTE('[1,2,3]')", "\"[1,2,3]\"");
        this.testSqlApi("JSON_QUOTE('This is a \\t test \\n with special characters: \" \\ \\b \\f \\r \\u0041')", "\"This is a \\\\t test \\\\n with special characters: \\\" \\\\ \\\\b \\\\f \\\\r \\\\u0041\"");
        this.testSqlApi("JSON_QUOTE('\"special\": \"\\b\\f\\r\"')", "\"\\\"special\\\": \\\"\\\\b\\\\f\\\\r\\\"\"");
        this.testSqlApi("JSON_QUOTE('skipping backslash \\')", "\"skipping backslash \\\\\"");
        this.testSqlApi("JSON_QUOTE('\u2260 will be escaped')", "\"\\u2260 will be escaped\"");
        this.testSqlApi("JSON_QUOTE('\\u006z will not be escaped')", "\"\\\\u006z will not be escaped\"");
        this.testSqlApi("JSON_QUOTE('1')", "\"1\"");
        this.testSqlApi("JSON_QUOTE('\"1\"')", "\"\\\"1\\\"\"");
    }

    @Test
    public void testJsonUnquoteWithValidInput() {
        this.testSqlApi("JSON_UNQUOTE('\"\\\\u00aa\"')", "\\u00aa");
        this.testSqlApi("JSON_UNQUOTE('\"\\u00aa\"')", "\u00aa");
        this.testSqlApi("JSON_UNQUOTE('\"\\u00aa\"')", "\u00aa");
        this.testSqlApi("JSON_UNQUOTE('\"abc\"')", "abc");
        this.testSqlApi("JSON_UNQUOTE('\"[abc]\"')", "[abc]");
        this.testSqlApi("JSON_UNQUOTE('\"[\\u0041]\"')", "[A]");
        this.testSqlApi("JSON_UNQUOTE('\"\\u0041\"')", "A");
        this.testSqlApi("JSON_UNQUOTE('\"[\\t\\u0032]\"')", "[\t2]");
        this.testSqlApi("JSON_UNQUOTE('\"This is a \\t test \\n with special characters: \\b \\f \\r \\u0041\"')", "This is a \t test \n with special characters: \b \f \r A");
        this.testSqlApi("JSON_UNQUOTE('\"\"')", "");
        this.testSqlApi("JSON_UNQUOTE('\"\"\"')", "\"");
        this.testSqlApi("JSON_UNQUOTE('[]')", "[]");
        this.testSqlApi("JSON_UNQUOTE('\"\"\\ufffa\"')", "\"\ufffa");
        this.testSqlApi("JSON_UNQUOTE('{\"key\":1}')", "{\"key\":1}");
        this.testSqlApi("JSON_UNQUOTE('true')", "true");
    }

    @Test
    public void testJsonQuoteFollowedByUnquoteReturnsOriginal() {
        this.testSqlApi("JSON_UNQUOTE(JSON_QUOTE('test'))", "test");
        this.testSqlApi("JSON_UNQUOTE(JSON_QUOTE('3'))", "3");
        this.testSqlApi("JSON_UNQUOTE(JSON_QUOTE('[]'))", "[]");
        this.testSqlApi("JSON_UNQUOTE(JSON_QUOTE('{}'))", "{}");
        this.testSqlApi("JSON_UNQUOTE(JSON_QUOTE('{\"key\":\"value\"}'))", "{\"key\":\"value\"}");
        this.testSqlApi("JSON_UNQUOTE(JSON_QUOTE('\"this is not a json'))", "\"this is not a json");
        this.testSqlApi("JSON_UNQUOTE(JSON_QUOTE(''))", "");
        this.testSqlApi("JSON_UNQUOTE(JSON_QUOTE('\"'))", "\"");
    }

    @Test
    public void testJsonUnquoteWithInvalidInput() {
        this.testSqlApi("JSON_UNQUOTE('\"[1, 2, 3}')", "\"[1, 2, 3}");
        this.testSqlApi("JSON_UNQUOTE('\"')", "\"");
        this.testSqlApi("JSON_UNQUOTE('[}')", "[}");
        this.testSqlApi("JSON_UNQUOTE('1\"')", "1\"");
        this.testSqlApi("JSON_UNQUOTE('[')", "[");
        this.testSqlApi("JSON_UNQUOTE('')", "");
        this.testSqlApi("JSON_UNQUOTE('\"invalid unicode literal but valid json pass through \"\"\\uzzzz\"')", "\"invalid unicode literal but valid json pass through \"\"\\uzzzz\"");
    }

    @Test
    public void testFromBase64() {
        this.testSqlApi("FROM_BASE64('aGVsbG8gd29ybGQ=')", "hello world");
        this.testSqlApi("CONCAT(FROM_BASE64('5L2g5aW9'), ' flink')", "\u4f60\u597d flink");
        this.testSqlApi("FROM_BASE64(f33)", "NULL");
        this.testSqlApi("FROM_BASE64('5L2g5aW9')", "\u4f60\u597d");
        this.testSqlApi("FROM_BASE64(CAST(x'6147567362473867643239796247513D' AS VARBINARY))", "hello world");
        this.testSqlApi("FROM_BASE64(x'6147567362473867643239796247513D')", "hello world");
        this.testSqlApi("FROM_BASE64(f58)", "\u4f60\u597d");
    }

    @Test
    public void testToBase64() {
        this.testSqlApi("TO_BASE64(f0)", "VGhpcyBpcyBhIHRlc3QgU3RyaW5nLg==");
        this.testSqlApi("TO_BASE64(f8)", "IFRoaXMgaXMgYSB0ZXN0IFN0cmluZy4g");
        this.testSqlApi("TO_BASE64('')", "");
        this.testSqlApi("TO_BASE64(f33)", "NULL");
        this.testSqlApi("TO_BASE64('\u4f60\u597d')", "5L2g5aW9");
        this.testSqlApi("to_base64(f37)", "AQIDBA==");
        this.testSqlApi("to_base64(from_base64(f38))", "AQIDBA==");
    }

    @Test
    public void testSubString() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"substring", "substr"})).foreach((Function1 & Serializable & scala.Serializable)substr -> {
            ScalarFunctionsTest.$anonfun$testSubString$1(this, substr);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testLPad() {
        this.testSqlApi("lpad(f33,1,'??')", "NULL");
        this.testSqlApi("lpad(f35, 1, '??')", "a");
        this.testSqlApi("lpad(f35, 2, '??')", "?a");
        this.testSqlApi("lpad(f35, 5, '??')", "????a");
        this.testSqlApi("lpad(f35, CAST(null as INT), '??')", "NULL");
        this.testSqlApi("lpad(f35, 5, CAST(null as VARCHAR))", "NULL");
        this.testSqlApi("lpad(f40, 1, '??')", "NULL");
        this.testSqlApi("lpad('hi', 1, '??')", "h");
        this.testSqlApi("lpad('hi', 5, '??')", "???hi");
        this.testSqlApi("lpad(CAST(null as VARCHAR), 5, '??')", "NULL");
        this.testSqlApi("lpad('hi', CAST(null as INT), '??')", "NULL");
        this.testSqlApi("lpad('hi', 5, CAST(null as VARCHAR))", "NULL");
        this.testSqlApi("lpad('',1,'??')", "?");
        this.testSqlApi("lpad('',30,'??')", "??????????????????????????????");
        this.testSqlApi("lpad('111',-2,'??')", "NULL");
        this.testSqlApi("lpad('ab',1,'??')", "a");
        this.testSqlApi("lpad('\u23a8\u23a8',1,'??')", "\u23a8");
        this.testSqlApi("lpad('\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4',2,'??')", "\u00e4\u00e4");
        this.testSqlApi("lpad('\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4',10,'??')", "?\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4");
        this.testSqlApi("lpad('Hello', -1, 'x') IS NULL", "TRUE");
        this.testSqlApi("lpad('Hello', -1, 'x') IS NOT NULL", "FALSE");
        this.testSqlApi("lpad('ab', 5, '')", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("\u00e4\u00e4\u00e4").lpad((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(13), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("12345")), "lpad('\u00e4\u00e4\u00e4',13,'12345')", "1234512345\u00e4\u00e4\u00e4");
    }

    @Test
    public void testRPad() {
        this.testSqlApi("rpad(f33,1,'??')", "NULL");
        this.testSqlApi("rpad(f35, 1, '??')", "a");
        this.testSqlApi("rpad(f35, 2, '??')", "a?");
        this.testSqlApi("rpad(f35, 5, '??')", "a????");
        this.testSqlApi("rpad(f35, CAST(null as INT), '??')", "NULL");
        this.testSqlApi("rpad(f35, 5, CAST(null as VARCHAR))", "NULL");
        this.testSqlApi("rpad(f40, 1, '??')", "NULL");
        this.testSqlApi("rpad('hi', 1, '??')", "h");
        this.testSqlApi("rpad('hi', 5, '??')", "hi???");
        this.testSqlApi("rpad(CAST(null as VARCHAR), 5, '??')", "NULL");
        this.testSqlApi("rpad('hi', CAST(null as INT), '??')", "NULL");
        this.testSqlApi("rpad('hi', 5, CAST(null as VARCHAR))", "NULL");
        this.testSqlApi("rpad('',1,'??')", "?");
        this.testSqlApi("rpad('111',-2,'??')", "NULL");
        this.testSqlApi("rpad('ab',1,'??')", "a");
        this.testSqlApi("rpad('\u00fc\u00f6',1,'??')", "\u00fc");
        this.testSqlApi("rpad('abcd', 5, '')", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("\u00e4\u00e4\u00e4").rpad((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(13), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("12345")), "rpad('\u00e4\u00e4\u00e4',13,'12345')", "\u00e4\u00e4\u00e41234512345");
    }

    @Test
    public void testParseUrl() {
        this.testUrl$1("http://userinfo@flink.apache.org/path?query=1#Ref", "flink.apache.org", "/path", "query=1", "Ref", "http", "/path?query=1", "userinfo@flink.apache.org", "userinfo", "1");
        this.testUrl$1("https://use%20r:pas%20s@example.com/dir%20/pa%20th.HTML?query=x%20y&q2=2#Ref%20two", "example.com", "/dir%20/pa%20th.HTML", "query=x%20y&q2=2", "Ref%20two", "https", "/dir%20/pa%20th.HTML?query=x%20y&q2=2", "use%20r:pas%20s@example.com", "use%20r:pas%20s", "x%20y");
        this.testUrl$1("http://user:pass@host", "host", "", "NULL", "NULL", "http", "", "user:pass@host", "user:pass", "NULL");
        this.testUrl$1("http://user:pass@host/", "host", "/", "NULL", "NULL", "http", "/", "user:pass@host", "user:pass", "NULL");
        this.testUrl$1("http://user:pass@host/?#", "host", "/", "", "", "http", "/?", "user:pass@host", "user:pass", "NULL");
        this.testUrl$1("http://user:pass@host/file;param?query;p2", "host", "/file;param", "query;p2", "NULL", "http", "/file;param?query;p2", "user:pass@host", "user:pass", "NULL");
        this.testUrl$1("invalid://user:pass@host/file;param?query;p2", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL");
    }

    @Test
    public void testRepeat() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).repeat((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), "REPEAT(f0, 1)", "This is a test String.");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).repeat((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(2)), "REPEAT(f0, 2)", "This is a test String.This is a test String.");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).repeat((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(0)), "REPEAT(f0, 0)", "");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).repeat((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(-1)), "REPEAT(f0, -1)", "");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")).repeat((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(2)), "REPEAT(f33, 2)", "NULL");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.string2Literal("".repeat(1)), "REPEAT('', 2)", "");
    }

    @Test
    public void testReverse() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f38")).reverse(), "reverse(f38)", "==ABDIQA");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f40")).reverse(), "reverse(f40)", "NULL");
        this.testSqlApi("reverse('hi')", "ih");
        this.testSqlApi("reverse('hhhi')", "ihhh");
        this.testSqlApi("reverse(CAST(null as VARCHAR))", "NULL");
    }

    @Test
    public void testSplitIndex() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f38")).splitIndex((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("I"), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(0)), "split_index(f38, 'I', 0)", "AQ");
        this.testSqlApi("split_index(f38, 'I', 2)", "NULL");
        this.testSqlApi("split_index(f38, 'I', -1)", "NULL");
        this.testSqlApi("split_index(f38, CAST(null as VARCHAR), 0)", "NULL");
        this.testSqlApi("split_index(f38, 'I', CAST(null as INT))", "NULL");
        this.testSqlApi("split_index(f38, 'I', -1)", "NULL");
        this.testSqlApi("split_index(f40, 'I', 0)", "NULL");
        this.testSqlApi("split_index(f38, 73, 0)", "AQ");
        this.testSqlApi("split_index(f38, 256, 0)", "NULL");
        this.testSqlApi("split_index(f38, 0, 0)", "NULL");
        this.testSqlApi("split_index('Test', 'e', 1)", "st");
        this.testSqlApi("split_index(CAST(null as VARCHAR), 'e', 1)", "NULL");
        this.testSqlApi("split_index('test', CAST(null as VARCHAR), 1)", "NULL");
        this.testSqlApi("split_index('test', 'e', -1)", "NULL");
    }

    @Test
    public void testHashCode() {
        this.testSqlApi("hash_code('abc')", "96354");
        this.testSqlApi("hash_code(f35)", "97");
        this.testSqlApi("hash_code(f40)", "NULL");
        this.testSqlApi("hash_code(CAST(null as VARCHAR))", "NULL");
    }

    @Test
    public void testMD5() {
        this.testSqlApi("md5('abc')", "900150983cd24fb0d6963f7d28e17f72");
        this.testSqlApi("md5('')", "d41d8cd98f00b204e9800998ecf8427e");
        this.testSqlApi("md5(f35)", "0cc175b9c0f1b6a831c399e269772661");
        this.testSqlApi("md5(f40)", "NULL");
        this.testSqlApi("md5(CAST(null as VARCHAR))", "NULL");
    }

    @Test
    public void testRegexp() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("100-200").regexp((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("(\\d+)")), "regexp('100-200', '(\\d+)')", "TRUE");
        this.testSqlApi("regexp('abc-def', '(\\d+)')", "FALSE");
        this.testSqlApi("regexp(f35, 'a')", "TRUE");
        this.testSqlApi("regexp(f40, '(\\d+)')", "NULL");
        this.testSqlApi("regexp(CAST(null as VARCHAR), '(\\d+)')", "NULL");
        this.testSqlApi("regexp('100-200', CAST(null as VARCHAR))", "NULL");
    }

    @Test
    public void testHex() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(100).hex(), "HEX(100)", "64");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).hex(), "HEX(f2)", "2A");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.nullOf(DataTypes.TINYINT())).hex(), "HEX(CAST(NULL AS TINYINT))", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).hex(), "HEX(f3)", "2B");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).hex(), "HEX(f4)", "2C");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7")).hex(), "HEX(f7)", "3");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(12).hex(), "HEX(12)", "C");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(10).hex(), "HEX(10)", "A");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(0).hex(), "HEX(0)", "0");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("\u00f6").hex(), "HEX('\u00f6')", "C3B6");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f32")).hex(), "HEX(f32)", "FFFFFFFFFFFFFFFF");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).hex(), "HEX(f0)", "546869732069732061207465737420537472696E672E");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f8")).hex(), "HEX(f8)", "20546869732069732061207465737420537472696E672E20");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f23")).hex(), "HEX(f23)", "25546869732069732061207465737420537472696E672E");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f24")).hex(), "HEX(f24)", "2A5F546869732069732061207465737420537472696E672E");
    }

    @Test
    public void testBin() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.nullOf(DataTypes.TINYINT())).bin(), "BIN((CAST(NULL AS TINYINT)))", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).bin(), "BIN(f2)", "101010");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).bin(), "BIN(f3)", "101011");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).bin(), "BIN(f4)", "101100");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7")).bin(), "BIN(f7)", "11");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(12).bin(), "BIN(12)", "1100");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(10).bin(), "BIN(10)", "1010");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(0).bin(), "BIN(0)", "0");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f32")).bin(), "BIN(f32)", "1111111111111111111111111111111111111111111111111111111111111111");
    }

    @Test
    public void testUUID() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.uuid()).charLength(), "CHARACTER_LENGTH(UUID())", "36");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.uuid()).substring((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(9), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), "SUBSTRING(UUID(), 9, 1)", "-");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.uuid()).substring((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(14), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), "SUBSTRING(UUID(), 14, 1)", "-");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.uuid()).substring((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(19), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), "SUBSTRING(UUID(), 19, 1)", "-");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.uuid()).substring((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(24), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), "SUBSTRING(UUID(), 24, 1)", "-");
    }

    @Test
    public void testTruncate() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f29")).truncate((Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f30"))), "truncate(f29, f30)", "0.4");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f29")).truncate(), "truncate(f29)", "0.0");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f31")).truncate((Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7"))), "truncate(f31, f7)", "-0.123");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f31")).truncate(), "truncate(f31)", "0");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).truncate((Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f32"))), "truncate(f4, f32)", "40");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).truncate(), "truncate(f4)", "44");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f28")).cast(DataTypes.DOUBLE())).truncate((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), "truncate(cast(f28 as DOUBLE), 1)", "0.4");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f28")).cast(DataTypes.DOUBLE())).truncate(), "truncate(cast(f28 as DOUBLE))", "0.0");
        this.testSqlApi("truncate(cast(f31 as decimal(38, 18)), 2)", "-0.12");
        this.testSqlApi("truncate(cast(f31 as decimal(38, 18)))", "0");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f28")).cast(DataTypes.FLOAT())).truncate((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), "truncate(cast(f28 as float), 1)", "0.4");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).cast(DataTypes.FLOAT())).truncate(), "truncate(cast(f5 as float))", "4.0");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(42).truncate((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(-1)), "truncate(42, -1)", "40");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(42).truncate((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(-3)), "truncate(42, -3)", "0");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(42).truncate(), "truncate(42)", "42");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")).cast(DataTypes.INT())).truncate((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), "truncate(cast(null as integer), 1)", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralDoubleExpression(43.21).truncate(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")).cast(DataTypes.INT())), "truncate(43.21, cast(null as integer))", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")).cast(DataTypes.DOUBLE())).truncate((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), "truncate(cast(null as double), 1)", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")).cast(DataTypes.INT())).truncate((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), "truncate(cast(null as integer))", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")).cast(DataTypes.DOUBLE())).truncate(), "truncate(cast(null as double))", "NULL");
    }

    @Test
    public void testExp() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).exp(), "EXP(f2)", Double.toString(package$.MODULE$.exp((double)((byte)42))));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).exp(), "EXP(f3)", Double.toString(package$.MODULE$.exp((double)((short)43))));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).exp(), "EXP(f4)", Double.toString(package$.MODULE$.exp((double)44)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).exp(), "EXP(f5)", Double.toString(package$.MODULE$.exp((double)((float)4.5))));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).exp(), "EXP(f6)", Double.toString(package$.MODULE$.exp(4.6)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7")).exp(), "EXP(f7)", Double.toString(package$.MODULE$.exp(3.0)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(3).exp(), "EXP(3)", Double.toString(package$.MODULE$.exp(3.0)));
    }

    @Test
    public void testLog10() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).log10(), "LOG10(f2)", Double.toString(package$.MODULE$.log10((double)((byte)42))));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).log10(), "LOG10(f3)", Double.toString(package$.MODULE$.log10((double)((short)43))));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).log10(), "LOG10(f4)", Double.toString(package$.MODULE$.log10((double)44)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).log10(), "LOG10(f5)", Double.toString(package$.MODULE$.log10((double)((float)4.5))));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).log10(), "LOG10(f6)", Double.toString(package$.MODULE$.log10(4.6)));
    }

    @Test
    public void testPower() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).power((Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7"))), "POWER(f2, f7)", Double.toString(package$.MODULE$.pow((double)((byte)42), 3.0)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).power((Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6"))), "POWER(f3, f6)", Double.toString(package$.MODULE$.pow((double)((short)43), 4.6)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).power((Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5"))), "POWER(f4, f5)", Double.toString(package$.MODULE$.pow((double)44, (double)((float)4.5))));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).power((Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5"))), "POWER(f4, f5)", Double.toString(package$.MODULE$.pow((double)44, (double)((float)4.5))));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).power((Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5"))), "power(f5, f5)", Double.toString(package$.MODULE$.pow(4.5, 4.5)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).power((Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6"))), "power(f5, f6)", Double.toString(package$.MODULE$.pow(4.5, 4.6)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).power((Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7"))), "power(f5, f7)", Double.toString(package$.MODULE$.pow(4.5, 3.0)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).power((Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4"))), "power(f5, f4)", Double.toString(package$.MODULE$.pow(4.5, 44.0)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f22")).cast(DataTypes.DOUBLE())).power((Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5"))), "power(CAST(f22 AS DOUBLE), f5)", Double.toString(package$.MODULE$.pow(2.0, 4.5)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f22")).cast(DataTypes.DOUBLE())).power((Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6"))), "power(CAST(f22 AS DOUBLE), f6)", Double.toString(package$.MODULE$.pow(2.0, 4.6)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f22")).cast(DataTypes.DOUBLE())).power((Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7"))), "power(CAST(f22 AS DOUBLE), f7)", Double.toString(package$.MODULE$.pow(2.0, 3.0)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f22")).cast(DataTypes.DOUBLE())).power((Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4"))), "power(CAST(f22 AS DOUBLE), f4)", Double.toString(package$.MODULE$.pow(2.0, 44.0)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).power(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f22")).cast(DataTypes.DOUBLE())), "power(f6, f22)", Double.toString(package$.MODULE$.pow(4.6, 2.0)));
    }

    @Test
    public void testSqrt() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).sqrt(), "SQRT(f6)", Double.toString(package$.MODULE$.sqrt(4.6)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7")).sqrt(), "SQRT(f7)", Double.toString(package$.MODULE$.sqrt(3.0)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).sqrt(), "SQRT(f4)", Double.toString(package$.MODULE$.sqrt(44.0)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f22")).cast(DataTypes.DOUBLE())).sqrt(), "SQRT(CAST(f22 AS DOUBLE))", Double.toString(package$.MODULE$.sqrt(2.0)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).sqrt(), "SQRT(f5)", Double.toString(package$.MODULE$.pow(4.5, 0.5)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(25).sqrt(), "SQRT(25)", "5.0");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralDoubleExpression(2.2).sqrt(), "POWER(CAST(2.2 AS DOUBLE), CAST(0.5 AS DOUBLE))", Double.toString(package$.MODULE$.sqrt(2.2)));
    }

    @Test
    public void testCosh() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(0).cosh(), "COSH(0)", Double.toString(package$.MODULE$.cosh(0.0)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(-1).cosh(), "COSH(-1)", Double.toString(package$.MODULE$.cosh(-1.0)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).cosh(), "COSH(f4)", Double.toString(package$.MODULE$.cosh(44.0)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).cosh(), "COSH(f6)", Double.toString(package$.MODULE$.cosh(4.6)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7")).cosh(), "COSH(f7)", Double.toString(package$.MODULE$.cosh(3.0)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f22")).cosh(), "COSH(f22)", Double.toString(package$.MODULE$.cosh(2.0)));
    }

    @Test
    public void testLn() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).ln(), "LN(f2)", Double.toString(package$.MODULE$.log((double)((byte)42))));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).ln(), "LN(f3)", Double.toString(package$.MODULE$.log((double)((short)43))));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).ln(), "LN(f4)", Double.toString(package$.MODULE$.log((double)44)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).ln(), "LN(f5)", Double.toString(package$.MODULE$.log((double)((float)4.5))));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).ln(), "LN(f6)", Double.toString(package$.MODULE$.log(4.6)));
    }

    @Test
    public void testAbs() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).abs(), "ABS(f2)", "42");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).abs(), "ABS(f3)", "43");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).abs(), "ABS(f4)", "44");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).abs(), "ABS(f5)", "4.5");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).abs(), "ABS(f6)", "4.6");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f9")).abs(), "ABS(f9)", "42");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f10")).abs(), "ABS(f10)", "43");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f11")).abs(), "ABS(f11)", "44");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f12")).abs(), "ABS(f12)", "4.5");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f13")).abs(), "ABS(f13)", "4.6");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f15")).abs(), "ABS(f15)", "1231.1231231321321321111");
    }

    @Test
    public void testArithmeticFloorCeil() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).floor(), "FLOOR(f5)", "4.0");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).ceil(), "CEIL(f5)", "5.0");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).floor(), "FLOOR(f3)", "43");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).ceil(), "CEIL(f3)", "43");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f15")).floor(), "FLOOR(f15)", "-1232");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f15")).ceil(), "CEIL(f15)", "-1231");
    }

    @Test
    public void testSin() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).sin(), "SIN(f2)", Double.toString(package$.MODULE$.sin((double)((byte)42))));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).sin(), "SIN(f3)", Double.toString(package$.MODULE$.sin((double)((short)43))));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).sin(), "SIN(f4)", Double.toString(package$.MODULE$.sin((double)44)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).sin(), "SIN(f5)", Double.toString(package$.MODULE$.sin((double)((float)4.5))));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).sin(), "SIN(f6)", Double.toString(package$.MODULE$.sin(4.6)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f15")).sin(), "SIN(f15)", Double.toString(package$.MODULE$.sin(-1231.1231231321322)));
    }

    @Test
    public void testCos() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).cos(), "COS(f2)", Double.toString(package$.MODULE$.cos((double)((byte)42))));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).cos(), "COS(f3)", Double.toString(package$.MODULE$.cos((double)((short)43))));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).cos(), "COS(f4)", Double.toString(package$.MODULE$.cos((double)44)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).cos(), "COS(f5)", Double.toString(package$.MODULE$.cos((double)((float)4.5))));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).cos(), "COS(f6)", Double.toString(package$.MODULE$.cos(4.6)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f15")).cos(), "COS(f15)", Double.toString(package$.MODULE$.cos(-1231.1231231321322)));
    }

    @Test
    public void testSinh() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(0).sinh(), "SINH(0)", Double.toString(package$.MODULE$.sinh(0.0)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(-1).sinh(), "SINH(-1)", Double.toString(package$.MODULE$.sinh(-1.0)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).sinh(), "SINH(f4)", Double.toString(package$.MODULE$.sinh(44.0)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).sinh(), "SINH(f6)", Double.toString(package$.MODULE$.sinh(4.6)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7")).sinh(), "SINH(f7)", Double.toString(package$.MODULE$.sinh(3.0)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f22")).sinh(), "SINH(f22)", Double.toString(package$.MODULE$.sinh(2.0)));
    }

    @Test
    public void testTan() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).tan(), "TAN(f2)", Double.toString(package$.MODULE$.tan((double)((byte)42))));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).tan(), "TAN(f3)", Double.toString(package$.MODULE$.tan((double)((short)43))));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).tan(), "TAN(f4)", Double.toString(package$.MODULE$.tan((double)44)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).tan(), "TAN(f5)", Double.toString(package$.MODULE$.tan((double)((float)4.5))));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).tan(), "TAN(f6)", Double.toString(package$.MODULE$.tan(4.6)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f15")).tan(), "TAN(f15)", Double.toString(package$.MODULE$.tan(-1231.1231231321322)));
    }

    @Test
    public void testTanh() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(0).tanh(), "TANH(0)", Double.toString(package$.MODULE$.tanh(0.0)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(-1).tanh(), "TANH(-1)", Double.toString(package$.MODULE$.tanh(-1.0)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).tanh(), "TANH(f4)", Double.toString(package$.MODULE$.tanh(44.0)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).tanh(), "TANH(f6)", Double.toString(package$.MODULE$.tanh(4.6)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7")).tanh(), "TANH(f7)", Double.toString(package$.MODULE$.tanh(3.0)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f22")).tanh(), "TANH(f22)", Double.toString(package$.MODULE$.tanh(2.0)));
    }

    @Test
    public void testCot() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).cot(), "COT(f2)", Double.toString(1.0 / package$.MODULE$.tan((double)((byte)42))));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).cot(), "COT(f3)", Double.toString(1.0 / package$.MODULE$.tan((double)((short)43))));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).cot(), "COT(f4)", Double.toString(1.0 / package$.MODULE$.tan((double)44)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).cot(), "COT(f5)", Double.toString(1.0 / package$.MODULE$.tan((double)((float)4.5))));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).cot(), "COT(f6)", Double.toString(1.0 / package$.MODULE$.tan(4.6)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f15")).cot(), "COT(f15)", Double.toString(1.0 / package$.MODULE$.tan(-1231.1231231321322)));
    }

    @Test
    public void testAsin() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f25")).asin(), "ASIN(f25)", Double.toString(package$.MODULE$.asin((double)((byte)0.42))));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f26")).asin(), "ASIN(f26)", Double.toString(package$.MODULE$.asin((double)((short)0))));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f27")).asin(), "ASIN(f27)", Double.toString(package$.MODULE$.asin((double)0)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f28")).asin(), "ASIN(f28)", Double.toString(package$.MODULE$.asin((double)((float)0.45))));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f29")).asin(), "ASIN(f29)", Double.toString(package$.MODULE$.asin(0.46)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f30")).asin(), "ASIN(f30)", Double.toString(package$.MODULE$.asin(1.0)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f31")).asin(), "ASIN(f31)", Double.toString(package$.MODULE$.asin(-0.12312313213213211)));
    }

    @Test
    public void testAcos() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f25")).acos(), "ACOS(f25)", Double.toString(package$.MODULE$.acos((double)((byte)0.42))));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f26")).acos(), "ACOS(f26)", Double.toString(package$.MODULE$.acos((double)((short)0))));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f27")).acos(), "ACOS(f27)", Double.toString(package$.MODULE$.acos((double)0)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f28")).acos(), "ACOS(f28)", Double.toString(package$.MODULE$.acos((double)((float)0.45))));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f29")).acos(), "ACOS(f29)", Double.toString(package$.MODULE$.acos(0.46)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f30")).acos(), "ACOS(f30)", Double.toString(package$.MODULE$.acos(1.0)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f31")).acos(), "ACOS(f31)", Double.toString(package$.MODULE$.acos(-0.12312313213213211)));
    }

    @Test
    public void testAtan() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f25")).atan(), "ATAN(f25)", Double.toString(package$.MODULE$.atan((double)((byte)0.42))));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f26")).atan(), "ATAN(f26)", Double.toString(package$.MODULE$.atan((double)((short)0))));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f27")).atan(), "ATAN(f27)", Double.toString(package$.MODULE$.atan((double)0)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f28")).atan(), "ATAN(f28)", Double.toString(package$.MODULE$.atan((double)((float)0.45))));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f29")).atan(), "ATAN(f29)", Double.toString(package$.MODULE$.atan(0.46)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f30")).atan(), "ATAN(f30)", Double.toString(package$.MODULE$.atan(1.0)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f31")).atan(), "ATAN(f31)", Double.toString(package$.MODULE$.atan(-0.12312313213213211)));
    }

    @Test
    public void testAtan2() {
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.atan2(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f25")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f26"))), "ATAN2(f25, f26)", Double.toString(package$.MODULE$.atan2((double)((byte)0.42), (double)((byte)0))));
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.atan2(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f26")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f25"))), "ATAN2(f26, f25)", Double.toString(package$.MODULE$.atan2((double)((short)0), (double)((short)0))));
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.atan2(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f27")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f27"))), "ATAN2(f27, f27)", Double.toString(package$.MODULE$.atan2((double)0, (double)0)));
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.atan2(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f28")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f28"))), "ATAN2(f28, f28)", Double.toString(package$.MODULE$.atan2((double)((float)0.45), (double)((float)0.45))));
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.atan2(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f29")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f29"))), "ATAN2(f29, f29)", Double.toString(package$.MODULE$.atan2(0.46, 0.46)));
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.atan2(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f30")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f30"))), "ATAN2(f30, f30)", Double.toString(package$.MODULE$.atan2(1.0, 1.0)));
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.atan2(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f31")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f31"))), "ATAN2(f31, f31)", Double.toString(package$.MODULE$.atan2(-0.12312313213213211, -0.12312313213213211)));
    }

    @Test
    public void testDegrees() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).degrees(), "DEGREES(f2)", Double.toString(package$.MODULE$.toDegrees((double)((byte)42))));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).degrees(), "DEGREES(f3)", Double.toString(package$.MODULE$.toDegrees((double)((short)43))));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).degrees(), "DEGREES(f4)", Double.toString(package$.MODULE$.toDegrees((double)44)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).degrees(), "DEGREES(f5)", Double.toString(package$.MODULE$.toDegrees((double)((float)4.5))));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).degrees(), "DEGREES(f6)", Double.toString(package$.MODULE$.toDegrees(4.6)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f15")).degrees(), "DEGREES(f15)", Double.toString(package$.MODULE$.toDegrees(-1231.1231231321322)));
    }

    @Test
    public void testRadians() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).radians(), "RADIANS(f2)", Double.toString(package$.MODULE$.toRadians((double)((byte)42))));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).radians(), "RADIANS(f3)", Double.toString(package$.MODULE$.toRadians((double)((short)43))));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).radians(), "RADIANS(f4)", Double.toString(package$.MODULE$.toRadians((double)44)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).radians(), "RADIANS(f5)", Double.toString(package$.MODULE$.toRadians((double)((float)4.5))));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).radians(), "RADIANS(f6)", Double.toString(package$.MODULE$.toRadians(4.6)));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f15")).radians(), "RADIANS(f15)", Double.toString(package$.MODULE$.toRadians(-1231.1231231321322)));
    }

    @Test
    public void testSign() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).sign(), "SIGN(f4)", Integer.toString(1));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).sign(), "SIGN(f6)", Double.toString(1.0));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f15")).sign(), "SIGN(f15)", "-1.0000000000000000000");
    }

    @Test
    public void testRound() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f29")).round((Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f30"))), "ROUND(f29, f30)", Double.toString(0.5));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).round((Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f32"))), "ROUND(f4, f32)", Integer.toString(40));
        this.testSqlApi("ROUND(125.315)", "125");
        this.testSqlApi("ROUND(-125.315, 2)", "-125.32");
        this.testSqlApi("ROUND(125.315, 0)", "125");
        this.testSqlApi("ROUND(1.4, 1)", "1.4");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(123).cast(DataTypes.TINYINT())).round((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(-2)), "ROUND(CAST(123 AS TINYINT), -2)", "100");
        this.testSqlApi("ROUND(CAST(123 AS TINYINT))", "123");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.nullOf(DataTypes.TINYINT())).round((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(-2)), "ROUND(CAST(NULL AS TINYINT), -2)", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(123).cast(DataTypes.TINYINT())).round((Object)org.apache.flink.table.api.package$.MODULE$.nullOf(DataTypes.INT())), "ROUND(CAST(123 AS TINYINT), CAST(NULL AS INT))", "NULL");
        this.testSqlApi("ROUND(CAST(NULL AS TINYINT))", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(123).cast(DataTypes.SMALLINT())).round((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(-2)), "ROUND(CAST(123 AS SMALLINT), -2)", "100");
        this.testSqlApi("ROUND(CAST(123 AS SMALLINT))", "123");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.nullOf(DataTypes.SMALLINT())).round((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(-2)), "ROUND(CAST(NULL AS SMALLINT), -2)", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(123).cast(DataTypes.SMALLINT())).round((Object)org.apache.flink.table.api.package$.MODULE$.nullOf(DataTypes.INT())), "ROUND(CAST(123 AS SMALLINT), CAST(NULL AS INT))", "NULL");
        this.testSqlApi("ROUND(CAST(NULL AS SMALLINT))", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(123).cast(DataTypes.INT())).round((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(-2)), "ROUND(CAST(123 AS INT), -2)", "100");
        this.testSqlApi("ROUND(CAST(123 AS INT))", "123");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.nullOf(DataTypes.INT())).round((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(-2)), "ROUND(CAST(NULL AS INT), -2)", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(123).cast(DataTypes.INT())).round((Object)org.apache.flink.table.api.package$.MODULE$.nullOf(DataTypes.INT())), "ROUND(CAST(123 AS INT), CAST(NULL AS INT))", "NULL");
        this.testSqlApi("ROUND(CAST(NULL AS INT))", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(123).cast(DataTypes.BIGINT())).round((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(-2)), "ROUND(CAST(123 AS BIGINT), -2)", "100");
        this.testSqlApi("ROUND(CAST(123 AS BIGINT))", "123");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.nullOf(DataTypes.BIGINT())).round((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(-2)), "ROUND(CAST(NULL AS BIGINT), -2)", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(123).cast(DataTypes.BIGINT())).round((Object)org.apache.flink.table.api.package$.MODULE$.nullOf(DataTypes.INT())), "ROUND(CAST(123 AS BIGINT), CAST(NULL AS INT))", "NULL");
        this.testSqlApi("ROUND(CAST(NULL AS BIGINT))", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralDoubleExpression(1.2345).cast(DataTypes.FLOAT())).round((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(3)), "ROUND(CAST(1.2345 AS FLOAT), 3)", "1.235");
        this.testSqlApi("ROUND(CAST(1.2345 AS FLOAT))", "1.0");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.nullOf(DataTypes.FLOAT())).round((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(3)), "ROUND(CAST(NULL AS FLOAT), 3)", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralDoubleExpression(1.2345).cast(DataTypes.FLOAT())).round((Object)org.apache.flink.table.api.package$.MODULE$.nullOf(DataTypes.INT())), "ROUND(CAST(1.2345 AS FLOAT), CAST(NULL AS INT))", "NULL");
        this.testSqlApi("ROUND(CAST(NULL AS FLOAT))", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralDoubleExpression(1.2345).cast(DataTypes.DOUBLE())).round((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(3)), "ROUND(CAST(1.2345 AS DOUBLE), 3)", "1.235");
        this.testSqlApi("ROUND(CAST(1.2345 AS DOUBLE))", "1.0");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.nullOf(DataTypes.DOUBLE())).round((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(3)), "ROUND(CAST(NULL AS DOUBLE), 3)", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralDoubleExpression(1.2345).cast(DataTypes.DOUBLE())).round((Object)org.apache.flink.table.api.package$.MODULE$.nullOf(DataTypes.INT())), "ROUND(CAST(1.2345 AS DOUBLE), CAST(NULL AS INT))", "NULL");
        this.testSqlApi("ROUND(CAST(NULL AS DOUBLE))", "NULL");
        this.testSqlApi("ROUND(CAST(1.2345 AS DECIMAL(5, 4)), 3)", "1.235");
        this.testSqlApi("ROUND(CAST(1.2345 AS DECIMAL(5, 4)))", "1");
        this.testSqlApi("ROUND(CAST(NULL AS DECIMAL(5, 4)), 3)", "NULL");
        this.testSqlApi("ROUND(CAST(1.2345 AS DECIMAL(5, 4)), CAST(NULL AS INT))", "NULL");
        this.testSqlApi("ROUND(CAST(NULL AS DECIMAL(5, 4)))", "NULL");
    }

    @Test
    public void testPi() {
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.pi(), "pi()", Double.toString(Math.PI));
    }

    @Test
    public void testRandAndRandInteger() {
        Random random1 = new Random(1L);
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.rand(org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), "RAND(1)", Double.toString(random1.nextDouble()));
        Random random2 = new Random(3L);
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.rand(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7"))), "RAND(f7)", Double.toString(random2.nextDouble()));
        Random random3 = new Random(1L);
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.randInteger(org.apache.flink.table.api.package$.MODULE$.int2Literal(1), org.apache.flink.table.api.package$.MODULE$.int2Literal(10)), "RAND_INTEGER(1, 10)", Integer.toString(random3.nextInt(10)));
        Random random4 = new Random(3L);
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.randInteger(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7")), (Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).cast(DataTypes.INT())), "RAND_INTEGER(f7, CAST(f4 AS INT))", Integer.toString(random4.nextInt(44)));
        Random random5 = new Random(1L);
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.rand(org.apache.flink.table.api.package$.MODULE$.int2Literal(1))).plus((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), "RAND(1) + 1", Double.toString(random5.nextDouble() + 1.0));
        Random random6 = new Random(1L);
        Random random7 = new Random(2L);
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.rand(org.apache.flink.table.api.package$.MODULE$.int2Literal(1))).plus((Object)org.apache.flink.table.api.package$.MODULE$.rand(org.apache.flink.table.api.package$.MODULE$.int2Literal(2))), "RAND(1) + RAND(2)", Double.toString(random6.nextDouble() + random7.nextDouble()));
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.rand((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f21")).cast(DataTypes.INT()))).plus((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), "rand(cast(null as int)) + 1", "NULL");
    }

    @Test
    public void testE() {
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.e(), "E()", Double.toString(Math.E));
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.e(), "e()", Double.toString(Math.E));
    }

    @Test
    public void testLog() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).log(), "LOG(f6)", "1.5260563034950492");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).$minus(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")))).$plus(org.apache.flink.table.api.package$.MODULE$.int2Literal(100))).log((Object)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).$minus(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")))).$plus(org.apache.flink.table.api.package$.MODULE$.int2Literal(10))), "LOG(f6 - f6 + 10, f6 - f6 + 100)", "2.0");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).$plus(org.apache.flink.table.api.package$.MODULE$.int2Literal(20))).log(), "LOG(f6+20)", "3.202746442938317");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(10).log(), "LOG(10)", "2.302585092994046");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(100).log((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(10)), "LOG(10, 100)", "2.0");
        this.testSqlApi("LOG(cast (null AS DOUBLE))", "NULL");
        this.testSqlApi("LOG(cast (null AS DOUBLE), 1)", "NULL");
        this.testSqlApi("LOG(1, cast (null AS DOUBLE))", "NULL");
        this.testSqlApi("LOG(cast (null AS DOUBLE), cast (null AS DOUBLE))", "NULL");
        this.testSqlApi("LOG(1, 100)", "Infinity");
        this.testSqlApi("LOG(-1)", "NaN");
    }

    @Test
    public void testLog2() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).log2(), "LOG2(f6)", "2.2016338611696504");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).$minus(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")))).$plus(org.apache.flink.table.api.package$.MODULE$.int2Literal(100))).log2(), "LOG2(f6 - f6 + 100)", "6.643856189774725");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).$plus(org.apache.flink.table.api.package$.MODULE$.int2Literal(20))).log2(), "LOG2(f6+20)", "4.620586410451877");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(10).log2(), "LOG2(10)", "3.3219280948873626");
        this.testSqlApi("LOG2(cast (null AS DOUBLE))", "NULL");
    }

    @Test
    public void testChr() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(65).chr(), "CHR(65)", "A");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(-9).chr(), "CHR(-9)", "");
        this.testSqlApi("CHR(f4)", ",");
        this.testSqlApi("CHR(f43)", "");
        this.testSqlApi("CHR(f42)", Character.toString('\u0000'));
        this.testSqlApi("CHR(CAST (-10 AS BIGINT))", "");
        this.testSqlApi("CHR(300)", ",");
        this.testSqlApi("CHR(97)", "a");
        this.testSqlApi("CHR(97 + 256)", "a");
        this.testSqlApi("CHR(0)", Character.toString('\u0000'));
        this.testSqlApi("CHR(149)", Character.toString((char)149));
        this.testSqlApi("CHR(cast (null AS BIGINT))", "NULL");
    }

    @Test
    public void testExtract() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f16")).extract(TimeIntervalUnit.MILLENNIUM), "EXTRACT(MILLENNIUM FROM f16)", "2");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f16")).extract(TimeIntervalUnit.CENTURY), "EXTRACT(CENTURY FROM f16)", "20");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f16")).extract(TimeIntervalUnit.DECADE), "EXTRACT(DECADE FROM f16)", "199");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f16")).extract(TimeIntervalUnit.YEAR), "EXTRACT(YEAR FROM f16)", "1996");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f16")).extract(TimeIntervalUnit.QUARTER), "EXTRACT(QUARTER FROM f16)", "4");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f16")).extract(TimeIntervalUnit.MONTH), "EXTRACT(MONTH FROM f16)", "11");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f16")).extract(TimeIntervalUnit.WEEK), "EXTRACT(WEEK FROM f16)", "45");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f16")).extract(TimeIntervalUnit.DAY), "EXTRACT(DAY FROM f16)", "10");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18")).extract(TimeIntervalUnit.YEAR), "EXTRACT(YEAR FROM f18)", "1996");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18")).extract(TimeIntervalUnit.QUARTER), "EXTRACT(QUARTER FROM f18)", "4");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f16")).extract(TimeIntervalUnit.QUARTER), "EXTRACT(QUARTER FROM f16)", "4");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18")).extract(TimeIntervalUnit.MONTH), "EXTRACT(MONTH FROM f18)", "11");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18")).extract(TimeIntervalUnit.WEEK), "EXTRACT(WEEK FROM f18)", "45");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18")).extract(TimeIntervalUnit.DAY), "EXTRACT(DAY FROM f18)", "10");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18")).extract(TimeIntervalUnit.HOUR), "EXTRACT(HOUR FROM f18)", "6");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f17")).extract(TimeIntervalUnit.HOUR), "EXTRACT(HOUR FROM f17)", "6");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18")).extract(TimeIntervalUnit.MINUTE), "EXTRACT(MINUTE FROM f18)", "55");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f17")).extract(TimeIntervalUnit.MINUTE), "EXTRACT(MINUTE FROM f17)", "55");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18")).extract(TimeIntervalUnit.SECOND), "EXTRACT(SECOND FROM f18)", "44");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f17")).extract(TimeIntervalUnit.SECOND), "EXTRACT(SECOND FROM f17)", "44");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18")).extract(TimeIntervalUnit.MILLISECOND), "EXTRACT(MILLISECOND FROM f18)", "333");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f17")).extract(TimeIntervalUnit.MILLISECOND), "EXTRACT(MILLISECOND FROM f17)", "0");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18")).extract(TimeIntervalUnit.MICROSECOND), "EXTRACT(MICROSECOND FROM f18)", "333000");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18")).extract(TimeIntervalUnit.NANOSECOND), "EXTRACT(NANOSECOND FROM f18)", "333000000");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f19")).extract(TimeIntervalUnit.DAY), "EXTRACT(DAY FROM f19)", "16979");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f19")).extract(TimeIntervalUnit.HOUR), "EXTRACT(HOUR FROM f19)", "7");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f19")).extract(TimeIntervalUnit.MINUTE), "EXTRACT(MINUTE FROM f19)", "23");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f19")).extract(TimeIntervalUnit.SECOND), "EXTRACT(SECOND FROM f19)", "33");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f20")).extract(TimeIntervalUnit.MONTH), "EXTRACT(MONTH FROM f20)", "1");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f20")).extract(TimeIntervalUnit.QUARTER), "EXTRACT(QUARTER FROM f20)", "1");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f20")).extract(TimeIntervalUnit.YEAR), "EXTRACT(YEAR FROM f20)", "2");
        this.testSqlApi("EXTRACT(MILLENNIUM FROM f18)", "2");
        this.testSqlApi("EXTRACT(MILLENNIUM FROM f16)", "2");
        this.testSqlApi("EXTRACT(CENTURY FROM f18)", "20");
        this.testSqlApi("EXTRACT(CENTURY FROM f16)", "20");
        this.testSqlApi("EXTRACT(DECADE FROM f18)", "199");
        this.testSqlApi("EXTRACT(DECADE FROM f16)", "199");
        this.testSqlApi("EXTRACT(DOY FROM f18)", "315");
        this.testSqlApi("EXTRACT(DOY FROM f16)", "315");
        this.testSqlApi("EXTRACT(ISOYEAR FROM f18)", "1996");
        this.testSqlApi("EXTRACT(ISOYEAR FROM f16)", "1996");
        this.testSqlApi("EXTRACT(DOW FROM f18)", "1");
        this.testSqlApi("EXTRACT(DOW FROM f16)", "1");
        this.testSqlApi("EXTRACT(ISODOW FROM f18)", "7");
        this.testSqlApi("EXTRACT(ISODOW FROM f16)", "7");
        this.testSqlApi("EXTRACT(QUARTER FROM f18)", "4");
        this.testSqlApi("EXTRACT(QUARTER FROM f16)", "4");
        this.testSqlApi("EXTRACT(WEEK FROM f18)", "45");
        this.testSqlApi("EXTRACT(WEEK FROM f16)", "45");
        this.testSqlApi("YEAR(f18)", "1996");
        this.testSqlApi("YEAR(f16)", "1996");
        this.testSqlApi("QUARTER(f18)", "4");
        this.testSqlApi("QUARTER(f16)", "4");
        this.testSqlApi("MONTH(f18)", "11");
        this.testSqlApi("MONTH(f16)", "11");
        this.testSqlApi("WEEK(f18)", "45");
        this.testSqlApi("WEEK(f16)", "45");
        this.testSqlApi("DAYOFYEAR(f18)", "315");
        this.testSqlApi("DAYOFYEAR(f16)", "315");
        this.testSqlApi("DAYOFMONTH(f18)", "10");
        this.testSqlApi("DAYOFMONTH(f16)", "10");
        this.testSqlApi("DAYOFWEEK(f18)", "1");
        this.testSqlApi("DAYOFWEEK(f16)", "1");
        this.testSqlApi("HOUR(f17)", "6");
        this.testSqlApi("HOUR(f19)", "7");
        this.testSqlApi("MINUTE(f17)", "55");
        this.testSqlApi("MINUTE(f19)", "23");
        this.testSqlApi("SECOND(f17)", "44");
        this.testSqlApi("SECOND(f19)", "33");
    }

    @Test
    public void testTemporalFloor() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18")).floor(TimeIntervalUnit.YEAR), "FLOOR(f18 TO YEAR)", "1996-01-01 00:00:00.000");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18")).floor(TimeIntervalUnit.MONTH), "FLOOR(f18 TO MONTH)", "1996-11-01 00:00:00.000");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18")).floor(TimeIntervalUnit.DAY), "FLOOR(f18 TO DAY)", "1996-11-10 00:00:00.000");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18")).floor(TimeIntervalUnit.HOUR), "FLOOR(f18 TO HOUR)", "1996-11-10 06:00:00.000");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18")).floor(TimeIntervalUnit.MINUTE), "FLOOR(f18 TO MINUTE)", "1996-11-10 06:55:00.000");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18")).floor(TimeIntervalUnit.SECOND), "FLOOR(f18 TO SECOND)", "1996-11-10 06:55:44.000");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f17")).floor(TimeIntervalUnit.HOUR), "FLOOR(f17 TO HOUR)", "06:00:00");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f17")).floor(TimeIntervalUnit.MINUTE), "FLOOR(f17 TO MINUTE)", "06:55:00");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f17")).floor(TimeIntervalUnit.SECOND), "FLOOR(f17 TO SECOND)", "06:55:44");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f16")).floor(TimeIntervalUnit.YEAR), "FLOOR(f16 TO YEAR)", "1996-01-01");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f16")).floor(TimeIntervalUnit.MONTH), "FLOOR(f16 TO MONTH)", "1996-11-01");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18")).ceil(TimeIntervalUnit.YEAR), "CEIL(f18 TO YEAR)", "1997-01-01 00:00:00.000");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18")).ceil(TimeIntervalUnit.MONTH), "CEIL(f18 TO MONTH)", "1996-12-01 00:00:00.000");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18")).ceil(TimeIntervalUnit.DAY), "CEIL(f18 TO DAY)", "1996-11-11 00:00:00.000");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18")).ceil(TimeIntervalUnit.HOUR), "CEIL(f18 TO HOUR)", "1996-11-10 07:00:00.000");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18")).ceil(TimeIntervalUnit.MINUTE), "CEIL(f18 TO MINUTE)", "1996-11-10 06:56:00.000");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18")).ceil(TimeIntervalUnit.SECOND), "CEIL(f18 TO SECOND)", "1996-11-10 06:55:45.000");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f17")).ceil(TimeIntervalUnit.HOUR), "CEIL(f17 TO HOUR)", "07:00:00");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f17")).ceil(TimeIntervalUnit.MINUTE), "CEIL(f17 TO MINUTE)", "06:56:00");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f17")).ceil(TimeIntervalUnit.SECOND), "CEIL(f17 TO SECOND)", "06:55:44");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f16")).ceil(TimeIntervalUnit.YEAR), "CEIL(f16 TO YEAR)", "1997-01-01");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f16")).ceil(TimeIntervalUnit.MONTH), "CEIL(f16 TO MONTH)", "1996-12-01");
    }

    @Test
    public void testCurrentTimePoint() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.currentDate()).cast(DataTypes.STRING())).charLength(), "CHAR_LENGTH(CAST(CURRENT_DATE AS VARCHAR))", "10");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.localTime()).cast(DataTypes.STRING())).charLength(), "CHAR_LENGTH(CAST(LOCALTIME AS VARCHAR))", "8");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.currentTime()).cast(DataTypes.STRING())).charLength(), "CHAR_LENGTH(CAST(CURRENT_TIME AS VARCHAR))", "8");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.localTimestamp()).cast(DataTypes.STRING())).charLength(), "CHAR_LENGTH(CAST(LOCALTIMESTAMP AS VARCHAR))", "23");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.currentTimestamp()).cast(DataTypes.STRING())).charLength(), "CHAR_LENGTH(CAST(CURRENT_TIMESTAMP AS VARCHAR))", "23");
        this.testSqlApi("CHAR_LENGTH(CAST(NOW() AS VARCHAR))", "23");
        this.testSqlApi("CHAR_LENGTH(CAST(CURRENT_ROW_TIMESTAMP() AS VARCHAR))", "23");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.localTimestamp()).$eq$eq$eq(org.apache.flink.table.api.package$.MODULE$.localTimestamp()), "LOCALTIMESTAMP = LOCALTIMESTAMP", "TRUE");
    }

    @Test
    public void testOverlaps() {
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.temporalOverlaps((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2:55:00").toTime(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(1).hour(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("3:30:00").toTime(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(2).hours()), "(TIME '2:55:00', INTERVAL '1' HOUR) OVERLAPS (TIME '3:30:00', INTERVAL '2' HOUR)", "TRUE");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.temporalOverlaps((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("9:00:00").toTime(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("9:30:00").toTime(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("9:29:00").toTime(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("9:31:00").toTime()), "(TIME '9:00:00', TIME '9:30:00') OVERLAPS (TIME '9:29:00', TIME '9:31:00')", "TRUE");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.temporalOverlaps((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("9:00:00").toTime(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("10:00:00").toTime(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("10:15:00").toTime(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(3).hours()), "(TIME '9:00:00', TIME '10:00:00') OVERLAPS (TIME '10:15:00', INTERVAL '3' HOUR)", "FALSE");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.temporalOverlaps((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2011-03-10").toDate(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(10).days(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2011-03-19").toDate(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(10).days()), "(DATE '2011-03-10', INTERVAL '10' DAY) OVERLAPS (DATE '2011-03-19', INTERVAL '10' DAY)", "TRUE");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.temporalOverlaps((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2011-03-10 05:02:02").toTimestamp(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(0).milli(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2011-03-10 05:02:02").toTimestamp(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2011-03-10 05:02:01").toTimestamp()), "(TIMESTAMP '2011-03-10 05:02:02', INTERVAL '0' SECOND) OVERLAPS (TIMESTAMP '2011-03-10 05:02:02', TIMESTAMP '2011-03-10 05:02:01')", "TRUE");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.temporalOverlaps((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2011-03-10 02:02:02.001").toTimestamp(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(0).milli(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2011-03-10 02:02:02.002").toTimestamp(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2011-03-10 02:02:02.002").toTimestamp()), "(TIMESTAMP '2011-03-10 02:02:02.001', INTERVAL '0' SECOND) OVERLAPS (TIMESTAMP '2011-03-10 02:02:02.002', TIMESTAMP '2011-03-10 02:02:02.002')", "FALSE");
    }

    @Test
    public void testQuarter() {
        this.testSqlApi("QUARTER(DATE '1997-01-27')", "1");
        this.testSqlApi("QUARTER(DATE '1997-04-27')", "2");
        this.testSqlApi("QUARTER(DATE '1997-12-31')", "4");
    }

    @Test
    public void testTimestampDiff() {
        Map dataMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"DAY", (Object)TimePointUnit.DAY, (Object)"SQL_TSI_DAY")), (Object)new .colon.colon((Object)new Tuple3((Object)"2018-07-03 11:11:11", (Object)"2018-07-05 11:11:11", (Object)"2"), (List)new .colon.colon((Object)new Tuple3((Object)"2016-06-15", (Object)"2016-06-16 11:11:11", (Object)"1"), (List)new .colon.colon((Object)new Tuple3((Object)"2016-06-15 11:00:00", (Object)"2016-06-19", (Object)"3"), (List)new .colon.colon((Object)new Tuple3((Object)"2016-06-15", (Object)"2016-06-18", (Object)"3"), (List)Nil$.MODULE$))))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"HOUR", (Object)TimePointUnit.HOUR, (Object)"SQL_TSI_HOUR")), (Object)new .colon.colon((Object)new Tuple3((Object)"2018-07-03 11:11:11", (Object)"2018-07-04 12:12:11", (Object)"25"), (List)new .colon.colon((Object)new Tuple3((Object)"2016-06-15", (Object)"2016-06-16 11:11:11", (Object)"35"), (List)new .colon.colon((Object)new Tuple3((Object)"2016-06-15 11:00:00", (Object)"2016-06-19", (Object)"85"), (List)new .colon.colon((Object)new Tuple3((Object)"2016-06-15", (Object)"2016-06-12", (Object)"-72"), (List)Nil$.MODULE$))))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"MINUTE", (Object)TimePointUnit.MINUTE, (Object)"SQL_TSI_MINUTE")), (Object)new .colon.colon((Object)new Tuple3((Object)"2018-07-03 11:11:11", (Object)"2018-07-03 12:10:11", (Object)"59"), (List)new .colon.colon((Object)new Tuple3((Object)"2016-06-15", (Object)"2016-06-16 11:11:11", (Object)"2111"), (List)new .colon.colon((Object)new Tuple3((Object)"2016-06-15 11:00:00", (Object)"2016-06-19", (Object)"5100"), (List)new .colon.colon((Object)new Tuple3((Object)"2016-06-15", (Object)"2016-06-18", (Object)"4320"), (List)Nil$.MODULE$))))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"SECOND", (Object)TimePointUnit.SECOND, (Object)"SQL_TSI_SECOND")), (Object)new .colon.colon((Object)new Tuple3((Object)"2018-07-03 11:11:11", (Object)"2018-07-03 11:12:12", (Object)"61"), (List)new .colon.colon((Object)new Tuple3((Object)"2016-06-15", (Object)"2016-06-16 11:11:11", (Object)"126671"), (List)new .colon.colon((Object)new Tuple3((Object)"2016-06-15 11:00:00", (Object)"2016-06-19", (Object)"306000"), (List)new .colon.colon((Object)new Tuple3((Object)"2016-06-15", (Object)"2016-06-18", (Object)"259200"), (List)Nil$.MODULE$))))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"WEEK", (Object)TimePointUnit.WEEK, (Object)"SQL_TSI_WEEK")), (Object)new .colon.colon((Object)new Tuple3((Object)"2018-05-03 11:11:11", (Object)"2018-07-03 11:12:12", (Object)"8"), (List)new .colon.colon((Object)new Tuple3((Object)"2016-04-15", (Object)"2016-07-16 11:11:11", (Object)"13"), (List)new .colon.colon((Object)new Tuple3((Object)"2016-04-15 11:00:00", (Object)"2016-09-19", (Object)"22"), (List)new .colon.colon((Object)new Tuple3((Object)"2016-08-15", (Object)"2016-06-18", (Object)"-8"), (List)Nil$.MODULE$))))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"MONTH", (Object)TimePointUnit.MONTH, (Object)"SQL_TSI_MONTH")), (Object)new .colon.colon((Object)new Tuple3((Object)"2018-07-03 11:11:11", (Object)"2018-09-05 11:11:11", (Object)"2"), (List)new .colon.colon((Object)new Tuple3((Object)"2016-06-15", (Object)"2018-06-16 11:11:11", (Object)"24"), (List)new .colon.colon((Object)new Tuple3((Object)"2016-06-15 11:00:00", (Object)"2018-05-19", (Object)"23"), (List)new .colon.colon((Object)new Tuple3((Object)"2016-06-15", (Object)"2018-03-18", (Object)"21"), (List)Nil$.MODULE$))))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"QUARTER", (Object)TimePointUnit.QUARTER, (Object)"SQL_TSI_QUARTER")), (Object)new .colon.colon((Object)new Tuple3((Object)"2018-01-03 11:11:11", (Object)"2018-09-05 11:11:11", (Object)"2"), (List)new .colon.colon((Object)new Tuple3((Object)"2016-06-15", (Object)"2018-06-16 11:11:11", (Object)"8"), (List)new .colon.colon((Object)new Tuple3((Object)"2016-06-15 11:00:00", (Object)"2018-05-19", (Object)"7"), (List)new .colon.colon((Object)new Tuple3((Object)"2016-06-15", (Object)"2018-03-18", (Object)"7"), (List)Nil$.MODULE$)))))}));
        dataMap.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)ScalarFunctionsTest.$anonfun$testTimestampDiff$1(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            ScalarFunctionsTest.$anonfun$testTimestampDiff$2(this, x$3);
            return BoxedUnit.UNIT;
        });
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.timestampDiff(TimePointUnit.DAY, org.apache.flink.table.api.package$.MODULE$.nullOf(DataTypes.TIMESTAMP((int)3)), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2016-02-24 12:42:25").toTimestamp()), "TIMESTAMPDIFF(DAY, CAST(NULL AS TIMESTAMP), TIMESTAMP '2016-02-24 12:42:25')", "NULL");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.timestampDiff(TimePointUnit.DAY, (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2016-02-24 12:42:25").toTimestamp(), org.apache.flink.table.api.package$.MODULE$.nullOf(DataTypes.TIMESTAMP((int)3))), "TIMESTAMPDIFF(DAY, TIMESTAMP '2016-02-24 12:42:25',  CAST(NULL AS TIMESTAMP))", "NULL");
    }

    @Test
    public void testTimestampAdd() {
        Seq data = (Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)"2017-11-29 22:58:58.998"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)3), (Object)"2017-11-29 22:58:58.998"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)-1), (Object)"2017-11-29 22:58:58.998"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)-61), (Object)"2017-11-29 22:58:58.998"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)-1000), (Object)"2017-11-29 22:58:58.998"), (List)Nil$.MODULE$)))));
        Seq YEAR = (Seq)new .colon.colon((Object)"2018-11-29 22:58:58.998", (List)new .colon.colon((Object)"2020-11-29 22:58:58.998", (List)new .colon.colon((Object)"2016-11-29 22:58:58.998", (List)new .colon.colon((Object)"1956-11-29 22:58:58.998", (List)new .colon.colon((Object)"1017-11-29 22:58:58.998", (List)Nil$.MODULE$)))));
        Seq QUARTER = (Seq)new .colon.colon((Object)"2018-02-28 22:58:58.998", (List)new .colon.colon((Object)"2018-08-29 22:58:58.998", (List)new .colon.colon((Object)"2017-08-29 22:58:58.998", (List)new .colon.colon((Object)"2002-08-29 22:58:58.998", (List)new .colon.colon((Object)"1767-11-29 22:58:58.998", (List)Nil$.MODULE$)))));
        Seq MONTH = (Seq)new .colon.colon((Object)"2017-12-29 22:58:58.998", (List)new .colon.colon((Object)"2018-02-28 22:58:58.998", (List)new .colon.colon((Object)"2017-10-29 22:58:58.998", (List)new .colon.colon((Object)"2012-10-29 22:58:58.998", (List)new .colon.colon((Object)"1934-07-29 22:58:58.998", (List)Nil$.MODULE$)))));
        Seq WEEK = (Seq)new .colon.colon((Object)"2017-12-06 22:58:58.998", (List)new .colon.colon((Object)"2017-12-20 22:58:58.998", (List)new .colon.colon((Object)"2017-11-22 22:58:58.998", (List)new .colon.colon((Object)"2016-09-28 22:58:58.998", (List)new .colon.colon((Object)"1998-09-30 22:58:58.998", (List)Nil$.MODULE$)))));
        Seq DAY = (Seq)new .colon.colon((Object)"2017-11-30 22:58:58.998", (List)new .colon.colon((Object)"2017-12-02 22:58:58.998", (List)new .colon.colon((Object)"2017-11-28 22:58:58.998", (List)new .colon.colon((Object)"2017-09-29 22:58:58.998", (List)new .colon.colon((Object)"2015-03-05 22:58:58.998", (List)Nil$.MODULE$)))));
        Seq HOUR = (Seq)new .colon.colon((Object)"2017-11-29 23:58:58.998", (List)new .colon.colon((Object)"2017-11-30 01:58:58.998", (List)new .colon.colon((Object)"2017-11-29 21:58:58.998", (List)new .colon.colon((Object)"2017-11-27 09:58:58.998", (List)new .colon.colon((Object)"2017-10-19 06:58:58.998", (List)Nil$.MODULE$)))));
        Seq MINUTE = (Seq)new .colon.colon((Object)"2017-11-29 22:59:58.998", (List)new .colon.colon((Object)"2017-11-29 23:01:58.998", (List)new .colon.colon((Object)"2017-11-29 22:57:58.998", (List)new .colon.colon((Object)"2017-11-29 21:57:58.998", (List)new .colon.colon((Object)"2017-11-29 06:18:58.998", (List)Nil$.MODULE$)))));
        Seq SECOND = (Seq)new .colon.colon((Object)"2017-11-29 22:58:59.998", (List)new .colon.colon((Object)"2017-11-29 22:59:01.998", (List)new .colon.colon((Object)"2017-11-29 22:58:57.998", (List)new .colon.colon((Object)"2017-11-29 22:57:57.998", (List)new .colon.colon((Object)"2017-11-29 22:42:18.998", (List)Nil$.MODULE$)))));
        Map intervalMapResults = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"YEAR"), (Object)YEAR), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SQL_TSI_YEAR"), (Object)YEAR), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"QUARTER"), (Object)QUARTER), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SQL_TSI_QUARTER"), (Object)QUARTER), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"MONTH"), (Object)MONTH), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SQL_TSI_MONTH"), (Object)MONTH), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"WEEK"), (Object)WEEK), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SQL_TSI_WEEK"), (Object)WEEK), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"DAY"), (Object)DAY), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SQL_TSI_DAY"), (Object)DAY), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"HOUR"), (Object)HOUR), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SQL_TSI_HOUR"), (Object)HOUR), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"MINUTE"), (Object)MINUTE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SQL_TSI_MINUTE"), (Object)MINUTE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SECOND"), (Object)SECOND), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SQL_TSI_SECOND"), (Object)SECOND)}));
        intervalMapResults.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)ScalarFunctionsTest.$anonfun$testTimestampAdd$1(check$ifrefutable$4))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            ScalarFunctionsTest.$anonfun$testTimestampAdd$2(this, data, x$5);
            return BoxedUnit.UNIT;
        });
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2016-02-24 12:42:25").toTimestamp()).$plus(org.apache.flink.table.api.package$.MODULE$.nullOf(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MINUTE()))), "TIMESTAMPADD(HOUR, CAST(NULL AS INTEGER), TIMESTAMP '2016-02-24 12:42:25')", "NULL");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.nullOf(DataTypes.TIMESTAMP((int)3))).$plus((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(-200).hours()), "TIMESTAMPADD(HOUR, -200, CAST(NULL AS TIMESTAMP))", "NULL");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2016-06-15").toDate()).$plus((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(1).day()), "TIMESTAMPADD(DAY, 1, DATE '2016-06-15')", "2016-06-16");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.nullOf(DataTypes.TIMESTAMP((int)3))).$plus((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(3).months()), "TIMESTAMPADD(MONTH, 3, CAST(NULL AS TIMESTAMP))", "NULL");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2016-02-24 12:42:25").toTimestamp()).$plus(org.apache.flink.table.api.package$.MODULE$.nullOf(Types.INTERVAL_MILLIS())), "TIMESTAMPADD(HOUR, CAST(NULL AS INTEGER), TIMESTAMP '2016-02-24 12:42:25')", "NULL");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.nullOf(Types.SQL_TIMESTAMP())).$plus((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(-200).hours()), "TIMESTAMPADD(HOUR, -200, CAST(NULL AS TIMESTAMP))", "NULL");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.nullOf(Types.SQL_TIMESTAMP())).$plus((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(3).months()), "TIMESTAMPADD(MONTH, 3, CAST(NULL AS TIMESTAMP))", "NULL");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2016-06-15").toDate()).$plus((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(1).month()), "timestampadd(MONTH, 1, date '2016-06-15')", "2016-07-15");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2016-06-15").toDate()).$plus((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(1).day()), "timestampadd(DAY, 1, date '2016-06-15')", "2016-06-16");
        this.testTableApi(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2016-06-15").toTimestamp()).$minus((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(1).hour()), "2016-06-14 23:00:00.000");
        this.testSqlApi("timestampadd(HOUR, -1, date '2016-06-15')", "2016-06-14 23:00:00.000000");
        this.testTableApi(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2016-06-15").toTimestamp()).$plus((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(1).minute()), "2016-06-15 00:01:00.000");
        this.testSqlApi("timestampadd(MINUTE, 1, date '2016-06-15')", "2016-06-15 00:01:00.000000");
        this.testTableApi(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2016-06-15").toTimestamp()).$minus((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(1).second()), "2016-06-14 23:59:59.000");
        this.testSqlApi("timestampadd(SQL_TSI_SECOND, -1, date '2016-06-15')", "2016-06-14 23:59:59.000000");
        this.testTableApi(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2016-06-15").toTimestamp()).$plus((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(1).second()), "2016-06-15 00:00:01.000");
        this.testSqlApi("timestampadd(SECOND, 1, date '2016-06-15')", "2016-06-15 00:00:01.000000");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.nullOf(Types.SQL_TIMESTAMP())).$plus((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(1).second()), "timestampadd(SECOND, 1, cast(null as date))", "NULL");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.nullOf(Types.SQL_TIMESTAMP())).$plus((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(1).day()), "timestampadd(DAY, 1, cast(null as date))", "NULL");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2016-05-31").toDate()).$plus((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(1).month()), "timestampadd(MONTH, 1, date '2016-05-31')", "2016-06-30");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2016-01-31").toDate()).$plus((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(5).month()), "timestampadd(MONTH, 5, date '2016-01-31')", "2016-06-30");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2016-03-31").toDate()).$minus((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(1).month()), "timestampadd(MONTH, -1, date '2016-03-31')", "2016-02-29");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2016-03-31").toDate()).$minus((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(1).week()), "timestampadd(WEEK, -1, date '2016-03-31')", "2016-03-24");
        this.testSqlApi("TIMESTAMPADD(SECOND, 1, time '23:59:59')", "00:00:00");
        this.testSqlApi("TIMESTAMPADD(MINUTE, 1, time '00:00:00')", "00:01:00");
        this.testSqlApi("TIMESTAMPADD(MINUTE, 1, time '23:59:59')", "00:00:59");
        this.testSqlApi("TIMESTAMPADD(HOUR, 1, time '23:59:59')", "00:59:59");
        this.testSqlApi("TIMESTAMPADD(DAY, 15, time '23:59:59')", "23:59:59");
        this.testSqlApi("TIMESTAMPADD(WEEK, 3, time '23:59:59')", "23:59:59");
        this.testSqlApi("TIMESTAMPADD(MONTH, 6, time '23:59:59')", "23:59:59");
        this.testSqlApi("TIMESTAMPADD(QUARTER, 1, time '23:59:59')", "23:59:59");
        this.testSqlApi("TIMESTAMPADD(YEAR, 10, time '23:59:59')", "23:59:59");
        this.testSqlApi("TIMESTAMPADD(SECOND, -1, time '00:00:00')", "23:59:59");
        this.testSqlApi("TIMESTAMPADD(MINUTE, -1, time '00:00:00')", "23:59:00");
        this.testSqlApi("TIMESTAMPADD(MINUTE, -1, time '00:00:59')", "23:59:59");
        this.testSqlApi("TIMESTAMPADD(HOUR, -1, time '00:00:00')", "23:00:00");
        this.testSqlApi("TIMESTAMPADD(DAY, -1, time '23:59:59')", "23:59:59");
        this.testSqlApi("TIMESTAMPADD(WEEK, -1, time '23:59:59')", "23:59:59");
        this.testSqlApi("TIMESTAMPADD(MONTH, -1, time '23:59:59')", "23:59:59");
        this.testSqlApi("TIMESTAMPADD(QUARTER, -1, time '23:59:59')", "23:59:59");
        this.testSqlApi("TIMESTAMPADD(YEAR, -1, time '23:59:59')", "23:59:59");
        this.testSqlApi("TIMESTAMPADD(SECOND, CAST(1 AS TINYINT), time '23:59:59')", "00:00:00");
        this.testSqlApi("TIMESTAMPADD(MINUTE, CAST(1 AS TINYINT), time '00:00:00')", "00:01:00");
        this.testSqlApi("TIMESTAMPADD(MINUTE, CAST(1 AS TINYINT), time '23:59:59')", "00:00:59");
        this.testSqlApi("TIMESTAMPADD(HOUR, CAST(1 AS TINYINT), time '23:59:59')", "00:59:59");
        this.testSqlApi("TIMESTAMPADD(DAY, CAST(15 AS TINYINT), date '2021-10-30')", "2021-11-14");
        this.testSqlApi("TIMESTAMPADD(WEEK, CAST(3 AS TINYINT), date '2021-10-30')", "2021-11-20");
        this.testSqlApi("TIMESTAMPADD(MONTH, CAST(6 AS TINYINT), date '2021-10-30')", "2022-04-30");
        this.testSqlApi("TIMESTAMPADD(QUARTER, CAST(1 AS TINYINT), date '2021-10-30')", "2022-01-30");
        this.testSqlApi("TIMESTAMPADD(YEAR, CAST(10 AS TINYINT), date '2021-10-30')", "2031-10-30");
        this.testSqlApi("TIMESTAMPADD(SECOND, CAST(-1 AS TINYINT), time '00:00:00')", "23:59:59");
        this.testSqlApi("TIMESTAMPADD(MINUTE, CAST(-1 AS TINYINT), time '00:00:00')", "23:59:00");
        this.testSqlApi("TIMESTAMPADD(MINUTE, CAST(-1 AS TINYINT), time '00:00:59')", "23:59:59");
        this.testSqlApi("TIMESTAMPADD(HOUR, CAST(-1 AS TINYINT), time '00:00:00')", "23:00:00");
        this.testSqlApi("TIMESTAMPADD(DAY, CAST(-1 AS TINYINT), date '2021-10-30')", "2021-10-29");
        this.testSqlApi("TIMESTAMPADD(WEEK, CAST(-1 AS TINYINT), date '2021-10-30')", "2021-10-23");
        this.testSqlApi("TIMESTAMPADD(MONTH, CAST(-1 AS TINYINT), date '2021-10-30')", "2021-09-30");
        this.testSqlApi("TIMESTAMPADD(QUARTER, CAST(-1 AS TINYINT), date '2021-10-30')", "2021-07-30");
        this.testSqlApi("TIMESTAMPADD(YEAR, CAST(-1 AS TINYINT), date '2021-10-30')", "2020-10-30");
        this.testSqlApi("TIMESTAMPADD(SECOND, CAST(1 AS SMALLINT), time '23:59:59')", "00:00:00");
        this.testSqlApi("TIMESTAMPADD(MINUTE, CAST(1 AS SMALLINT), time '00:00:00')", "00:01:00");
        this.testSqlApi("TIMESTAMPADD(MINUTE, CAST(1 AS SMALLINT), time '23:59:59')", "00:00:59");
        this.testSqlApi("TIMESTAMPADD(HOUR, CAST(1 AS SMALLINT), time '23:59:59')", "00:59:59");
        this.testSqlApi("TIMESTAMPADD(DAY, CAST(15 AS SMALLINT), date '2021-10-30')", "2021-11-14");
        this.testSqlApi("TIMESTAMPADD(WEEK, CAST(3 AS SMALLINT), date '2021-10-30')", "2021-11-20");
        this.testSqlApi("TIMESTAMPADD(MONTH, CAST(6 AS SMALLINT), date '2021-10-30')", "2022-04-30");
        this.testSqlApi("TIMESTAMPADD(QUARTER, CAST(1 AS SMALLINT), date '2021-10-30')", "2022-01-30");
        this.testSqlApi("TIMESTAMPADD(YEAR, CAST(10 AS SMALLINT), date '2021-10-30')", "2031-10-30");
        this.testSqlApi("TIMESTAMPADD(SECOND, CAST(-1 AS SMALLINT), time '00:00:00')", "23:59:59");
        this.testSqlApi("TIMESTAMPADD(MINUTE, CAST(-1 AS SMALLINT), time '00:00:00')", "23:59:00");
        this.testSqlApi("TIMESTAMPADD(MINUTE, CAST(-1 AS SMALLINT), time '00:00:59')", "23:59:59");
        this.testSqlApi("TIMESTAMPADD(HOUR, CAST(-1 AS SMALLINT), time '00:00:00')", "23:00:00");
        this.testSqlApi("TIMESTAMPADD(DAY, CAST(-1 AS SMALLINT), date '2021-10-30')", "2021-10-29");
        this.testSqlApi("TIMESTAMPADD(WEEK, CAST(-1 AS SMALLINT), date '2021-10-30')", "2021-10-23");
        this.testSqlApi("TIMESTAMPADD(MONTH, CAST(-1 AS SMALLINT), date '2021-10-30')", "2021-09-30");
        this.testSqlApi("TIMESTAMPADD(QUARTER, CAST(-1 AS SMALLINT), date '2021-10-30')", "2021-07-30");
        this.testSqlApi("TIMESTAMPADD(YEAR, CAST(-1 AS SMALLINT), date '2021-10-30')", "2020-10-30");
    }

    @Test
    public void testToTimestamp() {
        this.testSqlApi("to_timestamp('abc')", "NULL");
        this.testSqlApi("to_timestamp('2017-09-15 00:00:00')", "2017-09-15 00:00:00.000");
        this.testSqlApi("to_timestamp('20170915000000', 'yyyyMMddHHmmss')", "2017-09-15 00:00:00.000");
        this.testSqlApi("to_timestamp('2017-09-15', 'yyyy-MM-dd')", "2017-09-15 00:00:00.000");
        this.testSqlApi("to_timestamp(cast(null as varchar))", "NULL");
    }

    @Test
    public void testToDate() {
        this.testSqlApi("to_date('2017-09-15 00:00:00')", "2017-09-15");
    }

    @Test
    public void testHashFunctions() {
        String expectedMd5 = "098f6bcd4621d373cade4e832627b4f6";
        String expectedSha1 = "a94a8fe5ccb19ba61c4c0873d391e987982fbbd3";
        String expectedSha224 = "90a3ed9e32b2aaf4c61c410eb925426119e1a9dc53d4286ade99a809";
        String expectedSha256 = "9f86d081884c7d659a2feaa0c55ad015a3bf4f1b2b0b822cd15d6c15b0f00a08";
        String expectedSha384 = "768412320f7b0aa5812fce428dc4706b3cae50e02a64caa16a782249bfe8efc4b7ef1ccb126255d196047dfedf17a0a9";
        String expectedSha512 = "ee26b0dd4af7e749aa1a8ee3c10ae9923f618980772e473f8819a5d4940e0db27ac185f8a0e1d5f84f88bc887fd67b143732c304cc5fa9ad8e6f57f50028a8ff";
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("test").md5(), "MD5('test')", expectedMd5);
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("test").sha1(), "SHA1('test')", expectedSha1);
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("test").sha224(), "SHA224('test')", expectedSha224);
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("test").sha2((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(224)), "SHA2('test', 224)", expectedSha224);
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("test").sha256(), "SHA256('test')", expectedSha256);
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("test").sha2((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(256)), "SHA2('test', 256)", expectedSha256);
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("test").sha384(), "SHA384('test')", expectedSha384);
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("test").sha2((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(384)), "SHA2('test', 384)", expectedSha384);
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("test").sha512(), "SHA512('test')", expectedSha512);
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("test").sha2((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(512)), "SHA2('test', 512)", expectedSha512);
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")).md5(), "MD5(f33)", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")).sha1(), "SHA1(f33)", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")).sha224(), "SHA2(f33, 224)", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")).sha2((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(224)), "SHA2(f33, 224)", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")).sha256(), "SHA2(f33, 256)", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")).sha384(), "SHA2(f33, 384)", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")).sha512(), "SHA2(f33, 512)", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("test").sha2((Object)org.apache.flink.table.api.package$.MODULE$.nullOf(DataTypes.INT())), "SHA2('test', CAST(NULL AS INT))", "NULL");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("test").sha2((Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f44"))), "SHA2('test', f44)", expectedSha256);
        this.testSqlApi("MD5(cast(null as varbinary))", "NULL");
        this.testSqlApi("SHA1(cast(null as varbinary))", "NULL");
        this.testSqlApi("SHA224(cast(null as varbinary))", "NULL");
        this.testSqlApi("SHA2(cast(null as varbinary), 224)", "NULL");
        this.testSqlApi("SHA256(cast(null as varbinary))", "NULL");
        this.testSqlApi("SHA2(cast(null as varbinary), 256)", "NULL");
        this.testSqlApi("SHA384(cast(null as varbinary))", "NULL");
        this.testSqlApi("SHA2(cast(null as varbinary), 384)", "NULL");
        this.testSqlApi("SHA512(cast(null as varbinary))", "NULL");
        this.testSqlApi("SHA2(cast(null as varbinary), 512)", "NULL");
    }

    @Test
    public void testIsTrueIsFalse() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).isTrue(), "f1 IS TRUE", "TRUE");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f21")).isTrue(), "f21 IS TRUE", "FALSE");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralBooleanExpression(false).isFalse(), "FALSE IS FALSE", "TRUE");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f21")).isFalse(), "f21 IS FALSE", "FALSE");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).isNotTrue(), "f1 IS NOT TRUE", "FALSE");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f21")).isNotTrue(), "f21 IS NOT TRUE", "TRUE");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralBooleanExpression(false).isNotFalse(), "FALSE IS NOT FALSE", "FALSE");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f21")).isNotFalse(), "f21 IS NOT FALSE", "TRUE");
    }

    @Test
    public void testStringFunctionsWithNull() {
        List functions = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"f40"}))).$((Seq)Nil$.MODULE$)).substring((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(2)), (Object)"SUBSTRING(f40, 2)"), new Tuple2(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"f40"}))).$((Seq)Nil$.MODULE$)).trim(), (Object)"TRIM(f40)"), new Tuple2(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"f40"}))).$((Seq)Nil$.MODULE$)).like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%%link")), (Object)"f40 LIKE '%%link'"), new Tuple2(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"f40"}))).$((Seq)Nil$.MODULE$)).charLength(), (Object)"CHAR_LENGTH(f40)"), new Tuple2(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"f40"}))).$((Seq)Nil$.MODULE$)).lowerCase(), (Object)"LOWER(f40)"), new Tuple2(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"f40"}))).$((Seq)Nil$.MODULE$)).upperCase(), (Object)"UPPER(f40)"), new Tuple2(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"f40"}))).$((Seq)Nil$.MODULE$)).initCap(), (Object)"INITCAP(f40)"), new Tuple2(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"f40"}))).$((Seq)Nil$.MODULE$)).position((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("aa")), (Object)"POSITION('aa' IN f40)"), new Tuple2(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"f40"}))).$((Seq)Nil$.MODULE$)).overlay((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("aa"), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(2)), (Object)"OVERLAY(f40 PLACING 'aa' FROM 2 FOR 2)")}));
        functions.foreach((Function1 & Serializable & scala.Serializable)x -> {
            this.testAllApis((Expression)x._1(), (String)x._2(), "NULL");
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCodeGenNPE() {
        Seq fields = (Seq)new .colon.colon((Object)"f0", (List)new .colon.colon((Object)"f40", (List)new .colon.colon((Object)"''", (List)Nil$.MODULE$)));
        .colon.colon cases = new .colon.colon((Object)new Tuple2(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"f0"}))).$((Seq)Nil$.MODULE$)).substring((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(-1)), (Object)"UPPER(SUBSTRING(f0, 1, -1))"), (List)new .colon.colon((Object)new Tuple2(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"f40"}))).$((Seq)Nil$.MODULE$)).substring((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(-1)), (Object)"UPPER(SUBSTRING(f40, 1, -1))"), (List)new .colon.colon((Object)new Tuple2(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.lit((Object)"")).substring((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(-1)), (Object)"UPPER(SUBSTRING('', 1, -1))"), (List)Nil$.MODULE$)));
        cases.foreach((Function1 & Serializable & scala.Serializable)x -> {
            this.testAllApis((Expression)x._1(), (String)x._2(), "NULL");
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testNullBigDecimal() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f41")).sign(), "SIGN(f41)", "NULL");
    }

    @Test
    public void testEncodeAndDecode() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("aabbef").encode((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("UTF-16LE"))).decode((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("UTF-16LE")), "decode(encode('aabbef', 'UTF-16LE'), 'UTF-16LE')", "aabbef");
        this.testSqlApi("decode(encode('aabbef', 'utf-8'), 'utf-8')", "aabbef");
        this.testSqlApi("decode(encode('', 'utf-8'), 'utf-8')", "");
        this.testSqlApi("encode(cast (null AS VARCHAR), 'utf-8')", "NULL");
        this.testSqlApi("encode(cast (null AS VARCHAR), cast (null AS VARCHAR))", "NULL");
        this.testSqlApi("encode('aabbef', cast (null AS VARCHAR))", "NULL");
        this.testSqlApi("decode(cast (null AS BINARY), 'utf-8')", "NULL");
        this.testSqlApi("decode(cast (null AS BINARY), cast (null AS VARCHAR))", "NULL");
        this.testSqlApi("decode(encode('aabbef', 'utf-8'), cast (null AS VARCHAR))", "NULL");
        this.testSqlApi("decode(encode('\u4e2d\u56fd', 'UTF-16LE'), 'UTF-16LE')", "\u4e2d\u56fd");
        this.testSqlApi("decode(encode('val_238', 'US-ASCII'), 'US-ASCII') = decode(encode('val_238', 'utf-8'), 'utf-8')", "TRUE");
    }

    @Test
    public void testStringToMap() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("k1=v1,k2=v2").strToMap(), "STR_TO_MAP('k1=v1,k2=v2')", "{k1=v1, k2=v2}");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("k1:v1;k2: v2").strToMap((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal(";"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal(":")), "STR_TO_MAP('k1:v1;k2: v2', ';', ':')", "{k1=v1, k2= v2}");
        this.testSqlApi("STR_TO_MAP('k1$$v1|k2$$ v2', '\\|', '\\$\\$')", "{k1=v1, k2= v2}");
        this.testSqlApi("STR_TO_MAP('')", "{}");
        this.testSqlApi("STR_TO_MAP('k1=v1,k2=v2')['k1']", "v1");
        this.testSqlApi("STR_TO_MAP('k1:v1;k2:v2', ';', ':')['k2']", "v2");
        this.testSqlApi("STR_TO_MAP('k1=v1,k2=v2')['k3']", "NULL");
        this.testSqlApi("STR_TO_MAP(f46)", "{test1=1, test2=2, test3=3}");
        this.testSqlApi("STR_TO_MAP(f47)", "NULL");
    }

    @Test
    public void testIf() {
        this.testSqlApi("IF(f7 > 5, f14, f4)", "44");
        this.testSqlApi("IF(f7 < 5, cast(null as int), f4)", "NULL");
        this.testSqlApi("IF(f7 < 5, cast(null as int), 0)", "NULL");
        this.testSqlApi("IF(1 = 1, f6, cast(f0 as double))", "4.6");
        this.testSqlApi("IF(f7 > 5, f0, f8)", " This is a test String. ");
        this.testSqlApi("IF(f7 < 5, f2, f9)", "42");
        this.testSqlApi("IF(f7 < 5, f14, f7)", "-3");
        this.testSqlApi("IF(f7 < 5, f3, f10)", "43");
        this.testSqlApi("IF(f7 < 5, f4, f11)", "44");
        this.testSqlApi("IF(f7 < 5, f6, f13)", "4.6");
        this.testSqlApi("IF(f7 < 5, f1, f48)", "TRUE");
        this.testSqlApi("IF(f7 < 5, f15, f49)", "-1231.1231231321321321111");
        this.testSqlApi("IF(f7 < 5, f53, f54)", "hello world");
        this.testSqlApi("IF(f7 < 5, f16, f50)", "1996-11-10");
        this.testSqlApi("IF(f7 < 5, f17, f51)", "06:55:44");
    }

    @Test
    public void testRandAndIf() {
        this.testSqlApi("IF(1 = 1, RAND(), cast(1.0 as double))");
        this.testSqlApi("IF(1 = 1, RAND(f7), cast(1.0 as double))", "0.731057369148862");
        this.testSqlApi("IF(1 = 1, RAND(cast(null as int)), cast(1.0 as double))", "NULL");
        this.testSqlApi("IF(1 = 1, RAND(1), cast(1.0 as double))", "0.7308781907032909");
        this.testSqlApi("IF(1 = 1, RAND_INTEGER(f7), 1)");
        this.testSqlApi("IF(1 = 1, RAND_INTEGER(10), 1)");
        this.testSqlApi("IF(1 = 1, RAND_INTEGER(cast(null as int)), 1)");
        this.testSqlApi("IF(1 = 1, RAND_INTEGER(f7, 10), 1)", "4");
        this.testSqlApi("IF(1 = 1, RAND_INTEGER(3, f7), 1)", "2");
        this.testSqlApi("IF(1 = 1, RAND_INTEGER(cast(null as int), 10), 1)", "NULL");
        this.testSqlApi("IF(1 = 1, RAND_INTEGER(3, cast(null as int)), 1)", "NULL");
        this.testSqlApi("IF(1 = 1, RAND_INTEGER(3, 99), 1)", "50");
    }

    @Test
    public void testIfDecimal() {
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.ifThenElse(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7")).$less(org.apache.flink.table.api.package$.MODULE$.int2Literal(5)), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f31")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f34"))), "IF(f7 < 5, f31, f34)", "-0.1231231321321321111");
    }

    @Test
    public void testIsDecimal() {
        this.testSqlApi("IS_DECIMAL('1')", "TRUE");
        this.testSqlApi("IS_DECIMAL('123')", "TRUE");
        this.testSqlApi("IS_DECIMAL('2')", "TRUE");
        this.testSqlApi("IS_DECIMAL('11.4445')", "TRUE");
        this.testSqlApi("IS_DECIMAL('3')", "TRUE");
        this.testSqlApi("IS_DECIMAL('abc')", "FALSE");
        this.testSqlApi("IS_DECIMAL(f33)", "FALSE");
    }

    @Test
    public void testIsDigit() {
        this.testSqlApi("IS_DIGIT('1')", "TRUE");
        this.testSqlApi("IS_DIGIT('123')", "TRUE");
        this.testSqlApi("IS_DIGIT('2')", "TRUE");
        this.testSqlApi("IS_DIGIT('11.4445')", "FALSE");
        this.testSqlApi("IS_DIGIT('3')", "TRUE");
        this.testSqlApi("IS_DIGIT('abc')", "FALSE");
        this.testSqlApi("IS_DIGIT(f33)", "FALSE");
    }

    @Test
    public void testIsAlpha() {
        this.testSqlApi("IS_ALPHA('1')", "FALSE");
        this.testSqlApi("IS_ALPHA('123')", "FALSE");
        this.testSqlApi("IS_ALPHA('2')", "FALSE");
        this.testSqlApi("IS_ALPHA('11.4445')", "FALSE");
        this.testSqlApi("IS_ALPHA('3')", "FALSE");
        this.testSqlApi("IS_ALPHA('abc')", "TRUE");
        this.testSqlApi("IS_ALPHA(f33)", "FALSE");
    }

    @Test
    public void testRawTypeEquality() {
        this.testSqlApi("f55=f56", "FALSE");
        this.testSqlApi("f55=f57", "TRUE");
    }

    @Test
    public void testStringFunctionAndExpressionResultType() {
        String str1 = "CAST('Hello' AS VARCHAR(5))";
        String str2 = "CAST('Hi' AS VARCHAR(2))";
        String str3 = "CAST('hello world' AS VARCHAR(11))";
        String str4 = "CAST(' hello ' AS VARCHAR(7))";
        String url = "CAST('http://user:pass@host' AS VARCHAR(50))";
        String base64 = "CAST('aGVsbG8gd29ybGQ=' AS VARCHAR(20))";
        this.testSqlApi(new StringBuilder(24).append("IFNULL(SUBSTR(").append(str1).append(", 2, 3), ").append(str2).append(")").toString(), "ell");
        this.testSqlApi(new StringBuilder(27).append("IFNULL(SUBSTRING(").append(str1).append(", 2, 3), ").append(str2).append(")").toString(), "ell");
        this.testSqlApi(new StringBuilder(19).append("IFNULL(LEFT(").append(str1).append(", 3), ").append(str2).append(")").toString(), "Hel");
        this.testSqlApi(new StringBuilder(20).append("IFNULL(RIGHT(").append(str1).append(", 3), ").append(str2).append(")").toString(), "llo");
        this.testSqlApi(new StringBuilder(46).append("IFNULL(REGEXP_EXTRACT(").append(str1).append(", 'H(.+?)l(.+?)$', 2), ").append(str2).append(")").toString(), "lo");
        this.testSqlApi(new StringBuilder(40).append("IFNULL(REGEXP_REPLACE(").append(str1).append(", 'e.l', 'EXL'), ").append(str2).append(")").toString(), "HEXLo");
        this.testSqlApi(new StringBuilder(17).append("IFNULL(UPPER(").append(str1).append("), ").append(str2).append(")").toString(), "HELLO");
        this.testSqlApi(new StringBuilder(17).append("IFNULL(LOWER(").append(str1).append("), ").append(str2).append(")").toString(), "hello");
        this.testSqlApi(new StringBuilder(19).append("IFNULL(INITCAP(").append(str3).append("), ").append(str2).append(")").toString(), "Hello World");
        this.testSqlApi(new StringBuilder(41).append("IFNULL(OVERLAY(").append(str1).append(" PLACING ").append(str3).append(" FROM 2 FOR 3), ").append(str2).append(")").toString(), "Hhello worldo");
        this.testSqlApi(new StringBuilder(21).append("IFNULL(LPAD(").append(str1).append(", 7, ").append(str3).append("), ").append(str2).append(")").toString(), "heHello");
        this.testSqlApi(new StringBuilder(21).append("IFNULL(RPAD(").append(str1).append(", 7, ").append(str3).append("), ").append(str2).append(")").toString(), "Hellohe");
        this.testSqlApi(new StringBuilder(21).append("IFNULL(REPEAT(").append(str1).append(", 2), ").append(str2).append(")").toString(), "HelloHello");
        this.testSqlApi(new StringBuilder(19).append("IFNULL(REVERSE(").append(str1).append("), ").append(str2).append(")").toString(), "olleH");
        this.testSqlApi(new StringBuilder(29).append("IFNULL(REPLACE(").append(str3).append(", ' ', '_'), ").append(str2).append(")").toString(), "hello_world");
        this.testSqlApi(new StringBuilder(31).append("IFNULL(SPLIT_INDEX(").append(str3).append(", ' ', 1), ").append(str2).append(")").toString(), "world");
        this.testSqlApi(new StringBuilder(15).append("IFNULL(MD5(").append(str1).append("), ").append(str2).append(")").toString(), "8b1a9953c4611296a827abf8c47804d7");
        this.testSqlApi(new StringBuilder(16).append("IFNULL(SHA1(").append(str1).append("), ").append(str2).append(")").toString(), "f7ff9e8b7bb2e09b70935a5d785e0cc5d9d0abf0");
        this.testSqlApi(new StringBuilder(18).append("IFNULL(SHA224(").append(str1).append("), ").append(str2).append(")").toString(), "4149da18aa8bfc2b1e382c6c26556d01a92c261b6436dad5e3be3fcc");
        this.testSqlApi(new StringBuilder(18).append("IFNULL(SHA256(").append(str1).append("), ").append(str2).append(")").toString(), "185f8db32271fe25f561a6fc938b2e264306ec304eda518007d1764826381969");
        this.testSqlApi(new StringBuilder(18).append("IFNULL(SHA384(").append(str1).append("), ").append(str2).append(")").toString(), "3519fe5ad2c596efe3e276a6f351b8fc0b03db861782490d45f7598ebd0ab5fd5520ed102f38c4a5ec834e98668035fc");
        this.testSqlApi(new StringBuilder(18).append("IFNULL(SHA512(").append(str1).append("), ").append(str2).append(")").toString(), "3615f80c9d293ed7402687f94b22d58e529b8cc7916f8fac7fddf7fbd5af4cf777d3d795a7a00a16bf7e7f3fb9561ee9baae480da9fe7a18769e71886b03f315");
        this.testSqlApi(new StringBuilder(21).append("IFNULL(SHA2(").append(str1).append(", 256), ").append(str2).append(")").toString(), "185f8db32271fe25f561a6fc938b2e264306ec304eda518007d1764826381969");
        this.testSqlApi(new StringBuilder(29).append("IFNULL(PARSE_URL(").append(url).append(", 'HOST'), ").append(str2).append(")").toString(), "host");
        this.testSqlApi(new StringBuilder(23).append("IFNULL(FROM_BASE64(").append(base64).append("), ").append(str2).append(")").toString(), "hello world");
        this.testSqlApi(new StringBuilder(21).append("IFNULL(TO_BASE64(").append(str3).append("), ").append(str2).append(")").toString(), "aGVsbG8gd29ybGQ=");
        this.testSqlApi(new StringBuilder(17).append("IFNULL(CHR(65), ").append(str2).append(")").toString(), "A");
        this.testSqlApi(new StringBuilder(17).append("IFNULL(BIN(10), ").append(str2).append(")").toString(), "1010");
        this.testSqlApi(new StringBuilder(20).append("IFNULL(CONCAT(").append(str1).append(", ").append(str2).append("), ").append(str2).append(")").toString(), "HelloHi");
        this.testSqlApi(new StringBuilder(28).append("IFNULL(CONCAT_WS('~', ").append(str1).append(", ").append(str2).append("), ").append(str2).append(")").toString(), "Hello~Hi");
        this.testSqlApi(new StringBuilder(16).append("IFNULL(TRIM(").append(str4).append("), ").append(str2).append(")").toString(), "hello");
        this.testSqlApi(new StringBuilder(17).append("IFNULL(LTRIM(").append(str4).append("), ").append(str2).append(")").toString(), "hello ");
        this.testSqlApi(new StringBuilder(17).append("IFNULL(RTRIM(").append(str4).append("), ").append(str2).append(")").toString(), " hello");
        this.testSqlApi(new StringBuilder(14).append("IFNULL(").append(str1).append(" || ").append(str2).append(", ").append(str2).append(")").toString(), "HelloHi");
        this.testSqlApi(new StringBuilder(33).append("IFNULL(SUBSTRING(UUID(), 9, 1), ").append(str2).append(")").toString(), "-");
        this.testSqlApi(new StringBuilder(44).append("IFNULL(DECODE(ENCODE(").append(str1).append(", 'utf-8'), 'utf-8'), ").append(str2).append(")").toString(), "Hello");
        this.testSqlApi(new StringBuilder(48).append("IFNULL(CAST(DATE '2021-04-06' AS VARCHAR(10)), ").append(str2).append(")").toString(), "2021-04-06");
        this.testSqlApi(new StringBuilder(45).append("IFNULL(CAST(TIME '11:05:30' AS VARCHAR(8)), ").append(str2).append(")").toString(), "11:05:30");
        this.testSqlApi(new StringBuilder(62).append("IFNULL(CAST(TIMESTAMP '2021-04-06 11:05:30' AS VARCHAR(19)), ").append(str2).append(")").toString(), "2021-04-06 11:05:30");
        this.testSqlApi(new StringBuilder(48).append("IFNULL(CAST(INTERVAL '2' YEAR AS VARCHAR(20)), ").append(str2).append(")").toString(), "+2-00");
        this.testSqlApi(new StringBuilder(47).append("IFNULL(CAST(INTERVAL '2' DAY AS VARCHAR(20)), ").append(str2).append(")").toString(), "+2 00:00:00.000");
        this.testSqlApi(new StringBuilder(35).append("IFNULL(CAST(f53 AS VARCHAR(100)), ").append(str2).append(")").toString(), "hello world");
    }

    public static final /* synthetic */ void $anonfun$testSubString$1(ScalarFunctionsTest $this, String substr) {
        $this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).substr((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(2), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(3)), new StringBuilder(10).append(substr).append("(f0, 2, 3)").toString(), "his");
        $this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).substr((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(2)), new StringBuilder(7).append(substr).append("(f0, 2)").toString(), "his is a test String.");
        $this.testSqlApi(new StringBuilder(12).append(substr).append("(f0, 2, 100)").toString(), "his is a test String.");
        $this.testSqlApi(new StringBuilder(13).append(substr).append("(f0, 100, 10)").toString(), "");
        $this.testSqlApi(new StringBuilder(11).append(substr).append("(f0, 2, -1)").toString(), "NULL");
        $this.testSqlApi(new StringBuilder(11).append(substr).append("(f40, 2, 3)").toString(), "NULL");
        $this.testSqlApi(new StringBuilder(29).append(substr).append("(CAST(null AS VARCHAR), 2, 3)").toString(), "NULL");
        $this.testSqlApi(new StringBuilder(12).append(substr).append("(f0, 2, f14)").toString(), "NULL");
        $this.testSqlApi(new StringBuilder(13).append(substr).append("(f0, f30, f7)").toString(), "Thi");
        $this.testSqlApi(new StringBuilder(11).append(substr).append("(f39, 1, 2)").toString(), "1\u4e16");
    }

    public static final /* synthetic */ boolean $anonfun$testParseUrl$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$testParseUrl$2(ScalarFunctionsTest $this, String url$1, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            String n = (String)tuple2._1();
            String v = (String)tuple2._2();
            $this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression(url$1).parseUrl((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal(String.valueOf(n))), new StringBuilder(17).append("parse_url('").append(url$1).append("', '").append(n).append("')").toString(), v);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private final void testUrl$1(String url, String host, String path, String query, String ref, String protocol, String file, String authority, String userInfo, String qv) {
        Map parts = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"HOST"), (Object)host), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PATH"), (Object)path), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"QUERY"), (Object)query), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"REF"), (Object)ref), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PROTOCOL"), (Object)protocol), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"FILE"), (Object)file), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"AUTHORITY"), (Object)authority), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"USERINFO"), (Object)userInfo)}));
        parts.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ScalarFunctionsTest.$anonfun$testParseUrl$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            ScalarFunctionsTest.$anonfun$testParseUrl$2(this, url, x$1);
            return BoxedUnit.UNIT;
        });
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression(url).parseUrl((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("QUERY"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("query")), new StringBuilder(31).append("parse_url('").append(url).append("', 'QUERY', 'query')").toString(), qv);
    }

    public static final /* synthetic */ boolean $anonfun$testTimestampDiff$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$testTimestampDiff$3(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$testTimestampDiff$4(ScalarFunctionsTest $this, Tuple3 unitParts$1, Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 != null) {
            int index;
            Tuple3 data = (Tuple3)tuple2._1();
            int n = index = tuple2._2$mcI$sp();
            switch (n) {
                case 0: {
                    $this.testAllApis(org.apache.flink.table.api.package$.MODULE$.timestampDiff((TimePointUnit)unitParts$1._2(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression((String)data._1()).toTimestamp(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression((String)data._2()).toTimestamp()), new StringBuilder(43).append("TIMESTAMPDIFF(").append(unitParts$1._1()).append(", TIMESTAMP '").append(data._1()).append("', TIMESTAMP '").append(data._2()).append("')").toString(), (String)data._3());
                    $this.testSqlApi(new StringBuilder(43).append("TIMESTAMPDIFF(").append(unitParts$1._3()).append(", TIMESTAMP '").append(data._1()).append("', TIMESTAMP '").append(data._2()).append("')").toString(), (String)data._3());
                    return;
                }
                case 1: {
                    $this.testAllApis(org.apache.flink.table.api.package$.MODULE$.timestampDiff((TimePointUnit)unitParts$1._2(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression((String)data._1()).toDate(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression((String)data._2()).toTimestamp()), new StringBuilder(38).append("TIMESTAMPDIFF(").append(unitParts$1._1()).append(", DATE '").append(data._1()).append("', TIMESTAMP '").append(data._2()).append("')").toString(), (String)data._3());
                    $this.testSqlApi(new StringBuilder(38).append("TIMESTAMPDIFF(").append(unitParts$1._3()).append(", DATE '").append(data._1()).append("', TIMESTAMP '").append(data._2()).append("')").toString(), (String)data._3());
                    return;
                }
                case 2: {
                    $this.testAllApis(org.apache.flink.table.api.package$.MODULE$.timestampDiff((TimePointUnit)unitParts$1._2(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression((String)data._1()).toTimestamp(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression((String)data._2()).toDate()), new StringBuilder(38).append("TIMESTAMPDIFF(").append(unitParts$1._1()).append(", TIMESTAMP '").append(data._1()).append("', DATE '").append(data._2()).append("')").toString(), (String)data._3());
                    $this.testSqlApi(new StringBuilder(38).append("TIMESTAMPDIFF(").append(unitParts$1._3()).append(", TIMESTAMP '").append(data._1()).append("', DATE '").append(data._2()).append("')").toString(), (String)data._3());
                    return;
                }
                case 3: {
                    $this.testAllApis(org.apache.flink.table.api.package$.MODULE$.timestampDiff((TimePointUnit)unitParts$1._2(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression((String)data._1()).toDate(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression((String)data._2()).toDate()), new StringBuilder(33).append("TIMESTAMPDIFF(").append(unitParts$1._1()).append(", DATE '").append(data._1()).append("', DATE '").append(data._2()).append("')").toString(), (String)data._3());
                    $this.testSqlApi(new StringBuilder(33).append("TIMESTAMPDIFF(").append(unitParts$1._3()).append(", DATE '").append(data._1()).append("', DATE '").append(data._2()).append("')").toString(), (String)data._3());
                    return;
                }
            }
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$testTimestampDiff$2(ScalarFunctionsTest $this, Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 != null) {
            Tuple3 unitParts = (Tuple3)tuple2._1();
            Seq dataParts = (Seq)tuple2._2();
            ((TraversableLike)dataParts.zipWithIndex(Seq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)ScalarFunctionsTest.$anonfun$testTimestampDiff$3(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                ScalarFunctionsTest.$anonfun$testTimestampDiff$4($this, unitParts, x$2);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final Tuple2 intervalCount$1(String interval, int count) {
        String string = interval;
        if ("YEAR".equals(string)) {
            return new Tuple2(org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(count).years(), (Object)new StringBuilder(6).append(count).append(".years").toString());
        }
        if ("SQL_TSI_YEAR".equals(string)) {
            return new Tuple2(org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(count).years(), (Object)new StringBuilder(6).append(count).append(".years").toString());
        }
        if ("QUARTER".equals(string)) {
            return new Tuple2(org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(count).quarters(), (Object)new StringBuilder(9).append(count).append(".quarters").toString());
        }
        if ("SQL_TSI_QUARTER".equals(string)) {
            return new Tuple2(org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(count).quarters(), (Object)new StringBuilder(9).append(count).append(".quarters").toString());
        }
        if ("MONTH".equals(string)) {
            return new Tuple2(org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(count).months(), (Object)new StringBuilder(7).append(count).append(".months").toString());
        }
        if ("SQL_TSI_MONTH".equals(string)) {
            return new Tuple2(org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(count).months(), (Object)new StringBuilder(7).append(count).append(".months").toString());
        }
        if ("WEEK".equals(string)) {
            return new Tuple2(org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(count).weeks(), (Object)new StringBuilder(6).append(count).append(".weeks").toString());
        }
        if ("SQL_TSI_WEEK".equals(string)) {
            return new Tuple2(org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(count).weeks(), (Object)new StringBuilder(6).append(count).append(".weeks").toString());
        }
        if ("DAY".equals(string)) {
            return new Tuple2(org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(count).days(), (Object)new StringBuilder(5).append(count).append(".days").toString());
        }
        if ("SQL_TSI_DAY".equals(string)) {
            return new Tuple2(org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(count).days(), (Object)new StringBuilder(5).append(count).append(".days").toString());
        }
        if ("HOUR".equals(string)) {
            return new Tuple2(org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(count).hours(), (Object)new StringBuilder(6).append(count).append(".hours").toString());
        }
        if ("SQL_TSI_HOUR".equals(string)) {
            return new Tuple2(org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(count).hours(), (Object)new StringBuilder(6).append(count).append(".hours").toString());
        }
        if ("MINUTE".equals(string)) {
            return new Tuple2(org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(count).minutes(), (Object)new StringBuilder(8).append(count).append(".minutes").toString());
        }
        if ("SQL_TSI_MINUTE".equals(string)) {
            return new Tuple2(org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(count).minutes(), (Object)new StringBuilder(8).append(count).append(".minutes").toString());
        }
        if ("SECOND".equals(string)) {
            return new Tuple2(org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(count).seconds(), (Object)new StringBuilder(8).append(count).append(".seconds").toString());
        }
        if ("SQL_TSI_SECOND".equals(string)) {
            return new Tuple2(org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(count).seconds(), (Object)new StringBuilder(8).append(count).append(".seconds").toString());
        }
        throw new MatchError((Object)string);
    }

    public static final /* synthetic */ boolean $anonfun$testTimestampAdd$1(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$testTimestampAdd$2(ScalarFunctionsTest $this, Seq data$1, Tuple2 x$5) {
        Tuple2 tuple2 = x$5;
        if (tuple2 != null) {
            String interval = (String)tuple2._1();
            Seq result = (Seq)tuple2._2();
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                Tuple2 tuple2 = (Tuple2)data$1.apply(i);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int offset = tuple2._1$mcI$sp();
                String ts = (String)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)offset), (Object)ts);
                int offset2 = tuple22._1$mcI$sp();
                String ts2 = (String)tuple22._2();
                Tuple2 timeInterval = ScalarFunctionsTest.intervalCount$1(interval, offset2);
                $this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)timeInterval._1()).$plus((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression(ts2).toTimestamp()), new StringBuilder(30).append("TIMESTAMPADD(").append(interval).append(", ").append(offset2).append(", TIMESTAMP '").append(ts2).append("')").toString(), (String)result.apply(i));
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }
}

