/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.planner.expressions.utils.ExpressionTestBase;
import org.apache.flink.table.planner.expressions.utils.ExpressionTestBase$;
import org.apache.flink.table.planner.expressions.utils.Func3$;
import org.apache.flink.types.Row;
import org.junit.jupiter.api.Test;
import scala.Predef;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001\r4A!\u0003\u0006\u0001/!)a\u0004\u0001C\u0001?!)!\u0005\u0001C\u0001G!)Q\u0007\u0001C\u0001G!)q\u0007\u0001C\u0001G!)\u0011\b\u0001C\u0001G!)1\b\u0001C!y!)\u0001\u000b\u0001C!#\")\u0001\f\u0001C!3\nYA*\u001b;fe\u0006dG+Z:u\u0015\tYA\"A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0007\u000f\u0003\u001d\u0001H.\u00198oKJT!a\u0004\t\u0002\u000bQ\f'\r\\3\u000b\u0005E\u0011\u0012!\u00024mS:\\'BA\n\u0015\u0003\u0019\t\u0007/Y2iK*\tQ#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u00011A\u0011\u0011\u0004H\u0007\u00025)\u00111DC\u0001\u0006kRLGn]\u0005\u0003;i\u0011!#\u0012=qe\u0016\u001c8/[8o)\u0016\u001cHOQ1tK\u00061A(\u001b8jiz\"\u0012\u0001\t\t\u0003C\u0001i\u0011AC\u0001\u001bi\u0016\u001cHOR5fY\u0012<\u0016\u000e\u001e5C_>dW-\u00198Qe\u00164\u0017\u000e\u001f\u000b\u0002IA\u0011Q\u0005K\u0007\u0002M)\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*M\t!QK\\5uQ\t\u00111\u0006\u0005\u0002-g5\tQF\u0003\u0002/_\u0005\u0019\u0011\r]5\u000b\u0005A\n\u0014a\u00026va&$XM\u001d\u0006\u0003eQ\tQA[;oSRL!\u0001N\u0017\u0003\tQ+7\u000f^\u0001\u0014i\u0016\u001cHOT8o\u0003N\u001c\u0017.\u001b'ji\u0016\u0014\u0018\r\u001c\u0015\u0003\u0007-\nq\u0002^3ti\u0012{WO\u00197f#V|G/\u001a\u0015\u0003\t-\n!\u0003^3tiN#(/\u001b8h\u0019&$XM]1mg\"\u0012QaK\u0001\nMVt7\r^5p]N,\u0012!\u0010\t\u0005}\u0015C5J\u0004\u0002@\u0007B\u0011\u0001IJ\u0007\u0002\u0003*\u0011!IF\u0001\u0007yI|w\u000e\u001e \n\u0005\u00113\u0013A\u0002)sK\u0012,g-\u0003\u0002G\u000f\n\u0019Q*\u00199\u000b\u0005\u00113\u0003C\u0001 J\u0013\tQuI\u0001\u0004TiJLgn\u001a\t\u0003\u0019:k\u0011!\u0014\u0006\u0003w9I!aT'\u0003\u001dM\u001b\u0017\r\\1s\rVt7\r^5p]\u0006AA/Z:u\t\u0006$\u0018-F\u0001S!\t\u0019f+D\u0001U\u0015\t)\u0006#A\u0003usB,7/\u0003\u0002X)\n\u0019!k\\<\u0002\u0011QL\b/Z%oM>,\u0012A\u0017\t\u00037\u0006l\u0011\u0001\u0018\u0006\u0003;z\u000b\u0011\u0002^=qKV$\u0018\u000e\\:\u000b\u0005}\u0003\u0017\u0001\u00026bm\u0006T!A\f\t\n\u0005\td&a\u0003*poRK\b/Z%oM>\u0004")
public class LiteralTest
extends ExpressionTestBase {
    @Test
    public void testFieldWithBooleanPrefix() {
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "trUeX")), "trUeX", "trUeX_value");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "FALSE_A")), "FALSE_A", "FALSE_A_value");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "FALSE_AB")), "FALSE_AB", "FALSE_AB_value");
        this.testAllApis(package$.MODULE$.boolean2Literal(true), "trUe", "TRUE");
        this.testAllApis(package$.MODULE$.boolean2Literal(false), "FALSE", "FALSE");
    }

    @Test
    public void testNonAsciiLiteral() {
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).like((Object)package$.MODULE$.string2Literal("%\u6d4b\u8bd5%")), "f4 LIKE '%\u6d4b\u8bd5%'", "TRUE");
        this.testAllApis(package$.MODULE$.string2Literal("\u0410\u0431\u0432\u0433\u0434\u0435\u8c22\u8c22"), "'\u0410\u0431\u0432\u0433\u0434\u0435' || '\u8c22\u8c22'", "\u0410\u0431\u0432\u0433\u0434\u0435\u8c22\u8c22");
    }

    @Test
    public void testDoubleQuote() {
        String hello = "\"<hello>\"";
        this.testAllApis(package$.MODULE$.ScalarFunctionCall((ScalarFunction)Func3$.MODULE$).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.int2Literal(42), package$.MODULE$.string2Literal(hello)})), new StringBuilder(13).append("Func3(42, '").append(hello).append("')").toString(), new StringBuilder(7).append("42 and ").append(hello).toString());
    }

    @Test
    public void testStringLiterals() {
        this.testAllApis(package$.MODULE$.string2Literal(">\n<"), "'>\n<'", ">\n<");
        this.testAllApis(package$.MODULE$.string2Literal(">\u263a<"), "'>\u263a<'", ">\u263a<");
        this.testAllApis(package$.MODULE$.string2Literal(">\\<"), "'>\\<'", ">\\<");
        this.testAllApis(package$.MODULE$.string2Literal(">'<"), "'>''<'", ">'<");
        this.testAllApis(package$.MODULE$.string2Literal(" "), "' '", " ");
        this.testAllApis(package$.MODULE$.string2Literal(""), "''", "");
        this.testAllApis(package$.MODULE$.string2Literal(">foo([\\w]+)<"), "'>foo([\\w]+)<'", ">foo([\\w]+)<");
        this.testAllApis(package$.MODULE$.string2Literal(">\\'\n<"), "'>\\''\n<'", ">\\'\n<");
        this.testAllApis(package$.MODULE$.string2Literal("It's me."), "'It''s me.'", "It's me.");
        this.testSqlApi("U&'>\\263A<'", ">\u263a<");
        this.testSqlApi("U&'>#263A<' UESCAPE '#'", ">\u263a<");
        this.testSqlApi("'>\\\\<'", ">\\\\<");
    }

    @Override
    public Map<String, ScalarFunction> functions() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Func3"), (Object)Func3$.MODULE$)}));
    }

    @Override
    public Row testData() {
        Row testData = new Row(4);
        testData.setField(0, (Object)"trUeX_value");
        testData.setField(1, (Object)"FALSE_A_value");
        testData.setField(2, (Object)"FALSE_AB_value");
        testData.setField(3, (Object)"\u8fd9\u662f\u4e2a\u6d4b\u8bd5\u5b57\u7b26\u4e32");
        return testData;
    }

    @Override
    public RowTypeInfo typeInfo() {
        return new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.STRING, Types.STRING, Types.STRING, Types.STRING}), (String[])((Object[])new String[]{"trUeX", "FALSE_A", "FALSE_AB", "f4"}));
    }

    public LiteralTest() {
        super(ExpressionTestBase$.MODULE$.$lessinit$greater$default$1());
    }
}

