/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen.agg;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.agg.AggTestBase;
import org.apache.flink.table.planner.codegen.agg.AggsHandlerCodeGenerator;
import org.apache.flink.table.runtime.dataview.PerKeyStateDataViewStore;
import org.apache.flink.table.runtime.dataview.StateDataViewStore;
import org.apache.flink.table.runtime.generated.AggsHandleFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001-4A!\u0003\u0006\u00013!)a\u0004\u0001C\u0001?!)\u0011\u0005\u0001C\u0001E!)A\u0007\u0001C\u0001E!)a\u0007\u0001C\u0001E!)\u0001\b\u0001C\u0005s!)a\t\u0001C\u0005\u000f\")a\n\u0001C\u0005\u001f\")!\f\u0001C\u00057\na\u0012iZ4t\u0011\u0006tG\r\\3s\u0007>$WmR3oKJ\fGo\u001c:UKN$(BA\u0006\r\u0003\r\twm\u001a\u0006\u0003\u001b9\tqaY8eK\u001e,gN\u0003\u0002\u0010!\u00059\u0001\u000f\\1o]\u0016\u0014(BA\t\u0013\u0003\u0015!\u0018M\u00197f\u0015\t\u0019B#A\u0003gY&t7N\u0003\u0002\u0016-\u00051\u0011\r]1dQ\u0016T\u0011aF\u0001\u0004_J<7\u0001A\n\u0003\u0001i\u0001\"a\u0007\u000f\u000e\u0003)I!!\b\u0006\u0003\u0017\u0005;w\rV3ti\n\u000b7/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\u0002\"a\u0007\u0001\u0002\u000fQ,7\u000f^!wOR\t1\u0005\u0005\u0002%O5\tQEC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tASE\u0001\u0003V]&$\bF\u0001\u0002+!\tY#'D\u0001-\u0015\tic&A\u0002ba&T!a\f\u0019\u0002\u000f),\b/\u001b;fe*\u0011\u0011GF\u0001\u0006UVt\u0017\u000e^\u0005\u0003g1\u0012A\u0001V3ti\u0006\u0011B/Z:u\u0003Z<w+\u001b;i%\u0016$(/Y2uQ\t\u0019!&\u0001\tuKN$\u0018I^4XSRDW*\u001a:hK\"\u0012AAK\u0001\u0003U2$\"A\u000f\"\u0011\u0005m\u0002U\"\u0001\u001f\u000b\u0005ur\u0014\u0001\u00027b]\u001eT\u0011aP\u0001\u0005U\u00064\u0018-\u0003\u0002By\t!Aj\u001c8h\u0011\u0015\u0019U\u00011\u0001E\u0003\u0005a\u0007C\u0001\u0013F\u0013\t\tU%\u0001\u0002kIR\u0011\u0001j\u0013\t\u0003w%K!A\u0013\u001f\u0003\r\u0011{WO\u00197f\u0011\u0015\u0019e\u00011\u0001M!\t!S*\u0003\u0002KK\u0005\u0011!\u000e\u001e\u000b\u0004!ZC\u0006CA)U\u001b\u0005\u0011&BA*\u0011\u0003\u0011!\u0017\r^1\n\u0005U\u0013&AD$f]\u0016\u0014\u0018n\u0019*po\u0012\u000bG/\u0019\u0005\u0006/\u001e\u0001\r\u0001R\u0001\u0003YFBQ!W\u0004A\u0002\u0011\u000b!\u0001\u001c\u001a\u0002\u0015\u001d,G\u000fS1oI2,'\u000fF\u0002]I&\u0004\"!\u00182\u000e\u0003yS!a\u00181\u0002\u0013\u001d,g.\u001a:bi\u0016$'BA1\u0011\u0003\u001d\u0011XO\u001c;j[\u0016L!a\u00190\u0003%\u0005;wm\u001d%b]\u0012dWMR;oGRLwN\u001c\u0005\u0006K\"\u0001\rAZ\u0001\f]\u0016,GMU3ue\u0006\u001cG\u000f\u0005\u0002%O&\u0011\u0001.\n\u0002\b\u0005>|G.Z1o\u0011\u0015Q\u0007\u00021\u0001g\u0003%qW-\u001a3NKJ<W\r")
public class AggsHandlerCodeGeneratorTest
extends AggTestBase {
    @Test
    public void testAvg() {
        AggsHandleFunction handler = this.getHandler(false, false);
        handler.resetAccumulators();
        handler.accumulate((RowData)GenericRowData.of((Object[])new Object[]{"f0", this.jl(5L), this.jd(5.3), this.jl(2L)}));
        handler.accumulate((RowData)GenericRowData.of((Object[])new Object[]{"f0", this.jl(6L), this.jd(6.5), this.jl(3L)}));
        handler.accumulate((RowData)GenericRowData.of((Object[])new Object[]{"f0", this.jl(7L), this.jd(7.1), this.jl(4L)}));
        RowData ret = handler.getValue();
        Assertions.assertEquals((float)6.0f, (float)ret.getLong(0), (float)0.0f);
        Assertions.assertEquals((double)6.3, (double)ret.getDouble(1), (double)0.0);
        Assertions.assertEquals((float)3.0f, (float)ret.getLong(2), (float)0.0f);
    }

    @Test
    public void testAvgWithRetract() {
        AggsHandleFunction handler = this.getHandler(true, false);
        handler.resetAccumulators();
        handler.accumulate((RowData)GenericRowData.of((Object[])new Object[]{"f0", this.jl(5L), this.jd(5.3), this.jl(2L)}));
        handler.accumulate((RowData)GenericRowData.of((Object[])new Object[]{"f0", this.jl(6L), this.jd(6.3), this.jl(3L)}));
        handler.accumulate((RowData)GenericRowData.of((Object[])new Object[]{"f0", this.jl(7L), this.jd(7.4), this.jl(4L)}));
        handler.retract((RowData)GenericRowData.of((Object[])new Object[]{"f0", this.jl(9L), this.jd(5.5), this.jl(5L)}));
        RowData ret = handler.getValue();
        Assertions.assertEquals((float)4.0f, (float)ret.getLong(0), (float)0.0f);
        Assertions.assertEquals((double)6.75, (double)ret.getDouble(1), (double)0.0);
        Assertions.assertEquals((float)2.0f, (float)ret.getLong(2), (float)0.0f);
    }

    @Test
    public void testAvgWithMerge() {
        AggsHandleFunction handler = this.getHandler(false, true);
        handler.resetAccumulators();
        handler.merge((RowData)GenericRowData.of((Object[])new Object[]{"f0", this.jl(50L), this.jl(2L), this.jd(5.0), this.jl(2L), this.jt(50L, 2L)}));
        handler.merge((RowData)GenericRowData.of((Object[])new Object[]{"f0", this.jl(40L), this.jl(2L), this.jd(4.0), this.jl(2L), this.jt(40L, 2L)}));
        handler.merge((RowData)GenericRowData.of((Object[])new Object[]{"f0", this.jl(43L), this.jl(1L), this.jd(4.0), this.jl(1L), this.jt(43L, 1L)}));
        RowData ret = handler.getValue();
        Assertions.assertEquals((float)26.0f, (float)ret.getLong(0), (float)0.0f);
        Assertions.assertEquals((double)2.6, (double)ret.getDouble(1), (double)0.0);
        Assertions.assertEquals((float)26.0f, (float)ret.getLong(2), (float)0.0f);
    }

    private Long jl(long l) {
        return new Long(l);
    }

    private Double jd(double l) {
        return new Double(l);
    }

    private GenericRowData jt(long l1, long l2) {
        return GenericRowData.of((Object[])new Object[]{this.jl(l1), this.jl(l2)});
    }

    private AggsHandleFunction getHandler(boolean needRetract, boolean needMerge) {
        AggsHandlerCodeGenerator generator = new AggsHandlerCodeGenerator(this.ctx(), this.relBuilder(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])this.inputTypes()), true);
        Object object = needRetract ? generator.needRetract() : BoxedUnit.UNIT;
        Object object2 = needMerge ? generator.needMerge(1, true, (DataType[])((Object[])new DataType[]{DataTypes.BIGINT(), DataTypes.BIGINT(), DataTypes.DOUBLE(), DataTypes.BIGINT(), TypeConversions.fromLegacyInfoToDataType(this.imperativeAggFunc().getAccumulatorType())})) : BoxedUnit.UNIT;
        AggsHandleFunction handler = (AggsHandleFunction)generator.needAccumulate().generateAggsHandler("Test", this.aggInfoList()).newInstance(this.classLoader());
        handler.open((StateDataViewStore)new PerKeyStateDataViewStore(this.context().getRuntimeContext()));
        return handler;
    }

    public AggsHandlerCodeGeneratorTest() {
        super(false);
    }
}

