/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen;

import java.io.Serializable;
import java.util.Collection;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.api.common.eventtime.WatermarkGeneratorSupplier;
import org.apache.flink.api.common.functions.DefaultOpenContext;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.streaming.util.MockStreamingRuntimeContext;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.calcite.SqlToRexConverter;
import org.apache.flink.table.planner.codegen.WatermarkGeneratorCodeGenTest$;
import org.apache.flink.table.planner.codegen.WatermarkGeneratorCodeGenerator$;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.utils.PlannerMocks;
import org.apache.flink.table.runtime.generated.GeneratedWatermarkGenerator;
import org.apache.flink.table.runtime.generated.WatermarkGenerator;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.utils.CatalogManagerMocks;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.util.clock.RelativeClock;
import org.apache.flink.util.clock.SystemClock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005ec\u0001\u0002\n\u0014\u0001\u0001B\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\u0006W\u0001!\t\u0001\f\u0005\ba\u0001\u0011\r\u0011\"\u00012\u0011\u0019A\u0004\u0001)A\u0005e!)\u0011\b\u0001C\u0001u!9\u0011\t\u0001b\u0001\n\u0003\u0011\u0005B\u0002)\u0001A\u0003%1\tC\u0003R\u0001\u0011\u0005!\u000bC\u0003b\u0001\u0011\u0005!\u000bC\u0003d\u0001\u0011\u0005!\u000bC\u0003f\u0001\u0011\u0005!\u000bC\u0003f\u0001\u0011%q\rC\u0003k\u0001\u0011%1nB\u0004\u00020MA\t!!\r\u0007\rI\u0019\u0002\u0012AA\u001a\u0011\u0019Ys\u0002\"\u0001\u00026!9\u0011qG\b\u0005\u0002\u0005e\"!H,bi\u0016\u0014X.\u0019:l\u000f\u0016tWM]1u_J\u001cu\u000eZ3HK:$Vm\u001d;\u000b\u0005Q)\u0012aB2pI\u0016<WM\u001c\u0006\u0003-]\tq\u0001\u001d7b]:,'O\u0003\u0002\u00193\u0005)A/\u00192mK*\u0011!dG\u0001\u0006M2Lgn\u001b\u0006\u00039u\ta!\u00199bG\",'\"\u0001\u0010\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\t\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g-A\u000bvg\u0016$UMZ5oK\u0012\u001cuN\\:ueV\u001cGo\u001c:\u0011\u0005\tJ\u0013B\u0001\u0016$\u0005\u001d\u0011un\u001c7fC:\fa\u0001P5oSRtDCA\u00170!\tq\u0003!D\u0001\u0014\u0011\u00159#\u00011\u0001)\u00031\u0001H.\u00198oKJlunY6t+\u0005\u0011\u0004CA\u001a7\u001b\u0005!$BA\u001b\u0016\u0003\u0015)H/\u001b7t\u0013\t9DG\u0001\u0007QY\u0006tg.\u001a:N_\u000e\\7/A\u0007qY\u0006tg.\u001a:N_\u000e\\7\u000fI\u0001\u000bO\u0016$\b\u000b\\1o]\u0016\u0014X#A\u001e\u0011\u0005qzT\"A\u001f\u000b\u0005y*\u0012aB2bY\u000eLG/Z\u0005\u0003\u0001v\u0012\u0001C\u00127j].\u0004F.\u00198oKJLU\u000e\u001d7\u0002\t\u0011\fG/Y\u000b\u0002\u0007B\u0019A)S&\u000e\u0003\u0015S!AR$\u0002\u0013%lW.\u001e;bE2,'B\u0001%$\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u0015\u0016\u0013A\u0001T5tiB\u0011AJT\u0007\u0002\u001b*\u0011\u0011iF\u0005\u0003\u001f6\u0013abR3oKJL7MU8x\t\u0006$\u0018-A\u0003eCR\f\u0007%\u0001\fuKN$\u0018i]2f]\u0012LgnZ,bi\u0016\u0014X.\u0019:l)\u0005\u0019\u0006C\u0001\u0012U\u0013\t)6E\u0001\u0003V]&$\bF\u0001\u0005X!\tAv,D\u0001Z\u0015\tQ6,A\u0002ba&T!\u0001X/\u0002\u000f),\b/\u001b;fe*\u0011a,H\u0001\u0006UVt\u0017\u000e^\u0005\u0003Af\u0013A\u0002V3tiR+W\u000e\u001d7bi\u0016\fa\u0004^3ti\n{WO\u001c3fI>+Ho\u00144Pe\u0012,'oV1uKJl\u0017M]6)\u0005%9\u0016!\b;fgRdUmZ1ds\u000e+8\u000f^8nSj,GmV1uKJl\u0017M]6)\u0005)9\u0016a\u0006;fgR\u001cUo\u001d;p[&TX\rZ,bi\u0016\u0014X.\u0019:lQ\tYq\u000b\u0006\u0002TQ\")\u0011\u000e\u0004a\u0001Q\u0005A\u0011n\u001d'fO\u0006\u001c\u00170\u0001\u000ehK:,'/\u0019;f/\u0006$XM]7be.<UM\\3sCR|'\u000f\u0006\u0003mi\u0006\r\u0001CA7s\u001b\u0005q'BA8q\u0003%9WM\\3sCR,GM\u0003\u0002r/\u00059!/\u001e8uS6,\u0017BA:o\u0005I9\u0016\r^3s[\u0006\u00148nR3oKJ\fGo\u001c:\t\u000bUl\u0001\u0019\u0001<\u0002\t\u0015D\bO\u001d\t\u0003ozt!\u0001\u001f?\u0011\u0005e\u001cS\"\u0001>\u000b\u0005m|\u0012A\u0002\u001fs_>$h(\u0003\u0002~G\u00051\u0001K]3eK\u001aL1a`A\u0001\u0005\u0019\u0019FO]5oO*\u0011Qp\t\u0005\u0006O5\u0001\r\u0001\u000b\u0015\b\u0001\u0005\u001d\u00111CA\u000b!\u0011\tI!a\u0004\u000e\u0005\u0005-!bAA\u00073\u0006IQ\r\u001f;f]NLwN\\\u0005\u0005\u0003#\tYA\u0001\u0006FqR,g\u000eZ,ji\"\fQA^1mk\u0016d#!a\u0006$\u0005\u0005e\u0001\u0003BA\u000e\u0003Wi!!!\b\u000b\t\u0005}\u0011\u0011E\u0001\u000ea\u0006\u0014\u0018-\\3uKJL'0\u001a3\u000b\t\u0005\r\u0012QE\u0001\u000bKb$XM\\:j_:\u001c(b\u00010\u0002()\u0019\u0011\u0011F\r\u0002\u0013Q,7\u000f^;uS2\u001c\u0018\u0002BA\u0017\u0003;\u0011!\u0004U1sC6,G/\u001a:ju\u0016$G+Z:u\u000bb$XM\\:j_:\fQdV1uKJl\u0017M]6HK:,'/\u0019;pe\u000e{G-Z$f]R+7\u000f\u001e\t\u0003]=\u0019\"aD\u0011\u0015\u0005\u0005E\u0012A\u00039be\u0006lW\r^3sgR\u0011\u00111\b\t\u0006\u0003{\t9\u0005K\u0007\u0003\u0003\u007fQA!!\u0011\u0002D\u0005!Q\u000f^5m\u0015\t\t)%\u0001\u0003kCZ\f\u0017\u0002BA%\u0003\u007f\u0011!bQ8mY\u0016\u001cG/[8oQ\u001d\t\u0012QJA*\u0003+\u0002B!a\u0007\u0002P%!\u0011\u0011KA\u000f\u0005)\u0001\u0016M]1nKR,'o]\u0001\u0005]\u0006lW-\t\u0002\u0002X\u0005IRo]3EK\u001aLg.\u001a3D_:\u001cHO];di>\u0014Xh\u001f\u0019~\u0001")
public class WatermarkGeneratorCodeGenTest {
    private final boolean useDefinedConstructor;
    private final PlannerMocks plannerMocks;
    private final List<GenericRowData> data;

    @Parameters(name="useDefinedConstructor={0}")
    public static Collection<Object> parameters() {
        return WatermarkGeneratorCodeGenTest$.MODULE$.parameters();
    }

    public PlannerMocks plannerMocks() {
        return this.plannerMocks;
    }

    public FlinkPlannerImpl getPlanner() {
        return this.plannerMocks().getPlanner();
    }

    public List<GenericRowData> data() {
        return this.data;
    }

    @TestTemplate
    public void testAscendingWatermark() {
        WatermarkGenerator generator = this.generateWatermarkGenerator("ts - INTERVAL '0.001' SECOND", this.useDefinedConstructor);
        List results = (List)this.data().map((Function1 & Serializable & scala.Serializable)d -> generator.currentWatermark((RowData)d), List$.MODULE$.canBuildFrom());
        .colon.colon expected = new .colon.colon((Object)999L, (List)new .colon.colon(null, (List)new .colon.colon((Object)2999L, (List)new .colon.colon((Object)4999L, (List)new .colon.colon((Object)3999L, (List)new .colon.colon((Object)5999L, (List)Nil$.MODULE$))))));
        Assertions.assertEquals((Object)expected, (Object)results);
    }

    @TestTemplate
    public void testBoundedOutOfOrderWatermark() {
        WatermarkGenerator generator = this.generateWatermarkGenerator("ts - INTERVAL '5' SECOND", this.useDefinedConstructor);
        List results = (List)this.data().map((Function1 & Serializable & scala.Serializable)d -> generator.currentWatermark((RowData)d), List$.MODULE$.canBuildFrom());
        .colon.colon expected = new .colon.colon((Object)-4000L, (List)new .colon.colon(null, (List)new .colon.colon((Object)-2000L, (List)new .colon.colon((Object)0L, (List)new .colon.colon((Object)-1000L, (List)new .colon.colon((Object)1000L, (List)Nil$.MODULE$))))));
        Assertions.assertEquals((Object)expected, (Object)results);
    }

    @TestTemplate
    public void testLegacyCustomizedWatermark() {
        this.testCustomizedWatermark(true);
    }

    @TestTemplate
    public void testCustomizedWatermark() {
        this.testCustomizedWatermark(false);
    }

    private void testCustomizedWatermark(boolean isLegacy) {
        JavaUserDefinedScalarFunctions.JavaFunc5.openCalled = false;
        JavaUserDefinedScalarFunctions.JavaFunc5.closeCalled = false;
        if (isLegacy) {
            this.plannerMocks().getFunctionCatalog().registerTempCatalogScalarFunction(ObjectIdentifier.of((String)CatalogManagerMocks.DEFAULT_CATALOG, (String)CatalogManagerMocks.DEFAULT_DATABASE, (String)"myFunc"), (ScalarFunction)new JavaUserDefinedScalarFunctions.JavaFunc5());
        } else {
            this.plannerMocks().getFunctionCatalog().registerTemporaryCatalogFunction(UnresolvedIdentifier.of((String[])new String[]{CatalogManagerMocks.DEFAULT_CATALOG, CatalogManagerMocks.DEFAULT_DATABASE, "myFunc"}), (FunctionDefinition)new JavaUserDefinedScalarFunctions.JavaFunc5(), false);
        }
        WatermarkGenerator generator = this.generateWatermarkGenerator("myFunc(ts, `offset`)", this.useDefinedConstructor);
        if (!this.useDefinedConstructor) {
            generator.setRuntimeContext((RuntimeContext)new MockStreamingRuntimeContext(false, 1, 0));
        }
        generator.open(DefaultOpenContext.INSTANCE);
        List results = (List)this.data().map((Function1 & Serializable & scala.Serializable)d -> generator.currentWatermark((RowData)d), List$.MODULE$.canBuildFrom());
        generator.close();
        .colon.colon expected = new .colon.colon((Object)995L, (List)new .colon.colon(null, (List)new .colon.colon(null, (List)new .colon.colon((Object)4997L, (List)new .colon.colon((Object)3990L, (List)new .colon.colon((Object)5992L, (List)Nil$.MODULE$))))));
        Assertions.assertEquals((Object)expected, (Object)results);
        Assertions.assertTrue((boolean)JavaUserDefinedScalarFunctions.JavaFunc5.openCalled);
        Assertions.assertTrue((boolean)JavaUserDefinedScalarFunctions.JavaFunc5.closeCalled);
    }

    private WatermarkGenerator generateWatermarkGenerator(String expr, boolean useDefinedConstructor) {
        RelDataType tableRowType = this.plannerMocks().getPlannerContext().getTypeFactory().buildRelNodeRowType((Seq)new .colon.colon((Object)"ts", (List)new .colon.colon((Object)"offset", (List)Nil$.MODULE$)), (Seq)new .colon.colon((Object)new TimestampType(3), (List)new .colon.colon((Object)new IntType(), (List)Nil$.MODULE$)));
        RowType rowType = FlinkTypeFactory$.MODULE$.toLogicalRowType(tableRowType);
        SqlToRexConverter converter = ((FlinkContext)this.plannerMocks().getPlanner().createToRelContext().getCluster().getPlanner().getContext().unwrap(FlinkContext.class)).getRexFactory().createSqlToRexConverter(tableRowType, null);
        RexNode rexNode = converter.convertToRexNode(expr);
        if (useDefinedConstructor) {
            GeneratedWatermarkGenerator generated = WatermarkGeneratorCodeGenerator$.MODULE$.generateWatermarkGenerator((ReadableConfig)new Configuration(), Thread.currentThread().getContextClassLoader(), rowType, rexNode, Option$.MODULE$.apply((Object)"context"));
            Object[] newReferences = (Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(generated.getReferences())).$colon$plus((Object)new WatermarkGeneratorSupplier.Context(null){

                public MetricGroup getMetricGroup() {
                    return null;
                }

                public RelativeClock getInputActivityClock() {
                    return SystemClock.getInstance();
                }
            }, ClassTag$.MODULE$.Object());
            return (WatermarkGenerator)generated.newInstance(Thread.currentThread().getContextClassLoader(), new Object[]{newReferences});
        }
        GeneratedWatermarkGenerator generated = WatermarkGeneratorCodeGenerator$.MODULE$.generateWatermarkGenerator((ReadableConfig)new Configuration(), Thread.currentThread().getContextClassLoader(), rowType, rexNode, WatermarkGeneratorCodeGenerator$.MODULE$.generateWatermarkGenerator$default$5());
        return (WatermarkGenerator)generated.newInstance(Thread.currentThread().getContextClassLoader());
    }

    public WatermarkGeneratorCodeGenTest(boolean useDefinedConstructor) {
        this.useDefinedConstructor = useDefinedConstructor;
        this.plannerMocks = PlannerMocks.create();
        this.data = new .colon.colon((Object)GenericRowData.of((Object[])new Object[]{TimestampData.fromEpochMillis((long)1000L), 5}), (List)new .colon.colon((Object)GenericRowData.of((Object[])new Object[]{null, 4}), (List)new .colon.colon((Object)GenericRowData.of((Object[])new Object[]{TimestampData.fromEpochMillis((long)3000L), null}), (List)new .colon.colon((Object)GenericRowData.of((Object[])new Object[]{TimestampData.fromEpochMillis((long)5000L), 3}), (List)new .colon.colon((Object)GenericRowData.of((Object[])new Object[]{TimestampData.fromEpochMillis((long)4000L), 10}), (List)new .colon.colon((Object)GenericRowData.of((Object[])new Object[]{TimestampData.fromEpochMillis((long)6000L), 8}), (List)Nil$.MODULE$))))));
    }
}

